/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.InvalidSpanProtectionOp;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.Upsr2BlsrInServiceUpgradeMgr;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

class Upsr2BlsrInServiceUpgradeWorker
implements IJobControl {
    NetCircuit ckt;
    Upsr2BlsrInServiceUpgradeMgr isMgr;

    public Upsr2BlsrInServiceUpgradeWorker(NetCircuit netCircuit, Upsr2BlsrInServiceUpgradeMgr upsr2BlsrInServiceUpgradeMgr) {
        this.ckt = netCircuit;
        this.isMgr = upsr2BlsrInServiceUpgradeMgr;
    }

    public JobStatus executeJob() throws Exception {
        boolean bl = false;
        String string = "Error in in-service upgrade for " + this.ckt.getCircuitName() + ": ";
        try {
            Upsr2BlsrInServiceUpgradeMgr.debug("In-Service Upgrade: ......");
            this.isMgr.performInServiceUpgrade(this.ckt);
        }
        catch (InvalidSpanProtectionOp invalidSpanProtectionOp) {
            bl = true;
            string = string + invalidSpanProtectionOp.getMessage();
        }
        catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
            bl = true;
            string = string + connectionInTopologyUpgrade.getMessage();
        }
        catch (TopologyUpgradeNotAllowed topologyUpgradeNotAllowed) {
            bl = true;
            string = string + topologyUpgradeNotAllowed.getMessage();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
            string = string + abstractCmsIOException.getMessage();
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            bl = true;
            string = string + adminStateProvisioningError.getMessage();
        }
        catch (Exception exception) {
            Upsr2BlsrInServiceUpgradeMgr.printStackTrace(exception);
            bl = true;
            string = string + exception.getMessage();
        }
        if (bl) {
            string = string + "\n";
            Upsr2BlsrInServiceUpgradeMgr.debug("In-Service Upgrade:" + string);
            return new JobStatus(2, (Object)new InServiceUpgradeError(string));
        }
        return new JobStatus(4);
    }

    public String getName() {
        return "Upsr2BlsrInServiceUpgradeWorker";
    }

    public void abortJob() {
    }
}

