/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CouldNotGenerateUniqueId;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhTerm;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXcon;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IdAlreadyPresent;
import cerent.cms.model.InvalidCircuitInfoParameters;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidOhXcon;
import cerent.cms.model.InvalidUdcRate;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.OhChannel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhCircuitInfo;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTerm;
import cerent.cms.model.OhXcon;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ocm.IOhCircuitState;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.ocm.OhCircuitWatchDog;
import cerent.cms.ocm.OhConnectionModelComparator;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class OhCircuit
extends CmsObservable
implements Observer,
Comparable {
    private static final SDebug db = new SDebug("OhCircuit");
    protected static Network net = Network.instance();
    protected OhCircuitManager manager = OhCircuitManager.instance();
    protected int state;
    private Object stateLock = new Object();
    protected ICircuitId circuitId;
    protected IOhCircuitModel circuitModel;
    protected Map connModelMap = Collections.synchronizedMap(new HashMap());
    protected Map usedLinkMap = Collections.synchronizedMap(new HashMap());
    protected List spanList;
    private String circuitName;
    private OhNetCircuitEnd bufferedSource;
    private OhNetCircuitEnd bufferedDestination;
    private boolean isCircuitRefValid = true;
    protected UpdateEvent updateEvent = new UpdateEvent();
    protected boolean updateEventQueued = false;

    public OhCircuit(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        this.validateCircuitInfo(iOhCircuitInfo);
        this.initState(0);
        try {
            this.buildCircuit(iOhCircuitInfo);
            this.completeCheck();
            if (!this.isComplete()) {
                throw new IllegalStateException("The circuit state is not DISCOVERED.");
            }
        }
        catch (Exception exception) {
            String string = "You cannot create the required overhead circuit.";
            AnnotatedException annotatedException = new AnnotatedException(string, exception);
            if (this.dbgOn()) {
                db.warning("Create OhCircuit Failure");
                if (annotatedException.getChild() != null) {
                    SDebug.printStackTrace((Throwable)annotatedException.getChild());
                }
                SDebug.printStackTrace((Throwable)annotatedException);
            }
            try {
                this.destroy(true);
            }
            catch (Exception exception2) {
                String string2 = string + "\nThe automatic rollback also failed." + "\nPlease delete the circuit manually.";
                throw new AnnotatedException(string2, exception2);
            }
            throw annotatedException;
        }
    }

    protected void buildCircuit(IOhCircuitInfo iOhCircuitInfo) throws NoRoute, CircuitProvError, InvalidOhTerm, InvalidOhXcon, AllocFailed, IncorrectCircuitState, Busy, OhMaxConnections, ResourceInUse, InvalidUdcRate, ProvisionError {
        INetLink[] iNetLinkArray = this.routeDestination(iOhCircuitInfo.getSrcPoint(), iOhCircuitInfo.getDestPoints()[0], iOhCircuitInfo.getCircuitType());
        this.createOhCircuitInfoIfce(iOhCircuitInfo);
        this.createConnections(iOhCircuitInfo.getSrcPoint(), iOhCircuitInfo.getDestPoints()[0], iOhCircuitInfo.getCircuitType(), iNetLinkArray);
    }

    public OhCircuit(IOhConnectionModel iOhConnectionModel) {
        this.initState(4);
        this.circuitId = iOhConnectionModel.getCircuitId();
        this.addConnection(iOhConnectionModel);
        this.circuitChanged();
    }

    public OhCircuit(IOhCircuitModel iOhCircuitModel) {
        this.initState(4);
        this.addCircuitInfo(iOhCircuitModel);
    }

    public void validateCircuitInfo(IOhCircuitInfo iOhCircuitInfo) {
        if (iOhCircuitInfo.getDestPoints().length != 1) {
            throw new IllegalStateException("One source and one destination are needed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != n) {
                if (this.dbgOn()) {
                    db.fine("Circuit " + this.getCircuitName() + " state change: old = " + EnumStrings.getString(IOhCircuitState.class, (int)this.state) + "; new = " + EnumStrings.getString(IOhCircuitState.class, (int)n));
                }
                this.state = n;
            }
        }
        this.circuitChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initState(int n) {
        if (this.dbgOn()) {
            db.fine("Circuit state init: " + EnumStrings.getString(IOhCircuitState.class, (int)n));
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.state = n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OhCircuit) {
            return object == this;
        }
        return false;
    }

    public boolean isCircuitRefValid() {
        return this.isCircuitRefValid;
    }

    protected boolean circuitInfoActive() {
        return this.circuitModel != null;
    }

    public boolean isComplete() {
        return this.getState() == 1;
    }

    protected void addDiscoveredConnection(IOhConnectionModel iOhConnectionModel) {
        if (!iOhConnectionModel.getCircuitId().equals(this.circuitId)) {
            throw new IllegalStateException("The connection references a circuit ID that does match this overhead circuit ID.");
        }
        if (this.addConnection(iOhConnectionModel)) {
            if (this.dbgOn()) {
                db.fine("Adding discovered connection [" + iOhConnectionModel + "] to " + OhCircuit.prettyString(this.circuitId));
            }
            this.completeCheck();
            this.circuitChanged();
        }
    }

    protected boolean addConnection(IOhConnectionModel iOhConnectionModel) {
        INodeModel iNodeModel;
        if (this.dbgOn()) {
            db.fine("addConnection entry");
        }
        if ((iNodeModel = iOhConnectionModel.getNodeModel()) == null) {
            if (this.dbgOn()) {
                db.warning("NodeModel for a connection is null -- in 'addConnection' of 'OhCircuit'.");
            }
            return false;
        }
        Integer n = new Integer(iNodeModel.getNodeId());
        Set<IOhConnectionModel> set = (Set<IOhConnectionModel>)this.connModelMap.get(n);
        if (set == null) {
            set = Collections.synchronizedSet(new TreeSet(new OhConnectionModelComparator()));
            if (this.dbgOn()) {
                db.fine("Add nodeId " + Integer.toHexString(n) + " with modelSet " + set + " into connModelMap");
            }
            this.connModelMap.put(n, set);
        }
        if (set.contains(iOhConnectionModel)) {
            return false;
        }
        if (set.size() > 0 && !(this instanceof OwCircuit)) {
            throw new IllegalStateException("Only orderwire circuits can have two connections on one node.");
        }
        if (this.dbgOn()) {
            db.fine("Add conn " + iOhConnectionModel + " into modelSet " + set);
        }
        set.add(iOhConnectionModel);
        iOhConnectionModel.addObserver((Observer)this);
        if (!this.getCircuitTypeObj().isIpTunnelType()) {
            return this.setUsedLinks(iNodeModel, iOhConnectionModel);
        }
        return true;
    }

    protected boolean setUsedLinks(INodeModel iNodeModel, IOhConnectionModel iOhConnectionModel) {
        INetElement iNetElement = net.getNetElem(iNodeModel.getNodeId());
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.warning("Can't find nodeElem");
            }
            return true;
        }
        int[] nArray = iOhConnectionModel.getUsedOpticalPorts();
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            Object object2;
            INetLink iNetLink = net.findNetLinkFromEnt(iNetElement, nArray[i], true);
            if (iNetLink == null) {
                object2 = new OhNetCircuitEnd(new OhCircuitEnd(iNodeModel.getNodeId(), nArray[i]), iNodeModel.getNodeId());
                object = ((OhNetCircuitEnd)object2).getAssociatedVirtualLinksForCkt(this);
                if (object != null && ((INetLink[])object).length > 0) {
                    iNetLink = object[0];
                }
                if (iNetLink == null) {
                    iNetLink = ((OhNetCircuitEnd)object2).getAssociatedLink();
                }
            }
            if (iNetLink == null) continue;
            object2 = new HashSet<IOhConnectionModel>();
            ((HashSet)object2).add(iOhConnectionModel);
            this.associateLinkWithConnections(iNetLink, (Set)object2);
            object = net.findReverseLink(iNetLink);
            if (object == null) continue;
            this.associateLinkWithConnections((INetLink)object, (Set)object2);
        }
        return true;
    }

    protected boolean removeConnection(IOhConnectionModel iOhConnectionModel) {
        INodeModel iNodeModel = iOhConnectionModel.getNodeModel();
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.warning("NodeModel for a connection is null -- in 'removeConnection' of 'OhCircuit'.");
            }
            return false;
        }
        Integer n = new Integer(iNodeModel.getNodeId());
        Set set = (Set)this.connModelMap.get(n);
        if (set == null || !set.contains(iOhConnectionModel)) {
            return false;
        }
        set.remove(iOhConnectionModel);
        iOhConnectionModel.deleteObserver((Observer)this);
        if (set.size() == 0) {
            this.connModelMap.remove(n);
        }
        HashSet hashSet = this.getAssociatedLinks(iOhConnectionModel);
        for (INetLink iNetLink : hashSet) {
            this.disassociateLinkWithConnection(iNetLink, iOhConnectionModel);
        }
        return true;
    }

    protected boolean destroyConnections(List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                this.destroyConnection((IOhConnectionModel)iterator.next());
            }
            catch (DeletionError deletionError) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)deletionError);
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void destroyConnection(IOhConnectionModel iOhConnectionModel) throws DeletionError {
        if (this.dbgOn()) {
            db.fine("destroyConnection() - " + iOhConnectionModel);
        }
        if (iOhConnectionModel != null) {
            try {
                iOhConnectionModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.warning("Unable to delete the connection - xBusy");
                }
                return;
            }
            catch (NoLanAccess noLanAccess) {
                if (this.dbgOn()) {
                    db.warning("Unable to delete the connection - NoLanAccess");
                }
                return;
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (this.dbgOn()) {
                    db.fine("The conn already deleted");
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.warning("i/o exception trying to destroy connection at " + this.getCircuitName());
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                throw new DeletionError("An I/O error occurred while deleting the circuit " + this.getCircuitName() + ".\n" + abstractCmsIOException.toString());
            }
            this.removeConnection(iOhConnectionModel);
        }
    }

    private void destroyAllConnections() throws DeletionError {
        for (IOhConnectionModel iOhConnectionModel : this.getConnections()) {
            if (iOhConnectionModel == null) continue;
            this.destroyConnection(iOhConnectionModel);
        }
    }

    protected void addCircuitInfo(IOhCircuitModel iOhCircuitModel) {
        this.circuitModel = iOhCircuitModel;
        this.updateCircuitInfo();
        this.addCircuitInfoObserver();
        this.completeCheck();
        this.circuitChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCircuitInfo() {
        if (this.circuitId == null || this.circuitId.equals(this.circuitModel.getId())) {
            this.circuitId = this.circuitModel.getId();
            this.circuitName = this.circuitModel.getName();
            if (!OhCircuit.isNullCircuitId(this.circuitId)) {
                this.manager.updateCircuitNameMap(this.circuitId, this.circuitName);
            }
        } else {
            ICircuitId iCircuitId = this.circuitModel.getId();
            Object object = this.manager.getCktMapSearchLock();
            synchronized (object) {
                OhCircuit ohCircuit = this.manager.getCircuitFromId(iCircuitId);
                if (this.dbgOn()) {
                    db.fine("Find new circuit " + ohCircuit + " for ID " + OhCircuit.prettyString(iCircuitId));
                }
                if (ohCircuit != null) {
                    ohCircuit.addDiscoveredCircuitInfo(this.circuitModel);
                } else {
                    this.manager.newCircuitFromCircuitInfo(this.circuitModel);
                }
            }
            this.disposeCircuitInfo();
        }
    }

    protected void addDiscoveredCircuitInfo(IOhCircuitModel iOhCircuitModel) throws AbstractCmsIOException {
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            db.fine("Adding discovered circuitinfo to circuit ");
        }
        try {
            this.addCircuitInfo(iOhCircuitModel);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.disposeCircuitInfo();
            throw abstractCmsIOException;
        }
    }

    protected void disposeCircuitInfo() {
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.warning("disposeCircuitInfo: info already not active");
            }
            return;
        }
        if (this.dbgOn()) {
            db.fine("disposeCircuitInfo for circuit " + OhCircuit.prettyString(this.circuitId));
        }
        this.deleteCircuitInfoObserver();
        this.circuitModel = null;
        this.deactivateCircuit();
    }

    private void destroyCircuitInfo() throws IncorrectCircuitState, DeletionError {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (!this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            db.fine("destroyCircuitInfo(" + this.getCircuitName() + "): Id = " + OhCircuit.prettyString(this.getCircuitId()));
        }
        try {
            this.circuitModel.delete();
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.fine("Unable to delete circuit info: database update failed: " + (Object)((Object)cTCUserException));
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            throw new DeletionError("An internal error occurred while deleting the circuit model.");
        }
    }

    protected void deactivateCircuit() {
        if (this.connModelMap.values().size() == 0 && this.circuitModel == null) {
            this.isCircuitRefValid = false;
            this.manager.removeCircuit(this);
            this.circuitDeleted();
            if (!OhCircuit.isNullCircuitId(this.circuitId)) {
                this.manager.updateCircuitNameMap(this.circuitId, null);
            }
            if (this.dbgOn()) {
                db.fine("deactivateCircuit: Nothing remains. deleting circuit");
            }
        } else {
            int n = this.getState();
            this.setState(4);
            if (this.getState() != n) {
                this.circuitChanged();
            }
        }
    }

    public ICircuitId getCircuitId() {
        return this.circuitId;
    }

    public String getCircuitName() {
        return this.circuitName == null ? "" : this.circuitName;
    }

    public int getCircuitType() {
        try {
            if (this.circuitInfoActive()) {
                return this.circuitModel.getCircuitType();
            }
            if (!this.connModelMap.isEmpty()) {
                return ((IOhConnectionModel)this.getConnections().get(0)).getCircuitType();
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        return -1;
    }

    public OhCircuitType getCircuitTypeObj() {
        if (this.getCircuitType() != -1) {
            return OhCircuitType.getOhCktTypeObj((int)this.getCircuitType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCircuitNodes() {
        Map map = this.connModelMap;
        synchronized (map) {
            return new HashSet(this.connModelMap.keySet());
        }
    }

    public Set getCircuitEndNodes() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(this.getSource().getNodeId()));
        List list = this.getDestinations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashSet.add(new Integer(((IOhCircuitEnd)iterator.next()).getNodeId()));
        }
        return hashSet;
    }

    public OhNetCircuitEnd getSource() {
        if (!this.circuitInfoActive()) {
            return null;
        }
        IOhCircuitEnd iOhCircuitEnd = this.circuitModel.getSrcPoint();
        if (iOhCircuitEnd == null) {
            return null;
        }
        if (this.bufferedSource == null || !this.bufferedSource.equals(iOhCircuitEnd)) {
            this.bufferedSource = new OhNetCircuitEnd(iOhCircuitEnd, iOhCircuitEnd.getNodeId());
        }
        return this.bufferedSource;
    }

    public OhNetCircuitEnd getFirstDestination() {
        if (!this.circuitInfoActive()) {
            return null;
        }
        IOhCircuitEnd iOhCircuitEnd = this.circuitModel.getSrcPoint();
        IOhCircuitEnd iOhCircuitEnd2 = this.circuitModel.getDestPoints()[0];
        if (iOhCircuitEnd2 == null) {
            return null;
        }
        if (!(this.bufferedDestination != null && this.bufferedDestination.equals(iOhCircuitEnd2) || iOhCircuitEnd == null)) {
            this.bufferedDestination = new OhNetCircuitEnd(iOhCircuitEnd2, iOhCircuitEnd.getNodeId());
        }
        return this.bufferedDestination;
    }

    public List getDestinations() {
        if (this.circuitInfoActive()) {
            return Arrays.asList(this.circuitModel.getDestPoints());
        }
        return new ArrayList();
    }

    protected boolean isDestination(IOhCircuitEnd iOhCircuitEnd) {
        return this.getDestinations().contains(iOhCircuitEnd);
    }

    public boolean isTerm2TermCircuit() {
        if (this.getSource() == null || this.getFirstDestination() == null) {
            return false;
        }
        return !this.getSource().isPortOptical() && !this.getFirstDestination().isPortOptical();
    }

    protected static boolean isNullCircuitId(ICircuitId iCircuitId) {
        if (iCircuitId == null) {
            return true;
        }
        return iCircuitId.getNodeId() == 0 && iCircuitId.getUniquePart().getUniqueId() == 0;
    }

    public static String prettyString(ICircuitId iCircuitId) {
        if (iCircuitId == null || iCircuitId.getUniquePart() == null) {
            return "<null>";
        }
        return Integer.toHexString(iCircuitId.getNodeId()) + "::" + iCircuitId.getUniquePart().getUniqueId();
    }

    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("CIRCUIT Name = " + this.getCircuitName() + ". Id=" + OhCircuit.prettyString(this.circuitId) + ". State=" + EnumStrings.getString(IOhCircuitState.class, (int)this.state));
        sDebug.println("Source: " + this.getSource());
        sDebug.println("Destination(s) :");
        Iterator iterator = this.getDestinations().iterator();
        while (iterator.hasNext()) {
            sDebug.println(iterator.next().toString());
        }
        sDebug.println("Connection(s) :");
        iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            sDebug.println(iterator.next().toString());
        }
        sDebug.println("Used Link(s) :");
        iterator = this.getUsedLinks().iterator();
        while (iterator.hasNext()) {
            sDebug.println(((INetLink)iterator.next()).prettyString());
        }
    }

    public String toString() {
        return this.getCircuitName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConnections() {
        ArrayList arrayList = new ArrayList();
        Map map = this.connModelMap;
        synchronized (map) {
            Iterator iterator = this.connModelMap.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((Set)iterator.next());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List findConnections(int n, int n2) {
        if (this.dbgOn()) {
            db.finer("Entering findConnections: nodeId=" + Integer.toHexString(n) + ", ent=" + n2);
        }
        ArrayList<IOhConnectionModel> arrayList = new ArrayList<IOhConnectionModel>();
        Set set = (Set)this.connModelMap.get(new Integer(n));
        if (set == null) {
            return arrayList;
        }
        Set set2 = set;
        synchronized (set2) {
            for (IOhConnectionModel iOhConnectionModel : set) {
                if (!iOhConnectionModel.usingEntity(n2)) continue;
                arrayList.add(iOhConnectionModel);
            }
            for (IOhConnectionModel iOhConnectionModel : set) {
                int[] nArray = iOhConnectionModel.getUsedOpticalPorts();
                for (int i = 0; i < nArray.length; ++i) {
                    OhNetCircuitEnd ohNetCircuitEnd = new OhNetCircuitEnd(new OhCircuitEnd(n, nArray[i]), n);
                    ITdmPortModel iTdmPortModel = ohNetCircuitEnd.getTdmPortModelForDccLinkOnDwdmPort();
                    if (iTdmPortModel != null && iTdmPortModel.getIndex() == n2) {
                        arrayList.add(iOhConnectionModel);
                        continue;
                    }
                    IEntityModel[] iEntityModelArray = ohNetCircuitEnd.getAssociatedOtsPorts(this);
                    if (iEntityModelArray == null || iEntityModelArray.length <= 1) continue;
                    if (iEntityModelArray[0].getIndex() == n2) {
                        arrayList.add(iOhConnectionModel);
                        continue;
                    }
                    if (iEntityModelArray[1].getIndex() != n2) continue;
                    arrayList.add(iOhConnectionModel);
                }
            }
        }
        if (this.dbgOn()) {
            db.fine("Found " + arrayList.size() + " connections");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getUsedLinks() {
        Map map = this.usedLinkMap;
        synchronized (map) {
            return new HashSet(this.usedLinkMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getAssociatedLinks(IOhConnectionModel iOhConnectionModel) {
        HashSet hashSet = new HashSet();
        Map map = this.usedLinkMap;
        synchronized (map) {
            for (Map.Entry entry : this.usedLinkMap.entrySet()) {
                if (!((Set)entry.getValue()).contains(iOhConnectionModel)) continue;
                hashSet.add(entry.getKey());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getUsedLinks(OhChannelType ohChannelType) {
        if (!ohChannelType.getCorrespondingCircuitType().equals((Object)this.getCircuitTypeObj())) {
            return null;
        }
        if (this.getCircuitType() != 4) {
            return this.getUsedLinks();
        }
        HashSet<INetLink> hashSet = new HashSet<INetLink>();
        Map map = this.usedLinkMap;
        synchronized (map) {
            for (Map.Entry entry : this.usedLinkMap.entrySet()) {
                INetLink iNetLink = (INetLink)entry.getKey();
                Set set = (Set)entry.getValue();
                for (IOhConnectionModel iOhConnectionModel : set) {
                    if (!OhCircuit.usingChannel(iNetLink, iOhConnectionModel, ohChannelType)) continue;
                    hashSet.add(iNetLink);
                }
            }
        }
        return hashSet;
    }

    private static boolean usingChannel(INetLink iNetLink, IOhConnectionModel iOhConnectionModel, OhChannelType ohChannelType) {
        int n;
        if (iOhConnectionModel.usingEntity(iNetLink.getSrc().getNodeId(), iNetLink.getSrcEntityIndex())) {
            n = iNetLink.getSrcEntityIndex();
        } else if (iOhConnectionModel.usingEntity(iNetLink.getDst().getNodeId(), iNetLink.getDstEntityIndex())) {
            n = iNetLink.getDstEntityIndex();
        } else {
            return false;
        }
        return iOhConnectionModel.usedChannel(n, ohChannelType);
    }

    protected boolean associateLinkWithConnections(INetLink iNetLink, Set set) {
        Set set2;
        if (this.dbgOn()) {
            db.fine("Add used link: " + iNetLink.prettyString() + ", conns = " + set);
        }
        if ((set2 = (Set)this.usedLinkMap.get(iNetLink)) == null) {
            this.usedLinkMap.put(iNetLink, set);
            iNetLink.addObserver(this);
            return true;
        }
        return set2.addAll(set);
    }

    private boolean disassociateLinkWithConnection(INetLink iNetLink, IOhConnectionModel iOhConnectionModel) {
        Set set = (Set)this.usedLinkMap.get(iNetLink);
        if (set == null) {
            if (this.dbgOn()) {
                db.finer("To be deleted link is not used by this circuit - " + iNetLink);
            }
            return false;
        }
        if (!set.contains(iOhConnectionModel)) {
            return false;
        }
        if (this.dbgOn()) {
            db.fine("Disassociate used link " + iNetLink.prettyString() + " with connection " + iOhConnectionModel);
        }
        if (set.size() == 1) {
            this.usedLinkMap.remove(iNetLink);
            iNetLink.deleteObserver(this);
        } else {
            set.remove(iOhConnectionModel);
        }
        return true;
    }

    protected void addCircuitInfoObserver() {
        if (this.circuitModel == null) {
            if (this.dbgOn()) {
                db.warning("Warning! addCircuitInfoObserver: circuitModel null");
            }
            return;
        }
        this.circuitModel.addObserver((Observer)this);
        if (this.dbgOn()) {
            db.fine("addCircuitInfoObserver for " + this.getCircuitName());
        }
    }

    protected void deleteCircuitInfoObserver() {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.fine("deleteCircuitInfoObserver for " + this.getCircuitName());
            }
            this.circuitModel.deleteObserver((Observer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOhCircuitInfoIfce(IOhCircuitInfo iOhCircuitInfo) throws CircuitProvError {
        INodeModel iNodeModel;
        if (this.dbgOn()) {
            db.fine("createOhCircuitInfoIfce: " + iOhCircuitInfo);
        }
        if ((iNodeModel = net.getNodeModel(iOhCircuitInfo.getSrcPoint().getNodeId())) == null) {
            throw new CircuitProvError("The source node cannot be found.");
        }
        Object object = this.manager.getCktMapSearchLock();
        synchronized (object) {
            try {
                this.circuitModel = iNodeModel.getOhCircuitFactoryModel().createOhCircuit(iOhCircuitInfo);
                this.addCircuitInfoObserver();
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.warning("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                throw new CircuitProvError("New circuit information cannot be created.");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.warning("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("New circuit information cannot be created.");
            }
            try {
                this.circuitId = this.circuitModel.getId();
                this.circuitName = this.circuitModel.getName();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                this.disposeCircuitInfo();
                throw new CircuitProvError("The circuit information cannot be found.");
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.disposeCircuitInfo();
                if (this.dbgOn()) {
                    db.severe("Unable to get circuit id: " + (Object)((Object)abstractCmsCommFailException));
                }
                throw new CircuitProvError("The circuit ID cannot be retrieved.");
            }
            this.manager.insertCircuit(this, false);
        }
        if (this.circuitModel.getName().trim().equals("")) {
            object = iNodeModel.getName();
            if (((String)object).length() > 16) {
                object = ((String)object).substring(0, 15);
            }
            String string = OhCircuitType.getOhCktTypeObj((int)this.getCircuitType()).getShortName() + "_" + (String)object + "_" + this.circuitId.getUniquePart().getUniqueId();
            this.rename(string);
        }
    }

    protected INetLink[] routeDestination(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2, int n) throws NoRoute, AllocFailed, IncorrectCircuitState {
        Object object;
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)n);
        if (iOhCircuitEnd.getNodeId() == iOhCircuitEnd2.getNodeId()) {
            return null;
        }
        if (this.dbgOn()) {
            db.println("routeDrop called for cktType " + n + " src = " + iOhCircuitEnd + ", dst = " + iOhCircuitEnd2);
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setSrc(net.getNetElem(iOhCircuitEnd.getNodeId()));
        routePrefs.setDst(net.getNetElem(iOhCircuitEnd2.getNodeId()));
        routePrefs.setPathOnly(true);
        routePrefs.setForOhCircuit();
        routePrefs.setCircuitType(n);
        routePrefs.setTsi(true);
        routePrefs.setPathProt(2);
        this.excludeAiciUnsupportedNodes(routePrefs);
        Set set = this.manager.getUsedLinks(ohCircuitType);
        if (this.dbgOn()) {
            db.finer("Size of usedLinks = " + set.size());
            object = set.iterator();
            while (object.hasNext()) {
                db.finer(((INetLink)object.next()).prettyString());
            }
        }
        routePrefs.addExcludeLinks(new LinkedList(set));
        AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs);
        CircuitPath circuitPath = autoRouteRequestor.getCircuitPath();
        object = circuitPath.getPathSegments();
        if (((LinkedList)object).size() != 1) {
            throw new IllegalStateException("The path should only contain one segment because it is not protected.");
        }
        INetLink[] iNetLinkArray = ((PathSegment)((AbstractSequentialList)object).iterator().next()).getPrimaryLinks().toArray(new INetLink[0]);
        if (iNetLinkArray.length == 0) {
            throw new NoRoute("No route matching the given requirements could be found.");
        }
        return iNetLinkArray;
    }

    protected static boolean linkValid(INetLink iNetLink, int n) {
        if (!iNetLink.getSrc().getConnectionState() || !iNetLink.getDst().getConnectionState()) {
            return false;
        }
        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
        INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
        if ((iNodeModel.getNeType().startsWith("15600") || iNodeModel2.getNeType().startsWith("15600")) && n != 4 && n != 6) {
            return false;
        }
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)n);
        OhChannelType ohChannelType = ohCircuitType.getCorrespondingChannelType();
        int n2 = iNetLink.getSrcEntityIndex();
        int n3 = iNetLink.getDstEntityIndex();
        return iNodeModel.getOhConnectionModels().isChannelAvailable(n2, ohChannelType) && iNodeModel2.getOhConnectionModels().isChannelAvailable(n3, ohChannelType);
    }

    protected void createConnections(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2, int n, INetLink[] iNetLinkArray) throws InvalidOhTerm, InvalidOhXcon, CircuitProvError, Busy, OhMaxConnections, ResourceInUse, InvalidUdcRate, ProvisionError {
        ArrayList<IOhConnectionModel> arrayList = new ArrayList<IOhConnectionModel>();
        try {
            try {
                if (iNetLinkArray == null) {
                    if (this.dbgOn()) {
                        db.println("src: " + iOhCircuitEnd + "dst: " + iOhCircuitEnd2 + " cktType: " + n);
                    }
                    arrayList.add(this.createConnection(iOhCircuitEnd, iOhCircuitEnd2, n, true, true));
                    Object var11_6 = null;
                    this.completeCheck();
                    this.circuitChanged();
                    return;
                }
                if (this.dbgOn()) {
                    db.println("Links: " + iNetLinkArray.length);
                }
                IOhCircuitEnd iOhCircuitEnd3 = iOhCircuitEnd;
                for (int i = 0; i < iNetLinkArray.length; ++i) {
                    INetLink iNetLink = iNetLinkArray[i];
                    OhCircuitEnd ohCircuitEnd = new OhCircuitEnd(iNetLink.getSrc().getNodeId(), iNetLink.getSrcEntityIndex());
                    if (this.dbgOn()) {
                        db.println("Ist conn - outputend: " + ohCircuitEnd + "inputEnd: " + iOhCircuitEnd3);
                    }
                    arrayList.add(this.createConnection(iOhCircuitEnd3, ohCircuitEnd, n, i == 0, false));
                    iOhCircuitEnd3 = new OhCircuitEnd(iNetLink.getDst().getNodeId(), iNetLink.getDstEntityIndex());
                }
                if (this.dbgOn()) {
                    db.println("inputend: " + iOhCircuitEnd3 + "dst: " + iOhCircuitEnd2);
                }
                arrayList.add(this.createConnection(iOhCircuitEnd3, iOhCircuitEnd2, n, false, true));
            }
            catch (InvalidOhTerm invalidOhTerm) {
                this.destroyConnections(arrayList);
                throw invalidOhTerm;
            }
            catch (InvalidOhXcon invalidOhXcon) {
                this.destroyConnections(arrayList);
                throw invalidOhXcon;
            }
            catch (CircuitProvError circuitProvError) {
                this.destroyConnections(arrayList);
                throw circuitProvError;
            }
            catch (Busy busy) {
                this.destroyConnections(arrayList);
                throw busy;
            }
            catch (OhMaxConnections ohMaxConnections) {
                this.destroyConnections(arrayList);
                throw ohMaxConnections;
            }
            catch (ResourceInUse resourceInUse) {
                this.destroyConnections(arrayList);
                throw resourceInUse;
            }
            catch (InvalidUdcRate invalidUdcRate) {
                this.destroyConnections(arrayList);
                throw invalidUdcRate;
            }
            catch (ProvisionError provisionError) {
                this.destroyConnections(arrayList);
                throw provisionError;
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.completeCheck();
            this.circuitChanged();
            throw throwable;
        }
        Object var11_7 = null;
        this.completeCheck();
        this.circuitChanged();
    }

    protected IOhConnectionModel createConnection(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2, int n, boolean bl, boolean bl2) throws InvalidOhTerm, InvalidOhXcon, Busy, CircuitProvError, ResourceInUse, OhMaxConnections, InvalidUdcRate, ProvisionError {
        IOhConnectionModel iOhConnectionModel;
        boolean bl3;
        if (iOhCircuitEnd.getNodeId() != iOhCircuitEnd2.getNodeId()) {
            throw new IllegalStateException("Two ends of a connection must reside in the same node!");
        }
        if (!(!iOhCircuitEnd.equals(iOhCircuitEnd2) || bl && bl2)) {
            throw new CircuitProvError("The source/destination is an endpoint of a network link.");
        }
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)n);
        INodeModel iNodeModel = net.getNodeModel(iOhCircuitEnd.getNodeId());
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.warning("Can't find the node model for node - " + iOhCircuitEnd.getNodeId());
            }
            return null;
        }
        IOhConnectionModels iOhConnectionModels = iNodeModel.getOhConnectionModels();
        OhNetCircuitEnd ohNetCircuitEnd = null;
        OhNetCircuitEnd ohNetCircuitEnd2 = null;
        if (ohCircuitType.isDccTunnelType()) {
            bl3 = false;
        } else if (!bl && !bl2) {
            bl3 = false;
        } else {
            ohNetCircuitEnd = new OhNetCircuitEnd(iOhCircuitEnd, iOhCircuitEnd.getNodeId());
            ohNetCircuitEnd2 = new OhNetCircuitEnd(iOhCircuitEnd2, iOhCircuitEnd.getNodeId());
            boolean bl4 = bl3 = !ohNetCircuitEnd.isPortOptical() || !ohNetCircuitEnd2.isPortOptical();
        }
        if (bl3) {
            int n2 = ohCircuitType.getCorrespondingChannelType().getIndex();
            OhTerm ohTerm = ohNetCircuitEnd2.isPortOptical() ? new OhTerm(new OhChannel(ohNetCircuitEnd2.getPort(), n2), ohNetCircuitEnd.getPort()) : new OhTerm(new OhChannel(ohNetCircuitEnd.getPort(), n2), ohNetCircuitEnd2.getPort());
            if (this.dbgOn()) {
                db.fine("Created new term: " + ohTerm);
            }
            iOhConnectionModel = this.createOhTerm(iOhConnectionModels, ohTerm);
        } else {
            OhChannelType ohChannelType = this.getChannelType(true, iOhCircuitEnd, ohCircuitType);
            OhChannelType ohChannelType2 = this.getChannelType(false, iOhCircuitEnd2, ohCircuitType);
            if (ohChannelType == null || ohChannelType2 == null) {
                throw new CircuitProvError("No channels are available.");
            }
            OhXcon ohXcon = new OhXcon(new OhChannel(iOhCircuitEnd.getPort(), ohChannelType.getIndex()), new OhChannel(iOhCircuitEnd2.getPort(), ohChannelType2.getIndex()));
            if (this.dbgOn()) {
                db.fine("Created new xcon: " + ohXcon);
            }
            iOhConnectionModel = iOhConnectionModels.createOhXcon(this.getCircuitId(), (IOhXcon)ohXcon);
        }
        this.addConnection(iOhConnectionModel);
        return iOhConnectionModel;
    }

    protected IOhConnectionModel createOhTerm(IOhConnectionModels iOhConnectionModels, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, InvalidUdcRate, ProvisionError {
        return iOhConnectionModels.createOhTerm(this.getCircuitId(), iOhTerm);
    }

    protected OhChannelType getChannelType(boolean bl, IOhCircuitEnd iOhCircuitEnd, OhCircuitType ohCircuitType) {
        return ohCircuitType.getCorrespondingChannelType();
    }

    public boolean doesCircuitUseNetElem(INetElement iNetElement) {
        int n = iNetElement.getNodeId();
        if (this.getSource() != null && this.getSource().getNodeId() == n) {
            return true;
        }
        Iterator iterator = this.getDestinations().iterator();
        while (iterator.hasNext()) {
            if (((IOhCircuitEnd)iterator.next()).getNodeId() != n) continue;
            return true;
        }
        return this.connModelMap.get(new Integer(n)) != null;
    }

    protected boolean doesCircuitUseConn(IOhConnectionModel iOhConnectionModel) {
        return this.getConnections().contains(iOhConnectionModel);
    }

    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        return this.usedLinkMap.keySet().contains(iNetLink);
    }

    public List getLinkEndpoints(INetLink iNetLink) {
        ArrayList<IOhCircuitEnd> arrayList = new ArrayList<IOhCircuitEnd>();
        if (OhCircuit.linkUsingCktEnd(iNetLink, this.getSource())) {
            arrayList.add(this.getSource());
        }
        for (IOhCircuitEnd iOhCircuitEnd : this.getDestinations()) {
            if (!OhCircuit.linkUsingCktEnd(iNetLink, iOhCircuitEnd)) continue;
            arrayList.add(iOhCircuitEnd);
        }
        return arrayList;
    }

    private static boolean linkUsingCktEnd(INetLink iNetLink, IOhCircuitEnd iOhCircuitEnd) {
        return iOhCircuitEnd.getPort() == iNetLink.getSrcEntityIndex() && iOhCircuitEnd.getNodeId() == iNetLink.getSrc().getNodeId() || iOhCircuitEnd.getPort() == iNetLink.getDstEntityIndex() && iOhCircuitEnd.getNodeId() == iNetLink.getDst().getNodeId();
    }

    public void foundNewNetLink(INetLink iNetLink) {
        if (this.getState() == 1 && this.isTerm2TermCircuit()) {
            return;
        }
        if (this.usedLinkMap.keySet().contains(iNetLink)) {
            if (this.dbgOn()) {
                db.finer("New found link is already in the used link");
            }
            return;
        }
        HashSet hashSet = this.getConnectionsUsingLink(iNetLink);
        if (!hashSet.isEmpty() && this.associateLinkWithConnections(iNetLink, hashSet)) {
            this.completeCheck();
            this.circuitChanged();
        }
    }

    private HashSet getConnectionsUsingLink(INetLink iNetLink) {
        HashSet hashSet = new HashSet();
        int n = iNetLink.getSrc().getNodeId();
        int n2 = iNetLink.getDst().getNodeId();
        int n3 = iNetLink.getSrcEntityIndex();
        int n4 = iNetLink.getDstEntityIndex();
        hashSet.addAll(this.findConnections(n, n3));
        hashSet.addAll(this.findConnections(n2, n4));
        return hashSet;
    }

    protected synchronized void completeCheck() {
        if (this.dbgOn()) {
            db.fine("Performing complete check for circuit. ");
        }
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.warning("Circuit Info is not active");
            }
            return;
        }
        if (!this.isComplete()) {
            boolean bl;
            boolean bl2 = bl = this.getSource().getNodeId() == this.getFirstDestination().getNodeId();
            if (bl && this.foundMatchedConnection() || !bl && this.foundAllPaths()) {
                this.setState(1);
            }
        }
    }

    private boolean foundMatchedConnection() {
        if (this.circuitModel == null) {
            return false;
        }
        if (this.connModelMap.size() != 1) {
            return false;
        }
        IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)this.getConnections().get(0);
        if (iOhConnectionModel.getNodeModel().getNodeId() != this.getSource().getNodeId()) {
            return false;
        }
        return iOhConnectionModel.usingEntity(this.getSource().getPort()) && iOhConnectionModel.usingEntity(this.getFirstDestination().getPort());
    }

    protected boolean foundAllPaths() {
        this.spanList = this.getPathLinks();
        return this.spanList != null;
    }

    private List getPathLinks() {
        if (!this.circuitInfoActive()) {
            return null;
        }
        return this.getPathLinks(this.getSource(), this.getFirstDestination());
    }

    protected List getPathLinks(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2) {
        if (!this.circuitInfoActive()) {
            return null;
        }
        if (this.dbgOn()) {
            db.fine("Entering getPathLinks(): src=" + iOhCircuitEnd + ", dst=" + iOhCircuitEnd2);
        }
        List list = this.findConnections(iOhCircuitEnd.getNodeId(), iOhCircuitEnd.getPort());
        List list2 = this.findConnections(iOhCircuitEnd2.getNodeId(), iOhCircuitEnd2.getPort());
        if (this.dbgOn()) {
            db.println("start conns: " + list.size() + " end Conns: " + list2.size());
        }
        for (IOhConnectionModel iOhConnectionModel : list) {
            for (IOhConnectionModel iOhConnectionModel2 : list2) {
                List list3 = this.getPathLinks(iOhConnectionModel, iOhConnectionModel2);
                if (list3 == null) continue;
                if (this.dbgOn()) {
                    db.fine("Found path from " + iOhCircuitEnd + " to " + iOhCircuitEnd2);
                }
                return list3;
            }
        }
        if (this.dbgOn()) {
            db.fine("Did not find path from " + iOhCircuitEnd + " to " + iOhCircuitEnd2);
        }
        return null;
    }

    protected List getPathLinks(IOhConnectionModel iOhConnectionModel, IOhConnectionModel iOhConnectionModel2) {
        ArrayList arrayList;
        block5: {
            if (this.dbgOn()) {
                db.fine("Entering getPathLinks(): firstConn=" + iOhConnectionModel + ", lastConn=" + iOhConnectionModel2);
            }
            arrayList = new ArrayList();
            if (iOhConnectionModel == null || iOhConnectionModel2 == null) {
                if (this.dbgOn()) {
                    db.fine("firstConn or lastConn is null");
                }
                return null;
            }
            IOhConnectionModel iOhConnectionModel3 = iOhConnectionModel;
            do {
                if ((iOhConnectionModel3 = this.getNextConnection(iOhConnectionModel3, arrayList, true)) == null) {
                    return null;
                }
                if (iOhConnectionModel3.equals(iOhConnectionModel2)) break block5;
            } while (!(iOhConnectionModel3 instanceof IOhTermModel));
            return null;
        }
        return arrayList;
    }

    protected IOhConnectionModel getNextConnection(IOhConnectionModel iOhConnectionModel, List list, boolean bl) {
        IOhConnectionModel iOhConnectionModel2;
        OhNetCircuitEnd ohNetCircuitEnd;
        INetLink[] iNetLinkArray;
        Object object;
        if (iOhConnectionModel.getNodeModel() == null) {
            return null;
        }
        if (this.dbgOn()) {
            db.fine("getNextConnection-forwarding(" + bl + "): " + iOhConnectionModel);
        }
        int n = iOhConnectionModel.getNodeModel().getNodeId();
        int n2 = -1;
        if (iOhConnectionModel instanceof IOhTermModel) {
            n2 = ((IOhTermModel)iOhConnectionModel).getOpticalPortIndex();
        } else {
            object = (IOhXconModel)iOhConnectionModel;
            int n3 = object.getInputPortIndex();
            int n4 = object.getOutputPortIndex();
            if (list != null && !list.isEmpty()) {
                INetLink iNetLink = (INetLink)list.get(list.size() - 1);
                if (iNetLink.getDst().getNodeId() == n) {
                    n2 = iNetLink.getDstEntityIndex() == n3 ? n4 : n3;
                } else if (iNetLink.getSrc().getNodeId() == n) {
                    n2 = iNetLink.getSrcEntityIndex() == n3 ? n4 : n3;
                }
            } else {
                n2 = bl ? object.getOutputPortIndex() : object.getInputPortIndex();
            }
        }
        object = this.findUsedNetLinkFromEnt(n, n2);
        if (this.dbgOn()) {
            db.fine("getNextConnection: found used link = " + (object == null ? null : object.prettyString()));
        }
        if (object == null && (iNetLinkArray = (ohNetCircuitEnd = new OhNetCircuitEnd(new OhCircuitEnd(n, n2), n)).getAssociatedVirtualLinksForCkt(this)) != null && iNetLinkArray.length > 0) {
            object = iNetLinkArray[0];
        }
        if (object == null) {
            return null;
        }
        List list2 = this.findConnections(object.getDst().getNodeId(), object.getDstEntityIndex());
        IOhConnectionModel iOhConnectionModel3 = iOhConnectionModel2 = list2.isEmpty() ? null : (IOhConnectionModel)list2.get(0);
        if (iOhConnectionModel2 != null && list != null) {
            list.add(object);
        }
        if (this.dbgOn()) {
            db.fine("getNextConnection: nextConn=" + iOhConnectionModel2);
        }
        return iOhConnectionModel2;
    }

    public INetLink findUsedNetLinkFromEnt(int n, int n2) {
        if (this.dbgOn()) {
            db.fine("findUsedNetLinkFromEnt: nodeId=" + Integer.toHexString(n) + ", entIx=" + Integer.toHexString(n2));
        }
        for (INetLink iNetLink : this.getUsedLinks()) {
            ITdmPortModel iTdmPortModel;
            if (iNetLink.getSrc().getNodeId() == n && n2 == iNetLink.getSrcEntityIndex()) {
                return iNetLink;
            }
            OhNetCircuitEnd ohNetCircuitEnd = new OhNetCircuitEnd(new OhCircuitEnd(n, n2), n);
            int n3 = -1;
            if (ohNetCircuitEnd != null && (iTdmPortModel = ohNetCircuitEnd.getTdmPortModelForDccLinkOnDwdmPort()) != null) {
                n3 = iTdmPortModel.getIndex();
            }
            if (iNetLink.getSrc().getNodeId() != n || n3 != iNetLink.getSrcEntityIndex()) continue;
            return iNetLink;
        }
        return null;
    }

    public List getCircuitSpans() {
        if (this.spanList == null) {
            return null;
        }
        return new ArrayList(this.spanList);
    }

    public int numOfSpansUsed() {
        if (this.spanList == null) {
            return 0;
        }
        return this.spanList.size();
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        OhCircuit ohCircuit = (OhCircuit)object;
        ICircuitId iCircuitId = this.getCircuitId();
        ICircuitId iCircuitId2 = ohCircuit.getCircuitId();
        if (iCircuitId == null && iCircuitId2 == null) {
            return 0;
        }
        if (iCircuitId == null) {
            return -1;
        }
        if (iCircuitId2 == null) {
            return 1;
        }
        return (int)(iCircuitId.longValue() - iCircuitId2.longValue());
    }

    public void circuitDeleteCheck() throws IncorrectCircuitState {
        if (this.getState() == 0 || this.getState() == 11) {
            throw new IncorrectCircuitState("A circuit in a transitory state cannot be destroyed.");
        }
    }

    public boolean isCircuitNodesInVersionUp() {
        List list = this.getConnections();
        Collections.shuffle(list);
        boolean bl = false;
        for (IOhConnectionModel iOhConnectionModel : list) {
            if (!iOhConnectionModel.getNodeModel().provides(Feature.ML_VERSION_UP_ENH) || !iOhConnectionModel.getNodeModel().isVersionUpStateEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void destroy(boolean bl) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        Object object;
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        List list = this.getConnections();
        if (this.dbgOn()) {
            object = this.getCircuitName();
            db.fine("destroying circuit (with shuffled conn list): " + (String)object == null ? "unknown" : (String)object + ", length " + list.size());
        }
        Collections.shuffle(list);
        object = null;
        int n = 0;
        for (IOhConnectionModel iOhConnectionModel : list) {
            if (this.dbgOn()) {
                db.fine("Deactivating " + iOhConnectionModel);
            }
            try {
                this.destroyConnection(iOhConnectionModel);
            }
            catch (DeletionError deletionError) {
                if (this.dbgOn()) {
                    db.warning("deletion error exception in destroy");
                }
                ++n;
                if (object != null) continue;
                object = deletionError;
            }
        }
        if (object != null) {
            if (this.dbgOn()) {
                db.warning("Total of " + n + " catches");
            }
            throw object;
        }
        try {
            if (this.circuitInfoActive()) {
                this.circuitModel.delete();
                this.disposeCircuitInfo();
            }
        }
        catch (CTCUserException cTCUserException) {
            db.warning("Unable to delete circuit info: database update failed: " + (Object)((Object)cTCUserException));
            SDebug.printStackTrace((Throwable)cTCUserException);
            throw new DeletionError("Internal error");
        }
        this.isCircuitRefValid = false;
        this.circuitDeleted();
        this.manager.removeCircuit(this);
    }

    protected void dispose() {
        if (this.dbgOn()) {
            db.fine("dispose circuit: " + this.getCircuitName());
        }
        super.destroy();
        this.deleteCircuitInfoObserver();
        this.connModelMap = Collections.synchronizedMap(new HashMap());
    }

    public void rename(String string) throws CircuitProvError {
        if (!this.isCircuitRefValid()) {
            throw new CircuitProvError("The circuit was already destroyed.");
        }
        if (string.trim().equals("")) {
            throw new CircuitProvError("The circuit name cannot be blank.");
        }
        if (this.circuitInfoActive()) {
            try {
                this.circuitModel.setName(string);
            }
            catch (InvalidCircuitName invalidCircuitName) {
                if (this.dbgOn()) {
                    db.warning("rename: Invalid Circuit Name");
                }
                throw new CircuitProvError("The new circuit name cannot be provisioned.");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                throw new CircuitProvError("The circuit cannot be renamed.");
            }
        } else {
            throw new CircuitProvError("The circuit cannot be renamed in its \ncurrent state, " + EnumStrings.getString(IOhCircuitState.class, (int)this.state) + ".");
        }
        this.circuitName = string;
        this.circuitChanged();
    }

    protected IOhCircuitModel circuitModel() {
        return this.circuitModel;
    }

    protected void circuitChanged() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected void circuitDeleted() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof IOhCircuitModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.info("ckt.update: DELETED for " + this.getCircuitName());
                }
                this.updateEvent.deleted = true;
                OhCircuitWatchDog.instance().queueCircuitUpdate(this);
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.info("ckt.update: CHANGED for " + this.getCircuitName());
                }
                this.updateEvent.changed = true;
                OhCircuitWatchDog.instance().queueCircuitUpdate(this);
            }
        } else if (observable instanceof IOhConnectionModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.info("connection.update: DELETED for " + observable);
                }
                if (this.removeConnection((IOhConnectionModel)observable)) {
                    this.deactivateCircuit();
                }
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.info("connection.update: CHANGED for " + observable);
                }
                IOhConnectionModel iOhConnectionModel = (IOhConnectionModel)observable;
                this.handleCircuitChange(iOhConnectionModel);
            }
        } else if (observable instanceof INetLink && ((Integer)object).equals(ModelUpdateType.DELETED)) {
            if (this.dbgOn()) {
                db.info("link.update: DELETED for " + observable);
            }
            if (this.usedLinkMap.remove(observable) != null) {
                ((INetLink)((Object)observable)).deleteObserver(this);
                this.deactivateCircuitState();
                this.completeCheck();
                this.circuitChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCircuitChange(IOhConnectionModel iOhConnectionModel) {
        ICircuitId iCircuitId = iOhConnectionModel.getCircuitId();
        if (!iCircuitId.equals(this.getCircuitId())) {
            if (this.removeConnection(iOhConnectionModel)) {
                this.deactivateCircuit();
            }
            Object object = this.manager.getCktMapSearchLock();
            synchronized (object) {
                OhCircuit ohCircuit = this.manager.getCircuitFromId(iCircuitId);
                if (this.dbgOn()) {
                    db.fine("Find new circuit " + ohCircuit + " for ID " + OhCircuit.prettyString(iCircuitId));
                }
                if (ohCircuit != null) {
                    ohCircuit.addDiscoveredConnection(iOhConnectionModel);
                } else {
                    this.manager.newCircuitFromConn(iOhConnectionModel);
                }
            }
        }
    }

    private void deactivateCircuitState() {
        if (this.isComplete()) {
            this.setState(4);
        }
    }

    protected void runUpdate() {
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.updateEvent.deleted) {
            if (this.dbgOn()) {
                db.info("ckt.runUpdate: DELETED for " + this.getCircuitName());
            }
            this.updateEvent.deleted = false;
            this.disposeCircuitInfo();
        } else if (this.updateEvent.changed) {
            if (this.dbgOn()) {
                db.info("ckt.runUpdate: CHANGED for " + this.getCircuitName());
            }
            this.updateEvent.changed = false;
            this.updateChanged();
        }
    }

    private void updateChanged() {
        if (this.getState() != 1 && this.getState() != 4) {
            return;
        }
        try {
            this.setState(4);
            this.updateCircuitInfo();
            this.completeCheck();
            this.circuitChanged();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            INetElement iNetElement = net.getNetElem(this.circuitModel.getNodeId());
            this.disposeCircuitInfo();
            OhCircuitWatchDog.instance().reloadCircuitInfos(iNetElement);
        }
    }

    private void excludeAiciUnsupportedNodes(RoutePrefs routePrefs) {
        Collection collection = net.getElements();
        for (INetElement iNetElement : collection) {
            if (iNetElement.getNodeModel().provides(Feature.AICI)) continue;
            routePrefs.addExcludeNode(iNetElement);
        }
    }

    protected boolean isRepairable() {
        if (this.circuitModel == null) {
            if (this.dbgOn()) {
                db.fine("Circuit Model does not exist. It cannot be repaired");
            }
            return false;
        }
        return !OhCircuit.isNullCircuitId(this.circuitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean repairCircuit(int n, int n2) throws CircuitProvError {
        boolean bl = false;
        if (this.dbgOn()) {
            db.fine("Repairing Circuit: " + this.getCircuitName());
        }
        if (!this.isRepairable()) {
            return false;
        }
        if (this.circuitId.getNodeId() == n) {
            Object object;
            IOhCircuitEnd iOhCircuitEnd;
            if (this.dbgOn()) {
                db.fine("Circuit Id's node id matched with old Node ID ( " + n + " ) ");
            }
            OhCircuitInfo ohCircuitInfo = new OhCircuitInfo(this.circuitModel.getSrcPoint(), this.circuitModel.getDestPoints(), this.circuitModel.getCircuitType(), this.circuitModel.getName());
            OhCircuitInfo ohCircuitInfo2 = new OhCircuitInfo(ohCircuitInfo);
            ohCircuitInfo2.getSrcPoint().setNodeId(n2);
            for (int i = 0; i < ohCircuitInfo2.getDestPoints().length; ++i) {
                iOhCircuitEnd = ohCircuitInfo2.getDestPoints()[i];
                if (iOhCircuitEnd.getNodeId() != n) continue;
                if (this.dbgOn()) {
                    db.fine("Destination belongs to the modified node");
                }
                iOhCircuitEnd.setNodeId(n2);
            }
            IOhCircuitModel iOhCircuitModel = null;
            iOhCircuitEnd = this.getSource().getNodeModel();
            if (iOhCircuitEnd == null) {
                object = net.getNetElem(n2);
                if (object != null) {
                    iOhCircuitEnd = object.getNodeModel();
                }
                if (iOhCircuitEnd == null) {
                    throw new CircuitProvError("A source node model cannot be found.");
                }
            }
            object = iOhCircuitEnd.getOhCircuitFactoryModel();
            Throwable throwable = null;
            Object object2 = this.manager.getCktMapSearchLock();
            synchronized (object2) {
                try {
                    iOhCircuitModel = object.createOhCircuit((IOhCircuitInfo)ohCircuitInfo2);
                }
                catch (InvalidCircuitInfoParameters invalidCircuitInfoParameters) {
                    throwable = invalidCircuitInfoParameters;
                }
                catch (CouldNotGenerateUniqueId couldNotGenerateUniqueId) {
                    throwable = couldNotGenerateUniqueId;
                }
                catch (IdAlreadyPresent idAlreadyPresent) {
                    throwable = idAlreadyPresent;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    throwable = abstractCmsIOException;
                }
                if (throwable != null) {
                    if (this.dbgOn()) {
                        db.warning("Unable to create circuit info: " + throwable);
                    }
                    throw new CircuitProvError("New circuit information cannot be created.");
                }
                ICircuitId iCircuitId = null;
                try {
                    iCircuitId = iOhCircuitModel.getId();
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (this.dbgOn()) {
                        db.warning("New CircuitModel disappeared");
                    }
                    throw new CircuitProvError("The new circuit model cannot be found.");
                }
                try {
                    this.destroyCircuitInfo();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                }
                catch (DeletionError deletionError) {
                    throw new CircuitProvError("The circuit could only be partially repaired.");
                }
                this.disposeCircuitInfo();
                this.addCircuitInfo(iOhCircuitModel);
                this.manager.insertCircuit(this, false);
                if (this.dbgOn()) {
                    db.fine("Changing circuit id on Cross connections");
                }
                for (IOhConnectionModel iOhConnectionModel : this.getConnections()) {
                    iOhConnectionModel.setCircuitId(iCircuitId);
                }
            }
            bl = true;
        } else {
            for (int i = 0; i < this.circuitModel.getDestPoints().length; ++i) {
                IOhCircuitEnd iOhCircuitEnd = this.circuitModel.getDestPoints()[i];
                if (iOhCircuitEnd.getNodeId() != n) continue;
                if (this.dbgOn()) {
                    db.fine("Destination belongs to the modified node");
                }
                OhCircuitEnd ohCircuitEnd = new OhCircuitEnd(n2, iOhCircuitEnd.getPort());
                this.circuitModel.addDestination((IOhCircuitEnd)ohCircuitEnd);
                this.circuitModel.delDestination(iOhCircuitEnd);
                bl = true;
            }
        }
        if (bl) {
            this.completeCheck();
            this.circuitChanged();
        }
        return bl;
    }

    protected Set getAffectedNodes(int n) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        if (this.dbgOn()) {
            db.fine("getAffectedNodes(" + this.getCircuitName() + ", " + OhCircuit.prettyString(this.circuitId) + ") ");
        }
        if (this.circuitId.getNodeId() == n) {
            Iterator iterator = this.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                INetElement iNetElement = net.getNetElem(n2);
                if (iNetElement == null) continue;
                hashSet.add(iNetElement.getNodeModel());
            }
        } else {
            if (this.dbgOn()) {
                db.fine("getAffectedNodes(" + this.getCircuitName() + ", " + OhCircuit.prettyString(this.circuitId) + ") " + ": Checking destinations to see if they have old NodeId");
            }
            for (IOhCircuitEnd iOhCircuitEnd : this.getDestinations()) {
                if (iOhCircuitEnd.getNodeId() != n || this.getSource() == null) continue;
                hashSet.add(this.getSource().getNodeModel());
                break;
            }
        }
        if (db.on()) {
            db.fine("Models associated with the old node = " + this.connModelMap.get(new Integer(n)));
        }
        this.connModelMap.remove(new Integer(n));
        return hashSet;
    }

    protected boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }

    protected class UpdateEvent {
        public boolean changed = false;
        public boolean deleted = false;
    }
}

