/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.List;

public class OhNetCircuitEnd
extends OhCircuitEnd {
    INetElement elem;
    INodeModel nodeModel;
    IPortModel portModel;
    INetLink associatedLink = null;
    IOhCircuitEnd cktEnd = null;
    private static final SDebug db = new SDebug("OhNetCircuitEnd");

    public OhNetCircuitEnd() {
        this.cktEnd = new OhCircuitEnd();
    }

    public OhNetCircuitEnd(IOhCircuitEnd iOhCircuitEnd, int n) {
        super(iOhCircuitEnd);
        this.setModels();
        INodeModel iNodeModel = null;
        if (iOhCircuitEnd.getNodeId() == n) {
            iNodeModel = this.nodeModel;
        } else {
            INetElement iNetElement = Network.instance().getNetElem(n);
            if (iNetElement != null) {
                iNodeModel = iNetElement.getNodeModel();
            }
        }
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
            this.setShelf(iOhCircuitEnd.getShelf());
        }
    }

    private void setModels() {
        block5: {
            this.elem = Network.instance().getNetElem(this.getNodeId());
            if (this.elem != null) {
                this.nodeModel = this.elem.getNodeModel();
            }
            if (this.nodeModel != null) {
                try {
                    IEntityTableModel iEntityTableModel = this.nodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        this.portModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(this.getPort());
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.dbgOn()) break block5;
                    db.warning("Can't find the entity for index = " + this.getPort());
                }
            }
        }
    }

    public INetElement getNetElement() {
        if (this.elem == null) {
            this.setModels();
        }
        return this.elem;
    }

    public INodeModel getNodeModel() {
        if (this.nodeModel == null) {
            this.setModels();
        }
        return this.nodeModel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
    }

    public boolean isPortOptical() {
        if (this.portModel == null) {
            this.setModels();
        }
        return this.portModel != null && this.portModel.isOptical();
    }

    public INetLink getAssociatedLink() {
        if (this.associatedLink == null) {
            ITdmPortModel iTdmPortModel;
            if (this.isPortOptical()) {
                this.associatedLink = Network.instance().findNetLinkFromEnt(this.elem, this.getPort(), true);
            }
            if (this.associatedLink == null && (iTdmPortModel = this.getTdmPortModelForDccLinkOnDwdmPort()) != null && iTdmPortModel instanceof ITdmPortModel) {
                this.associatedLink = Network.instance().findNetLinkFromEnt(this.elem, iTdmPortModel.getIndex(), true);
            }
        }
        return this.associatedLink;
    }

    public ITdmPortModel getTdmPortModelForDccLinkOnDwdmPort() {
        if (this.portModel instanceof IDwdmPortModel) {
            List list = this.portModel.getParent().getChildren();
            for (IEntityModel iEntityModel : list) {
                if (!(iEntityModel instanceof ITdmPortModel)) continue;
                return (ITdmPortModel)iEntityModel;
            }
        }
        return null;
    }

    public boolean associateWithLink(INetLink iNetLink) {
        if (iNetLink == null || this.getAssociatedLink() == null) {
            return false;
        }
        if (((Object)this.getAssociatedLink()).equals(iNetLink)) {
            return true;
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        return iNetLink2 != null && ((Object)this.getAssociatedLink()).equals(iNetLink2);
    }

    public boolean isPortAssociatedWithVirtualLink(OhCircuit ohCircuit, INetLink iNetLink) {
        INetLink[] iNetLinkArray = this.getAssociatedVirtualLinksForCkt(ohCircuit);
        if (iNetLink == null || iNetLinkArray == null) {
            return false;
        }
        if (iNetLinkArray.length != 2) {
            return false;
        }
        if (this.compareLinks(iNetLinkArray[0], iNetLink)) {
            return true;
        }
        if (this.compareLinks(iNetLinkArray[1], iNetLink)) {
            return true;
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        if (this.compareLinks(iNetLinkArray[0], iNetLink2)) {
            return true;
        }
        return this.compareLinks(iNetLinkArray[1], iNetLink2);
    }

    private boolean compareLinks(INetLink iNetLink, INetLink iNetLink2) {
        if (iNetLink.getSrc() != iNetLink2.getSrc()) {
            return false;
        }
        if (iNetLink.getDst() != iNetLink2.getDst()) {
            return false;
        }
        return iNetLink.getSrcEntityIndex() == iNetLink2.getSrcEntityIndex() && iNetLink.getDstEntityIndex() == iNetLink2.getDstEntityIndex();
    }

    public IEntityModel[] getAssociatedOtsPorts(OhCircuit ohCircuit) {
        IEntityModel[] iEntityModelArray = null;
        if (this.isPortOptical() && OchTrailHelper.isTrunkPort((IEntityModel)this.portModel)) {
            IOhConnectionModels iOhConnectionModels = this.nodeModel.getOhConnectionModels();
            OhChannelType ohChannelType = OhCircuitType.getOhCktTypeObj((int)ohCircuit.getCircuitType()).getCorrespondingChannelType();
            if (iOhConnectionModels.isChannelInUse(this.portModel.getIndex(), ohChannelType)) {
                int n;
                IEntityModel[] iEntityModelArray2;
                block7: {
                    iEntityModelArray2 = OchTrailHelper.getColocatedOchPorts((IEntityModel)this.portModel);
                    n = 0;
                    try {
                        n = ((IOpticsChannelModel)this.portModel.getInterfaceModel()).getActualWaveLength();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!db.on()) break block7;
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
                if (iEntityModelArray2.length < 1) {
                    return iEntityModelArray;
                }
                iEntityModelArray = new IEntityModel[]{OchncHelper.getInLinePort(n, iEntityModelArray2[0]), OchncHelper.getOutLinePort(n, iEntityModelArray2[0])};
            }
        }
        return iEntityModelArray;
    }

    public INetLink[] getAssociatedVirtualLinksForCkt(OhCircuit ohCircuit) {
        INetLink[] iNetLinkArray = null;
        if (this.isPortOptical() && OchTrailHelper.isTrunkPort((IEntityModel)this.portModel)) {
            IOhConnectionModels iOhConnectionModels = this.nodeModel.getOhConnectionModels();
            OhChannelType ohChannelType = OhCircuitType.getOhCktTypeObj((int)ohCircuit.getCircuitType()).getCorrespondingChannelType();
            if (iOhConnectionModels.isChannelInUse(this.portModel.getIndex(), ohChannelType)) {
                int n;
                IEntityModel[] iEntityModelArray;
                block7: {
                    iEntityModelArray = OchTrailHelper.getColocatedOchPorts((IEntityModel)this.portModel);
                    n = 0;
                    try {
                        n = ((IOpticsChannelModel)this.portModel.getInterfaceModel()).getActualWaveLength();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!db.on()) break block7;
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
                if (iEntityModelArray == null || iEntityModelArray.length < 1) {
                    return null;
                }
                iNetLinkArray = new INetLink[2];
                IEntityModel iEntityModel = OchncHelper.getInLinePort(n, iEntityModelArray[0]);
                iNetLinkArray[0] = this.getAssociatedVirtualLinkForOtsPort(iEntityModel);
                IEntityModel iEntityModel2 = OchncHelper.getOutLinePort(n, iEntityModelArray[0]);
                iNetLinkArray[1] = this.getAssociatedVirtualLinkForOtsPort(iEntityModel2);
            }
        }
        return iNetLinkArray;
    }

    private INetLink getAssociatedVirtualLinkForOtsPort(IEntityModel iEntityModel) {
        INetLink iNetLink = null;
        if (this.isPortOptical() && iEntityModel instanceof IPortModel) {
            iNetLink = Network.instance().findNetLinkFromEnt(this.elem, iEntityModel.getIndex());
        }
        return iNetLink;
    }

    public IEntityModel getEntityModel() throws ObjNotFound {
        IEntityModel iEntityModel;
        block4: {
            int n;
            iEntityModel = null;
            IEntityTableModel iEntityTableModel = null;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (n = this.getPort()) != 0) {
                try {
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getPort());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.dbgOn()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (iEntityModel != null) {
            return iEntityModel;
        }
        throw new ObjNotFound("Unable to get entity model");
    }

    protected boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }
}

