/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DropPath;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.PathSegment;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.LinkedList;

public class MemberPath {
    private DropPath dropPath;
    private LinkedList pathSegments;
    private MemberPrefs memberPrefs;

    public MemberPath(DropPath dropPath) {
        this.dropPath = dropPath;
        this.pathSegments = new LinkedList();
    }

    public void addPathSegments(LinkedList linkedList) {
        for (PathSegment pathSegment : linkedList) {
            this.addPathSegment(pathSegment);
        }
    }

    public void addPathSegment(PathSegment pathSegment) {
        this.pathSegments.add(pathSegment);
    }

    public LinkedList getPathSegments() {
        return this.pathSegments;
    }

    public LinkedList getSpans() {
        LinkedList linkedList = new LinkedList();
        for (PathSegment pathSegment : this.pathSegments) {
            linkedList.addAll(pathSegment.getPrimary());
            linkedList.addAll(pathSegment.getAlternate());
            linkedList.addAll(pathSegment.getDri());
        }
        return linkedList;
    }

    public void updatePathSegment(MemberPath memberPath) {
        PathSegment pathSegment = (PathSegment)memberPath.getPathSegments().getFirst();
        INetElement iNetElement = this.dropPath.getCircuitPath().getRoutePrefs().getActiveMember().findDriPeer(pathSegment.getSrc());
        INetElement iNetElement2 = this.dropPath.getCircuitPath().getRoutePrefs().getActiveMember().findDriPeer(pathSegment.getDst());
        for (PathSegment pathSegment2 : this.getPathSegments()) {
            if (pathSegment2.getSrc() == pathSegment.getSrc() || pathSegment2.getDst() == pathSegment.getDst()) {
                pathSegment2.setAlternate(pathSegment.getPrimary());
                return;
            }
            if (iNetElement == null || !pathSegment2.getSrc().equals(iNetElement) || iNetElement2 == null || !pathSegment2.getDst().equals(iNetElement2)) continue;
            pathSegment2.setAlternate(pathSegment.getPrimary());
            return;
        }
        this.addPathSegment(pathSegment);
    }

    public void addDriPathSegment(MemberPath memberPath) {
        PathSegment pathSegment = (PathSegment)memberPath.getPathSegments().getFirst();
        INetElement iNetElement = pathSegment.getSrc();
        for (PathSegment pathSegment2 : this.getPathSegments()) {
            LinkedList linkedList = pathSegment2.getPrimaryLinks();
            for (INetLink iNetLink : linkedList) {
                if (!iNetLink.getSrc().equals(iNetElement) && !iNetLink.getDst().equals(iNetElement)) continue;
                pathSegment2.setDri(pathSegment.getPrimary());
                return;
            }
        }
    }

    public void addBlsrDriSecondary(MemberPath memberPath) {
        PathSegment pathSegment = (PathSegment)memberPath.getPathSegments().getFirst();
        INetElement iNetElement = pathSegment.getSrc();
        INetElement iNetElement2 = pathSegment.getDst();
        for (PathSegment pathSegment2 : this.getPathSegments()) {
            LinkedList linkedList = pathSegment2.getPrimaryLinks();
            for (INetLink iNetLink : linkedList) {
                if (!iNetLink.getSrc().equals(iNetElement) && !iNetLink.getDst().equals(iNetElement) && !iNetLink.getSrc().equals(iNetElement2) && !iNetLink.getDst().equals(iNetElement2)) continue;
                pathSegment2.setDri(pathSegment.getPrimary());
                return;
            }
        }
    }

    public void setMemberPrefs(MemberPrefs memberPrefs) {
        this.memberPrefs = memberPrefs;
    }

    public MemberPrefs getMemberPrefs() {
        return this.memberPrefs;
    }

    public String prettyString() {
        String string = "\n\t\tMember Path: ";
        for (PathSegment pathSegment : this.pathSegments) {
            string = string + pathSegment.prettyString();
        }
        return string;
    }
}

