/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.OchncPathFilter;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xNoAlternatePath;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class OchncProtectedPathFilter
extends OchncPathFilter {
    public OchncProtectedPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        Set set = this.buildProtectSrgList();
        DropPrefs dropPrefs = this.prefs.getActiveDropPrefs();
        MemberGroupPrefs memberGroupPrefs = dropPrefs.getActiveMemberGroupPrefs();
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        memberPrefs.addSrgs(set);
        memberPrefs.setDiverseSrlg(true);
        CircuitPath circuitPath = super.getCircuitPath();
        OchncProtectedPathFilter.setPathProtectionRole(circuitPath.getAvailSpans(), 1);
        try {
            CircuitPath circuitPath2 = this.computeAlternatePath(circuitPath, this.prefs.getSrc(), this.prefs.getDst(), 3, null, null);
            if (circuitPath != null) {
                OchncProtectedPathFilter.setPathProtectionRole(circuitPath2.getAvailSpans(), 0);
                circuitPath.updatePathSegments(circuitPath2);
            }
        }
        catch (xNoAlternatePath xNoAlternatePath2) {
            throw new NoRoute(xNoAlternatePath2.getMessage());
        }
        return circuitPath;
    }

    private CircuitPath computeAlternatePath(CircuitPath circuitPath, INetElement iNetElement, INetElement iNetElement2, int n, IPathFilter iPathFilter, Set set) throws xNoAlternatePath {
        LinkedList linkedList = circuitPath.getPathLinks();
        if (!this.prefs.isOchncCircuit()) {
            linkedList.addAll(circuitPath.getReversePathLinks());
        }
        CircuitPath circuitPath2 = null;
        RoutePrefs routePrefs = RoutePrefs.getOchncRoutePrefs(this.prefs.getcktOptChannel(), iNetElement, this.prefs.getcktSrcEntityIndex(), this.prefs.getcktDstEntityIndex(), this.prefs.getcktSecSrcEntityIndex(), this.prefs.getcktSecDstEntityIndex());
        routePrefs.setCircuitType(this.prefs.getCircuitType());
        routePrefs.setCircuitSize(this.prefs.getCircuitSize());
        routePrefs.setParentFilter(iPathFilter);
        routePrefs.setOrigSource(this.prefs.getSrc());
        routePrefs.setOrigDrop(this.prefs.getDst());
        DropPrefs dropPrefs = routePrefs.getActiveDropPrefs();
        MemberGroupPrefs memberGroupPrefs = dropPrefs.getActiveMemberGroupPrefs();
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        dropPrefs.setDrop(iNetElement2);
        memberPrefs.setPrimaryOptimizationCriterion(this.prefs.getPrimaryOptimizationCriterion());
        memberPrefs.setPathProtection(n);
        memberPrefs.setExcludeSrgs(this.prefs.getProtExcludeSrgs());
        try {
            memberPrefs.setReqEntityList(this.prefs.getReqProtEntityList());
        }
        catch (ObjDuplicate objDuplicate) {
            SDebug.printStackTrace((Throwable)objDuplicate);
        }
        Set set2 = this.buildWorkingSrgList(linkedList);
        memberPrefs.addSrgs(set2);
        memberPrefs.setDiverseSrlg(true);
        routePrefs.getLog().getDebugLog().beginIndent();
        try {
            AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs, true);
            circuitPath2 = autoRouteRequestor.getCircuitPath();
        }
        catch (NoRoute noRoute) {
            DetailedLog detailedLog = noRoute.getDetailedLog();
            routePrefs.getLog().getDebugLog().endIndent();
            throw new xNoAlternatePath("Alternate path  for segment originating at " + iNetElement.prettyString() + " terminating at " + iNetElement2.prettyString() + " is not available", detailedLog);
        }
        routePrefs.getLog().getDebugLog().endIndent();
        return circuitPath2;
    }

    private Set buildWorkingSrgList(LinkedList linkedList) {
        HashSet<PortSrg> hashSet = new HashSet<PortSrg>();
        for (INetLink iNetLink : linkedList) {
            if (OchTrailHelper.isTrunkPort(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex()) || OchTrailHelper.isTrunkPort(iNetLink.getDst().getNodeModel(), iNetLink.getDstEntityIndex())) continue;
            hashSet.add(new PortSrg(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), iNetLink.getSrcShelfNumber(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber()));
            hashSet.add(new PortSrg(iNetLink.getDst(), iNetLink.getDstEntityIndex(), iNetLink.getDstShelfNumber(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber()));
        }
        return hashSet;
    }

    private Set buildProtectSrgList() {
        HashSet hashSet = new HashSet();
        this.addPorts(hashSet, this.prefs.getSrc().getNodeModel(), this.prefs.getcktSrcEntityIndex());
        this.addPorts(hashSet, this.prefs.getDst().getNodeModel(), this.prefs.getcktDstEntityIndex());
        return hashSet;
    }

    private void addPorts(Set set, INodeModel iNodeModel, int n) {
        try {
            IPortModel iPortModel;
            IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            if (OchTrailHelper.isTrunkPort(iNodeModel, n) && (iPortModel = OchTrailHelper.getConnectedPorts(iEntityModel)) != null && ((IEntityModel[])iPortModel).length == 2) {
                iEntityModel = iPortModel[1];
            }
            iPortModel = (IPortModel)OchncHelper.getProtectedOutLinePort(this.prefs.getcktOptChannel(), iEntityModel);
            INetElement iNetElement = Network.instance().findNetElem(iPortModel.getNodeModel());
            set.add(new PortSrg(iNetElement, iPortModel.getIndex(), iPortModel.getShelfId(), iPortModel.getSlot(), iPortModel.getPortNum()));
            this.info("Adding " + iPortModel + " to SRG list");
            IPortModel iPortModel2 = OchncHelper.getReversePort(iPortModel);
            set.add(new PortSrg(iNetElement, iPortModel2.getIndex(), iPortModel2.getShelfId(), iPortModel2.getSlot(), iPortModel2.getPortNum()));
            this.info("Adding " + iPortModel2 + " to SRG list");
        }
        catch (Exception exception) {
            this.info(exception.getMessage());
        }
    }

    private static void setPathProtectionRole(LinkedList linkedList, int n) {
        for (INetLinkSpan iNetLinkSpan : linkedList) {
            iNetLinkSpan.setProtectionRole(n);
        }
    }

    private void info(String string) {
        this.prefs.getLog().getDebugLog().info(string);
    }
}

