/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DebugLog;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptNode;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetLink;
import cerent.util.ILabel;
import java.util.LinkedList;

public class SptLink {
    private ILabelSet srcLabelSet = null;
    private ILabelSet dstLabelSet = null;
    private INetLink link;
    private SptNode srcNode;
    private SptNode dstNode;
    private DebugLog dLog;
    private xLinkNotUsable unusableReason;

    public SptLink(SptNode sptNode, INetLink iNetLink, DebugLog debugLog) {
        this.link = iNetLink;
        this.dLog = debugLog;
        this.srcNode = sptNode;
        this.unusableReason = null;
    }

    public SptLink(INetLink iNetLink, SptNode sptNode) {
        this.link = iNetLink;
        this.srcNode = sptNode;
        this.unusableReason = null;
    }

    protected SptNode getSrcNode() {
        return this.srcNode;
    }

    public SptNode getDstNode() {
        return this.dstNode;
    }

    protected void setDstLabelSet(ILabelSet iLabelSet) {
        this.dstLabelSet = iLabelSet;
    }

    protected void setSrcLabelSet(ILabelSet iLabelSet) {
        this.srcLabelSet = iLabelSet;
    }

    protected ILabelSet getDstLabelSet() {
        return this.dstLabelSet;
    }

    protected ILabelSet getSrcLabelSet() {
        return this.srcLabelSet;
    }

    public void setDstNode(SptNode sptNode) {
        this.dstNode = sptNode;
    }

    protected void setUnusableException(xLinkNotUsable xLinkNotUsable2) {
        this.unusableReason = xLinkNotUsable2;
    }

    protected xLinkNotUsable getUnusableException() {
        return this.unusableReason;
    }

    protected void setLabelSets(ILabelSet iLabelSet, ILabelSet iLabelSet2, RoutePrefs routePrefs) {
        boolean bl = routePrefs.Tsi();
        SptLink sptLink = this;
        SptLink sptLink2 = sptLink.getSrcNode().getBestLink();
        INetLink iNetLink = sptLink.getLink();
        INetLink iNetLink2 = null;
        if (sptLink2 != null) {
            iNetLink2 = sptLink2.getLink();
        }
        if (iNetLink2 != null && !bl && iNetLink.originatingInRing() && iNetLink2.terminatingInRing() && iNetLink.originatingRingName().equals(iNetLink2.terminatingRingName()) && iLabelSet != null) {
            iLabelSet.intersect(sptLink2.getDstLabelSet());
        }
        if (iNetLink.shouldSrcDstLabelsMatch()) {
            if (iLabelSet2 != null) {
                iLabelSet2.intersect(iLabelSet);
            }
            if (iLabelSet != null) {
                iLabelSet.intersect(iLabelSet2);
            }
        }
        if (iNetLink.isLOTunnel() && iLabelSet2 != null) {
            iLabelSet2.intersectSelf(iLabelSet);
        }
        this.srcLabelSet = iLabelSet;
        this.dstLabelSet = iLabelSet2;
    }

    protected void computeLabels(RoutePrefs routePrefs) {
        INetLink iNetLink = null;
        INetLink iNetLink2 = null;
        SptLink sptLink = null;
        SptLink sptLink2 = this;
        boolean bl = routePrefs.sameStsRouting();
        LinkedList linkedList = routePrefs.allStsToUse();
        while (sptLink2 != null) {
            iNetLink2 = sptLink2.getLink();
            if (iNetLink != null && (bl || !routePrefs.Tsi() && iNetLink2.terminatingInRing() && iNetLink.originatingInRing() && iNetLink2.terminatingRingName().equals(iNetLink.originatingRingName())) && sptLink2.dstLabelSet != null) {
                sptLink2.dstLabelSet.intersect(sptLink.getSrcLabelSet());
            }
            if (bl) {
                if (this.dLog != null) {
                    this.dLog.finest("SptLink:srcLabelSet size = " + sptLink2.getSrcLabelSet().size() + " before filtering for " + linkedList.size() + " # of HOs");
                }
                if (sptLink2.getSrcLabelSet() != null) {
                    sptLink2.getSrcLabelSet().hoFilter(linkedList);
                }
                if (this.dLog != null) {
                    this.dLog.finest("SptLink:srcLabelSet size after sameSts filtering " + sptLink2.getSrcLabelSet().size());
                }
            }
            if (iNetLink2.shouldSrcDstLabelsMatch()) {
                if (sptLink2.getSrcLabelSet() != null) {
                    sptLink2.getSrcLabelSet().intersect(sptLink2.getDstLabelSet());
                }
                if (sptLink2.getDstLabelSet() != null) {
                    sptLink2.getDstLabelSet().intersect(sptLink2.getSrcLabelSet());
                }
            }
            if (iNetLink2.isLOTunnel() && sptLink2.getDstLabelSet() != null) {
                sptLink2.getDstLabelSet().intersectSelf(sptLink2.getSrcLabelSet());
            }
            iNetLink = iNetLink2;
            sptLink = sptLink2;
            sptLink2 = sptLink2.getSrcNode().getBestLink();
        }
    }

    protected LinkedList getNSpans(boolean bl, int n) {
        LinkedList<NetLinkSpan> linkedList = new LinkedList<NetLinkSpan>();
        if (this.srcLabelSet.size() < n || this.dstLabelSet.size() < n) {
            return linkedList;
        }
        ILabel[] iLabelArray = this.srcLabelSet.getLabels(n);
        ILabel[] iLabelArray2 = this.dstLabelSet.getLabels(n);
        for (int i = 0; i < n; ++i) {
            NetLinkSpan netLinkSpan = new NetLinkSpan(this.getLink(), iLabelArray[i], iLabelArray2[i]);
            linkedList.add(netLinkSpan);
        }
        return linkedList;
    }

    public INetLink getLink() {
        return this.link;
    }

    public INetLink getParentLink() {
        if (this.getSrcNode() != null && this.getSrcNode().getBestLink() != null) {
            return this.getSrcNode().getBestLink().getLink();
        }
        return null;
    }

    public String prettyString() {
        return this.getLink().prettyString();
    }
}

