/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDccConnectionTableModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NoSuchDcc;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.Observer;

public class DccLinkStateMachine
extends LinkStateMachine {
    private IOhTermModel srcObs;
    private IOhTermModel dstObs;
    private IDccConnectionTableModel srcDcc;
    private IDccConnectionTableModel dstDcc;
    private ITermConnectionModel srcTerm = null;
    private ITermConnectionModel dstTerm = null;

    public DccLinkStateMachine(Network network, INetLink iNetLink, SDebug sDebug) {
        super(network, iNetLink, sDebug);
    }

    protected void registerSrcWithTerm() {
        NodeModel nodeModel = (NodeModel)this.link.getSrc().getNodeModel();
        if (!nodeModel.isInited()) {
            if (this.db.on()) {
                this.db.println("registerSrcWithTerm: src NE " + nodeModel.getActualHostName() + " not inited");
            }
            return;
        }
        if (nodeModel.provides(Feature.OCHNC_PROVISIONING)) {
            if (this.db.on()) {
                this.db.println("registerSrcWithTerm: using new ITermConnectionModel interface");
            }
            this.registerSrcWithSdcc();
            this.registerSrcWithLdcc();
            return;
        }
        if (this.srcState == 1) {
            if (this.db.on()) {
                this.db.println("registerSrcWithTerm: ITermConnectionModel not supported, using old interface");
            }
            if (this.link.getSrc().getConnectionState()) {
                try {
                    this.srcDcc = nodeModel.getIDccConnectionTableModel();
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerSrcWithTerm: src caught Comm Fail exception");
                }
                if (this.srcDcc != null) {
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.addObserver((IObservable)this.srcDcc, this.srcTermObserver);
                    try {
                        this.srcDcc.addSdccObserver(this.link.getSrcEntityIndex(), (Observer)this.srcTermObserver);
                        if (this.db.on()) {
                            this.db.println("registerSrcWithTerm: registered with NE " + this.link.getSrc().getActualAddressDisplay() + " DCC on index " + this.link.getSrcEntityIndex());
                        }
                        this.srcState = 2;
                        this.link.getSrc().deleteObserver(this);
                    }
                    catch (NoSuchTerm noSuchTerm) {
                        if (this.db.on()) {
                            this.db.println("registerSrcWithTerm: cannot observe Non-existent DccModel");
                        }
                    }
                    catch (NoSuchDcc noSuchDcc) {
                        if (this.db.on()) {
                            this.db.println("registerSrcWithTerm: cannot observe Non-existent DccModel");
                        }
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.println("registerSrcWithTerm: caught IO exception while adding DCC observer");
                    }
                } else if (this.db.on()) {
                    this.db.println("registerSrcWithTerm: failed to register with NE " + this.link.getSrc().getActualAddressDisplay() + " DCC, DCC = null");
                }
            } else if (this.db.on()) {
                this.db.println("registerSrcWithTerm: failed to register with NE " + this.link.getSrc().getActualAddressDisplay() + " DCC, NE not ready");
            }
        } else if (this.srcState == 2) {
            if (this.db.on()) {
                this.db.println("registerSrcWithTerm: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerSrcWithTerm: invalid srcState = " + this.srcState);
        }
    }

    private boolean addSrcTermObserver(ITermConnectionModel iTermConnectionModel) {
        if (iTermConnectionModel != null) {
            try {
                this.srcObs = iTermConnectionModel.getTermModel(this.link.getSrcEntityIndex());
                if (this.srcObs == null) {
                    if (this.db.on()) {
                        this.db.println("addSrcTermObserver: cannot find OhTermModel with index " + this.link.getSrcEntityIndex());
                    }
                    return false;
                }
                ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                modelIndirectObservable.addObserver((IObservable)this.srcObs, this.srcTermObserver);
                this.srcState = 2;
                this.link.getSrc().deleteObserver(this);
                return true;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.db.println("addSrcTermObserver: Comm Fail Exception");
            }
        } else if (this.db.on()) {
            this.db.println("addSrcTermObserver: failed to register with NE " + this.link.getSrc().getActualAddressDisplay() + " DCC, DCC = null");
        }
        return false;
    }

    private void registerSrcWithSdcc() {
        NodeModel nodeModel = (NodeModel)this.link.getSrc().getNodeModel();
        if (this.srcState == 1) {
            if (this.link.getSrc().getConnectionState()) {
                try {
                    if (nodeModel.provides(Feature.OCHNC_PROVISIONING)) {
                        this.srcTerm = nodeModel.getDccTermConnectionModel();
                        if (this.db.on()) {
                            this.db.println("registerSrcWithSdcc: ITermConnectionModel interface supported, srcTerm = " + this.srcTerm);
                        }
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerSrcWithSdcc: src caught Comm Fail exception");
                }
                if (this.addSrcTermObserver(this.srcTerm) && this.db.on()) {
                    this.db.println("registerSrcWithSdcc: observing SDCC on index " + this.link.getSrcEntityIndex());
                }
            } else if (this.db.on()) {
                this.db.println("registerSrcWithSdcc: failed to register with NE " + this.link.getSrc().getActualAddressDisplay() + " SDCC, NE not ready");
            }
        } else if (this.srcState == 2) {
            if (this.db.on()) {
                this.db.println("registerSrcWithSdcc: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerSrcWithSdcc: invalid srcState = " + this.srcState);
        }
    }

    private void registerSrcWithLdcc() {
        NodeModel nodeModel = (NodeModel)this.link.getSrc().getNodeModel();
        if (this.srcState == 1) {
            if (this.link.getSrc().getConnectionState()) {
                try {
                    if (nodeModel.provides(Feature.ENHANCED_DCC)) {
                        this.srcTerm = nodeModel.getLdccTermConnectionModel();
                        if (this.db.on()) {
                            this.db.println("registerSrcWithLdcc: ENHANCED_DCC feature supported, srcTerm = " + this.srcTerm);
                        }
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerSrcWithLdcc: src caught Comm Fail exception");
                }
                if (this.addSrcTermObserver(this.srcTerm) && this.db.on()) {
                    this.db.println("registerSrcWithLdcc: observing LDCC on index " + this.link.getSrcEntityIndex());
                }
            } else if (this.db.on()) {
                this.db.println("registerSrcWithLdcc: failed to register with NE" + this.link.getSrc().getActualAddressDisplay() + " LDCC, NE not ready");
            }
        } else if (this.srcState == 2) {
            if (this.db.on()) {
                this.db.println("registerSrcWithLdcc: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerSrcWithLdcc: invalid srcState = " + this.srcState);
        }
    }

    protected void registerDstWithTerm() {
        NodeModel nodeModel = (NodeModel)this.link.getDst().getNodeModel();
        if (!nodeModel.isInited()) {
            if (this.db.on()) {
                this.db.println("registerDstWithTerm: src NE " + nodeModel.getActualHostName() + " not inited");
            }
            return;
        }
        if (nodeModel.provides(Feature.OCHNC_PROVISIONING)) {
            if (this.db.on()) {
                this.db.println("registerDstWithTerm: using new ITermConnectionModel interface");
            }
            this.registerDstWithSdcc();
            this.registerDstWithLdcc();
            return;
        }
        if (this.dstState == 1) {
            if (this.db.on()) {
                this.db.println("registerDstWithTerm: ITermConnectionModel not supported, using old interface");
            }
            if (this.link.getDst().getConnectionState()) {
                try {
                    this.dstDcc = nodeModel.getIDccConnectionTableModel();
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerDstWithTerm: dst caught Comm Fail exception");
                }
                if (this.dstDcc != null) {
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.addObserver((IObservable)this.dstDcc, this.dstTermObserver);
                    try {
                        this.dstDcc.addSdccObserver(this.link.getDstEntityIndex(), (Observer)this.dstTermObserver);
                        if (this.db.on()) {
                            this.db.println("registerDstWithTerm: registered with NE " + this.link.getDst().getActualAddressDisplay() + " DCC on index " + this.link.getDstEntityIndex());
                        }
                        this.dstState = 2;
                        this.link.getDst().deleteObserver(this);
                    }
                    catch (NoSuchTerm noSuchTerm) {
                        if (this.db.on()) {
                            this.db.println("registerDstWithTerm: cannot observe Non-existent DccModel");
                        }
                    }
                    catch (NoSuchDcc noSuchDcc) {
                        if (this.db.on()) {
                            this.db.println("registerDstWithTerm: cannot observe Non-existent DccModel");
                        }
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.println("registerDstWithTerm: caught IO exception while adding DCC observer");
                    }
                } else if (this.db.on()) {
                    this.db.println("registerDstWithTerm: failed to register with NE " + this.link.getDst().getActualAddressDisplay() + " DCC, DCC = null");
                }
            } else if (this.db.on()) {
                this.db.println("registerDstWithTerm: failed to register with NE " + this.link.getDst().getActualAddressDisplay() + " DCC, NE not ready");
            }
        } else if (this.dstState == 2) {
            if (this.db.on()) {
                this.db.println("registerDstWithTerm: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerDstWithTerm: invalid dstState = " + this.dstState);
        }
    }

    private boolean addDstTermObserver(ITermConnectionModel iTermConnectionModel) {
        if (iTermConnectionModel != null) {
            try {
                this.dstObs = iTermConnectionModel.getTermModel(this.link.getDstEntityIndex());
                if (this.dstObs == null) {
                    if (this.db.on()) {
                        this.db.println("addDstTermObserver: cannot find OhTermModel with index " + this.link.getDstEntityIndex());
                    }
                    return false;
                }
                ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                modelIndirectObservable.addObserver((IObservable)this.dstObs, this.dstTermObserver);
                this.dstState = 2;
                this.link.getDst().deleteObserver(this);
                return true;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.db.println("addDstTermObserver: Comm Fail Exception");
            }
        } else if (this.db.on()) {
            this.db.println("addDstTermObserver: failed to register with NE " + this.link.getDst().getActualAddressDisplay() + " DCC, DCC = null");
        }
        return false;
    }

    private void registerDstWithSdcc() {
        NodeModel nodeModel = (NodeModel)this.link.getDst().getNodeModel();
        if (this.dstState == 1) {
            if (this.link.getDst().getConnectionState()) {
                try {
                    if (nodeModel.provides(Feature.OCHNC_PROVISIONING)) {
                        this.dstTerm = nodeModel.getDccTermConnectionModel();
                        if (this.db.on()) {
                            this.db.println("registerDstWithSdcc: ITermConnectionModel interface supported, dstTerm = " + this.dstTerm);
                        }
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerDstWithSdcc: dst caught Comm Fail exception");
                }
                if (this.addDstTermObserver(this.dstTerm) && this.db.on()) {
                    this.db.println("registerDstWithSdcc: observing SDCC on index " + this.link.getDstEntityIndex());
                }
            } else if (this.db.on()) {
                this.db.println("registerDstWithSdcc: failed to register with NE " + this.link.getDst().getActualAddressDisplay() + " SDCC, NE not ready");
            }
        } else if (this.dstState == 2) {
            if (this.db.on()) {
                this.db.println("registerDstWithSdcc: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerDstWithSdcc: invalid dstState = " + this.dstState);
        }
    }

    private void registerDstWithLdcc() {
        NodeModel nodeModel = (NodeModel)this.link.getDst().getNodeModel();
        if (this.dstState == 1) {
            if (this.link.getDst().getConnectionState()) {
                try {
                    if (nodeModel.provides(Feature.ENHANCED_DCC)) {
                        this.dstTerm = nodeModel.getLdccTermConnectionModel();
                        if (this.db.on()) {
                            this.db.println("registerDstWithLdcc: ENHANCED_DCC feature supported, dstTerm = " + this.dstTerm);
                        }
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerDstWithLdcc: dst caught Comm Fail exception");
                }
                if (this.addDstTermObserver(this.dstTerm) && this.db.on()) {
                    this.db.println("registerDstWithLdcc: observing LDCC on index " + this.link.getDstEntityIndex());
                }
            } else if (this.db.on()) {
                this.db.println("registerDstWithLdcc: failed to register with NE " + this.link.getDst().getActualAddressDisplay() + " LDCC, NE not ready");
            }
        } else if (this.dstState == 2) {
            if (this.db.on()) {
                this.db.println("registerDstWithLdcc: TERM already observed");
            }
        } else if (this.db.on()) {
            this.db.println("registerDstWithLdcc: invalid dstState = " + this.dstState);
        }
    }

    protected void deregisterSrcWithTerm() {
        if (this.srcState == 2) {
            int n = this.link.getSrcEntityIndex();
            if (this.srcDcc != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterSrcWithDcc: removing Sdcc observer on index " + n);
                }
                try {
                    this.srcDcc.deleteSdccObserver(n, (Observer)this.srcTermObserver);
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.deleteObserver((IObservable)this.srcDcc, this.srcTermObserver);
                    this.srcDcc = null;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterSrcWithTerm: Comm Fail while deleting srcDcc observer");
                }
                this.link.getSrc().addObserver(this);
                this.srcState = 1;
            } else if (this.srcTerm != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterSrcWithDcc: removing Term observer on index " + n);
                }
                try {
                    if (this.srcObs != null) {
                        ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                        modelIndirectObservable.deleteObserver((IObservable)this.srcObs, this.srcTermObserver);
                    } else if (this.db.on()) {
                        this.db.println("deregisterSrcWithTerm: cannot find OhTermModel with index " + n);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterSrcWithTerm: Comm Fail while deleting ohTermModel observer");
                }
                this.srcTerm = null;
                this.link.getSrc().addObserver(this);
                this.srcState = 1;
            }
        }
    }

    protected void deregisterDstWithTerm() {
        if (this.dstState == 2) {
            int n = this.link.getDstEntityIndex();
            if (this.dstDcc != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterDstWithDcc: removing Sdcc observer on index " + n);
                }
                try {
                    this.dstDcc.deleteSdccObserver(n, (Observer)this.dstTermObserver);
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.deleteObserver((IObservable)this.dstDcc, this.dstTermObserver);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterDstWithDcc: Comm Fail while deleting dstDcc observer");
                }
                this.dstDcc = null;
                this.link.getDst().addObserver(this);
                this.dstState = 1;
            } else if (this.dstTerm != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterDstWithDcc: removing Term observer on index " + n);
                }
                try {
                    if (this.dstObs != null) {
                        ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                        modelIndirectObservable.deleteObserver((IObservable)this.dstObs, this.dstTermObserver);
                    } else if (this.db.on()) {
                        this.db.println("deregisterDstWithTerm: cannot find OhTermModel with index " + n);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterDstWithTerm: Comm Fail while deleting ohTermModel observer");
                }
                this.dstTerm = null;
                this.link.getDst().addObserver(this);
                this.dstState = 1;
            }
        }
    }
}

