/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractLmpException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.ILmpCtrlChannelModels;
import cerent.cms.model.ILmpDataLinkModel;
import cerent.cms.model.ILmpDataLinkModels;
import cerent.cms.model.ILmpTeLinkModel;
import cerent.cms.model.ILmpTeLinkModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.ICtcRetriever;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.InetUtil;
import cerent.util.Preferences;
import cerent.util.RouterUtil;
import cerent.util.SDebug;
import cerent.util.tty.CtcCLIRetriever;
import cerent.util.tty.CtcCLIRetrieverException;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYLogFactory;
import cerent.util.tty.TTYSessionFactory;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LmpNetLinkManager
implements IObserver {
    protected static LmpNetLinkManager lmpNetLinkMgr = null;
    private Map<String, CrsLmpData> lmpCRSsToHandle;
    private List<INetElement> lmpDWDMsToHandle;
    private static final String PROP_CTC = "ctc";
    private static final String PROP_CTM_MODE = "ctmmode";
    private static final String PROP_CRS_DISCOVERY = "crs.discovery";
    private boolean ctcRunningInCtmMode;
    private boolean crsDiscoveryAllowed;
    protected LmpNetLinkMgrDebug db = new LmpNetLinkMgrDebug();

    private LmpNetLinkManager() {
        this.lmpCRSsToHandle = new HashMap<String, CrsLmpData>();
        this.lmpDWDMsToHandle = new ArrayList<INetElement>();
        this.ctcRunningInCtmMode = Preferences.instance().getBoolean(PROP_CTC, PROP_CTM_MODE, false);
        this.crsDiscoveryAllowed = Preferences.instance().getBoolean(PROP_CTC, PROP_CRS_DISCOVERY, true);
    }

    public static synchronized LmpNetLinkManager instance() {
        if (lmpNetLinkMgr == null) {
            lmpNetLinkMgr = new LmpNetLinkManager();
        }
        return lmpNetLinkMgr;
    }

    public void discoverLMPLinks() {
        if (!this.ctcRunningInCtmMode && this.crsDiscoveryAllowed) {
            this.processCrsList();
            this.processDwdmNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDwdmNodes() {
        if (this.lmpDWDMsToHandle.size() > 0) {
            Object object;
            ArrayList<INetElement> arrayList;
            Object object2 = this.lmpDWDMsToHandle;
            synchronized (object2) {
                arrayList = new ArrayList<INetElement>(this.lmpDWDMsToHandle);
                this.lmpDWDMsToHandle.clear();
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (INetElement)object2.next();
                if (this.db.on()) {
                    this.db.println("Processing DWDM node " + object.getName());
                }
                if (Network.instance().findNetElem((INetElement)object) == null) {
                    if (this.db.on()) {
                        this.db.println("processDwdmNodes: Node " + object.getName() + " is no more in the network.");
                    }
                    object2.remove();
                    continue;
                }
                INodeModel iNodeModel = object.getNodeModel();
                if (!object.getConnectionState() || !iNodeModel.isInited()) {
                    if (!this.db.on()) continue;
                    this.db.println("node " + object.getName() + " not connected/inited - skip it");
                    continue;
                }
                if (!iNodeModel.getNeType().endsWith("454") && !iNodeModel.getNeType().endsWith("454SDH")) {
                    if (this.db.on()) {
                        this.db.println("processDwdmNodes: Not a DWDM node, skipped");
                    }
                    object2.remove();
                    continue;
                }
                if (!iNodeModel.provides(Feature.CRS_OCHTRAIL_LMP)) {
                    if (this.db.on()) {
                        this.db.println("processDwdmNodes: LMP Links not supported at node " + iNodeModel.getName());
                    }
                    object2.remove();
                    continue;
                }
                this.processLmpLinks((INetElement)object);
                object2.remove();
            }
            if (arrayList.size() != 0) {
                object = this.lmpDWDMsToHandle;
                synchronized (object) {
                    this.lmpDWDMsToHandle.addAll(arrayList);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCrsList() {
        if (this.lmpCRSsToHandle.size() > 0) {
            Map<String, CrsLmpData> map = this.lmpCRSsToHandle;
            synchronized (map) {
                Iterator<String> iterator = this.lmpCRSsToHandle.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    CrsLmpData crsLmpData = this.lmpCRSsToHandle.get(string);
                    HashMap<INetElement, ILmpCtrlChannelModel> hashMap = crsLmpData.getControlChannels();
                    block15: for (INetElement iNetElement : hashMap.keySet()) {
                        INodeModel iNodeModel = iNetElement.getNodeModel();
                        switch (crsLmpData.getCrsState()) {
                            case NOT_CONNECTED: {
                                crsLmpData.setCrsState(CrsState.SESSION_PENDING);
                                CrsSessionGenerator crsSessionGenerator = new CrsSessionGenerator(string, iNetElement);
                                crsSessionGenerator.start();
                                break;
                            }
                            case SESSION_OPEN: {
                                try {
                                    this.addCrsNeToNetwork(string, iNetElement, crsLmpData);
                                    crsLmpData.setCrsState(CrsState.CONNECTED);
                                }
                                catch (UnknownHostException unknownHostException) {
                                    if (!this.db.on()) continue block15;
                                    this.db.println("processCrsList: UnknownHostException " + unknownHostException);
                                }
                                catch (AbstractCmsIOException abstractCmsIOException) {
                                    if (!this.db.on()) continue block15;
                                    this.db.println("processCrsList: AbstractCmsIOException " + (Object)((Object)abstractCmsIOException));
                                }
                                break;
                            }
                            case CONNECTED: {
                                ILmpTeLinkModels iLmpTeLinkModels = iNodeModel.getILmpTeLinkModels();
                                try {
                                    ILmpTeLinkModel[] iLmpTeLinkModelArray = iLmpTeLinkModels.getITeLinksForCtrlChannel(hashMap.get(iNetElement));
                                    INetElement iNetElement2 = crsLmpData.getCrsNe();
                                    if (iNetElement2.isInited()) {
                                        for (ILmpTeLinkModel iLmpTeLinkModel : iLmpTeLinkModelArray) {
                                            if (iNetElement2 == null) {
                                                throw new Exception("WARNING!!!processCrsList: CRS NE null for ip " + string);
                                            }
                                            this.processLmpTeLink(iNetElement, iNetElement2, hashMap.get(iNetElement), iLmpTeLinkModel);
                                        }
                                        iterator.remove();
                                        break;
                                    }
                                    if (!this.db.on()) continue block15;
                                    this.db.println("processCrsList: CRS1 NE " + iNetElement2.getHostName() + " not Inited yet!");
                                    break;
                                }
                                catch (AbstractLmpException abstractLmpException) {
                                    if (!this.db.on()) continue block15;
                                    this.db.println("processCrsList: " + (Object)((Object)abstractLmpException));
                                    break;
                                }
                                catch (Exception exception) {
                                    if (!this.db.on()) break;
                                    this.db.println("processCrsList: " + exception);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void processLmpLinks(INetElement iNetElement) {
        ILmpCtrlChannelModel[] iLmpCtrlChannelModelArray;
        ILmpCtrlChannelModels iLmpCtrlChannelModels;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (this.db.on()) {
            this.db.println("processLmpLinks() - Processing node " + iNodeModel.getName());
        }
        if ((iLmpCtrlChannelModels = iNodeModel.getILmpCtrlChannelModels()) == null) {
            if (this.db.on()) {
                this.db.println("WARNING!!! processLmpLinks: control channels model is NULL");
            }
            return;
        }
        iLmpCtrlChannelModels.addObserver((IObserver)this);
        ILmpDataLinkModels iLmpDataLinkModels = iNodeModel.getILmpDataLinkModels();
        if (iLmpDataLinkModels != null) {
            iLmpDataLinkModels.addObserver((IObserver)this);
        }
        try {
            iLmpCtrlChannelModelArray = iLmpCtrlChannelModels.getICtrlChannels();
        }
        catch (AbstractLmpException abstractLmpException) {
            if (this.db.on()) {
                this.db.println("WARNING!!! processLmpLinks : Cannot access LMP links at node " + iNetElement.getName() + ": " + (Object)((Object)abstractLmpException));
            }
            return;
        }
        for (ILmpCtrlChannelModel iLmpCtrlChannelModel : iLmpCtrlChannelModelArray) {
            try {
                this.processLmpCtrlChannel(iNetElement, iLmpCtrlChannelModel);
            }
            catch (AbstractLmpException abstractLmpException) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpLinks : LmpException while processing LMP CTRL Channel " + iNetElement.getName() + ": " + (Object)((Object)abstractLmpException));
            }
            catch (CtcCLIRetrieverException ctcCLIRetrieverException) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpLinks : CtcCLIRetrieverException while processing LMP CTRL Channel " + iNetElement.getName() + ": " + (Object)((Object)ctcCLIRetrieverException));
            }
            catch (IOException iOException) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpLinks : IOException while processing LMP CTRL Channel " + iNetElement.getName() + ": " + iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLmpCtrlChannel(INetElement iNetElement, ILmpCtrlChannelModel iLmpCtrlChannelModel) throws AbstractLmpException, CtcCLIRetrieverException, IOException {
        if (!iLmpCtrlChannelModel.isRemoteCrs()) {
            if (this.db.on()) {
                this.db.println("WARNING!!! processLmpCtrlChannel : remote node is  not CRS1");
            }
            return;
        }
        TTYLogFactory.setClassLoader((ClassLoader)this.getClass().getClassLoader());
        IIpAddr iIpAddr = iLmpCtrlChannelModel.getIRemoteNodeId();
        String string = InetUtil.makeDottedString(iIpAddr);
        if (this.db.on()) {
            this.db.println("processLmpCtrlChannel() called for NE " + iNetElement.getName() + ", CTRL Channel to " + string);
        }
        Map<String, CrsLmpData> map = this.lmpCRSsToHandle;
        synchronized (map) {
            if (this.lmpCRSsToHandle.containsKey(string)) {
                CrsLmpData crsLmpData = this.lmpCRSsToHandle.get(string);
                HashMap<INetElement, ILmpCtrlChannelModel> hashMap = crsLmpData.getControlChannels();
                if (!hashMap.containsKey(iNetElement)) {
                    hashMap.put(iNetElement, iLmpCtrlChannelModel);
                }
            } else {
                HashMap<INetElement, ILmpCtrlChannelModel> hashMap = new HashMap<INetElement, ILmpCtrlChannelModel>();
                hashMap.put(iNetElement, iLmpCtrlChannelModel);
                CrsLmpData crsLmpData = new CrsLmpData(hashMap);
                this.lmpCRSsToHandle.put(string, crsLmpData);
            }
        }
    }

    private void processLmpTeLink(INetElement iNetElement, INetElement iNetElement2, ILmpCtrlChannelModel iLmpCtrlChannelModel, ILmpTeLinkModel iLmpTeLinkModel) throws AbstractLmpException {
        ILmpDataLinkModel[] iLmpDataLinkModelArray;
        if (this.db.on()) {
            this.db.println("processLmpTeLink() called for TE Link " + iLmpTeLinkModel.getLocalTeLinkId());
        }
        ILmpDataLinkModels iLmpDataLinkModels = iNetElement.getNodeModel().getILmpDataLinkModels();
        for (ILmpDataLinkModel iLmpDataLinkModel : iLmpDataLinkModelArray = iLmpDataLinkModels.getIDataLinksForTeLink(iLmpTeLinkModel)) {
            try {
                this.processLmpDataLink(iNetElement, iNetElement2, iLmpTeLinkModel, iLmpDataLinkModel);
            }
            catch (AbstractLmpException abstractLmpException) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpTeLink : Cannot process LMP Data Link " + iNetElement.getName() + ": " + (Object)((Object)abstractLmpException));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpTeLink : Cannot process LMP Data Link " + iNetElement.getName() + ": " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpTeLink : Cannot process LMP Data Link " + iNetElement.getName() + ": " + (Object)((Object)wrongInterfaceType));
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpTeLink : Cannot process LMP Data Link " + iNetElement.getName() + ": " + (Object)((Object)noSuchInterface));
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.db.on()) continue;
                this.db.println("WARNING!!! processLmpTeLink : Cannot process LMP Data Link " + iNetElement.getName() + ": " + (Object)((Object)objDuplicate));
            }
        }
    }

    private void processLmpDataLink(INetElement iNetElement, INetElement iNetElement2, ILmpTeLinkModel iLmpTeLinkModel, ILmpDataLinkModel iLmpDataLinkModel) throws AbstractLmpException, AbstractCmsNoSuchEntityException, WrongInterfaceType, NoSuchInterface, ObjDuplicate {
        Object object;
        LinkModel linkModel;
        Object object2;
        Topology topology;
        int n;
        int n2;
        int n3;
        block24: {
            if (this.db.on()) {
                this.db.println("Processing LMP Data Link from " + iNetElement.getName() + " to " + iNetElement2.getName() + ", port 0x" + Integer.toHexString(iLmpDataLinkModel.getRemoteDataLinkId()));
            }
            n3 = iLmpDataLinkModel.getRemoteCrsPortId();
            n2 = iLmpDataLinkModel.getLocalPortId();
            n = iLmpDataLinkModel.getNodeModel().getILmpDataLinkModels().getTxPortByRx2(iLmpDataLinkModel.getLocalPortId());
            if (n3 == -1) {
                n3 = iLmpDataLinkModel.getRemoteDataLinkId();
            }
            if (iNetElement.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
                block23: {
                    try {
                        topology = (IPortModel)iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(n2);
                        if (topology instanceof IOpticsPortModel && ((IOpticsPortModel)topology).isPassivePort()) {
                            n2 = OchTrailHelper.getColocatedAggregatedPort((IEntityModel)topology, ((IOpticsPortModel)topology).getWaveLength()).getEntityIndex();
                        }
                    }
                    catch (Exception exception) {
                        if (!this.db.on()) break block23;
                        LmpNetLinkMgrDebug.printStackTrace((Throwable)exception);
                    }
                }
                try {
                    topology = (IPortModel)iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(n);
                    if (topology instanceof IOpticsPortModel && ((IOpticsPortModel)topology).isPassivePort()) {
                        n = OchTrailHelper.getColocatedAggregatedPort((IEntityModel)topology, ((IOpticsPortModel)topology).getWaveLength()).getEntityIndex();
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block24;
                    LmpNetLinkMgrDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        topology = iNetElement.getTopology();
        Network network = Network.instance();
        INetLink iNetLink = Network.instance().findNetLink(iNetElement, n2, null, iNetElement2, n3, null, false, 11);
        if (iNetLink == null) {
            object2 = new LinkModel(iNetElement.getNodeModel(), n2, null, iNetElement2.getNodeModel(), n3, null, 11, 5, 13, false, false, -1, -1, 3, "", 0, 0, 0, 1024, 0, 0);
            iNetLink = NetLinkFactory.createNetLink(network, (ILinkModel)object2, iNetElement, iNetElement2, topology, false, false);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: adding LMP link to network " + iNetLink.prettyString());
            }
            network.addNetLink(iNetLink);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: starting observation of LMP data link");
            }
            ((LmpDataLinkNetLink)iNetLink).startObservingLmp(iLmpDataLinkModel);
            linkModel = new LinkModel(iNetElement2.getNodeModel(), n3, null, iNetElement.getNodeModel(), n2, null, 11, 5, 13, false, false, -1, -1, 3, "", 0, 0, 0, 1024, 0, 0);
            object = NetLinkFactory.createNetLink(network, (ILinkModel)linkModel, iNetElement2, iNetElement, topology, false, false);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: adding reverse link to network");
            }
            network.addNetLink((INetLink)object);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: starting observation of LMP data link");
            }
            ((LmpDataLinkNetLink)object).startObservingLmp(iLmpDataLinkModel);
        } else if (this.db.on()) {
            this.db.println("processLmpDataLink: LMP DL link is already in the network");
        }
        object2 = Network.instance().findNetLink(iNetElement, n, null, iNetElement2, n3, null, false, 11);
        if (object2 == null) {
            linkModel = new LinkModel(iNetElement.getNodeModel(), n, null, iNetElement2.getNodeModel(), n3, null, 11, 5, 13, true, true, -1, -1, 3, "", 0, 0, 0, 1024, 0, 0);
            object2 = NetLinkFactory.createNetLink(network, (ILinkModel)linkModel, iNetElement, iNetElement2, topology, false, false);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: adding LMP link to network");
            }
            network.addNetLink((INetLink)object2);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: starting observation of LMP data link");
            }
            ((LmpDataLinkNetLink)object2).startObservingLmp(iLmpDataLinkModel);
            object = new LinkModel(iNetElement2.getNodeModel(), n3, null, iNetElement.getNodeModel(), n, null, 11, 5, 13, true, true, -1, -1, 3, "", 0, 0, 0, 1024, 0, 0);
            INetLink iNetLink2 = NetLinkFactory.createNetLink(network, (ILinkModel)object, iNetElement2, iNetElement, topology, false, false);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: adding reverse link to network");
            }
            network.addNetLink(iNetLink2);
            if (this.db.on()) {
                this.db.println("processLmpDataLink: starting observation of LMP data link");
            }
            ((LmpDataLinkNetLink)iNetLink2).startObservingLmp(iLmpDataLinkModel);
        } else if (this.db.on()) {
            this.db.println("processLmpDataLink: LMP DL link is already in the network");
        }
    }

    private void addCrsNeToNetwork(String string, INetElement iNetElement, CrsLmpData crsLmpData) throws UnknownHostException, AbstractCmsIOException {
        String string2;
        INodeModel iNodeModel;
        String string3;
        Network network;
        INetElement iNetElement2;
        if (this.db.on()) {
            this.db.println("addCrsNeToNetwork: adding CRS NE " + string + " into the network");
        }
        if ((iNetElement2 = (network = Network.instance()).addNetElement(string, string3 = (iNodeModel = iNetElement.getNodeModel()).getUserName(), string2 = iNodeModel.getUserPassword(), iNetElement)) == null) {
            if (this.db.on()) {
                this.db.println("WARNING!!! CRS NE was not added for " + string);
            }
            return;
        }
        crsLmpData.setCrsNe(iNetElement2);
        if (this.db.on()) {
            this.db.println("Added CRS NE = " + iNetElement2.getName() + (iNetElement2 != null ? ", inited = " + iNetElement2.isInited() : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewNE(INetElement iNetElement) {
        if (!this.ctcRunningInCtmMode && this.crsDiscoveryAllowed) {
            if (this.db.on()) {
                this.db.println("addNewNE: " + iNetElement.getName());
            }
            List<INetElement> list = this.lmpDWDMsToHandle;
            synchronized (list) {
                if (!this.lmpDWDMsToHandle.contains(iNetElement)) {
                    this.lmpDWDMsToHandle.add(iNetElement);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IObservable iObservable, Object object) {
        block32: {
            block30: {
                block31: {
                    ILmpCtrlChannelModel[] iLmpCtrlChannelModelArray;
                    if (!(iObservable instanceof ILmpCtrlChannelModels)) break block30;
                    if (object != ModelUpdateType.CHANGED) break block31;
                    ILmpCtrlChannelModels iLmpCtrlChannelModels = (ILmpCtrlChannelModels)iObservable;
                    INetElement iNetElement = Network.instance().getNetElem(iLmpCtrlChannelModels.getNodeModel().getNodeId());
                    if (iNetElement == null) break block32;
                    try {
                        iLmpCtrlChannelModelArray = iLmpCtrlChannelModels.getICtrlChannels();
                    }
                    catch (Exception exception) {
                        this.db.warning("Cannot access LMP links at node " + iNetElement.getName() + ": " + exception.getMessage());
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        return;
                    }
                    for (ILmpCtrlChannelModel iLmpCtrlChannelModel : iLmpCtrlChannelModelArray) {
                        try {
                            this.processLmpCtrlChannel(iNetElement, iLmpCtrlChannelModel);
                        }
                        catch (Exception exception) {
                            this.db.warning("Cannot process LMP CTRL Channel: " + exception.getMessage());
                            if (!this.db.on()) continue;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    break block32;
                }
                if (object != ModelUpdateType.DELETED) break block32;
                ILmpCtrlChannelModels iLmpCtrlChannelModels = (ILmpCtrlChannelModels)iObservable;
                INetElement iNetElement = Network.instance().getNetElem(iLmpCtrlChannelModels.getNodeModel().getNodeId());
                if (iNetElement != null) {
                    ILmpCtrlChannelModel[] iLmpCtrlChannelModelArray;
                    try {
                        iLmpCtrlChannelModelArray = iLmpCtrlChannelModels.getICtrlChannels();
                    }
                    catch (Exception exception) {
                        this.db.warning("Cannot access LMP links at node " + iNetElement.getName() + ": " + exception.getMessage());
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        return;
                    }
                    Map<String, CrsLmpData> map = this.lmpCRSsToHandle;
                    synchronized (map) {
                        for (String string : this.lmpCRSsToHandle.keySet()) {
                            boolean bl = false;
                            for (ILmpCtrlChannelModel iLmpCtrlChannelModels2 : iLmpCtrlChannelModelArray) {
                                try {
                                    String bl2 = InetUtil.makeDottedString(iLmpCtrlChannelModels2.getIRemoteNodeIpAddress());
                                    if (!bl2.equals(string)) continue;
                                    bl = true;
                                }
                                catch (Exception exception) {
                                    this.db.warning("Cannot access CC LMP link data at node " + iNetElement.getName() + ": " + exception.getMessage());
                                    if (!this.db.on()) continue;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (bl) continue;
                            CrsLmpData crsLmpData = this.lmpCRSsToHandle.get(string);
                            HashMap<INetElement, ILmpCtrlChannelModel> hashMap = crsLmpData.getControlChannels();
                            hashMap.remove(iNetElement);
                            List list = (List)Network.instance().getAllElements();
                            Iterator iterator = list.iterator();
                            boolean bl2 = false;
                            while (iterator.hasNext()) {
                                NetElement netElement = (NetElement)iterator.next();
                                INodeModel iNodeModel = netElement.getNodeModel();
                                if (!iNodeModel.getNeType().endsWith("454") && !iNodeModel.getNeType().endsWith("454SDH")) continue;
                                try {
                                    ILmpCtrlChannelModel[] iLmpCtrlChannelModel;
                                    for (ILmpCtrlChannelModel iLmpCtrlChannelModel2 : iLmpCtrlChannelModel = iNodeModel.getILmpCtrlChannelModels().getICtrlChannels()) {
                                        String string2 = InetUtil.makeDottedString(iLmpCtrlChannelModel2.getIRemoteNodeIpAddress());
                                        if (!string2.equals(string)) continue;
                                        bl2 = true;
                                    }
                                }
                                catch (Exception exception) {
                                    this.db.warning("Cannot access CC LMP link data at node " + netElement.getName() + ": " + exception.getMessage());
                                    if (!this.db.on()) continue;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (bl2) continue;
                            TTYSessionFactory.instance().destroySessions(string);
                        }
                    }
                }
                break block32;
            }
            if (iObservable instanceof ILmpDataLinkModels && object == ModelUpdateType.CHANGED) {
                ILmpDataLinkModels iLmpDataLinkModels = (ILmpDataLinkModels)iObservable;
                INetElement iNetElement = Network.instance().getNetElem(iLmpDataLinkModels.getNodeModel().getNodeId());
                ILmpTeLinkModels iLmpTeLinkModels = iLmpDataLinkModels.getNodeModel().getILmpTeLinkModels();
                if (iNetElement != null) {
                    ILmpDataLinkModel[] iLmpDataLinkModelArray;
                    try {
                        iLmpDataLinkModelArray = iLmpDataLinkModels.getIDataLinks();
                    }
                    catch (Exception exception) {
                        this.db.warning("Cannot access LMP data links at node " + iNetElement.getName() + ": " + exception.getMessage());
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        return;
                    }
                    block22: for (ILmpDataLinkModel iLmpDataLinkModel : iLmpDataLinkModelArray) {
                        try {
                            ILmpTeLinkModel iLmpTeLinkModel = iLmpTeLinkModels.getITeLink(iLmpDataLinkModel.getLocalTeLinkId());
                            INetElement iNetElement2 = Network.instance().findNetElemByIp(InetUtil.makeDottedString(iLmpTeLinkModel.getIRemoteNodeId()));
                            ILmpCtrlChannelModels iLmpCtrlChannelModels = iLmpDataLinkModels.getNodeModel().getILmpCtrlChannelModels();
                            for (ILmpCtrlChannelModel iLmpCtrlChannelModel : iLmpCtrlChannelModels.getICtrlChannels()) {
                                if (iLmpCtrlChannelModel.getIRemoteNodeId().compareTo((Object)iLmpTeLinkModel.getIRemoteNodeId()) != 0 || !iLmpCtrlChannelModel.isRemoteCrs()) continue;
                                if (iNetElement2 == null) continue block22;
                                this.processLmpDataLink(iNetElement, iNetElement2, iLmpTeLinkModel, iLmpDataLinkModel);
                                continue block22;
                            }
                        }
                        catch (Exception exception) {
                            this.db.warning("Cannot process LMP CTRL Channel: " + exception.getMessage());
                            if (!this.db.on()) continue;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
            }
        }
    }

    public class LmpNetLinkMgrDebug
    extends SDebug {
        public LmpNetLinkMgrDebug() {
            super("LmpNetLinkMgrDebug");
        }

        public final void dump() {
            if (lmpNetLinkMgr != null) {
                this.dumpLmpCRSToHandle();
                this.dumpLmpDwdmToHandle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpLmpCRSToHandle() {
            LmpNetLinkManager.this.db.println("======================================");
            LmpNetLinkManager.this.db.println("CRS1 nodes to handle:");
            if (LmpNetLinkManager.this.lmpCRSsToHandle.size() > 0) {
                Map map = LmpNetLinkManager.this.lmpCRSsToHandle;
                synchronized (map) {
                    for (String string : LmpNetLinkManager.this.lmpCRSsToHandle.keySet()) {
                        LmpNetLinkManager.this.db.println("CRS1: " + string);
                        CrsLmpData crsLmpData = (CrsLmpData)LmpNetLinkManager.this.lmpCRSsToHandle.get(string);
                        HashMap<INetElement, ILmpCtrlChannelModel> hashMap = crsLmpData.getControlChannels();
                        Iterator<INetElement> iterator = hashMap.keySet().iterator();
                        LmpNetLinkManager.this.db.println("CRS1 state: " + (Object)((Object)crsLmpData.getCrsState()));
                        LmpNetLinkManager.this.db.println("Connected to: ");
                        while (iterator.hasNext()) {
                            LmpNetLinkManager.this.db.println("> " + iterator.next().getName());
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpLmpDwdmToHandle() {
            LmpNetLinkManager.this.db.println("======================================");
            LmpNetLinkManager.this.db.println("DWDM Nodes to handle:");
            List list = LmpNetLinkManager.this.lmpDWDMsToHandle;
            synchronized (list) {
                Iterator iterator = LmpNetLinkManager.this.lmpDWDMsToHandle.iterator();
                while (iterator.hasNext()) {
                    LmpNetLinkManager.this.db.println(((INetElement)iterator.next()).getName());
                }
            }
        }
    }

    private class CrsSessionGenerator
    extends Thread {
        String crsHostName;
        INetElement dwdmPeerNode;

        CrsSessionGenerator(String string, INetElement iNetElement) {
            this.crsHostName = string;
            this.dwdmPeerNode = iNetElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            ITTYSession iTTYSession = null;
            try {
                String string;
                block20: {
                    String string2;
                    if (LmpNetLinkManager.this.db.on()) {
                        LmpNetLinkManager.this.db.println("GETTING SESSION for " + this.crsHostName);
                    }
                    INodeModel iNodeModel = this.dwdmPeerNode.getNodeModel();
                    Preferences preferences = Preferences.instance();
                    if (preferences.getBoolean("ctc.router", "useRouterLogin", false)) {
                        object = preferences.getProperty("ctc.router", "username", "");
                        string2 = RouterUtil.decrypt(preferences.getProperty("ctc.router", "password", ""), (String)object);
                    } else {
                        object = iNodeModel.getUserName();
                        string2 = iNodeModel.getUserPassword();
                    }
                    try {
                        iTTYSession = TTYSessionFactory.instance().getSession(this.crsHostName, (String)object, string2, TTYSessionFactory.SessionType.CLI);
                        string = null;
                        if (iTTYSession == null) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (iTTYSession == null) throw throwable;
                        iTTYSession.releaseMe();
                        throw throwable;
                    }
                    iTTYSession.releaseMe();
                }
                if (LmpNetLinkManager.this.db.on()) {
                    LmpNetLinkManager.this.db.println("SESSION GOT for " + this.crsHostName);
                }
                CtcCLIRetriever ctcCLIRetriever = CtcCLIRetriever.instance();
                if (LmpNetLinkManager.this.db.on()) {
                    LmpNetLinkManager.this.db.println("Creating CLI Retriever for " + this.crsHostName);
                }
                if (!"crs".equals(string = ctcCLIRetriever.getNeType(this.crsHostName))) {
                    if (!LmpNetLinkManager.this.db.on()) return;
                    LmpNetLinkManager.this.db.println("Node is not CRS type but \"" + string + "\". Skipped");
                    return;
                }
                if (LmpNetLinkManager.this.db.on()) {
                    LmpNetLinkManager.this.db.println("Setting CLI Retriever for " + this.crsHostName);
                }
                CtcHttpRetriever.setCtcRetrieverForNode((ICtcRetriever)CtcCLIRetriever.instance(), (String)this.crsHostName);
            }
            catch (Exception exception) {
                if (LmpNetLinkManager.this.db.on()) {
                    LmpNetLinkManager.this.db.println("WARNING!!! SESSION NOT created - Node Unreachable Exception");
                }
                Map map = LmpNetLinkManager.this.lmpCRSsToHandle;
                synchronized (map) {
                    CrsLmpData crsLmpData = (CrsLmpData)LmpNetLinkManager.this.lmpCRSsToHandle.get(this.crsHostName);
                    if (crsLmpData != null) {
                        crsLmpData.setCrsState(CrsState.NOT_CONNECTED);
                    } else {
                        if (!LmpNetLinkManager.this.db.on()) return;
                        LmpNetLinkManager.this.db.println("WARNING!!! crsLmpData NULL trying to put back in NOT_CONNECTED");
                    }
                    return;
                }
            }
            Map map = LmpNetLinkManager.this.lmpCRSsToHandle;
            synchronized (map) {
                object = (CrsLmpData)LmpNetLinkManager.this.lmpCRSsToHandle.get(this.crsHostName);
                if (object != null) {
                    ((CrsLmpData)object).setCrsState(CrsState.SESSION_OPEN);
                } else {
                    if (!LmpNetLinkManager.this.db.on()) return;
                    LmpNetLinkManager.this.db.println("WARNING!!! crsLmpData NULL trying to move in SESSION_OPEN");
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CrsLmpData {
        private CrsState crsState = CrsState.NOT_CONNECTED;
        private INetElement crsNE = null;
        private HashMap<INetElement, ILmpCtrlChannelModel> controlChannels;

        public CrsLmpData(HashMap<INetElement, ILmpCtrlChannelModel> hashMap) {
            this.controlChannels = hashMap;
        }

        public HashMap<INetElement, ILmpCtrlChannelModel> getControlChannels() {
            return this.controlChannels;
        }

        public CrsState getCrsState() {
            return this.crsState;
        }

        public void setCrsState(CrsState crsState) {
            this.crsState = crsState;
        }

        public void setCrsNe(INetElement iNetElement) {
            this.crsNE = iNetElement;
        }

        public INetElement getCrsNe() {
            return this.crsNE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CrsState {
        NOT_CONNECTED,
        SESSION_PENDING,
        SESSION_OPEN,
        CONNECTED;

    }
}

