/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LinkModel;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.PathInUse;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServerTrailLinkId;
import cerent.cms.model.User;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetServerTrailManager;
import cerent.cms.topo.IPartitioner;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparatorKey;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailException;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.topo.Topology;
import cerent.util.HoLoFactory;
import cerent.util.HoLoRange;
import cerent.util.IDebugDiag;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.IIPAddressTranslator;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPAddressTranslator;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetServerTrailManager
implements IObserver,
INetServerTrailManager {
    protected static NetServerTrailManager sServerTrailMgr = null;
    protected List trailNodesToHandle = null;
    private Map svTrailPrimCTPs;
    private Map svTrailPeerCTPs;
    private static final int VC3_VC4_FACTOR = 3;
    private boolean active = true;
    private Network net = null;
    private Object masterTrailLock = new Object();
    protected NetServerTrailMgrDebug db = new NetServerTrailMgrDebug();

    private NetServerTrailManager() {
        this.trailNodesToHandle = Collections.synchronizedList(new LinkedList());
        this.svTrailPrimCTPs = new TreeMap(new TrailIdComparator());
        this.svTrailPeerCTPs = new TreeMap(new TrailIdComparator());
    }

    public static synchronized NetServerTrailManager instance() {
        if (sServerTrailMgr == null) {
            sServerTrailMgr = new NetServerTrailManager();
        }
        return sServerTrailMgr;
    }

    private Network getNetworkInstance() {
        if (this.net == null) {
            this.net = Network.instance();
        }
        return this.net;
    }

    public void createServerTrailLink(ServerTrailPrefs serverTrailPrefs) throws ServerTrailException {
        int n;
        int n2;
        Object object;
        if (serverTrailPrefs == null) {
            return;
        }
        if (this.db.on()) {
            this.db.println("createServerTrailLink: Prefs = " + serverTrailPrefs.prettyString());
        }
        INetElement iNetElement = serverTrailPrefs.getSrc();
        INetElement iNetElement2 = serverTrailPrefs.getDest();
        int n3 = serverTrailPrefs.getSrcEntity();
        ILabel iLabel = serverTrailPrefs.getSrcPoolStart();
        ILabel iLabel2 = serverTrailPrefs.getSrcPoolEnd();
        int n4 = serverTrailPrefs.getDestEntity();
        ILabel iLabel3 = serverTrailPrefs.getDestPoolStart();
        ILabel iLabel4 = serverTrailPrefs.getDestPoolEnd();
        int n5 = serverTrailPrefs.getPhyLinkType();
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        int n6 = serverTrailPrefs.getProtectionType();
        String string = serverTrailPrefs.getSrlg();
        int n7 = serverTrailPrefs.getCost();
        int n8 = serverTrailPrefs.getNx();
        if (iNetElement == null || iNetElement2 == null || !iNetElement.getConnectionState() || !iNetElement2.getConnectionState()) {
            throw new ServerTrailException("A server trail link cannot be created because the source or destination is null.");
        }
        if (this.getNetworkInstance().findNetLinkFromEnt(iNetElement, n3, true) != null || this.getNetworkInstance().findNetLinkFromEnt(iNetElement2, n4, true) != null) {
            throw new ServerTrailException("The following server trail link cannot be created because another SDCC link with the same source or destination exists: \nsource => " + iNetElement.getHostName() + ", entity index => " + n3 + "\ndestination => " + iNetElement2.getHostName() + ", entity index => " + n4);
        }
        NodeModel nodeModel = (NodeModel)iNetElement.getNodeModel();
        NodeModel nodeModel2 = (NodeModel)iNetElement2.getNodeModel();
        if (!nodeModel.provides(Feature.SERVER_TRAIL) || !nodeModel2.provides(Feature.SERVER_TRAIL)) {
            throw new ServerTrailException("The server trail feature is not supported on the nodes " + nodeModel.getName() + " and/or " + nodeModel2.getName() + ".");
        }
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        try {
            iEntityModel = nodeModel.getEntityTable().getEntityModelByIndex(n3);
            iEntityModel2 = nodeModel2.getEntityTable().getEntityModelByIndex(n4);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("createServerTrailLink: Src or Dst entity index invalid");
            }
            throw new ServerTrailException("A server trail link cannot be created because the source or destination entity index is invalid.");
        }
        if (iEntityModel instanceof IPortModel && iEntityModel2 instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            object = (IPortModel)iEntityModel2;
            n2 = iPortModel.getEqType();
            n = object.getEqType();
        } else {
            n2 = 329;
            n = 329;
            if (this.db.on()) {
                this.db.println("createServerTrailLink: Src or Dst entity index not instanceof IPortModel");
            }
        }
        boolean bl = false;
        if (!serverTrailPrefs.isDiscovered()) {
            serverTrailPrefs.setPoolEnds();
            try {
                this.validateServerTrailPrefs(serverTrailPrefs);
            }
            catch (ServerTrailException serverTrailException) {
                if (this.db.on()) {
                    this.db.println("createServerTrailLink: Invalid ServerTrailPrefs");
                }
                if (serverTrailException.getPrettyMessage().equals("")) {
                    throw new ServerTrailException("The preferences are invalid.");
                }
                throw new ServerTrailException(serverTrailException.getPrettyMessage());
            }
            if (this.db.on()) {
                this.db.println("ServerTrailPrefs are valid");
            }
            object = null;
            try {
                this.createServerTrailCTPs(serverTrailPrefs);
            }
            catch (PathInUse pathInUse) {
                bl = true;
                object = pathInUse.getMessage();
            }
            catch (InvalidPath invalidPath) {
                bl = true;
                object = invalidPath.getMessage();
            }
            catch (ProvisionError provisionError) {
                bl = true;
                object = provisionError.getMessage();
            }
            catch (ServerTrailException serverTrailException) {
                bl = true;
                object = serverTrailException.getMessage();
            }
            if (bl) {
                if (object == null) {
                    throw new ServerTrailException("Server trail link CTP objects could not be created.");
                }
                throw new ServerTrailException((String)object);
            }
            if (this.db.on()) {
                this.db.println("createServerTrailLink: CTP objects created successfully");
            }
        }
        int n9 = 12;
        LinkModel linkModel = new LinkModel(iNetElement.getNodeModel(), n3, null, iNetElement2.getNodeModel(), n4, null, 9, NetLink.getLinkPhysicalType(n2), n9, true, true, -1, -1, n6, "", 0, 0, 1, n7, 0, 0);
        LinkModel linkModel2 = new LinkModel(iNetElement2.getNodeModel(), n4, null, iNetElement.getNodeModel(), n3, null, 9, NetLink.getLinkPhysicalType(n), n9, true, true, -1, -1, n6, "", 0, 0, 1, n7, 0, 0);
        if (this.db.on()) {
            this.db.println("createServerTrailLink: creating fwd and rev NL's");
        }
        ServerTrailPrefs serverTrailPrefs2 = new ServerTrailPrefs(serverTrailPrefs, true);
        INetLink iNetLink = this.addServerTrailLink(linkModel, (NetElement)iNetElement, (NetElement)iNetElement2, false, ((NetElement)iNetElement).getTopology(), serverTrailPrefs, true);
        INetLink iNetLink2 = this.addServerTrailLink(linkModel2, (NetElement)iNetElement2, (NetElement)iNetElement, false, ((NetElement)iNetElement2).getTopology(), serverTrailPrefs2, false);
        this.getNetworkInstance().getNetLinkCreationNotifier().changed(iNetLink);
        this.getNetworkInstance().getNetLinkCreationNotifier().changed(iNetLink2);
        this.getNetworkInstance().putSvLink(iNetLink);
    }

    public List getAvailServerTrailPoints(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs) {
        ArrayList arrayList = new ArrayList();
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPoints @ " + iNodeModel + "::" + Integer.toHexString(iEntityModel.getEntityIndex()));
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getAvailSTPoints: STrail not supported at node " + iNodeModel.getName());
            }
            return arrayList;
        }
        int n = serverTrailPrefs.getCircuitType().getEnum();
        int n2 = serverTrailPrefs.getCircuitSize().getEnum();
        LinkedList linkedList = new LinkedList();
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(n, n2, 1);
        arrayList.addAll(Endpoints.instance().getAvailSourcePoints(iNodeModel, iEntityModel, circuitCreatInfo));
        arrayList.addAll(this.getConnectedPathsForServerTrail(iNodeModel, iEntityModel, serverTrailPrefs));
        this.removeExistingServerTrails(iNodeModel, iEntityModel, serverTrailPrefs, arrayList);
        return arrayList;
    }

    protected List getConnectedEntitiesForServerTrail(INodeModel iNodeModel, ServerTrailPrefs serverTrailPrefs) {
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        if (serverTrailPrefs.isLoTrail()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            List<ILoConnectionModel> list = Arrays.asList(iConnectionModels.getLoConnectionModels());
            List<ILoAditModel> list2 = Arrays.asList(iConnectionModels.getLoAditModels());
            for (ILoConnectionModel iLoConnectionModel : list) {
                if (!(iLoConnectionModel instanceof ILoConnectionModel)) continue;
                IEntityModel[] iEntityModelArray = iLoConnectionModel.getPathEntities();
                for (IEntityModel iEntityModel : Arrays.asList(iEntityModelArray)) {
                    if (linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
            }
            IEntityModel iEntityModel = null;
            for (ILoConnectionModel iLoConnectionModel : list2) {
                if (!(iLoConnectionModel instanceof ILoAditModel)) continue;
                ILoAditModel iLoAditModel = (ILoAditModel)iLoConnectionModel;
                int n = iLoAditModel.getHo().getPool().getEntityIndex();
                try {
                    iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
                    if (iEntityModel == null || linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("getConnectedEntitiesForServerTrail: Invalid AditentityIndex " + n);
                }
            }
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
            for (IHoConnectionModel iHoConnectionModel : list) {
                IHoConnectionModel iHoConnectionModel2;
                short s2;
                if (!(iHoConnectionModel instanceof IHoConnectionModel) || (s2 = (iHoConnectionModel2 = iHoConnectionModel).getPaths()[0].getPathWidth()) != s) continue;
                IEntityModel[] iEntityModelArray = iHoConnectionModel.getPathEntities();
                for (IEntityModel iEntityModel : Arrays.asList(iEntityModelArray)) {
                    if (linkedList.contains(iEntityModel)) continue;
                    linkedList.add(iEntityModel);
                }
            }
        }
        return linkedList;
    }

    public List getAvailServerTrailPorts(INodeModel iNodeModel, ServerTrailPrefs serverTrailPrefs) {
        short s;
        IEntityTableModel iEntityTableModel;
        List list = new LinkedList();
        if (serverTrailPrefs == null) {
            return list;
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getAvailSTPorts: STrail not supported at node " + iNodeModel.getName());
            }
            return list;
        }
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPorts called at " + iNodeModel + serverTrailPrefs.getCircuitSize().getCircuitSizeString());
        }
        if ((iEntityTableModel = iNodeModel.getEntityTable()) == null) {
            if (this.db.on()) {
                this.db.println("Unable to find entity table model");
            }
            return list;
        }
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        if (serverTrailPrefs.isLoTrail()) {
            s = iCircuitSize.size2widthOfLoCircuit();
            list = iEntityTableModel.getAvailEntitiesForLo((int)s, false);
        } else {
            s = iCircuitSize.size2widthOfHoCircuit();
            list = iEntityTableModel.getAvailEntitiesForHo(s, 1, false);
        }
        list.addAll(this.getConnectedEntitiesForServerTrail(iNodeModel, serverTrailPrefs));
        this.removeNonServerTrailPorts(iNodeModel, list);
        if (this.db.on()) {
            this.db.println("getAvailServerTrailPorts at " + iNodeModel + " returning " + list.size() + " entities");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel;
            List list2;
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            IModuleModel iModuleModel = iEntityModel2.getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel && ((IDwdmModuleModel)iModuleModel).isADMCard() && (list2 = (iEntityModel = iEntityModel2.getAncestorOfEqType(150)).getDescendantsOfEqType(123)).size() != 0 && ((IPortModel)list2.get(0)).getPortNum()[0] != 17) {
                iterator.remove();
                continue;
            }
            List list3 = this.getAvailServerTrailPoints(iNodeModel, iEntityModel2, serverTrailPrefs);
            if (list3.size() != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private void removeNonServerTrailPorts(INodeModel iNodeModel, List list) {
        INetElement iNetElement = this.getNetworkInstance().getNetElem(iNodeModel.getNodeId());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (!ServerTrailPrefs.isServerTrailPort(iEntityModel)) {
                iterator.remove();
                continue;
            }
            int n = iEntityModel.getEntityIndex();
            INetLink iNetLink = this.getNetworkInstance().findNetLinkFromEnt(iNetElement, n);
            if (iNetLink == null || iNetLink.getLinkType() == 9 || iNetLink.isLOTunnel() || iNetLink.isLAP()) continue;
            iterator.remove();
        }
    }

    protected List getConnectedPathsForServerTrail(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs) {
        ICircuitSize iCircuitSize = serverTrailPrefs.getCircuitSize();
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        if (serverTrailPrefs.isLoTrail()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            List<ILoConnectionModel> list = Arrays.asList(iConnectionModels.getLoConnectionModels());
            for (ILoConnectionModel iLoConnectionModel : list) {
                if (!(iLoConnectionModel instanceof ILoConnectionModel)) continue;
                ILoConnectionModel iLoConnectionModel2 = iLoConnectionModel;
                ILoDefModel[] iLoDefModelArray = iLoConnectionModel2.getPaths();
                for (ILoDefModel iLoDefModel : Arrays.asList(iLoDefModelArray)) {
                    ILoAditModel iLoAditModel = iLoDefModel.getLoAdit();
                    int n = iLoAditModel.getHo().getPool().getEntityIndex();
                    if (n != iEntityModel.getEntityIndex()) continue;
                    LoCircuitEnd loCircuitEnd = Endpoints.instance().getAutoAssignedLoCktEnd(iNodeModel, iEntityModel, serverTrailPrefs.getCircuitType());
                    if (loCircuitEnd != null) {
                        linkedList.add(loCircuitEnd);
                        continue;
                    }
                    ILoNum iLoNum = iLoDefModel.getLoNum();
                    IHoNum iHoNum = iLoAditModel.getHo().getStartingHo();
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
                    linkedList.add(loCircuitEnd);
                }
            }
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
            for (IHoConnectionModel iHoConnectionModel : list) {
                IHoConnectionModel iHoConnectionModel2;
                short s2;
                if (!(iHoConnectionModel instanceof IHoConnectionModel) || (s2 = (iHoConnectionModel2 = iHoConnectionModel).getPaths()[0].getPathWidth()) != s) continue;
                IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModel2.getPaths();
                for (IHoPathDefModel iHoPathDefModel : Arrays.asList(iHoPathDefModelArray)) {
                    if (iHoPathDefModel.getPool().getEntityIndex() != iEntityModel.getEntityIndex()) continue;
                    HoCircuitEnd hoCircuitEnd = Endpoints.instance().getAutoAssignedHoCktEnd(iNodeModel, iEntityModel, serverTrailPrefs.getCircuitType());
                    if (hoCircuitEnd != null) {
                        linkedList.add(hoCircuitEnd);
                        continue;
                    }
                    IHoNum iHoNum = iHoPathDefModel.getStartingHo();
                    hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum, null, false);
                    linkedList.add(hoCircuitEnd);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerTrailEnd findSvPrimCTP(IServerTrailLinkId iServerTrailLinkId) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            Object object2;
            IServerTrailEnd iServerTrailEnd = null;
            IServerTrailLinkId iServerTrailLinkId2 = null;
            if (this.db.on()) {
                object2 = this.svTrailPrimCTPs.values().iterator();
                int n = 0;
                while (object2.hasNext()) {
                    iServerTrailEnd = (IServerTrailEnd)object2.next();
                    iServerTrailLinkId2 = iServerTrailEnd.getServerTrailLinkId();
                    this.db.println(" P-ctp " + ++n + " has SvId-NodeId = " + iServerTrailLinkId2.getNodeId() + " Unique = " + iServerTrailLinkId2.getUniqueId());
                }
            }
            object2 = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            return (IServerTrailEnd)this.svTrailPrimCTPs.get(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerTrailEnd findSvPeerCTP(IServerTrailLinkId iServerTrailLinkId) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            return (IServerTrailEnd)this.svTrailPeerCTPs.get(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()));
        }
    }

    protected void createServerTrailLink(IServerTrailLinkId iServerTrailLinkId) {
        block4: {
            IServerTrailEnd iServerTrailEnd = this.findSvPrimCTP(iServerTrailLinkId);
            IServerTrailEnd iServerTrailEnd2 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd == null || iServerTrailEnd2 == null) {
                if (this.db.on()) {
                    this.db.println("ERROR: ServerTrail discovery");
                    this.db.println("CTP objects don't exist");
                }
                return;
            }
            ServerTrailPrefs serverTrailPrefs = this.makeSvPrefs(iServerTrailEnd, iServerTrailEnd2);
            try {
                this.createServerTrailLink(serverTrailPrefs);
            }
            catch (ServerTrailException serverTrailException) {
                if (!this.db.on()) break block4;
                this.db.println("discoverServerTrail: caught exception, e = " + serverTrailException.getMessage());
            }
        }
    }

    private ServerTrailPrefs makeSvPrefs(IServerTrailEnd iServerTrailEnd, IServerTrailEnd iServerTrailEnd2) {
        ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
        serverTrailPrefs.setDiscovered();
        serverTrailPrefs.setTrailId(iServerTrailEnd.getServerTrailLinkId());
        serverTrailPrefs.setSrlg(iServerTrailEnd.getSharedRiskLinkGroup());
        serverTrailPrefs.setProtectionType(iServerTrailEnd.getProtectionType());
        serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)iServerTrailEnd.getTrailSize()));
        if (iServerTrailEnd instanceof IHoServerTrailEnd && iServerTrailEnd2 instanceof IHoServerTrailEnd) {
            IHoPathDefModel iHoPathDefModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart();
            IHoPathDefModel iHoPathDefModel2 = ((IHoServerTrailEnd)iServerTrailEnd).getTrailEnd();
            IHoPathDefModel iHoPathDefModel3 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            IHoPathDefModel iHoPathDefModel4 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailEnd();
            serverTrailPrefs.setSrc(this.findNetElem(iHoPathDefModel.getNodeModel()));
            serverTrailPrefs.setDest(this.findNetElem(iHoPathDefModel3.getNodeModel()));
            serverTrailPrefs.setSrcEntity(iHoPathDefModel.getPool().getEntityIndex());
            serverTrailPrefs.setDestEntity(iHoPathDefModel3.getPool().getEntityIndex());
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            IHoNum iHoNum2 = iHoPathDefModel2.getStartingHo();
            serverTrailPrefs.setSrcPoolStart((ILabel)iHoNum);
            serverTrailPrefs.setSrcPoolEnd((ILabel)iHoNum2);
            IHoNum iHoNum3 = iHoPathDefModel3.getStartingHo();
            IHoNum iHoNum4 = iHoPathDefModel4.getStartingHo();
            serverTrailPrefs.setDestPoolStart((ILabel)iHoNum3);
            serverTrailPrefs.setDestPoolEnd((ILabel)iHoNum4);
            serverTrailPrefs.calculateNx((ILabel)iHoNum, (ILabel)iHoNum2);
        } else if (iServerTrailEnd instanceof ILoServerTrailEnd && iServerTrailEnd2 instanceof ILoServerTrailEnd) {
            ILoDefModel iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
            ILoDefModel iLoDefModel2 = ((ILoServerTrailEnd)iServerTrailEnd).getTrailEnd();
            ILoDefModel iLoDefModel3 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            ILoDefModel iLoDefModel4 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailEnd();
            IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel5 = iLoDefModel2.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel6 = iLoDefModel3.getLoAdit().getHo();
            IHoPathDefModel iHoPathDefModel7 = iLoDefModel4.getLoAdit().getHo();
            serverTrailPrefs.setSrc(this.findNetElem(iHoPathDefModel.getNodeModel()));
            serverTrailPrefs.setDest(this.findNetElem(iHoPathDefModel6.getNodeModel()));
            serverTrailPrefs.setSrcEntity(iHoPathDefModel.getPool().getEntityIndex());
            serverTrailPrefs.setDestEntity(iHoPathDefModel6.getPool().getEntityIndex());
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            ILoNum iLoNum = iLoDefModel.getLoNum();
            IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
            IHoNum iHoNum5 = iHoPathDefModel5.getStartingHo();
            ILoNum iLoNum2 = iLoDefModel2.getLoNum();
            IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum5, iLoNum2);
            serverTrailPrefs.setSrcPoolStart((ILabel)iHoLoNum);
            serverTrailPrefs.setSrcPoolEnd((ILabel)iHoLoNum2);
            IHoNum iHoNum6 = iHoPathDefModel6.getStartingHo();
            ILoNum iLoNum3 = iLoDefModel3.getLoNum();
            IHoLoNum iHoLoNum3 = HoLoFactory.createHoLoNum(iHoNum6, iLoNum3);
            IHoNum iHoNum7 = iHoPathDefModel7.getStartingHo();
            ILoNum iLoNum4 = iLoDefModel4.getLoNum();
            IHoLoNum iHoLoNum4 = HoLoFactory.createHoLoNum(iHoNum7, iLoNum4);
            serverTrailPrefs.setDestPoolStart((ILabel)iHoLoNum3);
            serverTrailPrefs.setDestPoolEnd((ILabel)iHoLoNum4);
            serverTrailPrefs.calculateNx((ILabel)iHoLoNum, (ILabel)iHoLoNum2);
        } else {
            if (this.db.on) {
                this.db.println("ERROR in discoverServerTrailPrefs");
                this.db.println(" CTP objects not of same type");
            }
            return null;
        }
        serverTrailPrefs.discoverCircuitType(iServerTrailEnd instanceof IHoServerTrailEnd);
        serverTrailPrefs.setLoTrail();
        return serverTrailPrefs;
    }

    private INetElement findNetElem(INodeModel iNodeModel) {
        return this.getNetworkInstance().findNetElem(iNodeModel);
    }

    public void deleteServerTrail(IServerTrailLinkId iServerTrailLinkId) throws ServerTrailException {
        this.removeServerTrail(iServerTrailLinkId, true);
    }

    private void removeServerTrail(IServerTrailLinkId iServerTrailLinkId, boolean bl) throws ServerTrailException {
        block12: {
            if (iServerTrailLinkId == null) {
                if (this.db.on()) {
                    this.db.println("RemoveServerTrail :: ServerTrailId is NULL");
                }
                return;
            }
            if (this.db.on()) {
                this.db.println("Removing SVTrail with NodeId " + iServerTrailLinkId.getNodeId() + "Uid " + iServerTrailLinkId.getUniqueId() + "deleteCTP " + bl);
            }
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            INetLink iNetLink = this.getNetworkInstance().findSvLink(serverTrailLinkId);
            if (iNetLink == null) {
                if (this.db.on()) {
                    this.db.println("removeServerTrail: ServerTrailLink already removed for svId::NodeId " + iServerTrailLinkId.getNodeId() + "Uid:: " + iServerTrailLinkId.getUniqueId());
                }
            } else {
                try {
                    this.deleteServerTrailLink(iNetLink);
                    this.getNetworkInstance().removeSvTrailLinksById(serverTrailLinkId);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!this.db.on()) break block12;
                    this.db.println("deleteServerTrail: caught exception, e = \n" + serverTrailException.getMessage());
                    throw new ServerTrailException();
                }
            }
        }
        if (bl) {
            if (this.db.on()) {
                this.db.println("deleteServerTrail: Going to delete CTP objects");
            }
            if (this.deleteCtp(this.findSvPrimCTP(iServerTrailLinkId)) && this.db.on()) {
                this.db.println("Successfully deleted Primary CTP");
            }
            if (this.deleteCtp(this.findSvPeerCTP(iServerTrailLinkId)) && this.db.on()) {
                this.db.println("Successfully deleted Peer CTP");
            }
        }
    }

    private void deleteServerTrailLink(INetLink iNetLink) throws ServerTrailException {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: cannot delete null link");
            }
            return;
        }
        if (iNetLink.getLinkType() != 9) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: cannot delete non-servertrail link " + iNetLink.prettyString());
            }
            throw new ServerTrailException("The link " + iNetLink.prettyString() + " cannot be deleted because it " + "is not a server trail link.");
        }
        if (iNetLink.isDeleted()) {
            if (this.db.on()) {
                this.db.println("deleteServerTrailLink: link is already deleted");
            }
            return;
        }
        INetLink iNetLink2 = this.getNetworkInstance().findReverseLink(iNetLink);
        iNetLink.dispose();
        if (iNetLink2 != null) {
            iNetLink2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteServerTrail(IServerTrailsManager iServerTrailsManager) {
        INetElement iNetElement;
        INetElement iNetElement2;
        INodeModel iNodeModel = iServerTrailsManager.getNodeModel();
        try {
            iNetElement2 = this.findNetElem(iNodeModel);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (iNetElement2 == null) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (!iServerTrailsManager.isInited()) {
            this.db.println("dStrl:: svMgr is not initialized");
            return;
        }
        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Currently " + iServerTrailEndArray.length + " CTP objects on" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        LinkedList linkedList = new LinkedList();
        TreeMap<ServerTrailLinkId, IServerTrailEnd> treeMap = new TreeMap<ServerTrailLinkId, IServerTrailEnd>(new TrailIdComparator());
        Iterator iterator = this.masterTrailLock;
        synchronized (iterator) {
            linkedList.addAll(this.svTrailPrimCTPs.values());
            linkedList.addAll(this.svTrailPeerCTPs.values());
        }
        for (IServerTrailEnd iServerTrailEnd : linkedList) {
            iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2);
            if (iNetElement == null || !iNetElement.equals(iNetElement2)) continue;
            treeMap.put(new ServerTrailLinkId(iServerTrailEnd.getServerTrailLinkId().getNodeId(), iServerTrailEnd.getServerTrailLinkId().getUniqueId()), iServerTrailEnd);
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Previously " + treeMap.size() + " CTP objects on" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
            IServerTrailEnd iServerTrailEnd;
            iServerTrailEnd = iServerTrailEndArray[i];
            treeMap.remove(new ServerTrailLinkId(iServerTrailEnd.getServerTrailLinkId().getNodeId(), iServerTrailEnd.getServerTrailLinkId().getUniqueId()));
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Update:: " + treeMap.size() + " CTP objects to be removed at" + iNetElement2.getName());
            this.db.println("=================================================");
        }
        if (treeMap.size() < 1) {
            if (this.db.on()) {
                this.db.println("No CTP removal needed at " + iNetElement2.getName());
            }
            this.handlePeerIpAddressChanges(iServerTrailEndArray, iNetElement2);
            return;
        }
        LinkedList linkedList2 = new LinkedList(treeMap.values());
        for (IServerTrailEnd iServerTrailEnd : linkedList2) {
            Object object;
            IServerTrailLinkId iServerTrailLinkId;
            block28: {
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (iServerTrailLinkId == null) {
                    if (!this.db.on()) continue;
                    this.db.println("Got a null svId for a CTP");
                    continue;
                }
                try {
                    if (this.db.on()) {
                        this.db.println("Removing ctp with svId::Uid " + iServerTrailLinkId.getUniqueId());
                    }
                    this.removeServerTrail(iServerTrailLinkId, false);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!this.db.on()) break block28;
                    this.db.println("removeServerTrail: Update caught exception, e = \n" + serverTrailException.getMessage());
                }
            }
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            iServerTrailEnd = this.findSvPeerCTP(serverTrailLinkId);
            if (iServerTrailEnd != null && (iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2)) != null && iNetElement.equals(iNetElement2)) {
                if (this.db.on()) {
                    this.db.println("PeerList: Removing CTP with Uid " + serverTrailLinkId.getUniqueId());
                }
                object = this.masterTrailLock;
                synchronized (object) {
                    this.svTrailPeerCTPs.remove(serverTrailLinkId);
                }
            }
            if ((iServerTrailEnd = this.findSvPrimCTP(serverTrailLinkId)) == null || (iNetElement = this.getCtpNe(iServerTrailEnd, iNetElement2)) == null || !iNetElement.equals(iNetElement2)) continue;
            if (this.db.on()) {
                this.db.println("PrimaryList: Removing CTP with Uid " + serverTrailLinkId.getUniqueId());
            }
            object = this.masterTrailLock;
            synchronized (object) {
                this.svTrailPrimCTPs.remove(serverTrailLinkId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePeerIpAddressChanges(IServerTrailEnd[] iServerTrailEndArray, INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("checking for PeerIP Address changes due to execution ofserver trail repair wizard");
        }
        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
            Object object;
            INetElement iNetElement2;
            IServerTrailEnd iServerTrailEnd = iServerTrailEndArray[i];
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            if (iServerTrailLinkId == null) {
                if (!this.db.on()) continue;
                this.db.println("Got a null svId for a CTP");
                continue;
            }
            IServerTrailEnd iServerTrailEnd2 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 != null && (iNetElement2 = this.getCtpNe(iServerTrailEnd2, iNetElement)) != null && iNetElement2.equals(iNetElement) && !iServerTrailEnd2.getPeerIpAddr().equals(iServerTrailEnd.getPeerIpAddr())) {
                if (this.db.on()) {
                    this.db.println("PeerList: updating CTP with Uid " + iServerTrailLinkId.getUniqueId());
                }
                object = this.masterTrailLock;
                synchronized (object) {
                    this.svTrailPeerCTPs.put(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()), iServerTrailEnd);
                    continue;
                }
            }
            iServerTrailEnd2 = this.findSvPrimCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 == null || (iNetElement2 = this.getCtpNe(iServerTrailEnd2, iNetElement)) == null || !iNetElement2.equals(iNetElement) || iServerTrailEnd2.getPeerIpAddr().equals(iServerTrailEnd.getPeerIpAddr())) continue;
            if (this.db.on()) {
                this.db.println("PrimaryList: updating CTP with Uid " + iServerTrailLinkId.getUniqueId());
            }
            object = this.masterTrailLock;
            synchronized (object) {
                this.svTrailPrimCTPs.put(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()), iServerTrailEnd);
                continue;
            }
        }
    }

    private boolean deleteCtp(IServerTrailEnd iServerTrailEnd) {
        if (iServerTrailEnd != null) {
            INetElement iNetElement = this.getCtpNe(iServerTrailEnd, null);
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("Failed to deleteCtp");
                }
                return false;
            }
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
                if (this.db.on()) {
                    this.db.println("deleteCTP: STrail not supported at node " + iNodeModel.getName());
                }
                return false;
            }
            IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
            try {
                if (this.db.on()) {
                    this.db.println("Going to delete CTP at" + iNodeModel.getName());
                }
                iServerTrailsManager.deleteServerTrail(iServerTrailLinkId);
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("deleteServerTrail: Failed to delete SrcCTP");
                }
                return false;
            }
            if (this.db.on()) {
                this.db.println("CTP deletion successful at" + iNodeModel.getName());
            }
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.cleanupLoAdits(iServerTrailEnd);
            return true;
        }
        return false;
    }

    protected INetElement getCtpNe(IServerTrailEnd iServerTrailEnd, INetElement iNetElement) {
        try {
            if (iServerTrailEnd instanceof IHoServerTrailEnd) {
                INodeModel iNodeModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart().getNodeModel();
                return this.findNetElem(iNodeModel);
            }
            if (iServerTrailEnd instanceof ILoServerTrailEnd) {
                ILoAditModel iLoAditModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart().getLoAdit();
                if (iLoAditModel != null) {
                    INodeModel iNodeModel = iLoAditModel.getHo().getNodeModel();
                    return this.findNetElem(iNodeModel);
                }
            } else if (this.db.on()) {
                this.db.println(" Unknown CTP instance ");
            }
        }
        catch (Exception exception) {
            this.db.println("getCtpNe: caught Exception => " + exception.getMessage() + "Returning null");
            this.invalidCTP(iServerTrailEnd, iNetElement);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverServerTrails() {
        Object object;
        if (this.trailNodesToHandle.size() == 0) {
            return;
        }
        LinkedList linkedList = new LinkedList(this.trailNodesToHandle);
        Object object2 = this.trailNodesToHandle;
        synchronized (object2) {
            this.trailNodesToHandle.clear();
        }
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (INetElement)object2.next();
            if (this.getNetworkInstance().findNetElem((INetElement)object) == null) {
                if (this.db.on()) {
                    this.db.println("Removing node " + object.getName() + "from TrailToHandle list");
                }
                object2.remove();
                continue;
            }
            INodeModel iNodeModel = object.getNodeModel();
            if (!object.getConnectionState()) {
                this.getNetworkInstance().removeSvTrailLinksOnNe((INetElement)object);
                continue;
            }
            if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
                if (this.db.on()) {
                    this.db.println("discoverServerTrails: STrail not supported at node " + iNodeModel.getName());
                }
                object2.remove();
                continue;
            }
            IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
            if (iServerTrailsManager == null || !iServerTrailsManager.isInited()) continue;
            ModelIndirectObservable.instance().addObserver((IObservable)iServerTrailsManager, this);
            this.deleteServerTrail(iServerTrailsManager);
            this.addNewServerTrail(iServerTrailsManager);
            object2.remove();
        }
        if (linkedList.size() != 0) {
            object = this.trailNodesToHandle;
            synchronized (object) {
                this.trailNodesToHandle.addAll(linkedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePrimPeerCtpsById(ServerTrailLinkId serverTrailLinkId) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            this.svTrailPeerCTPs.remove(serverTrailLinkId);
            this.svTrailPrimCTPs.remove(serverTrailLinkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidCTP(IServerTrailEnd iServerTrailEnd, INetElement iNetElement) {
        LinkedList<INetElement> linkedList;
        block11: {
            INetElement iNetElement2;
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            linkedList = new LinkedList<INetElement>();
            if (iNetElement != null && !this.trailNodesToHandle.contains(iNetElement)) {
                linkedList.add(iNetElement);
            }
            if ((iNetElement2 = this.getNetworkInstance().findNetElem(iServerTrailLinkId.getNodeId())) != null && !this.trailNodesToHandle.contains(iNetElement2)) {
                linkedList.add(iNetElement2);
            }
            INetElement iNetElement3 = null;
            INetElement iNetElement4 = null;
            ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
            IServerTrailEnd iServerTrailEnd2 = this.findSvPrimCTP(serverTrailLinkId);
            if (iServerTrailEnd2 != null) {
                iNetElement3 = this.getNetworkInstance().findNetElemByIp(iServerTrailEnd2.getPeerIpAddr());
                if (iNetElement3 != null && !this.trailNodesToHandle.contains(iNetElement3)) {
                    linkedList.add(iNetElement3);
                }
                this.svTrailPrimCTPs.remove(serverTrailLinkId);
            }
            if ((iServerTrailEnd2 = this.findSvPeerCTP(serverTrailLinkId)) != null) {
                iNetElement4 = this.getNetworkInstance().findNetElemByIp(iServerTrailEnd2.getPeerIpAddr());
                if (iNetElement4 != null && !this.trailNodesToHandle.contains(iNetElement4)) {
                    linkedList.add(iNetElement4);
                }
                this.svTrailPeerCTPs.remove(serverTrailLinkId);
            }
            try {
                this.removeServerTrail(serverTrailLinkId, false);
            }
            catch (ServerTrailException serverTrailException) {
                if (!this.db.on()) break block11;
                this.db.println("removeServerTrail: Caught exception at invalidCtp");
            }
        }
        List list = this.trailNodesToHandle;
        synchronized (list) {
            this.trailNodesToHandle.addAll(linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewServerTrail(IServerTrailsManager iServerTrailsManager) {
        INetElement iNetElement;
        INodeModel iNodeModel = iServerTrailsManager.getNodeModel();
        try {
            iNetElement = this.findNetElem(iNodeModel);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (iNetElement == null) {
            this.db.println(" ERROR : NetElement is null");
            return;
        }
        if (!iServerTrailsManager.isInited()) {
            this.db.println("addStrl:: SvMgr at is not initialized");
            return;
        }
        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Received " + iServerTrailEndArray.length + " CTP objects on" + iNetElement.getName());
            this.db.println("=================================================");
        }
        int n = iServerTrailEndArray == null ? 0 : iServerTrailEndArray.length;
        Network network = this.getNetworkInstance();
        try {
            for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                List list;
                INetElement iNetElement2;
                IServerTrailLinkId iServerTrailLinkId;
                IServerTrailEnd iServerTrailEnd;
                block36: {
                    iServerTrailEnd = iServerTrailEndArray[i];
                    if (!network.isMember(iServerTrailEnd, iNodeModel)) {
                        if (!this.db.on()) continue;
                        this.db.println("Skipping server trail endpoint: " + iServerTrailEnd + " due to the net.isMember() returning false");
                        continue;
                    }
                    iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                    String string = iServerTrailEnd.getPeerIpAddr();
                    try {
                        InetUtil.parseDottedString(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.db.println("ERROR: Invalid PEER-IPAddress on SVTrail CTP");
                        Object var19_20 = null;
                        if (n > 0) {
                            network.lastMember(iNodeModel, IPartitioner.AdjacencyType.SERVER_TRAIL);
                        }
                        return;
                    }
                    iNetElement2 = this.getNetworkInstance().findNetElemByIp(string);
                    if (iNetElement2 == null) {
                        try {
                            if (this.db.on()) {
                                this.db.println("SVDiscovery : Adding node " + string);
                            }
                            if (this.getNetworkInstance().isExcludeDynamicNodes()) continue;
                            iNetElement2 = this.getNetworkInstance().addNetElement(string, iNodeModel.getUserName(), iNodeModel.getUserPassword());
                            this.getNetworkInstance().createTopology(iNetElement2);
                            list = this.trailNodesToHandle;
                            synchronized (list) {
                                if (!this.trailNodesToHandle.contains(iNetElement2)) {
                                    this.trailNodesToHandle.add(iNetElement2);
                                }
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (this.db.on()) {
                                this.db.println("Unable to add node " + string + " Ex " + unknownHostException);
                            }
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            if (!this.db.on()) break block36;
                            this.db.println("Unable to add node " + string + " Ex " + (Object)((Object)abstractCmsIOException));
                        }
                    }
                }
                INetLink iNetLink = this.getNetworkInstance().findSvLink(iServerTrailLinkId);
                IServerTrailEnd iServerTrailEnd2 = this.findSvPrimCTP(iServerTrailLinkId);
                IServerTrailEnd iServerTrailEnd3 = this.findSvPeerCTP(iServerTrailLinkId);
                if (iServerTrailEnd2 != null && this.getCtpNe(iServerTrailEnd2, iNetElement) == null || iServerTrailEnd3 != null && this.getCtpNe(iServerTrailEnd3, iNetElement) == null) continue;
                if (iServerTrailEnd2 == null) {
                    if (this.db.on()) {
                        this.db.println("DiscoverServerTrail: Found 1st CTP.");
                    }
                    this.putSvPrimCTP(iServerTrailEnd);
                    if (iServerTrailEnd3 != null) {
                        this.createServerTrailLink(iServerTrailLinkId);
                    }
                    list = this.trailNodesToHandle;
                    synchronized (list) {
                        if (!this.trailNodesToHandle.contains(iNetElement2)) {
                            this.trailNodesToHandle.add(iNetElement2);
                        }
                        continue;
                    }
                }
                if (this.ctpMatch(iServerTrailEnd, iServerTrailEnd2)) {
                    if (!this.db.on()) continue;
                    this.db.println("DiscoverServerTrail: Found matching CTP in Primary list.");
                    continue;
                }
                if (iServerTrailEnd3 == null) {
                    if (this.db.on()) {
                        this.db.println("DiscoverServerTrail: Found 2nd CTP. Creating link");
                    }
                    this.putSvPeerCTP(iServerTrailEnd);
                    this.createServerTrailLink(iServerTrailLinkId);
                    continue;
                }
                if (this.ctpMatch(iServerTrailEnd3, iServerTrailEnd)) {
                    if (this.db.on() && iNetLink == null) {
                        this.db.println("ERROR: ServerTrail missing even after both CTPs have been discovered");
                    }
                    this.createServerTrailLink(iServerTrailLinkId);
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("ERROR: More than 2 CTPs with same svId");
            }
            Object var19_21 = null;
            if (n > 0) {
                network.lastMember(iNodeModel, IPartitioner.AdjacencyType.SERVER_TRAIL);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            if (n > 0) {
                network.lastMember(iNodeModel, IPartitioner.AdjacencyType.SERVER_TRAIL);
            }
            throw throwable;
        }
    }

    private boolean ctpMatch(IServerTrailEnd iServerTrailEnd, IServerTrailEnd iServerTrailEnd2) {
        IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
        IServerTrailLinkId iServerTrailLinkId2 = iServerTrailEnd2.getServerTrailLinkId();
        if (iServerTrailEnd instanceof IHoServerTrailEnd && iServerTrailEnd2 instanceof IHoServerTrailEnd) {
            IHoPathDefModel iHoPathDefModel = ((IHoServerTrailEnd)iServerTrailEnd).getTrailStart();
            IHoPathDefModel iHoPathDefModel2 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            INodeModel iNodeModel = iHoPathDefModel.getNodeModel();
            INodeModel iNodeModel2 = iHoPathDefModel2.getNodeModel();
            if (iServerTrailLinkId.getNodeId() == iServerTrailLinkId2.getNodeId() && iServerTrailLinkId.getUniqueId() == iServerTrailLinkId2.getUniqueId() && this.findNetElem(iNodeModel).getNodeId() == this.findNetElem(iNodeModel2).getNodeId()) {
                return true;
            }
        } else if (iServerTrailEnd instanceof ILoServerTrailEnd && iServerTrailEnd2 instanceof ILoServerTrailEnd) {
            ILoDefModel iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
            ILoDefModel iLoDefModel2 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailStart();
            INodeModel iNodeModel = iLoDefModel.getLoAdit().getHo().getNodeModel();
            INodeModel iNodeModel3 = iLoDefModel2.getLoAdit().getHo().getNodeModel();
            if (iServerTrailLinkId.getNodeId() == iServerTrailLinkId2.getNodeId() && iServerTrailLinkId.getUniqueId() == iServerTrailLinkId2.getUniqueId() && this.findNetElem(iNodeModel).getNodeId() == this.findNetElem(iNodeModel3).getNodeId()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerTrails(INetElement iNetElement) {
        List list = this.trailNodesToHandle;
        synchronized (list) {
            if (!this.trailNodesToHandle.contains(iNetElement)) {
                this.trailNodesToHandle.add(iNetElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSvPeerCTP(IServerTrailEnd iServerTrailEnd) {
        IServerTrailEnd iServerTrailEnd2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            iServerTrailEnd2 = this.findSvPeerCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailPeerCTPs.put(serverTrailLinkId, iServerTrailEnd);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSvPrimCTP(IServerTrailEnd iServerTrailEnd) {
        IServerTrailEnd iServerTrailEnd2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
            iServerTrailEnd2 = this.findSvPrimCTP(iServerTrailLinkId);
            if (iServerTrailEnd2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailPrimCTPs.put(serverTrailLinkId, iServerTrailEnd);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpServerTrails() {
        IServerTrailLinkId iServerTrailLinkId;
        IServerTrailEnd iServerTrailEnd;
        int n;
        Iterator iterator;
        this.db.println("Primary CTPs:");
        Object object = this.masterTrailLock;
        synchronized (object) {
            iterator = this.svTrailPrimCTPs.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                iServerTrailEnd = (IServerTrailEnd)iterator.next();
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                this.db.println(" P-ctp " + ++n + " has SvId-NodeId = " + iServerTrailLinkId.getNodeId() + " Unique = " + iServerTrailLinkId.getUniqueId() + " Peer IP Address " + iServerTrailEnd.getPeerIpAddr());
            }
        }
        this.db.println("Peer CTPs:");
        object = this.masterTrailLock;
        synchronized (object) {
            iterator = this.svTrailPeerCTPs.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                iServerTrailEnd = (IServerTrailEnd)iterator.next();
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                this.db.println(" S-Ctp " + ++n + " has SvId-NodeId = " + iServerTrailLinkId.getNodeId() + " Unique = " + iServerTrailLinkId.getUniqueId() + " Peer IP Address " + iServerTrailEnd.getPeerIpAddr());
            }
        }
    }

    protected void handleServerTrailCtp(IServerTrailsManager iServerTrailsManager, Object object) {
        if (object == ModelUpdateType.ADDED) {
            if (this.db.on()) {
                this.db.println("received ADDED event for ServerTrails");
            }
            this.addNewServerTrail(iServerTrailsManager);
        }
        if (object == ModelUpdateType.DELETED && this.db.on()) {
            this.db.println("received DELETED event for ServerTrails");
        }
        if (object == ModelUpdateType.CHANGED) {
            if (this.db.on()) {
                this.db.println("received CHANGED event for ServerTrails");
            }
            this.deleteServerTrail(iServerTrailsManager);
        }
    }

    public final void deleteSvTrail(String string, int n, int n2, int n3, int n4, int n5) {
        block13: {
            ServerTrailLink serverTrailLink;
            Object object;
            IHoNum iHoNum;
            int n6;
            InetAddress inetAddress;
            INetElement iNetElement = null;
            INetLink iNetLink = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = this.getNetworkInstance().findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                this.db.println("deleteServerTrail: caught exception, e = " + unknownHostException);
                return;
            }
            inetAddress = iNetElement.getNodeModel();
            try {
                n6 = NetCircuitManager.instance().calcFramingType(n4, n5);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.db.println("failed to get framing type for node: " + inetAddress.getNodeId() + " " + abstractCmsIOException.getMessage());
                return;
            }
            IHoLoNum iHoLoNum = null;
            IHoNum iHoNum2 = null;
            if (n3 > 0) {
                iHoNum = HoLoFactory.ho2HoNum(n6, n2);
                object = HoLoFactory.idlVt2LoNum(n6, n5, n3);
                iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, (ILoNum)object);
            } else {
                iHoNum2 = HoLoFactory.ho2HoNum(n6, n2);
            }
            iHoNum = null;
            try {
                iHoNum = inetAddress.getEntityTable().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return;
            }
            object = (LinkedList)this.findServerTrailsAtSrc((IEntityModel)iHoNum);
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                serverTrailLink = (ServerTrailLink)iterator.next();
                ILabel iLabel = serverTrailLink.getSrcPoolStartLabel();
                if ((!(iLabel instanceof IHoLoNum) || !iLabel.equals(iHoLoNum)) && (!(iLabel instanceof IHoNum) || !iLabel.equals(iHoNum2))) continue;
                iNetLink = serverTrailLink;
                break;
            }
            if (iNetLink == null) {
                this.db.println("deleteServerTrail: cannot find servertrail link to destroy");
            } else {
                try {
                    serverTrailLink = iNetLink.getServerTrailId();
                    this.deleteServerTrail((IServerTrailLinkId)serverTrailLink);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!this.db.on()) break block13;
                    this.db.println("deleteServerTrail: caught exception, e = \n" + serverTrailException.getMessage());
                }
            }
        }
    }

    public boolean isServerTrailInUse(IServerTrailLinkId iServerTrailLinkId) {
        ServerTrailLinkId serverTrailLinkId;
        IServerTrailEnd iServerTrailEnd;
        if (iServerTrailLinkId == null) {
            if (this.db.on()) {
                this.db.println("isServerTrailInUse :: ServerTrailId is NULL");
            }
            return false;
        }
        if (this.db.on()) {
            this.db.println("InUse check for SVTrail with NodeId " + iServerTrailLinkId.getNodeId() + "Uid " + iServerTrailLinkId.getUniqueId());
        }
        if ((iServerTrailEnd = this.findSvPrimCTP(serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()))) != null && iServerTrailEnd.inUse()) {
            if (this.db.on()) {
                this.db.println("Primary CTP is inUse");
            }
            return true;
        }
        iServerTrailEnd = this.findSvPeerCTP(serverTrailLinkId);
        if (iServerTrailEnd != null && iServerTrailEnd.inUse()) {
            if (this.db.on()) {
                this.db.println("Peer CTP is inUse");
            }
            return true;
        }
        return false;
    }

    private List findServerTrailsAtSrc(IEntityModel iEntityModel) {
        Collection collection = this.getNetworkInstance().getNetLinks();
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        INetElement iNetElement = this.getNetworkInstance().getNetElem(iEntityModel.getNodeModel().getNodeId());
        int n = iEntityModel.getEntityIndex();
        for (INetLink iNetLink : collection) {
            if (iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
            if (iNetLink.getLinkType() == 9) {
                linkedList.add(iNetLink);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("ERROR: Found a Non-ServerTrail on port " + iEntityModel.toString());
        }
        return linkedList;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IServerTrailsManager) {
            this.handleServerTrailCtp((IServerTrailsManager)iObservable, object);
        }
    }

    protected void removeExistingServerTrails(INodeModel iNodeModel, IEntityModel iEntityModel, ServerTrailPrefs serverTrailPrefs, List list) {
        Object object;
        IHoLoNum iHoLoNum;
        Object object2;
        IServerTrailEnd iServerTrailEnd2;
        List list2 = this.findCTPs(iEntityModel);
        LinkedList<HoLoRange> linkedList = new LinkedList<HoLoRange>();
        LinkedList linkedList2 = new LinkedList();
        List list3 = new LinkedList();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        int n = serverTrailPrefs.getCircuitType().getEnum();
        int n2 = serverTrailPrefs.getCircuitSize().getEnum();
        int n3 = NetCircuitManager.instance().calcFramingType(n, n2);
        if (this.db.on()) {
            this.db.println("removeExistingServerTrails: From allCktEnds size = " + list.size());
        }
        for (IServerTrailEnd iServerTrailEnd2 : list2) {
            if (serverTrailPrefs.isLoTrail()) {
                object2 = this.getNetworkInstance().getNetElem(iNodeModel.getNodeId());
                list3 = ServerTrailPrefs.getAllLoLabels(serverTrailPrefs.getCircuitSize(), iServerTrailEnd2);
                linkedList2.addAll(list3);
                if (!this.db.on()) continue;
                this.db.println("Adding " + list3.size() + " more ctp loLabels");
                this.db.println("Updated LoSet size = " + linkedList2.size());
                continue;
            }
            object2 = null;
            iHoLoNum = null;
            if (iServerTrailEnd2 instanceof IHoServerTrailEnd) {
                object2 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart().getStartingHo();
                iHoLoNum = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailEnd().getStartingHo();
                int n4 = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart().getStartingHo().getFramingType();
                if (n3 != n4) {
                    object = ((IHoServerTrailEnd)iServerTrailEnd2).getTrailStart().getPool();
                    IHoNum iHoNum = object.includedPath().getStartingHo(n3);
                    if (FramingType.getFramingType((int)n3) == FramingType.SDH_AU3) {
                        object2 = HoLoFactory.addOffset(iHoNum, (object2.getHoNum() - 1) * 3);
                        iHoLoNum = HoLoFactory.addOffset(iHoNum, iHoLoNum.getHoNum() * 3 - 1);
                    } else {
                        object2 = HoLoFactory.addOffset(iHoNum, (object2.getHoNum() - 1) / 3);
                        iHoLoNum = HoLoFactory.addOffset(iHoNum, (iHoLoNum.getHoNum() - 1) / 3);
                    }
                }
            } else if (iServerTrailEnd2 instanceof ILoServerTrailEnd) {
                object2 = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailStart().getLoAdit().getHo().getStartingHo();
                iHoLoNum = ((ILoServerTrailEnd)iServerTrailEnd2).getTrailEnd().getLoAdit().getHo().getStartingHo();
            }
            if (this.db.on()) {
                this.db.println("Creating Ho range from " + object2.getHoNum() + " to " + iHoLoNum.getHoNum() + " for pre-existing CTP");
            }
            HoLoRange hoLoRange2 = new HoLoRange((IHoNum)object2, (IHoNum)iHoLoNum);
            linkedList.add(hoLoRange2);
        }
        iServerTrailEnd2 = list.iterator();
        if (serverTrailPrefs.isLoTrail()) {
            while (iServerTrailEnd2.hasNext()) {
                object2 = (INetCircuitEnd)iServerTrailEnd2.next();
                if (!(object2 instanceof LoCircuitEnd) && this.db.on()) {
                    this.db.println("ERROR: CktEnd not LoType");
                }
                if (!linkedList2.contains(iHoLoNum = ((NetCircuitEnd)(object = (LoCircuitEnd)object2)).getHoLoNum())) continue;
                linkedList3.add(object2);
            }
        } else {
            object = CircuitSize.getCircuitSize((int)n2);
            short s = object.size2widthOfHoCircuit();
            IFramingType iFramingType = FramingType.getFramingType((int)n3);
            int n5 = iFramingType.getFramingTypeHoPathWidth((int)s);
            while (iServerTrailEnd2.hasNext()) {
                object2 = (INetCircuitEnd)iServerTrailEnd2.next();
                if (!(object2 instanceof HoCircuitEnd) && this.db.on()) {
                    this.db.println("ERROR: CktEnd not HoType");
                }
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)object2;
                IHoNum iHoNum = hoCircuitEnd.getHoNum();
                IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, n5 - 1);
                HoLoRange hoLoRange = new HoLoRange(iHoNum, iHoNum2);
                for (HoLoRange hoLoRange2 : linkedList) {
                    if (!hoLoRange.doesIntersect(hoLoRange2)) continue;
                    linkedList3.add(object2);
                    if (!this.db.on()) continue;
                    this.db.println("ServerTrails: Filtering out cktEnd " + hoCircuitEnd.prettyString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("allCktEnds size = " + list.size() + "usedCktEnds size = " + linkedList3.size());
        }
        list.removeAll(linkedList3);
        if (this.db.on()) {
            this.db.println("After removing allCktEnds size = " + list.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getServerTrails(INetElement iNetElement) {
        INodeModel iNodeModel;
        if (this.db.on()) {
            this.db.println("getServerTrails for " + iNetElement.getName());
        }
        if (!(iNodeModel = iNetElement.getNodeModel()).isInited()) {
            List list = this.trailNodesToHandle;
            synchronized (list) {
                if (!this.trailNodesToHandle.contains(iNetElement)) {
                    this.trailNodesToHandle.add(iNetElement);
                }
                return;
            }
        }
        if (!iNodeModel.provides(Feature.SERVER_TRAIL)) {
            if (this.db.on()) {
                this.db.println("getServerTrails: STrail not supported at node " + iNodeModel.getName());
            }
            return;
        }
        IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
        if (iServerTrailsManager != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)iServerTrailsManager, this);
            this.addNewServerTrail(iServerTrailsManager);
        }
    }

    public void validateServerTrailPrefs(ServerTrailPrefs serverTrailPrefs) throws ServerTrailException {
        IEntityModel iEntityModel;
        if (!serverTrailPrefs.validateTrailCktEnds()) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: Invalid boundary condition");
            }
            throw new ServerTrailException("A server trail link cannot be created because the trail boundaries are invalid.");
        }
        if (!serverTrailPrefs.validateLoNums()) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: LoNum mismatch");
            }
            throw new ServerTrailException("The server trail link creation failed because the LO numbers on the source and destination sides do not match.");
        }
        try {
            InetUtil.parseDottedString(serverTrailPrefs.getSrc().getHostName());
            InetUtil.parseDottedString(serverTrailPrefs.getDest().getHostName());
        }
        catch (NumberFormatException numberFormatException) {
            this.db.println("ERROR: Invalid IPAddress in SVTrailPrefs :");
            this.db.println("SRC hostname is " + serverTrailPrefs.getSrc().getHostName());
            this.db.println("Dest hostname is " + serverTrailPrefs.getDest().getHostName());
            throw new ServerTrailException("The source/destination IP address is invalid.\n");
        }
        INetLink iNetLink = this.getNetworkInstance().findNetLinkFromEnt(serverTrailPrefs.getSrc(), serverTrailPrefs.getSrcEntity());
        if (iNetLink != null && iNetLink.getLinkType() != 9 && !iNetLink.isLOTunnel() && !iNetLink.isLAP()) {
            if (this.db.on()) {
                this.db.println("A NON-ServerTrail link exists on Src Entity");
            }
            throw new ServerTrailException("The server trail link creation failed because the source port is already being used.\n");
        }
        iNetLink = this.getNetworkInstance().findNetLinkFromEnt(serverTrailPrefs.getDest(), serverTrailPrefs.getDestEntity());
        if (iNetLink != null && iNetLink.getLinkType() != 9 && !iNetLink.isLOTunnel() && !iNetLink.isLAP()) {
            if (this.db.on()) {
                this.db.println("A NON-ServerTrail link exists on Dest Entity");
            }
            throw new ServerTrailException("The server trail link creation failed because the destination port is already being used.\n");
        }
        INodeModel iNodeModel = serverTrailPrefs.getSrc().getNodeModel();
        try {
            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(serverTrailPrefs.getSrcEntity());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("validateServerTrailPrefs: Src entity index invalid");
            }
            throw new ServerTrailException("The server trail link cannot be created because the source entity index is invalid.");
        }
        List list = serverTrailPrefs.getCktEnds(serverTrailPrefs.getSrc());
        if (this.db.on()) {
            this.db.println("validateServerTrailPrefs: Got " + list.size() + " SourceCktEnds for " + serverTrailPrefs.prettyString());
        }
        int n = list.size();
        this.removeExistingServerTrails(iNodeModel, iEntityModel, serverTrailPrefs, list);
        if (this.db.on()) {
            this.db.println("addServerTrailLink: After removing there remain " + list.size() + " cktEnds ");
        }
        if (n != list.size()) {
            throw new ServerTrailException("The server trail link cannot be created because it overlaps with another\nserver trail link on the source port. \n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createServerTrailCTPs(ServerTrailPrefs serverTrailPrefs) throws ProvisionError, PathInUse, InvalidPath, ServerTrailException {
        Object object;
        ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(0, 0);
        IServerTrailLinkId iServerTrailLinkId = null;
        INodeModel iNodeModel = serverTrailPrefs.getSrc().getNodeModel();
        INodeModel iNodeModel2 = serverTrailPrefs.getDest().getNodeModel();
        if (!iNodeModel.provides(Feature.SERVER_TRAIL) || !iNodeModel2.provides(Feature.SERVER_TRAIL)) {
            throw new ServerTrailException("The server trail feature is not supported on the nodes " + iNodeModel.getName() + " and/or " + iNodeModel2.getName() + ".");
        }
        IServerTrailsManager iServerTrailsManager = iNodeModel.getServerTrailsManager();
        IServerTrailsManager iServerTrailsManager2 = iNodeModel2.getServerTrailsManager();
        IPoolModels iPoolModels = iNodeModel.getPoolModels();
        IPoolModel iPoolModel = iPoolModels.getPoolModel(serverTrailPrefs.getSrcEntity());
        IPoolModels iPoolModels2 = iNodeModel2.getPoolModels();
        IPoolModel iPoolModel2 = iPoolModels2.getPoolModel(serverTrailPrefs.getDestEntity());
        String string = serverTrailPrefs.getSrc().getHostName();
        String string2 = serverTrailPrefs.getDest().getHostName();
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        int n = serverTrailPrefs.getSrc().getNodeId();
        int n2 = serverTrailPrefs.getDest().getNodeId();
        IIPAddressTranslator iIPAddressTranslator = IPAddressTranslator.instance();
        try {
            if (CtcProxyFactory.isIPv6Network()) {
                if (iNodeModel.getIpConfig().getNodeMode()) {
                    inetAddress = iIPAddressTranslator.getIPv6Address(InetAddress.getByName(string));
                }
                if (null == inetAddress) {
                    inetAddress = iIPAddressTranslator.getIPv6Address(iIPAddressTranslator.findVirtualAddress(n));
                }
                if (iNodeModel2.getIpConfig().getNodeMode()) {
                    inetAddress2 = iIPAddressTranslator.getIPv6Address(InetAddress.getByName(string2));
                }
                if (null == inetAddress2) {
                    inetAddress2 = iIPAddressTranslator.getIPv6Address(iIPAddressTranslator.findVirtualAddress(n2));
                }
                if (inetAddress.equals("0:0:0:0:0:0:0:0")) {
                    inetAddress = null;
                }
                if (inetAddress2.equals("0:0:0:0:0:0:0:0")) {
                    inetAddress2 = null;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (!this.db.on()) throw new ProvisionError("An error occurred while looking up the IPv6 address.");
            this.db.println("IPv6 address lookup failed.");
            NetServerTrailMgrDebug.printStackTrace((Throwable)unknownHostException);
            throw new ProvisionError("An error occurred while looking up the IPv6 address.");
        }
        if (null == inetAddress) {
            if (iNodeModel.isSecureMode()) {
                inetAddress = IPAddressTranslator.instance().getSecureAddress(string);
                if (inetAddress == null) {
                    try {
                        object = IPAddressTranslator.instance().findVirtualAddress(n);
                        inetAddress = IPAddressTranslator.instance().getSecureAddress((InetAddress)object);
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddress = null;
                    }
                }
            } else {
                inetAddress = IPAddressTranslator.instance().getPublicAddress(string);
            }
        }
        if (null == inetAddress2) {
            if (iNodeModel2.isSecureMode()) {
                inetAddress2 = IPAddressTranslator.instance().getSecureAddress(string2);
                if (inetAddress2 == null) {
                    try {
                        object = IPAddressTranslator.instance().findVirtualAddress(n2);
                        inetAddress2 = IPAddressTranslator.instance().getSecureAddress((InetAddress)object);
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddress2 = null;
                    }
                }
            } else {
                inetAddress2 = IPAddressTranslator.instance().getPublicAddress(string2);
            }
        }
        if (inetAddress == null) {
            this.db.println("createServerTrailCTPs: Unable able to translate virtual ip " + string);
            throw new ProvisionError("An error occurred while looking up the IP address.");
        }
        if (inetAddress2 == null) {
            this.db.println("createServerTrailCTPs: Unable able to translate virtual ip " + string2);
            throw new ProvisionError("An error occurred while looking up the IP address.");
        }
        object = inetAddress.getHostAddress();
        String string3 = inetAddress2.getHostAddress();
        boolean bl = false;
        if (serverTrailPrefs.isLoTrail()) {
            serverTrailPrefs.checkLoAdits();
            short s = CircuitSize.getCircuitSize((int)serverTrailPrefs.getCircuitSize().getEnum()).size2widthOfLoCircuit();
            IHoNum iHoNum = ((IHoLoNum)serverTrailPrefs.getSrcPoolStart()).getHoNum();
            IHoNum iHoNum2 = ((IHoLoNum)serverTrailPrefs.getSrcPoolEnd()).getHoNum();
            ILoAditModel iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum, serverTrailPrefs.getSrc().getNodeModel(), serverTrailPrefs.getSrcEntity());
            ILoAditModel iLoAditModel2 = ServerTrailPrefs.getLoAdit(iHoNum2, serverTrailPrefs.getSrc().getNodeModel(), serverTrailPrefs.getSrcEntity());
            LoDefModel loDefModel = null;
            LoDefModel loDefModel2 = null;
            loDefModel = new LoDefModel(iNodeModel, iLoAditModel, ((IHoLoNum)serverTrailPrefs.getSrcPoolStart()).getLoNum(), s, 0, serverTrailPrefs.getSrcEntity());
            loDefModel2 = new LoDefModel(iNodeModel, iLoAditModel2, ((IHoLoNum)serverTrailPrefs.getSrcPoolEnd()).getLoNum(), s, 0, serverTrailPrefs.getSrcEntity());
            try {
                serverTrailLinkId = iServerTrailsManager.createLoServerTrail((ILoDefModel)loDefModel, (ILoDefModel)loDefModel2, string3, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (Exception exception) {
                serverTrailPrefs.cleanupLoAdits();
                throw new ServerTrailException(exception.getMessage());
            }
            if (this.db.on()) {
                this.db.println("Created source side loCTP object: sCTP Nodeid = " + serverTrailLinkId.getNodeId() + "sCTP uId = " + serverTrailLinkId.getUniqueId());
                this.db.println("StartHo :" + loDefModel.getLoAdit().getHo().getStartingHo().prettyString() + "Lo :" + loDefModel.getLoNum().prettyString() + "EndHo :" + loDefModel2.getLoAdit().getHo().getStartingHo().prettyString() + "Lo :" + loDefModel2.getLoNum().prettyString());
            }
            IHoNum iHoNum3 = ((IHoLoNum)serverTrailPrefs.getDestPoolStart()).getHoNum();
            IHoNum iHoNum4 = ((IHoLoNum)serverTrailPrefs.getDestPoolEnd()).getHoNum();
            ILoAditModel iLoAditModel3 = ServerTrailPrefs.getLoAdit(iHoNum3, serverTrailPrefs.getDest().getNodeModel(), serverTrailPrefs.getDestEntity());
            ILoAditModel iLoAditModel4 = ServerTrailPrefs.getLoAdit(iHoNum4, serverTrailPrefs.getDest().getNodeModel(), serverTrailPrefs.getDestEntity());
            LoDefModel loDefModel3 = null;
            LoDefModel loDefModel4 = null;
            loDefModel3 = new LoDefModel(iNodeModel2, iLoAditModel3, ((IHoLoNum)serverTrailPrefs.getDestPoolStart()).getLoNum(), s, 0, serverTrailPrefs.getDestEntity());
            loDefModel4 = new LoDefModel(iNodeModel2, iLoAditModel4, ((IHoLoNum)serverTrailPrefs.getDestPoolEnd()).getLoNum(), s, 0, serverTrailPrefs.getDestEntity());
            try {
                iServerTrailLinkId = iServerTrailsManager2.createLoServerTrail((ILoDefModel)loDefModel3, (ILoDefModel)loDefModel4, (String)object, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (PathInUse pathInUse) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            catch (InvalidPath invalidPath) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            catch (ProvisionError provisionError) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Failed to create CTP on destination node ");
                }
                bl = true;
            }
            if (bl) {
                if (this.db.on()) {
                    this.db.println("createServerTrailCTPs: Unable to create CTP objects. Attempting to rollback source server trail and cleanup adit if unused.");
                }
                try {
                    int n3 = 0;
                    while (true) {
                        boolean bl2 = false;
                        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
                        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                            IServerTrailEnd iServerTrailEnd = iServerTrailEndArray[i];
                            if (!iServerTrailEnd.getServerTrailLinkId().equals(serverTrailLinkId)) continue;
                            bl2 = true;
                            iServerTrailsManager.deleteServerTrail((IServerTrailLinkId)serverTrailLinkId);
                            break;
                        }
                        if (bl2) break;
                        if (n3 >= 30000) throw new Exception("Timed out trying to rollback source server trail");
                        Thread.sleep(2000L);
                        n3 += 2000;
                    }
                    serverTrailPrefs.cleanupLoAdits();
                    throw new ProvisionError("Server trail creation on the destination node failed.\nRollback of the source server trail was successful.");
                }
                catch (Exception exception) {
                    this.db.println("createServerTrailCTPs: Failed to rollback source CTP. " + exception);
                    NetServerTrailMgrDebug.printStackTrace((Throwable)exception);
                    throw new ProvisionError("The source CTP could not be rolled back. " + exception);
                }
            }
            if (this.db.on()) {
                this.db.println("Created destination side loCTP object: dCTP Nodeid = " + iServerTrailLinkId.getNodeId() + "dCTP uId = " + iServerTrailLinkId.getUniqueId());
            }
        } else {
            short s = CircuitSize.getCircuitSize((int)serverTrailPrefs.getCircuitSize().getEnum()).size2widthOfHoCircuit();
            IHoNum iHoNum = (IHoNum)serverTrailPrefs.getSrcPoolStart();
            int n4 = iHoNum.getFramingType();
            IHoNum iHoNum5 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel.includedPath().getStartingHo(n4) : iPoolModel.includedPath().getStartingHo();
            IHoNum iHoNum6 = HoLoFactory.removeOffset(iHoNum, iHoNum5);
            IHoNum iHoNum7 = (IHoNum)serverTrailPrefs.getSrcPoolEnd();
            IHoNum iHoNum8 = HoLoFactory.removeOffset(iHoNum7, iHoNum5);
            HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, iHoNum6, 0);
            HoPathDefModel hoPathDefModel2 = new HoPathDefModel(iPoolModel, s, iHoNum8, 0);
            serverTrailLinkId = iServerTrailsManager.createHoServerTrail((IHoPathDefModel)hoPathDefModel, (IHoPathDefModel)hoPathDefModel2, string3, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            if (this.db.on()) {
                this.db.println("Created source side CTP object: sCTP Nodeid = " + serverTrailLinkId.getNodeId() + "sCTP uId = " + serverTrailLinkId.getUniqueId());
            }
            iHoNum = (IHoNum)serverTrailPrefs.getDestPoolStart();
            n4 = iHoNum.getFramingType();
            iHoNum5 = Feature.provides((INodeModel)iPoolModel2.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel2.includedPath().getStartingHo(n4) : iPoolModel2.includedPath().getStartingHo();
            iHoNum6 = HoLoFactory.removeOffset(iHoNum, iHoNum5);
            iHoNum7 = (IHoNum)serverTrailPrefs.getDestPoolEnd();
            iHoNum8 = HoLoFactory.removeOffset(iHoNum7, iHoNum5);
            HoPathDefModel hoPathDefModel3 = new HoPathDefModel(iPoolModel2, s, iHoNum6, 0);
            HoPathDefModel hoPathDefModel4 = new HoPathDefModel(iPoolModel2, s, iHoNum8, 0);
            try {
                iServerTrailLinkId = iServerTrailsManager2.createHoServerTrail((IHoPathDefModel)hoPathDefModel3, (IHoPathDefModel)hoPathDefModel4, (String)object, (IServerTrailLinkId)serverTrailLinkId, serverTrailPrefs.getSrlg(), serverTrailPrefs.getIdlProtectionType(), serverTrailPrefs.getCircuitSize().getEnum(), serverTrailPrefs.getNx());
            }
            catch (ProvisionError provisionError) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            catch (PathInUse pathInUse) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            catch (InvalidPath invalidPath) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("Failed to create Ho CTP on destination node ");
                }
                bl = true;
            }
            if (bl) {
                if (this.db.on()) {
                    this.db.println("createServerTrailCTPs: Unable to create CTP objects. Attempting to rollback source server trail and cleanup adit if unused.");
                }
                try {
                    int n5 = 0;
                    while (true) {
                        boolean bl3 = false;
                        IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
                        for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                            IServerTrailEnd iServerTrailEnd = iServerTrailEndArray[i];
                            if (!iServerTrailEnd.getServerTrailLinkId().equals(serverTrailLinkId)) continue;
                            bl3 = true;
                            iServerTrailsManager.deleteServerTrail((IServerTrailLinkId)serverTrailLinkId);
                            break;
                        }
                        if (bl3) throw new ProvisionError("Server trail creation on the destination node failed.\nRollback of the source server trail was successful.");
                        if (n5 >= 30000) throw new Exception("Timed out trying to rollback source server trail");
                        Thread.sleep(2000L);
                        n5 += 2000;
                    }
                }
                catch (Exception exception) {
                    this.db.println("createServerTrailCTPs: Failed to rollback source CTP. " + exception);
                    NetServerTrailMgrDebug.printStackTrace((Throwable)exception);
                    throw new ProvisionError("The source CTP could not be rolled back. " + exception);
                }
            }
            if (this.db.on()) {
                this.db.println("Created dest side hoCTP object: dCTP Nodeid = " + iServerTrailLinkId.getNodeId() + "dCTP uId = " + iServerTrailLinkId.getUniqueId());
            }
        }
        serverTrailPrefs.setTrailId(serverTrailLinkId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findCTPs(IEntityModel iEntityModel) {
        LinkedList linkedList = new LinkedList();
        LinkedList<IServerTrailEnd> linkedList2 = this.masterTrailLock;
        synchronized (linkedList2) {
            linkedList.addAll(this.svTrailPrimCTPs.values());
            linkedList.addAll(this.svTrailPeerCTPs.values());
        }
        linkedList2 = new LinkedList<IServerTrailEnd>();
        INetElement iNetElement = this.getNetworkInstance().getNetElem(iEntityModel.getNodeModel().getNodeId());
        int n = iEntityModel.getEntityIndex();
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            IServerTrailEnd iServerTrailEnd = (IServerTrailEnd)iterator.next();
            INetElement iNetElement2 = this.getCtpNe(iServerTrailEnd, null);
            if (iNetElement2 == null) continue;
            if (iServerTrailEnd instanceof IHoServerTrailEnd) {
                IHoServerTrailEnd iHoServerTrailEnd = (IHoServerTrailEnd)iServerTrailEnd;
                n2 = iHoServerTrailEnd.getTrailStart().getPool().getEntityIndex();
            } else if (iServerTrailEnd instanceof ILoServerTrailEnd) {
                ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd;
                n2 = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getPool().getEntityIndex();
            }
            if (iNetElement2 == null || !iNetElement2.equals(iNetElement) || n != n2) continue;
            linkedList2.add(iServerTrailEnd);
        }
        if (this.db.on()) {
            this.db.println("=================================================");
            this.db.println("Found " + linkedList2.size() + " CTP objects on" + iNetElement.getName() + "::" + Integer.toHexString(n));
            this.db.println("=================================================");
        }
        return linkedList2;
    }

    private INetLink addServerTrailLink(ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, ServerTrailPrefs serverTrailPrefs, boolean bl2) throws ServerTrailException {
        if (iLinkModel == null) {
            if (this.db.on()) {
                this.db.println("addServerTrailLink: link model is null, returning null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("addServerTrailLink: Adding SvrTrl-NL between NE's " + iNetElement.getHostName() + " and " + iNetElement2.getHostName());
        }
        INetLink iNetLink = null;
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iLinkModel.linkType(), iNetElement, iNetElement2, iLinkModel.isVirtual() ? 0 : iLinkModel.srcEntityIndex(), iLinkModel.isVirtual() ? 0 : iLinkModel.dstEntityIndex(), iLinkModel.srcHo(), iLinkModel.dstHo(), iLinkModel.linkType() == 6 ? iLinkModel.getSrcLinkId() : -1, iLinkModel.linkType() == 6 ? iLinkModel.getDstLinkId() : -1, false, serverTrailPrefs.getTrailId());
        boolean bl3 = this.getNetworkInstance().isNetLinkKey(netLinkComparatorKey);
        if (bl3) {
            if (this.db.on()) {
                this.db.println("addServerTrailLink: Found matching ServerTrail existing NL, list size= " + this.getNetworkInstance().getAllNetLinkSize());
            }
            iNetLink = this.getNetworkInstance().getNetLink(netLinkComparatorKey);
            this.getNetworkInstance().addNewNetLink(iNetLink);
            return iNetLink;
        }
        iNetLink = NetLinkFactory.createNetLink(this.getNetworkInstance(), iLinkModel, iNetElement, iNetElement2, topology, bl, serverTrailPrefs);
        this.getNetworkInstance().addNewNetLink(iNetLink);
        return iNetLink;
    }

    private void prettyPrint(SDebug sDebug) {
        sDebug.println("Active ->" + this.active);
        this.dumpServerTrails();
    }

    public class NetServerTrailMgrDebug
    extends SDebug
    implements IDebugDiag,
    IActionClient {
        private User user;
        private static final String defaultUserName = "CISCO15";
        private static final String defaultPassword = "otbu+1";

        public NetServerTrailMgrDebug() {
            super("NetServerTrailManager");
            this.user = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (sServerTrailMgr != null) {
                NetServerTrailManager netServerTrailManager = sServerTrailMgr;
                synchronized (netServerTrailManager) {
                    sServerTrailMgr.prettyPrint(this);
                }
            }
        }

        public final void dumpAvailTrailPoints(String string, int n, int n2) {
            InetAddress inetAddress;
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n2));
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = NetServerTrailManager.this.getNetworkInstance().findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                NetServerTrailManager.this.db.println("createServerTrail: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            IEntityModel iEntityModel = null;
            if (inetAddress != null) {
                try {
                    iEntityModel = inetAddress.getEntityTable().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    return;
                }
            } else {
                return;
            }
            LinkedList linkedList = (LinkedList)NetServerTrailManager.this.getAvailServerTrailPoints((INodeModel)inetAddress, iEntityModel, serverTrailPrefs);
            for (NetCircuitEnd netCircuitEnd : linkedList) {
                NetServerTrailManager.this.db.println(" NetCircuitEnd: " + netCircuitEnd.prettyString());
            }
        }

        public final void dumpAvailTrailPorts(String string, int n) {
            InetAddress inetAddress;
            ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
            serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n));
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = NetServerTrailManager.this.getNetworkInstance().findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                NetServerTrailManager.this.db.println("dumpServerTrailPorts: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            LinkedList linkedList = (LinkedList)NetServerTrailManager.this.getAvailServerTrailPorts((INodeModel)inetAddress, serverTrailPrefs);
            for (IEntityModel iEntityModel : linkedList) {
                NetServerTrailManager.this.db.println(" Entity: " + iEntityModel.toString());
            }
        }

        public final void getCTPs(String string) {
            ILoDefModel iLoDefModel;
            boolean bl;
            IServerTrailLinkId iServerTrailLinkId;
            InetAddress inetAddress;
            INetElement iNetElement = null;
            try {
                inetAddress = InetAddress.getByName(string);
                iNetElement = NetServerTrailManager.this.getNetworkInstance().findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                NetServerTrailManager.this.db.println("getServerTrail: caught exception, e = " + unknownHostException.getMessage());
            }
            inetAddress = iNetElement.getNodeModel();
            if (!inetAddress.provides(Feature.SERVER_TRAIL)) {
                if (NetServerTrailManager.this.db.on()) {
                    NetServerTrailManager.this.db.println("getCTPs: STrail not supported at node " + inetAddress.getName());
                }
                return;
            }
            IServerTrailsManager iServerTrailsManager = inetAddress.getServerTrailsManager();
            NetServerTrailManager.this.db.println("Going to fetch CTPs");
            if (!iServerTrailsManager.isInited()) {
                NetServerTrailManager.this.db.println("getCTPs:: svMgr is not initialized");
                return;
            }
            IServerTrailEnd[] iServerTrailEndArray = iServerTrailsManager.getServerTrails();
            NetServerTrailManager.this.db.println("Received " + iServerTrailEndArray.length + " CTP objects on" + iNetElement.getName());
            for (int i = 0; i < iServerTrailEndArray.length; ++i) {
                IServerTrailEnd iServerTrailEnd = iServerTrailEndArray[i];
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) continue;
                bl = true;
                NetServerTrailManager.this.db.println("Validating LoCTP FROM NODE:: NodeId " + iServerTrailLinkId.getNodeId() + " Uid: " + iServerTrailLinkId.getUniqueId());
                try {
                    iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
                    inetAddress = iLoDefModel.getLoAdit().getHo().getNodeModel();
                }
                catch (Exception exception) {
                    NetServerTrailManager.this.db.println("Failed Adit call: Caught Exception => " + exception.getMessage());
                    bl = false;
                }
                if (!bl) continue;
                NetServerTrailManager.this.db.println("LoCTP (FROM NODE) looks good");
            }
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(NetServerTrailManager.this.svTrailPrimCTPs.values());
            linkedList.addAll(NetServerTrailManager.this.svTrailPeerCTPs.values());
            for (IServerTrailEnd iServerTrailEnd : linkedList) {
                iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) continue;
                bl = true;
                NetServerTrailManager.this.db.println("Validating LoCTP FROM local list:: NodeId " + iServerTrailLinkId.getNodeId() + " Uid: " + iServerTrailLinkId.getUniqueId());
                try {
                    iLoDefModel = ((ILoServerTrailEnd)iServerTrailEnd).getTrailStart();
                    inetAddress = iLoDefModel.getLoAdit().getHo().getNodeModel();
                }
                catch (Exception exception) {
                    NetServerTrailManager.this.db.println("Failed Adit call (LOCAL CTP): Caught Exception => " + exception.getMessage());
                    bl = false;
                }
                if (!bl) continue;
                NetServerTrailManager.this.db.println("LoCTP (LOCAL LIST) looks good at node " + NetServerTrailManager.this.findNetElem((INodeModel)inetAddress).getName());
            }
        }

        public final void createServerTrail(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, int n8, int n9, String string3, int n10, int n11) {
            block8: {
                IHoNum iHoNum;
                int n12;
                InetAddress inetAddress;
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    InetAddress inetAddress2 = InetAddress.getByName(string);
                    inetAddress = InetAddress.getByName(string2);
                    iNetElement = NetServerTrailManager.this.getNetworkInstance().findNetElemByIp(inetAddress2.getHostAddress());
                    iNetElement2 = NetServerTrailManager.this.getNetworkInstance().findNetElemByIp(inetAddress.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    NetServerTrailManager.this.db.println("createServerTrail: caught exception, e = " + unknownHostException.getMessage());
                }
                inetAddress = iNetElement.getNodeModel();
                try {
                    n12 = NetCircuitManager.instance().calcFramingType(n7, n8);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    NetServerTrailManager.this.db.println("failed to get framing type for node: " + inetAddress.getNodeId() + " " + abstractCmsIOException.getMessage());
                    return;
                }
                ServerTrailPrefs serverTrailPrefs = new ServerTrailPrefs();
                serverTrailPrefs.setSrc(iNetElement);
                serverTrailPrefs.setSrcEntity(n);
                serverTrailPrefs.setDest(iNetElement2);
                serverTrailPrefs.setDestEntity(n4);
                if (n3 != 0) {
                    iHoNum = HoLoFactory.ho2HoNum(n12, n2);
                    ILoNum iLoNum = HoLoFactory.idlVt2LoNum(n12, n8, n3);
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    serverTrailPrefs.setSrcPoolStart((ILabel)iHoLoNum);
                    iHoNum = HoLoFactory.ho2HoNum(n12, n5);
                    iLoNum = HoLoFactory.idlVt2LoNum(n12, n8, n6);
                    iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    serverTrailPrefs.setDestPoolStart((ILabel)iHoLoNum);
                } else {
                    iHoNum = HoLoFactory.ho2HoNum(n12, n2);
                    serverTrailPrefs.setSrcPoolStart((ILabel)iHoNum);
                    iHoNum = HoLoFactory.ho2HoNum(n12, n5);
                    serverTrailPrefs.setDestPoolStart((ILabel)iHoNum);
                }
                serverTrailPrefs.setProtectionType(n9);
                serverTrailPrefs.setSrlg(string3);
                serverTrailPrefs.setCost(n10);
                serverTrailPrefs.setNx(n11);
                serverTrailPrefs.setPhyLinkType(5);
                serverTrailPrefs.setCircuitSize(CircuitSize.getCircuitSize((int)n8));
                try {
                    NetServerTrailManager.this.createServerTrailLink(serverTrailPrefs);
                }
                catch (ServerTrailException serverTrailException) {
                    if (!NetServerTrailManager.this.db.on()) break block8;
                    NetServerTrailManager.this.db.println("createServerTrail: caught exception, e = " + serverTrailException.getMessage());
                }
            }
        }

        public void dumpDiag() {
            this.dump();
        }

        public void doAction() {
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    public class TrailIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IServerTrailLinkId iServerTrailLinkId = (IServerTrailLinkId)object;
            IServerTrailLinkId iServerTrailLinkId2 = (IServerTrailLinkId)object2;
            return ((ServerTrailLinkId)iServerTrailLinkId).compareTo(iServerTrailLinkId2);
        }
    }
}

