/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.DccLinkStateMachine;
import cerent.cms.topo.GccLinkStateMachine;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IObserver;

public class NonTerminationNetLink
extends NonRoutableNetLink {
    private static final int UNKNOWN_TERMINATION_TYPE = -1;
    private static final int SDCC_TERMINATION_TYPE = 0;
    private static final int GCC_TERMINATION_TYPE = 1;
    private int srcTerminationType = -1;
    private int dstTerminationType = -1;

    protected NonTerminationNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, true, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new NonTerminationNetLink");
        }
        this.createLinkStateMachine();
    }

    public String prettyString() {
        return super.prettyString() + " lsmState=" + (this.linkStateMc != null ? this.linkStateMc.getCurrentSrcStateAsString() : "") + "," + (this.linkStateMc != null ? this.linkStateMc.getCurrentDstStateAsString() : "");
    }

    protected void acquireSrcSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block28: {
            iNodeModel = this.getSrc().getNodeModel();
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getSrcEntityIndex());
                    if (iEntityModel != null) {
                        this.srcSlot = iEntityModel.getSlot();
                        this.srcPort = AbstractNetLink.getPortNum(iEntityModel);
                        if (this.db.on()) {
                            this.db.println("acquireSrcSlotAndPort: SRC slot => " + this.srcSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.srcPort));
                        }
                        if (iEntityModel instanceof IDwdmPortModel) {
                            IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                            if (iDwdmPortModel.isClientPort()) {
                                if (this.db.on()) {
                                    this.db.println("acquireSrcSlotAndPort: SRC DWDM Client port");
                                }
                                if (iDwdmPortModel.isSonetDccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireSrcSlotAndPort: SRC DWDM Client port term. is SDCC");
                                    }
                                    this.srcTerminationType = 0;
                                } else {
                                    this.db.println("acquireSrcSlotAndPort: WARNING SRC DWDM Client port - unknown termination type");
                                    this.srcTerminationType = -1;
                                }
                                this.isSrcDwdmPort = false;
                                this.createLinkStateMachine();
                            } else {
                                if (iDwdmPortModel.isSonetDccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireSrcSlotAndPort: SRC term. is SDCC");
                                    }
                                    this.srcTerminationType = 0;
                                } else if (iDwdmPortModel.isGccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireSrcSlotAndPort: SRC term. is GCC");
                                    }
                                    this.srcTerminationType = 1;
                                } else {
                                    this.db.println("acquireSrcSlotAndPort: WARNING - unknown termination type");
                                    this.srcTerminationType = -1;
                                }
                                if (this.db.on()) {
                                    this.db.println("acquireSrcSlotAndPort: SRC DWDM Trunk port");
                                }
                                this.isSrcDwdmPort = true;
                                this.createLinkStateMachine();
                            }
                        }
                        if (this.srcSlot != 0 && this.srcPort.length > 0) {
                            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                            this.setChanged();
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = true;
                if (this.db.on()) {
                    this.db.println("acquireSrcSlotAndPort: entity index invalid => " + abstractCmsNoSuchEntityException.getMessage());
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                bl = true;
                if (!this.db.on()) break block28;
                this.db.println("acquireSrcSlotAndPort: IO exc => " + abstractCmsIOException.getMessage());
            }
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireSrcSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireSrcSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    protected void acquireDstSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block28: {
            iNodeModel = this.getDst().getNodeModel();
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getDstEntityIndex());
                    if (iEntityModel != null) {
                        this.dstSlot = iEntityModel.getSlot();
                        this.dstPort = AbstractNetLink.getPortNum(iEntityModel);
                        if (this.db.on()) {
                            this.db.println("acquireDstSlotAndPort: DST slot => " + this.dstSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.dstPort));
                        }
                        if (iEntityModel instanceof IDwdmPortModel) {
                            IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                            if (iDwdmPortModel.isClientPort()) {
                                if (this.db.on()) {
                                    this.db.println("acquireDstSlotAndPort: DST DWDM Client port");
                                }
                                if (iDwdmPortModel.isSonetDccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireDstSlotAndPort: DST DWDM Client port term. is SDCC");
                                    }
                                    this.dstTerminationType = 0;
                                } else {
                                    this.db.println("acquireDstSlotAndPort: WARNING DST DWDM Client port - unknown termination type");
                                    this.srcTerminationType = -1;
                                }
                                this.isDstDwdmPort = false;
                                this.createLinkStateMachine();
                            } else {
                                if (iDwdmPortModel.isSonetDccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireDstSlotAndPort: DST term. is SDCC");
                                    }
                                    this.dstTerminationType = 0;
                                } else if (iDwdmPortModel.isGccTermination()) {
                                    if (this.db.on()) {
                                        this.db.println("acquireDstSlotAndPort: DST term. is GCC");
                                    }
                                    this.dstTerminationType = 1;
                                } else {
                                    this.db.println("acquireDstSlotAndPort: WARNING - unknown termination type");
                                    this.dstTerminationType = -1;
                                }
                                if (this.db.on()) {
                                    this.db.println("acquireDstSlotAndPort: DST DWDM Trunk port");
                                }
                                this.isDstDwdmPort = true;
                                this.createLinkStateMachine();
                            }
                        }
                        if (this.srcSlot != 0 && this.srcPort.length > 0) {
                            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                            this.setChanged();
                        }
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = true;
                if (this.db.on()) {
                    this.db.println("acquireDstSlotAndPort: entity index invalid");
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                bl = true;
                if (!this.db.on()) break block28;
                this.db.println("acquireDstSlotAndPort: IO exc => " + abstractCmsIOException.getMessage());
            }
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    private void createLinkStateMachine() {
        if (this.linkStateMc != null) {
            if (this.db.on()) {
                this.db.println("createLinkStateMachine: LinkSM already created");
            }
            return;
        }
        if (this.srcTerminationType == 1 && this.dstTerminationType == 1) {
            if (this.db.on()) {
                this.db.println("createLinkStateMachine: creating new GCC LinkSM");
            }
            this.linkStateMc = new GccLinkStateMachine(this.net, this, this.db);
        } else if (this.srcTerminationType == 0 && this.dstTerminationType == 0) {
            if (this.db.on()) {
                this.db.println("createLinkStateMachine: creating new DCC LinkSM");
            }
            this.linkStateMc = new DccLinkStateMachine(this.net, this, this.db);
        } else if (this.db.on()) {
            this.db.println("createLinkStateMachine: termination type unknown, src => " + this.srcTerminationType + ", dst => " + this.dstTerminationType);
        }
        if (this.linkStateMc != null) {
            this.linkStateMc.driveSm(5);
        }
    }
}

