/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.topo.Topology;
import cerent.util.HoLoRange;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class ServerTrailLink
extends NetLink {
    private Network network;
    private ServerTrailPrefs stPrefs;
    private boolean electricalLink;

    public ServerTrailLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, ServerTrailPrefs serverTrailPrefs) {
        super(network, iLinkModel, iNetElement, iNetElement2, false, topology, n, false);
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2;
        this.stPrefs = new ServerTrailPrefs(serverTrailPrefs);
        if (this.db.on()) {
            this.db.println("Creating new Link with prefs " + serverTrailPrefs.prettyString());
        }
        this.network = network;
        try {
            iEntityModel2 = this.stPrefs.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.stPrefs.getSrcEntity());
            iEntityModel = this.stPrefs.getDest().getNodeModel().getEntityTable().getEntityModelByIndex(this.stPrefs.getDestEntity());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return;
        }
        if (iEntityModel2 instanceof IPortModel && iEntityModel instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel2;
            IPortModel iPortModel2 = (IPortModel)iEntityModel;
            if (!iPortModel.isOptical() || !iPortModel2.isOptical()) {
                if (this.db.on()) {
                    this.db.println("Set Electrical ServerTrail");
                }
                this.electricalLink = true;
            } else {
                this.electricalLink = false;
            }
        }
    }

    public ServerTrailPrefs getPrefs() {
        return this.stPrefs;
    }

    protected ILabel getSrcPoolStartLabel() {
        return this.stPrefs.getSrcPoolStart();
    }

    public boolean isServerTrail() {
        return true;
    }

    public IServerTrailLinkId getServerTrailId() {
        if (this.stPrefs != null) {
            return this.stPrefs.getTrailId();
        }
        return null;
    }

    public String getServerTrailIdString() {
        if (this.stPrefs != null) {
            return this.stPrefs.getTrailIdString();
        }
        return "";
    }

    public String getServerTrailCktSizeString() {
        if (this.stPrefs != null) {
            return this.stPrefs.getCircuitSizeString();
        }
        return "";
    }

    protected ILabelSet getLabelSet(INetElement iNetElement, IPoolModel iPoolModel, int n, int n2, boolean bl) {
        if (n != this.stPrefs.getCircuitSize().getEnum()) {
            if (this.db.on()) {
                this.db.println("ServerTrail does not support circuit size: " + n);
            }
            return null;
        }
        ILabelSet iLabelSet = super.getLabelSet(iNetElement, iPoolModel, n, n2, bl);
        if (this.stPrefs.isLoTrail()) {
            if (!(iLabelSet instanceof LoLabelSet)) {
                if (this.db.on()) {
                    this.db.println("Lo-ServerTrail ERROR : PortLabels is not a LoLabelSet");
                }
                return null;
            }
            List list = this.stPrefs.getAllLoLabels(this.stPrefs.getCircuitType(), this.stPrefs.getCircuitSize(), iNetElement);
            Iterator iterator = iLabelSet.getLabelSet().iterator();
            while (iterator.hasNext()) {
                IHoLoNum iHoLoNum = (IHoLoNum)iterator.next();
                if (list.contains(iHoLoNum)) continue;
                iterator.remove();
            }
            if (this.db.on()) {
                this.db.println("Returning " + iLabelSet.size() + "Lolabels for ServerTrail label set");
            }
        } else {
            IHoNum iHoNum;
            IHoNum iHoNum2;
            if (!(iLabelSet instanceof HoLabelSet)) {
                if (this.db.on()) {
                    this.db.println("Ho-ServerTrail ERROR : PortLabels is not a HoLabelSet");
                }
                return null;
            }
            if (iNetElement.equals(this.stPrefs.getSrc())) {
                iHoNum2 = (IHoNum)this.stPrefs.getSrcPoolStart();
                iHoNum = this.stPrefs.getSrcEndHoNum();
            } else if (iNetElement.equals(this.stPrefs.getDest())) {
                iHoNum2 = (IHoNum)this.stPrefs.getDestPoolStart();
                iHoNum = this.stPrefs.getDstEndHoNum();
            } else {
                if (this.db.on()) {
                    this.db.println("Ho-ServerTrail ERROR : Invalid ne " + iNetElement.prettyString());
                }
                return null;
            }
            HoLoRange hoLoRange = new HoLoRange(iHoNum2, iHoNum);
            Iterator iterator = iLabelSet.getLabelSet().iterator();
            while (iterator.hasNext()) {
                IHoNum iHoNum3 = (IHoNum)iterator.next();
                if (hoLoRange.doesContain(iHoNum3)) continue;
                iterator.remove();
            }
            if (this.db.on()) {
                this.db.println("Returning " + iLabelSet.size() + "Holabels for ServerTrail label set");
            }
        }
        return iLabelSet;
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: ServerTrailLink : " + this.prettyString());
        }
        boolean bl = routePrefs.getFwdDropPrefs().isCommonFiber();
        int n = routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberCount();
        if (bl && n > 1) {
            throw new xLinkNotUsable("ServerTrailLink cannot be used for auto routing of Common Fiber VCAT circuits");
        }
        if (super.isUsable(routePrefs, iNetLink) && this.electricalLink && routePrefs.getPathProt() != 2 && routePrefs.getPathProt() != 3 && routePrefs.getPathProt() != 8) {
            throw new xLinkNotUsable("Electrical ServerTrail cannot be used for Protected circuit");
        }
        return true;
    }

    public IHoNum getFirstValidSrcHo() {
        ILabel iLabel = this.stPrefs.getSrcPoolStart();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    public IHoNum getLastValidSrcHo() {
        ILabel iLabel = this.stPrefs.getSrcPoolEnd();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    public IHoNum getFirstValidDstHo() {
        ILabel iLabel = this.stPrefs.getDestPoolStart();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    public IHoNum getLastValidDstHo() {
        ILabel iLabel = this.stPrefs.getDestPoolEnd();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    public IHoLoNum getDstHoLo(IHoNum iHoNum, ILoNum iLoNum) {
        return this.stPrefs.getDstHoLo(iHoNum, iLoNum);
    }

    public IHoNum getDstHo(IHoNum iHoNum) {
        return this.stPrefs.getDstHo(iHoNum);
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return this.isValidHoNumber(iHoNum, true);
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return this.isValidHoNumber(iHoNum, false);
    }

    public boolean isValidHoLoNum(IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        return this.stPrefs.isValidHoLoNum(iHoNum, iLoNum, bl);
    }

    public boolean isValidHoNumber(IHoNum iHoNum, boolean bl) {
        if (bl) {
            return holoComp.compare(this.getFirstValidSrcHo(), iHoNum) <= 0 && holoComp.compare(iHoNum, this.getLastValidSrcHo()) <= 0;
        }
        return holoComp.compare(this.getFirstValidDstHo(), iHoNum) <= 0 && holoComp.compare(iHoNum, this.getLastValidDstHo()) <= 0;
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof ServerTrailLink) {
            ServerTrailLink serverTrailLink = (ServerTrailLink)object;
            int n = this.getServerTrailId().getNodeId();
            int n2 = serverTrailLink.getServerTrailId().getNodeId();
            int n3 = this.getServerTrailId().getUniqueId();
            int n4 = serverTrailLink.getServerTrailId().getUniqueId();
            if (n == n2 && n3 == n4) {
                return true;
            }
        }
        return false;
    }

    public INetLinkSpan[] getNAvailSpans(int n, int n2, int n3) {
        if (this.db.on()) {
            this.db.println("getNAvailSpans: N = " + n3);
        }
        int n4 = 0;
        INetLink iNetLink = this.getReverseLink();
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("getNAvailSpans: ReverseLink is Null. Error");
            }
            return new INetLinkSpan[0];
        }
        if (n != this.stPrefs.getCircuitSize().getEnum()) {
            return new INetLinkSpan[0];
        }
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        INetLinkSpan[] iNetLinkSpanArray = new INetLinkSpan[iLabelSet.size()];
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        while (iterator.hasNext() && n4 < n3) {
            ILabel iLabel = (ILabel)iterator.next();
            Object object = this.stPrefs.isLoTrail() ? this.stPrefs.getDstHoLo(((IHoLoNum)iLabel).getHoNum(), ((IHoLoNum)iLabel).getLoNum()) : this.stPrefs.getDstHo((IHoNum)iLabel);
            iNetLinkSpanArray[n4++] = new NetLinkSpan(this, iNetLink, iLabel, (ILabel)object);
        }
        if (dbg.on()) {
            this.db.println("getNAvailSpans: Number of Spans: " + iNetLinkSpanArray.length);
        }
        return iNetLinkSpanArray;
    }

    public void getAvailableHoNumbers(Collection collection, int n, int n2) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        for (ILabel iLabel : iLabelSet.getLabelSet()) {
            if (iLabel instanceof IHoNum) {
                treeSet.add(iLabel);
                continue;
            }
            treeSet.add(((IHoLoNum)iLabel).getHoNum());
        }
        collection.addAll(treeSet);
    }

    public List getAvailLoNums(IHoNum iHoNum, boolean bl, int n) {
        if (this.db.on()) {
            this.db.println("getAvailLoNums: looking at link " + this.prettyString());
        }
        this.getPrefs().discoverCircuitType(false);
        ILabelSet iLabelSet = this.getSrcLabelSet(this.getPrefs().getCircuitSize().getEnum(), this.getPrefs().getCircuitType().getEnum());
        List list = super.getAvailLoNums(iHoNum, true, n);
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        ArrayList<ILoNum> arrayList = new ArrayList<ILoNum>();
        while (iterator.hasNext()) {
            IHoLoNum iHoLoNum = (IHoLoNum)iterator.next();
            arrayList.add(iHoLoNum.getLoNum());
        }
        if (list != null && list.size() > 0) {
            list.retainAll(arrayList);
        } else {
            list.addAll(arrayList);
        }
        if (this.db.on()) {
            this.db.println("getAvailLoNums: returning : " + list.size());
        }
        return list;
    }

    public String prettyString() {
        String string = super.prettyString() + this.getServerTrailIdString();
        return string;
    }

    public String prettyStringDetail() {
        String string = super.prettyString() + " " + this.stPrefs.prettyString();
        string = string + "Electrical Link : " + this.electricalLink;
        return string;
    }
}

