/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.InvalidTopoOperation;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.topo.OspfArea;
import cerent.cms.topo.TopologyAgent;
import cerent.util.ComparisonUtil;
import cerent.util.EventBus;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Topology
extends CmsObservable
implements ITopology,
Observer {
    private Network net;
    private int topoId;
    private Map topologyLinks;
    private Map topologyNetElems;
    private List stoppedTopoList;
    private List redundantLinks;
    private boolean updateRequired = false;
    private boolean clientQueued = false;
    private Object updateRequiredLock = new Object();
    private TopologyDebug db;
    private static SDebug dbg = new SDebug("Topology");
    private Collection unreachableNetElems = null;
    private Set reachableNetElems = null;
    private boolean isInitialized;
    private Map ospfAreas;
    private Map topoAgents;
    private List sortedTopoAgents;
    private boolean topoAgentChanged = false;
    private String latestSwVersion = "";
    private Map ospfAreaToTopoAgentMap;
    private List topoAgentEventQueue;
    private List destroyedTopoAgents;
    private List potentialTopoAgents;
    private Topology survivingTopo = null;
    public static final int UNASSIGNED_TOPOLOGY_ID = -1;
    public static final int DEFAULT_TOPOLOGY_ID = 0;
    private static final IIPAddressTranslator trans = IPAddressTranslator.instance();
    private boolean stopped = false;
    private boolean destroyed = false;
    private boolean transferComplete = false;
    private boolean transferRequired = false;
    boolean hasTopologySplit = false;
    boolean waitForOspfConvergence;
    boolean checkForSuspectLinks = false;
    private static final int SMALL_SIZE_TOPOLOGY = 50;
    private static final int MEDIUM_SIZE_TOPOLOGY = 250;
    private static final int LARGE_SIZE_TOPOLOGY = 500;
    private static final int SMALL_CONVERGENCE_TIME = 15;
    private static final int MEDIUM_CONVERGENCE_TIME = 30;
    private static final int LARGE_CONVERGENCE_TIME = 45;
    private static final int DEFAULT_CONVERGENCE_TIME = 60;
    private Set potentialElems;
    private Set recentlyConnectedElems;

    private int calculateTopologyConvergenceTime() {
        int n = this.topologyNetElems.size();
        if (n < 50) {
            return 15;
        }
        if (n < 250) {
            return 30;
        }
        if (n < 500) {
            return 45;
        }
        return 60;
    }

    private void init(Network network, int n) {
        this.net = network;
        this.topoId = n;
        this.db = new TopologyDebug("Topology" + n);
        if (dbg.on()) {
            this.db.set(true);
        }
        this.topologyLinks = Collections.synchronizedMap(new TreeMap(new NetLinkComparator()));
        this.topologyNetElems = Collections.synchronizedMap(new TreeMap());
        this.redundantLinks = Collections.synchronizedList(new LinkedList());
        this.stoppedTopoList = Collections.synchronizedList(new LinkedList());
        this.potentialElems = Collections.synchronizedSet(new TreeSet(new NetElemComparator()));
        this.recentlyConnectedElems = Collections.synchronizedSet(new TreeSet(new NetElemComparator()));
        this.reachableNetElems = Collections.synchronizedSet(new HashSet());
        this.ospfAreas = Collections.synchronizedMap(new TreeMap());
        this.topoAgents = Collections.synchronizedMap(new TreeMap());
        this.sortedTopoAgents = Collections.synchronizedList(new LinkedList());
        this.destroyedTopoAgents = Collections.synchronizedList(new LinkedList());
        this.ospfAreaToTopoAgentMap = Collections.synchronizedMap(new TreeMap());
        this.topoAgentEventQueue = Collections.synchronizedList(new LinkedList());
        this.potentialTopoAgents = Collections.synchronizedList(new LinkedList());
        this.stopped = false;
        this.waitForOspfConvergence = false;
    }

    protected Topology(Network network, NetElement netElement, int n) throws InvalidTopoOperation {
        if (n != 0 && netElement == null) {
            throw new InvalidTopoOperation("The topology instantiation is invalid. The topology host must be supplied for all topologies with a non-zero ID.");
        }
        this.init(network, n);
        if (this.db.on()) {
            this.db.println("Topology: creating topo with topo host " + netElement.getActualAddressDisplay());
        }
        this.addToTopology(netElement);
        this.isInitialized = true;
        this.putUpdate();
    }

    protected Topology(Network network, int n, boolean bl) {
        this.init(network, n);
        this.waitForOspfConvergence = bl;
        this.isInitialized = false;
        if (this.db.on()) {
            this.db.println("Topology: creating topo with unknown topo host ");
        }
    }

    public int inNumberOfTopoAgent(INetLink iNetLink) {
        Iterator iterator = this.getTopoAgents().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TopologyAgent topologyAgent = (TopologyAgent)((Object)iterator.next());
            if (!topologyAgent.linkExist(iNetLink)) continue;
            ++n;
        }
        return n;
    }

    protected void initialize(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("initialize: starting topology creation, topologyHost set to " + netElement.getActualAddressDisplay());
        }
        this.addToTopology(netElement);
        if (!netElement.getConnectionState()) {
            this.potentialElems.add(netElement);
            netElement.addObserver(this);
        }
        this.isInitialized = true;
        this.putUpdate();
    }

    protected void initialize() {
        if (this.topologyNetElems.isEmpty()) {
            this.db.println("initialize: Destroying empty Topo");
            this.destroy(true);
            return;
        }
        if (this.db.on()) {
            this.db.println("initialize: starting topology creation with unknown TopoHost");
        }
        this.isInitialized = true;
        this.topoAgentChanged = true;
        this.checkForSuspectLinks = true;
        this.putUpdate();
    }

    protected void stopThread(Topology topology) {
        if (this.stopped) {
            if (this.db.on()) {
                this.db.println("stopThread: Topo already stopped, ignoring request");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("stopThread: Topo being stopped because of overlap with Topo " + topology.getTopoId());
        }
        this.stopped = true;
        this.transferRequired = false;
        this.survivingTopo = topology;
        if (!this.stoppedTopoList.contains(this)) {
            this.stoppedTopoList.add(this);
        }
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            topologyAgent.deleteObserver(this);
            topologyAgent.destroy(false);
        }
        this.checkForSuspectLinks = true;
    }

    protected void addNetElement(INetElement iNetElement) throws InvalidTopoOperation {
        if (this.topoId != 0) {
            throw new InvalidTopoOperation("An invalid operation was called for the topology ID " + this.topoId + ". This operation is reserved for " + "the special topology ID 0 only.");
        }
        iNetElement.setTopology(this, this.topoId);
        this.topologyNetElems.put(new Integer(iNetElement.getNodeId()), iNetElement);
        if (this.db.on()) {
            this.db.println("addNetElement: added NE " + iNetElement.getHostName() + " with node id " + Integer.toHexString(iNetElement.getNodeId()) + " to list, list size = " + this.topologyNetElems.size());
        }
    }

    public static long ipAddrToLong(IIpAddr iIpAddr) {
        long l = 0L;
        if (iIpAddr != null) {
            byte[] byArray = iIpAddr.getAddr();
            l = byArray[12] << 24 | byArray[13] << 16 | byArray[14] << 8 | byArray[15];
            if (dbg.on()) {
                dbg.println("ipAddrToLong: converted " + Topology.IpAddrString(iIpAddr) + " to " + l);
            }
        }
        return l;
    }

    public static String IpAddrString(IIpAddr iIpAddr) {
        int n = iIpAddr.getAddr()[12] & 0xFF;
        int n2 = iIpAddr.getAddr()[13] & 0xFF;
        int n3 = iIpAddr.getAddr()[14] & 0xFF;
        int n4 = iIpAddr.getAddr()[15] & 0xFF;
        String string = String.valueOf(n) + "." + String.valueOf(n2) + "." + String.valueOf(n3) + "." + String.valueOf(n4);
        return string;
    }

    protected NetElement addNetElement(int n, IIpAddr iIpAddr) {
        NetElement netElement;
        String string = Topology.IpAddrString(iIpAddr);
        if (this.db.on()) {
            this.db.println("addNetElement: creating NE with node ID = " + Integer.toHexString(n) + ", IP = " + trans.getActualAddressDisplay(string));
        }
        if ((netElement = (NetElement)this.net.addNetElement(string, n, this, false, 0)) != null) {
            this.setLatestSwVersion(netElement);
        }
        return netElement;
    }

    protected INetLink addNetLink(NetElement netElement, NetElement netElement2, ILinkModel iLinkModel, boolean bl) {
        if (this.db.on()) {
            this.db.println("addNetLink: creating NL from " + netElement.getActualAddressDisplay() + ":" + iLinkModel.srcEntityIndex() + " to " + netElement2.getActualAddressDisplay() + ":" + iLinkModel.dstEntityIndex());
        }
        INetLink iNetLink = this.net.addNetLink(iLinkModel, netElement, netElement2, true, bl, this, this.redundantLinks);
        return iNetLink;
    }

    protected boolean transferRedundantLinks(Topology topology) {
        int n = this.redundantLinks.size();
        this.redundantLinks.addAll(topology.getRedundantLinks());
        int n2 = this.redundantLinks.size();
        if (this.db.on()) {
            this.db.println("transferRedundantLinks: transfered " + (n2 - n) + " redundant links from Topo " + topology.getTopoId());
        }
        return n2 > n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRedundantLinks() {
        if (this.db.on()) {
            this.db.println("removeRedundantLinks: removing any redundant links, count => " + this.redundantLinks.size());
        }
        if (this.redundantLinks.size() > 0) {
            List list = this.redundantLinks;
            synchronized (list) {
                Iterator iterator = this.redundantLinks.iterator();
                while (iterator.hasNext()) {
                    INetLink iNetLink = (INetLink)iterator.next();
                    if (this.db.on()) {
                        this.db.println("removeRedundantLinks: disposing " + iNetLink.prettyString());
                    }
                    iterator.remove();
                    iNetLink.dispose();
                }
            }
        }
    }

    protected void removeRedundantLink(INetLink iNetLink) {
        this.redundantLinks.remove(iNetLink);
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    private void setUpdateRequired(boolean bl) {
        this.updateRequired = bl;
    }

    private boolean isUpdateRequired() {
        return this.updateRequired;
    }

    private void setClientQueued(boolean bl) {
        this.clientQueued = bl;
        if (this.db.on()) {
            this.db.println("setClientQueued: clientQueued => " + this.clientQueued);
        }
    }

    private boolean isClientQueued() {
        return this.clientQueued;
    }

    protected void putUpdate() {
        if (!this.isInitialized) {
            if (this.db.on()) {
                this.db.println("putUpdate: Topology not initialized");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("putUpdate: Putting one update");
        }
        this.net.queueTopologyUpdateEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processUpdateEvents() {
        block29: {
            Object object;
            block28: {
                try {
                    try {
                        if (this.db.on()) {
                            this.db.println("processUpdateEvents: consuming one update");
                        }
                        if (this.stopped) {
                            if (this.db.on()) {
                                this.db.println("processUpdateEvents: Topology disposed, cannot consume update");
                            }
                            this.stop();
                            Object var4_1 = null;
                            object = this.updateRequiredLock;
                            break block28;
                        }
                        this.processTopoAgentOSPFEvents();
                        while (!this.potentialTopoAgents.isEmpty()) {
                            NetElement netElement = (NetElement)this.potentialTopoAgents.remove(0);
                            this.createTopoAgent(netElement);
                        }
                        if (!this.stopped) {
                            if (this.transferRequired) {
                                this.transferStoppedTopologies();
                                for (TopologyAgent topologyAgent : this.topoAgents.values()) {
                                    this.queueOSPFUpdateEvent(topologyAgent);
                                }
                            }
                        } else if (this.db.on()) {
                            this.db.println("processUpdateEvents: topo stopped, exiting");
                        }
                        this.removeRedundantLinks();
                        if (!this.stopped) {
                            this.runTopoAgentSelectionAlgorithm();
                        } else if (this.db.on()) {
                            this.db.println("processUpdateEvents: topo stopped, exiting");
                        }
                        if (!this.stopped) {
                            this.selectTopoAgents();
                            if (this.checkForSuspectLinks) {
                                this.checkForSuspectLinks = false;
                                this.clearSuspectLinks();
                            }
                            if (this.topologyNetElems.isEmpty()) {
                                this.db.println("processUpdateEvents: Destroying empty Topo");
                                this.destroy(true);
                            }
                        } else if (this.db.on()) {
                            this.db.println("processUpdateEvents: topo stopped, exiting");
                        }
                        if (this.db.on) {
                            this.db.println("processUpdateEvents: consumed one update completed");
                        }
                        break block29;
                    }
                    catch (Exception exception) {
                        this.db.println("processUpdateEvents: Exception in Topology");
                        TopologyDebug.printStackTrace((Throwable)exception);
                        Object var4_3 = null;
                        Object object2 = this.updateRequiredLock;
                        synchronized (object2) {
                            this.setClientQueued(false);
                        }
                        if (!this.isUpdateRequired()) return;
                        this.putUpdate();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Object object3 = this.updateRequiredLock;
                    synchronized (object3) {
                        this.setClientQueued(false);
                    }
                    if (!this.isUpdateRequired()) throw throwable;
                    this.putUpdate();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.setClientQueued(false);
            }
            if (!this.isUpdateRequired()) return;
            this.putUpdate();
            return;
        }
        Object var4_2 = null;
        Object object = this.updateRequiredLock;
        synchronized (object) {
            this.setClientQueued(false);
        }
        if (!this.isUpdateRequired()) return;
        this.putUpdate();
    }

    public int getTopoId() {
        return this.topoId;
    }

    public String toString() {
        return "Topology " + this.topoId;
    }

    public boolean equals(Object object) {
        if (object instanceof ITopology) {
            ITopology iTopology = (ITopology)object;
            return iTopology.getTopoId() == this.getTopoId();
        }
        return false;
    }

    public int hashCode() {
        return this.topoId;
    }

    private void setLatestSwVersion(INetElement iNetElement) {
        if (iNetElement.getConnectionState()) {
            if (this.latestSwVersion.compareTo(iNetElement.getSwVersion()) < 0) {
                if (this.db.on()) {
                    this.db.println("setLatestSwVersion: new NE " + iNetElement.getActualAddressDisplay() + " SW version => " + iNetElement.getSwVersion());
                }
                this.latestSwVersion = iNetElement.getSwVersion();
                this.recentlyConnectedElems.add(iNetElement);
            } else if (this.db.on()) {
                this.db.println("setLatestSwVersion: NE " + iNetElement.getActualAddressDisplay() + " SW version => " + iNetElement.getSwVersion());
            }
        } else {
            if (this.db.on()) {
                this.db.println("setLatestSwVersion: NE " + iNetElement.getActualAddressDisplay() + " not connected, observing");
            }
            this.potentialElems.add(iNetElement);
            iNetElement.addObserver(this);
        }
    }

    protected void addToTopology(INetElement iNetElement) {
        if (iNetElement.isDeleted()) {
            if (this.db.on()) {
                this.db.println("addToTopology: Not adding deleted NE " + iNetElement.getActualAddressDisplay());
            }
            return;
        }
        this.setLatestSwVersion(iNetElement);
        if (iNetElement.getTopoId() == 0 && iNetElement.getTopology() != null) {
            iNetElement.getTopology().removeFromTopology(iNetElement);
        }
        iNetElement.setTopology(this, this.topoId);
        this.topologyNetElems.put(new Integer(iNetElement.getNodeId()), iNetElement);
        if (!iNetElement.getConnectionState()) {
            this.potentialElems.add(iNetElement);
            iNetElement.addObserver(this);
        } else {
            this.recentlyConnectedElems.add(iNetElement);
        }
        if (this.net.isNodeModelEnabledByDefault()) {
            ((NodeModel)iNetElement.getNodeModel()).setEnabled(true);
        }
        if (this.db.on()) {
            this.db.println("addToTopology: added NE " + iNetElement.getActualAddressDisplay() + " with node id " + Integer.toHexString(iNetElement.getNodeId()) + " to list, list size = " + this.topologyNetElems.size());
        }
    }

    protected boolean containsNetElem(INetElement iNetElement) {
        return this.topologyNetElems.containsValue(iNetElement);
    }

    protected void addToTopology(INetLink iNetLink) {
        if (this.db.on()) {
            this.db.println("addToTopology: adding NL " + iNetLink.prettyString());
        }
        ((AbstractNetLink)iNetLink).setTopology(this, this.topoId);
        this.topologyLinks.put(iNetLink, iNetLink);
    }

    protected void removeFromTopology(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("removeFromTopology: removing NE " + iNetElement.getActualAddressDisplay() + " from topo");
        }
        iNetElement.deleteObserver(this);
        this.topologyNetElems.remove(new Integer(iNetElement.getNodeId()));
        this.potentialElems.remove(iNetElement);
        this.recentlyConnectedElems.remove(iNetElement);
        if (iNetElement instanceof NetElement) {
            if (this.topoAgents.containsKey(new Integer(iNetElement.getNodeId()))) {
                Object object = (TopologyAgent)((Object)this.topoAgents.get(new Integer(iNetElement.getNodeId())));
                this.delete((TopologyAgent)((Object)object));
            }
            for (TopologyAgent topologyAgent : this.getTopoAgents()) {
                topologyAgent.delete(iNetElement);
            }
        }
    }

    public INetElement findNetElem(int n) {
        TopologyAgent topologyAgent;
        INetElement iNetElement = null;
        Iterator iterator = this.getTopoAgents().iterator();
        while (iterator.hasNext() && (iNetElement = (topologyAgent = (TopologyAgent)((Object)iterator.next())).findNetElem(n)) == null) {
        }
        return iNetElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getRedundantLinks() {
        LinkedList linkedList = null;
        List list = this.redundantLinks;
        synchronized (list) {
            linkedList = new LinkedList(this.redundantLinks);
        }
        return linkedList;
    }

    public Collection getCurrentTopoHosts() {
        LinkedList<NetElement> linkedList = new LinkedList<NetElement>();
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            linkedList.add(topologyAgent.getTopoHost());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTopoElems() {
        LinkedList linkedList;
        Map map = this.topologyNetElems;
        synchronized (map) {
            linkedList = new LinkedList(this.topologyNetElems.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTopoLinks() {
        LinkedList linkedList;
        Map map = this.topologyLinks;
        synchronized (map) {
            linkedList = new LinkedList(this.topologyLinks.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getTopoAgents() {
        LinkedList linkedList;
        Map map = this.topoAgents;
        synchronized (map) {
            linkedList = new LinkedList(this.topoAgents.values());
        }
        return linkedList;
    }

    private TopologyAgent getTopoAgent(INetElement iNetElement) {
        return (TopologyAgent)((Object)this.topoAgents.get(new Integer(iNetElement.getNodeId())));
    }

    private void findIsolatedNetElems() {
        Object object;
        if (this.db.on()) {
            this.db.println("findIsolatedNetElems: getting latest NEs from TA's");
        }
        this.reachableNetElems.clear();
        for (Object object2 : this.getTopoAgents()) {
            object = ((TopologyAgent)((Object)object2)).getReachableNetElems();
            if (this.db.on()) {
                this.db.println("findIsolatedNetElems: TA " + ((TopologyAgent)((Object)object2)).getTopoHost().getActualAddressDisplay() + " NE count => " + object.size());
            }
            this.reachableNetElems.addAll(object);
        }
        if (!this.topoAgents.isEmpty() && this.topologyNetElems.size() != this.reachableNetElems.size()) {
            Object object2;
            if (this.db.on()) {
                this.db.println("findIsolatedNetElems: Topology is disjoint");
                this.db.println("findIsolatedNetElems: Topo NEs => " + this.topologyNetElems.size() + ", TA reachable " + "NEs => " + this.reachableNetElems.size());
            }
            this.unreachableNetElems = this.getTopoElems();
            this.unreachableNetElems.removeAll(this.reachableNetElems);
            object2 = this.unreachableNetElems.iterator();
            while (object2.hasNext()) {
                object = (NetElement)object2.next();
                if (object == null || ((NetElement)object).getNodeModel() == null || ((NetElement)object).getNodeModel().getNeType() == null || !((NetElement)object).getNodeModel().getNeType().contains("crs")) continue;
                object2.remove();
            }
            if (this.db.on()) {
                this.db.println("findIsolatedNetElems: Disjoint NEs => ");
                object2 = this.unreachableNetElems.iterator();
                while (object2.hasNext()) {
                    object = (NetElement)object2.next();
                    if (!this.db.on()) continue;
                    this.db.println("findIsolatedNetElems:     " + ((NetElement)object).getActualAddressDisplay());
                }
            }
            if ((object2 = this.net.createNewTopology(null, true)) != null) {
                this.transferDisjointTopology((Topology)object2, this.unreachableNetElems);
                ((Topology)object2).initialize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getStoppedTopoList() {
        LinkedList linkedList = null;
        List list = this.stoppedTopoList;
        synchronized (list) {
            linkedList = new LinkedList(this.stoppedTopoList);
        }
        return linkedList;
    }

    protected void delete(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("delete: deleting NE " + iNetElement.getActualAddressDisplay());
        }
        this.net.delete(iNetElement);
        this.removeFromTopology(iNetElement);
        IPAddressTranslator.instance().removeVirtual(iNetElement.getHostName());
        if (this.topologyNetElems.isEmpty() && this.getTopoId() != 0 && !this.destroyed) {
            if (this.db.on()) {
                this.db.println("delete: last NE " + iNetElement.getActualAddressDisplay() + " deleted from topo, calling destroy");
            }
            this.destroy(true);
        }
    }

    protected void delete(INetLink iNetLink) {
        if (iNetLink.getLinkType() == 1 || iNetLink.getLinkType() == 6) {
            if (this.db.on()) {
                this.db.println("delete: removing NL " + iNetLink.prettyString());
            }
            this.topologyLinks.remove(iNetLink);
            for (TopologyAgent topologyAgent : this.getTopoAgents()) {
                topologyAgent.delete(iNetLink);
            }
        }
    }

    private void delete(TopologyAgent topologyAgent) {
        if (this.db.on()) {
            this.db.println("delete: deleting TA " + topologyAgent.getTopoHost().getActualAddressDisplay());
        }
        this.topoAgents.remove(new Integer(topologyAgent.getTopoHost().getNodeId()));
        while (this.topoAgentEventQueue.remove((Object)topologyAgent)) {
        }
        for (OspfArea ospfArea : topologyAgent.getAreas()) {
            Long l = new Long(ospfArea.getAreaId());
            LinkedList linkedList = (LinkedList)this.ospfAreaToTopoAgentMap.get(l);
            if (linkedList == null) continue;
            linkedList.remove((Object)topologyAgent);
            if (!linkedList.isEmpty()) continue;
            this.ospfAreaToTopoAgentMap.remove(l);
            this.ospfAreas.remove(l);
        }
    }

    protected void pause() {
        if (this.db.on()) {
            this.db.println("pause: Topo being paused");
        }
    }

    protected void resume() {
        if (this.db.on()) {
            this.db.println("resume: Topo is resuming");
        }
        if (this.stopped) {
            return;
        }
        if (this.topologyNetElems.isEmpty()) {
            this.db.println("resume: Destroying empty Topo");
            this.destroy(true);
            return;
        }
        if (this.topoAgents.isEmpty()) {
            this.latestSwVersion = "";
            for (NetElement netElement : this.getTopoElems()) {
                this.setLatestSwVersion(netElement);
            }
        } else {
            for (TopologyAgent topologyAgent : this.getTopoAgents()) {
                this.queueOSPFUpdateEvent(topologyAgent);
            }
        }
        this.putUpdate();
    }

    protected void transferComplete() {
        if (this.db.on()) {
            this.db.println("transferComplete: Transfer completed");
        }
        this.transferComplete = true;
        this.putUpdate();
    }

    protected void transferRequired(Topology topology) {
        if (this.db.on()) {
            this.db.println("transferRequired: getting stopped topo list from " + topology.getTopoId() + ", count => " + topology.getStoppedTopoList().size());
        }
        if (this.stopped && this.survivingTopo != null) {
            if (this.db.on()) {
                this.db.println("transferRequired: Topo " + this.getTopoId() + " stopped, trying " + this.survivingTopo.getTopoId());
            }
            this.survivingTopo.transferRequired(topology);
        } else {
            for (ITopology iTopology : topology.getStoppedTopoList()) {
                if (this.stoppedTopoList.contains(iTopology)) continue;
                this.stoppedTopoList.add(iTopology);
                if (!this.db.on()) continue;
                this.db.println("transferRequired: added stopped Topo " + iTopology.getTopoId());
            }
            if (this.db.on()) {
                this.db.println("transferRequired: stopped topo list size => " + this.stoppedTopoList.size());
            }
            this.transferRequired = true;
            this.putUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        NetElement netElement;
        Iterator iterator;
        Object object2;
        if (this.destroyed) {
            return;
        }
        if (!this.transferComplete) {
            if (this.db.on()) {
                this.db.println("stop: cannot cleanup as transfer not complete");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("stop: topo stopped because of merge");
        }
        this.stopped = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        for (Object object2 : this.getTopoAgents()) {
            object2.deleteObserver((Observer)this);
            ((TopologyAgent)((Object)object2)).destroy(true);
        }
        object2 = this.potentialElems;
        synchronized (object2) {
            iterator = this.potentialElems.iterator();
            while (iterator.hasNext()) {
                netElement = (NetElement)iterator.next();
                netElement.deleteObserver(this);
                iterator.remove();
            }
        }
        object2 = this.recentlyConnectedElems;
        synchronized (object2) {
            iterator = this.recentlyConnectedElems.iterator();
            while (iterator.hasNext()) {
                netElement = (NetElement)iterator.next();
                netElement.deleteObserver(this);
                iterator.remove();
            }
        }
        for (Object object2 : this.getTopoElems()) {
            object2.deleteObserver((Observer)this);
        }
        this.net.removeTopology(this);
        this.topoAgents.clear();
        this.ospfAreas.clear();
        this.topologyNetElems.clear();
        this.topologyLinks.clear();
        super.destroy();
        this.db.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(boolean bl) {
        Object object;
        Iterator iterator;
        Object object22;
        if (this.destroyed) {
            return;
        }
        if (this.db.on()) {
            this.db.println("destroy: destroying all TA's, NE's and NL's");
        }
        this.destroyed = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        for (Object object22 : this.getTopoAgents()) {
            object22.deleteObserver((Observer)this);
            ((TopologyAgent)((Object)object22)).destroy(true);
        }
        object22 = this.potentialElems;
        synchronized (object22) {
            iterator = this.potentialElems.iterator();
            while (iterator.hasNext()) {
                object = (NetElement)iterator.next();
                object.deleteObserver((Observer)this);
                iterator.remove();
            }
        }
        object22 = this.recentlyConnectedElems;
        synchronized (object22) {
            iterator = this.recentlyConnectedElems.iterator();
            while (iterator.hasNext()) {
                object = (NetElement)iterator.next();
                object.deleteObserver((Observer)this);
                iterator.remove();
            }
        }
        for (Object object22 : this.getTopoLinks()) {
            object = this.net.findReverseLink((INetLink)object22);
            object22.dispose();
            if (object == null) continue;
            object.dispose();
        }
        if (bl) {
            iterator = this.getTopoElems().iterator();
            while (iterator.hasNext()) {
                ((INetElement)iterator.next()).destroy();
            }
        }
        this.net.removeTopology(this);
        this.topoAgents.clear();
        this.ospfAreas.clear();
        this.topologyNetElems.clear();
        this.topologyLinks.clear();
        super.destroy();
        this.db.dispose();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update: received update");
        }
        if (observable instanceof NetElement) {
            NetElement netElement = (NetElement)((Object)observable);
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NE " + netElement.getActualAddressDisplay());
                }
                if (netElement.getConnectionState()) {
                    netElement.deleteObserver(this);
                    this.topoAgentChanged = true;
                    this.potentialElems.remove(netElement);
                    this.recentlyConnectedElems.add(netElement);
                    this.putUpdate();
                }
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from NE " + netElement.getActualAddressDisplay());
                }
                this.removeFromTopology(netElement);
            }
        } else if (observable instanceof TopologyAgent) {
            TopologyAgent topologyAgent = (TopologyAgent)((Object)observable);
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from TA " + topologyAgent.getTopoHost().getActualAddressDisplay());
                }
                this.topoAgentChanged = true;
                this.putUpdate();
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from TA " + topologyAgent.getTopoHost().getActualAddressDisplay());
                }
                topologyAgent.deleteObserver(this);
                this.delete(topologyAgent);
            }
        }
    }

    protected synchronized void refreshTopology() {
        if (this.db.on()) {
            this.db.println("refreshTopology: starting Topology refresh");
        }
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            topologyAgent.refresh();
        }
        if (this.db.on()) {
            this.db.println("refreshTopology: completed Topology refresh");
        }
    }

    protected synchronized void resetTopology() {
        if (this.db.on()) {
            this.db.println("resetTopology: starting Topology reset");
        }
        for (Object object : this.ospfAreaToTopoAgentMap.values()) {
            ((LinkedList)object).clear();
        }
        this.ospfAreaToTopoAgentMap.clear();
        for (Object object : this.getTopoAgents()) {
            object.deleteObserver((Observer)this);
            ((TopologyAgent)((Object)object)).destroy(true);
        }
        this.ospfAreas.clear();
        this.topoAgents.clear();
        this.sortedTopoAgents.clear();
        this.putUpdate();
        if (this.db.on()) {
            this.db.println("resetTopology: completed Topology reset");
        }
    }

    private void clearSuspectLinks() {
        if (this.db.on()) {
            this.db.println("clearSuspectLinks: looking for suspect links");
        }
        for (AbstractNetLink abstractNetLink : this.getTopoLinks()) {
            boolean bl = true;
            for (TopologyAgent topologyAgent : this.getTopoAgents()) {
                if (!topologyAgent.linkExist(abstractNetLink)) continue;
                bl = false;
            }
            if (!bl) continue;
            if (this.db.on()) {
                this.db.println("clearSuspectLinks: marking down suspect NL " + abstractNetLink.prettyString());
            }
            abstractNetLink.newState(2);
        }
    }

    protected void updateIPAddress(NetElement netElement, String string) {
        this.net.updateIPAddress(netElement, string);
    }

    protected void updateSecureIPAddress(NetElement netElement, String string) {
        this.net.updateSecureIPAddress(netElement, string);
    }

    protected void updateNodeId(NetElement netElement) {
        if (this.db.on) {
            this.db.println("Entering updateNodeId");
        }
        Integer n = new Integer(netElement.getOldNodeId());
        Integer n2 = new Integer(netElement.getNodeId());
        TopologyAgent topologyAgent = (TopologyAgent)((Object)this.topoAgents.remove(n));
        if (topologyAgent != null) {
            this.topoAgents.put(n2, topologyAgent);
        }
        this.topologyNetElems.remove(n);
        this.topologyNetElems.put(n2, netElement);
        this.net.updateNodeId(netElement);
    }

    protected void replaceUnknownLink(INetLink iNetLink, INetLink iNetLink2) {
        if (this.db.on()) {
            this.db.println("replaceUnknownLink: replacing NL " + iNetLink.prettyString() + " with NL " + iNetLink2.prettyString());
        }
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            if (!topologyAgent.linkExist(iNetLink)) continue;
            topologyAgent.delete(iNetLink);
            topologyAgent.addNetLink(iNetLink2);
        }
        this.topologyLinks.remove(iNetLink);
        this.addToTopology(iNetLink2);
    }

    protected void ospfAreaChanged(INetLink iNetLink) {
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            if (!topologyAgent.linkExist(iNetLink) || topologyAgent.containsArea(iNetLink.getOspfAreaId())) continue;
            topologyAgent.delete(iNetLink);
            if (!this.db.on()) continue;
            this.db.println("ospfAreaChanged: removed NL " + iNetLink.prettyString() + ", in area " + iNetLink.getOspfAreaId() + " from TA " + topologyAgent.getTopoHost().getHostName());
        }
    }

    protected void queueOSPFUpdateEvent(TopologyAgent topologyAgent) {
        if (!this.topoAgentEventQueue.contains((Object)topologyAgent)) {
            if (this.db.on()) {
                this.db.println("queueOSPFUpdateEvent: adding OSPF update event for TA " + topologyAgent.getTopoHost().getActualAddressDisplay());
            }
            this.topoAgentEventQueue.add(topologyAgent);
        } else if (this.db.on()) {
            this.db.println("queueOSPFUpdateEvent: TA " + topologyAgent.getTopoHost().getActualAddressDisplay() + " already queued");
        }
        this.putUpdate();
    }

    protected void discoveredABR(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("discoveredABR: found potential TopoAgent " + netElement.getActualAddressDisplay());
        }
        this.addPotentialTopoAgent(netElement);
    }

    private void addPotentialTopoAgent(NetElement netElement) {
        if (!this.potentialTopoAgents.contains(netElement)) {
            this.potentialTopoAgents.add(netElement);
            this.putUpdate();
        }
    }

    protected void discoveredForeignOwnedNE(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("discoveredForeignOwnedNE: NE => " + netElement.getActualAddressDisplay() + ", Topo => " + netElement.getTopoId());
        }
        Topology topology = netElement.getTopology();
        if (netElement.getTopoId() == 0 && topology != null) {
            topology.removeFromTopology(netElement);
        } else if (netElement.getTopoId() > this.getTopoId() && topology != null) {
            if (!topology.isStopped()) {
                topology.stopThread(this);
                this.transferRequired(topology);
            }
        } else if (netElement.getTopoId() < this.getTopoId() && topology != null) {
            this.stopThread(topology);
            topology.transferRequired(this);
        }
    }

    protected void topoAgentABRStatusChanged(TopologyAgent topologyAgent) {
        this.topoAgentChanged = true;
        this.putUpdate();
    }

    protected void processOspfUpdateEvents() {
        this.processTopoAgentOSPFEvents();
    }

    private void processTopoAgentOSPFEvents() {
        if (this.db.on()) {
            this.db.println("processTopoAgentOSPFEvents: starting");
        }
        EventBus.instance().notifyEvent((Object)this.getClass().toString(), (Object)new Integer(1));
        if (!this.topoAgentEventQueue.isEmpty()) {
            while (!this.topoAgentEventQueue.isEmpty()) {
                TopologyAgent topologyAgent = (TopologyAgent)((Object)this.topoAgentEventQueue.remove(0));
                if (!this.stopped) {
                    if (topologyAgent.getTopoHost().getTopoId() != this.getTopoId()) {
                        if (!this.db.on()) continue;
                        this.db.println("processTopoAgentOSPFEvents: TA " + topologyAgent.getTopoHost().getActualAddressDisplay() + " now belongs to Topo " + topologyAgent.getTopoHost().getTopoId() + ", skipping event");
                        continue;
                    }
                    if (this.db.on()) {
                        this.db.println("processTopoAgentOSPFEvents: for TA " + topologyAgent.getTopoHost().getActualAddressDisplay());
                    }
                    topologyAgent.processOSPFUpdateEvent();
                    continue;
                }
                if (!this.db.on()) break;
                this.db.println("processTopoAgentOSPFEvents: topo stopped, exiting");
                break;
            }
        }
        if (!this.stopped) {
            this.findIsolatedNetElems();
        }
        EventBus.instance().notifyEvent((Object)this.getClass().toString(), (Object)new Integer(2));
        if (this.db.on()) {
            this.db.println("processTopoAgentOSPFEvents: completed");
        }
    }

    private void transferStoppedTopologies() {
        if (this.db.on()) {
            this.db.println("transferStoppedTopologies: stopped Topo list count => " + this.stoppedTopoList.size());
        }
        this.transferRequired = false;
        while (!this.stoppedTopoList.isEmpty()) {
            Topology topology = (Topology)this.stoppedTopoList.remove(0);
            if (this.db.on()) {
                this.db.println("transferStoppedTopologies: transferring data from Topo " + topology.getTopoId());
            }
            this.stoppedTopoList.remove(topology);
            this.transferRedundantLinks(topology);
            for (Object object : topology.getTopoElems()) {
                if (this.db.on()) {
                    this.db.println("transferStoppedTopologies: transferring NE " + ((NetElement)object).getActualAddressDisplay() + " from Topo " + topology.getTopoId());
                }
                this.addToTopology((INetElement)object);
            }
            for (Object object : topology.getTopoLinks()) {
                if (this.db.on()) {
                    this.db.println("transferStoppedTopologies: transferring NL " + object.prettyString() + " from Topo " + topology.getTopoId());
                }
                this.addToTopology((INetLink)object);
            }
            topology.transferComplete();
        }
        this.topoAgentChanged = true;
    }

    protected void transferDisjointTopology(Topology topology, Collection collection) {
        for (NetElement netElement : collection) {
            Integer n;
            if (this.db.on()) {
                this.db.println("transferDisjointTopology: processing NE " + netElement.getActualAddressDisplay());
            }
            if (this.topoAgents.containsKey(n = new Integer(netElement.getNodeId()))) {
                if (this.db.on()) {
                    this.db.println("transferDisjointTopology: NE is a TA");
                }
                TopologyAgent topologyAgent = (TopologyAgent)((Object)this.topoAgents.get(n));
                topologyAgent.destroy(false);
                this.topoAgentChanged = true;
            }
            this.removeFromTopology(netElement);
            topology.addToTopology(netElement);
        }
        this.checkForSuspectLinks = true;
    }

    private TopologyAgent createTopoAgent(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("createTopoAgent: creating new Topo Agent for NE " + netElement.getActualAddressDisplay() + ", nodeID = " + netElement.getNodeId());
        }
        TopologyAgent topologyAgent = null;
        if (this.topoAgents.containsKey(new Integer(netElement.getNodeId()))) {
            if (this.db.on()) {
                this.db.println("createTopoAgent: found Existing TopoAgent");
            }
            topologyAgent = (TopologyAgent)((Object)this.topoAgents.get(new Integer(netElement.getNodeId())));
        } else {
            if (this.db.on()) {
                this.db.println("createTopoAgent: TopoAgent is unique, creating new");
            }
            topologyAgent = new TopologyAgent(netElement, this, this.db);
            this.topoAgents.put(new Integer(netElement.getNodeId()), topologyAgent);
            topologyAgent.addObserver(this);
            topologyAgent.enable();
            if (topologyAgent.getTopoHost().getTopoId() != this.getTopoId()) {
                if (this.db.on()) {
                    this.db.println("createTopoAgent: new TA " + topologyAgent.getTopoHost().getActualAddressDisplay() + " moved to Topo " + topologyAgent.getTopoHost().getTopoId() + ", destroying");
                }
                this.removeFromTopology(netElement);
                topologyAgent.destroy(false);
                this.putUpdate();
            }
        }
        return topologyAgent;
    }

    protected void addOspfAreas(TopologyAgent topologyAgent) {
        if (this.db.on()) {
            this.db.println("addOspfAreas: topoAgent " + topologyAgent.getTopoHost().getActualAddressDisplay() + " adding " + topologyAgent.getAreas().size() + " areas");
        }
        for (OspfArea ospfArea : topologyAgent.getAreas()) {
            Object object;
            Long l = new Long(ospfArea.getAreaId());
            if (this.ospfAreas.containsKey(l)) {
                if (this.db.on()) {
                    this.db.println("addOspfArea: TA " + topologyAgent.getTopoHost().getActualAddressDisplay() + " adding existing area " + ospfArea.getAreaId());
                }
                if ((object = (LinkedList)this.ospfAreaToTopoAgentMap.get(l)) == null || ((LinkedList)object).contains((Object)topologyAgent)) continue;
                this.topoAgentChanged = true;
                ((LinkedList)object).add(topologyAgent);
                continue;
            }
            if (this.db.on()) {
                this.db.println("addOspfArea: TA " + topologyAgent.getTopoHost().getActualAddressDisplay() + " adding new area " + ospfArea.getAreaId());
            }
            object = new OspfArea(this.db, ospfArea.getAreaId(), false);
            this.ospfAreas.put(l, object);
            LinkedList<TopologyAgent> linkedList = new LinkedList<TopologyAgent>();
            linkedList.add(topologyAgent);
            this.ospfAreaToTopoAgentMap.put(l, linkedList);
            this.topoAgentChanged = true;
        }
    }

    protected void deleteOspfArea(TopologyAgent topologyAgent, OspfArea ospfArea) {
        Long l;
        LinkedList linkedList;
        if (this.db.on()) {
            this.db.println("deleteOspfArea: topoAgent " + topologyAgent.getTopoHost().getActualAddressDisplay() + " deleting area => " + ospfArea.getAreaId());
        }
        if ((linkedList = (LinkedList)this.ospfAreaToTopoAgentMap.get(l = new Long(ospfArea.getAreaId()))) != null) {
            linkedList.remove((Object)topologyAgent);
            if (linkedList.isEmpty()) {
                if (this.db.on()) {
                    this.db.println("deleteOspfArea: Area " + ospfArea.getAreaId() + " not represented, removing from Topo");
                }
                this.ospfAreaToTopoAgentMap.remove(l);
                this.ospfAreas.remove(l);
            }
        }
        this.topoAgentChanged = true;
    }

    protected void deleteOspfArea(OspfArea ospfArea) {
        TopologyAgent topologyAgent;
        if (this.db.on()) {
            this.db.println("deleteOspfArea: deleting area => " + ospfArea.getAreaId());
        }
        boolean bl = true;
        Iterator iterator = this.getTopoAgents().iterator();
        while (iterator.hasNext() && !(topologyAgent = (TopologyAgent)((Object)iterator.next())).containsArea(ospfArea)) {
            bl = false;
        }
        if (!bl) {
            this.ospfAreas.remove(ospfArea);
        }
    }

    private void runTopoAgentSelectionAlgorithm() {
        if (this.db.on()) {
            this.db.println("runTopoAgentSelectionAlgorithm: starting TopoAgent selection algorithm");
        }
        if (this.topoAgentChanged) {
            this.topoAgentChanged = false;
            this.resetAllAreasAndAgents();
            this.markRedundantAreas();
            this.checkForInactiveAreas();
            this.selectTopoAgents();
            this.purgeRedundantTopoAgents();
            if (this.topoAgents.isEmpty()) {
                this.putUpdate();
            }
        }
        if (this.db.on()) {
            this.db.println("runTopoAgentSelectionAlgorithm: finished TopoAgent selection algorithm");
        }
    }

    private void markRedundantAreas() {
        TopologyAgent[] topologyAgentArray = this.sortTopoAgentsByAllAreas().toArray(new TopologyAgent[0]);
        if (this.db.on()) {
            this.db.println("markRedundantAreas: TopoAgent count => " + topologyAgentArray.length);
        }
        for (int i = 0; i < topologyAgentArray.length; ++i) {
            int n;
            TopologyAgent topologyAgent = topologyAgentArray[i];
            if (this.db.on()) {
                this.db.println("markRedundantAreas: primary TA is " + topologyAgent.getTopoHost().getActualAddressDisplay() + ", pIndex => " + i);
                for (Object object : topologyAgent.getAreas()) {
                    this.db.println("markRedundantAreas:     area " + ((OspfArea)object).getAreaId() + " => " + ((OspfArea)object).isActive());
                }
            }
            if (!topologyAgent.isActive()) {
                if (!this.db.on()) continue;
                this.db.println("markRedundantAreas: primary TA is inactive, skipping");
                continue;
            }
            if (!topologyAgent.isConnected() && this.db.on()) {
                this.db.println("markRedundantAreas: primary TA is not connected, skipping");
            }
            for (n = i + 1; n < topologyAgentArray.length; ++n) {
                Object object;
                object = topologyAgentArray[n];
                if (this.db.on()) {
                    this.db.println("markRedundantAreas: secondary TA is " + ((TopologyAgent)((Object)object)).getTopoHost().getActualAddressDisplay() + ", sIndex => " + n);
                }
                for (OspfArea ospfArea : topologyAgent.getAreas()) {
                    if (!ospfArea.isActive()) continue;
                    this.setAreaActive(ospfArea.getAreaId(), true);
                    if (((TopologyAgent)((Object)object)).isActive()) {
                        ((TopologyAgent)((Object)object)).setAreaIsActive(ospfArea.getAreaId(), false);
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("markRedundantAreas: secondary TA is inactive, skipping");
                }
                if (!((TopologyAgent)((Object)object)).isRedundant()) continue;
                ((TopologyAgent)((Object)object)).setActive(false);
            }
            if (i + 1 == topologyAgentArray.length) {
                if (!topologyAgent.isActive()) continue;
                for (Object object : topologyAgent.getAreas()) {
                    if (!((OspfArea)object).isActive()) continue;
                    this.setAreaActive(((OspfArea)object).getAreaId(), true);
                }
                continue;
            }
            if (this.db.on()) {
                this.db.println("markRedundantAreas: sorting items " + (i + 1) + " to " + topologyAgentArray.length);
            }
            Arrays.sort(topologyAgentArray, i + 1, topologyAgentArray.length, new TopoAgentActiveAreaComparator());
            if (this.db.on()) {
                this.db.println("markRedundantAreas: topoAgentArray after sort");
            }
            for (n = 0; n < topologyAgentArray.length; ++n) {
                if (!this.db.on()) continue;
                this.db.println("markRedundantAreas: " + topologyAgentArray[n].getTopoHost().getActualAddressDisplay() + " => " + topologyAgentArray[n].getNumActiveAreas());
            }
        }
    }

    private List sortTopoAgentsByAllAreas() {
        List list = (List)this.getTopoAgents();
        Collections.sort(list, new TopoAgentAreaComparator());
        for (TopologyAgent topologyAgent : list) {
            if (!this.db.on()) continue;
            this.db.println("sortTopoAgentsByAllAreas: " + topologyAgent.getTopoHost().getActualAddressDisplay() + " => " + topologyAgent.getNumAreas());
        }
        return list;
    }

    private boolean areAllAreasActive() {
        boolean bl = true;
        for (OspfArea ospfArea : this.getAllOspfAreas()) {
            if (ospfArea.isActive()) continue;
            bl = false;
        }
        return bl;
    }

    private void checkForInactiveAreas() {
        for (OspfArea ospfArea : this.getAllOspfAreas()) {
            if (this.db.on()) {
                this.db.println("checkForInactiveAreas: area " + ospfArea.getAreaId() + " is active => " + ospfArea.isActive());
            }
            if (ospfArea.isActive()) continue;
            if (this.db.on()) {
                this.db.println("checkForInactiveAreas: need to find new TopoAgent for area " + ospfArea.getAreaId());
            }
            this.findTopoAgentForInactiveArea(ospfArea);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findTopoAgentForInactiveArea(OspfArea ospfArea) {
        boolean bl = false;
        Object object = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<INetElement> linkedList2 = new LinkedList<INetElement>();
        LinkedList<INetElement> linkedList3 = new LinkedList<INetElement>();
        List list = (List)this.ospfAreaToTopoAgentMap.get(new Long(ospfArea.getAreaId()));
        if (list == null) {
            if (this.db.on()) {
                this.db.println("findTopoAgentForInactiveArea: no TAs available");
            }
            this.putUpdate();
            return;
        }
        for (Object object2 : list) {
            linkedList2.add(((TopologyAgent)((Object)object2)).getTopoHost());
            this.potentialElems.add(((TopologyAgent)((Object)object2)).getTopoHost());
        }
        if (linkedList2.size() == 0) {
            if (this.db.on()) {
                this.db.println("findTopoAgentForInactiveArea: no TopoAgent's to choose from");
            }
            this.putUpdate();
            return;
        }
        while (linkedList2.size() > 0) {
            Object object2;
            object2 = (NetElement)linkedList2.getFirst();
            linkedList2.remove(object2);
            linkedList.add(object2);
            if (this.db.on()) {
                this.db.println("findTopoAgentForInactiveArea: candidate NE " + ((NetElement)object2).getActualAddressDisplay());
            }
            Object object3 = this.net.findAllNetLinksWithSource((INetElement)object2);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.isPca()) {
                    if (!this.db.on()) continue;
                    this.db.println("findTopoAgentForInactiveArea: ignoring PCA link");
                    continue;
                }
                INetElement iNetElement = iNetLink.getDst();
                if (!(iNetElement instanceof NetElement)) {
                    if (!this.db.on()) continue;
                    this.db.println("findTopoAgentForInactiveArea: ignoring NE " + iNetElement.getActualAddressDisplay());
                    continue;
                }
                if (iNetElement.getTopoId() != this.getTopoId()) {
                    if (!this.db.on()) continue;
                    this.db.println("findTopoAgentForInactiveArea: NE " + iNetElement.getActualAddressDisplay() + " in topo " + iNetElement.getTopoId() + ", ignored");
                    continue;
                }
                if (this.db.on()) {
                    this.db.println("findTopoAgentForInactiveArea: trying " + iNetElement.getActualAddressDisplay());
                }
                if (((NetElement)iNetElement).containsOspfArea(ospfArea.getAreaId())) {
                    block29: {
                        if (iNetElement.getConnectionState()) {
                            if (this.latestSwVersion.compareTo(iNetElement.getSwVersion()) > 0) {
                                if (this.db.on()) {
                                    this.db.println("findTopoAgentForInactiveArea: ignoring NE, SW ver = " + iNetElement.getSwVersion());
                                }
                                linkedList3.add(iNetElement);
                                break block29;
                            } else {
                                object = (NetElement)iNetElement;
                                break;
                            }
                        }
                        if (!this.potentialElems.contains(iNetElement)) {
                            if (this.db.on()) {
                                this.db.println("findTopoAgentForInactiveArea: NE not connected, adding to potential list");
                            }
                            this.potentialElems.add(iNetElement);
                        }
                    }
                    if (!linkedList.contains(iNetElement) && !linkedList2.contains(iNetElement)) {
                        linkedList2.add(iNetElement);
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("findTopoAgentForInactiveArea: NE not connected, and already known");
                    continue;
                }
                if (this.db.on()) {
                    this.db.println("findTopoAgentForInactiveArea: NE not in same area");
                }
                linkedList.add(iNetElement);
            }
            if (object == null) continue;
        }
        if (object == null) {
            if (!linkedList3.isEmpty()) {
                object = (NetElement)linkedList3.getFirst();
                if (this.db.on()) {
                    this.db.println("findTopoAgentForInactiveArea: selected NE with SW ver " + ((NetElement)object).getSwVersion());
                }
            }
            for (Object object3 : this.potentialElems) {
                object3.addObserver((Observer)this);
                if (this.db.on()) {
                    this.db.println("findTopoAgentForInactiveArea: observing NE " + ((NetElement)object3).getActualAddressDisplay());
                }
                if (!((NetElement)object3).getConnectionState()) continue;
                if (this.db.on()) {
                    this.db.println("findTopoAgentForInactiveArea: NE " + ((NetElement)object3).getActualAddressDisplay() + " is connected");
                }
                object = object3;
                object3.deleteObserver((Observer)this);
                break;
            }
        }
        if (object != null) {
            if (this.db.on()) {
                this.db.println("findTopoAgentForInactiveArea: found potential TopoAgent");
            }
            this.addPotentialTopoAgent((NetElement)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectTopoAgents() {
        TreeSet treeSet;
        if (this.db.on()) {
            this.db.println("selectTopoAgents: searching for TopoAgent(s)");
        }
        Object object = this.recentlyConnectedElems;
        synchronized (object) {
            treeSet = new TreeSet(new NetElemComparator());
            treeSet.addAll(this.recentlyConnectedElems);
            this.recentlyConnectedElems.clear();
        }
        if (this.topoAgents.isEmpty()) {
            if (treeSet.isEmpty()) {
                if (this.db.on()) {
                    this.db.println("selectTopoAgents: topo has no TA, searching");
                }
                for (NetElement netElement : this.getTopoElems()) {
                    if (netElement.getConnectionState()) {
                        if (this.db.on()) {
                            this.db.println("selectTopoAgents: found potential TopoAgent # 1");
                        }
                        this.addPotentialTopoAgent(netElement);
                        break;
                    }
                    if (this.db.on()) {
                        this.db.println("selectTopoAgents: observing disconnected NE" + netElement.getActualAddressDisplay());
                    }
                    this.potentialElems.add(netElement);
                    netElement.addObserver(this);
                }
                return;
            }
            object = "";
            NetElement netElement = null;
            for (NetElement netElement2 : treeSet) {
                if (((String)object).compareTo(netElement2.getSwVersion()) >= 0) continue;
                if (this.db.on()) {
                    this.db.println("selectTopoAgents: NE " + netElement2.getActualAddressDisplay() + " has later SW ver " + netElement2.getSwVersion());
                }
                object = netElement2.getSwVersion();
                netElement = netElement2;
            }
            if (netElement != null) {
                if (this.db.on()) {
                    this.db.println("selectTopoAgents: found potential TopoAgent # 2");
                }
                this.addPotentialTopoAgent(netElement);
            }
        } else {
            for (TopologyAgent topologyAgent : this.getTopoAgents()) {
                String string = topologyAgent.getTopoHost().getSwVersion();
                String string2 = topologyAgent.getTopoHost().getSwVersion();
                NetElement netElement = null;
                if (topologyAgent.getTopoHost().isABR()) continue;
                for (NetElement netElement3 : treeSet) {
                    if (!netElement3.getConnectionState()) {
                        if (!this.db.on()) continue;
                        this.db.println("selectTopoAgents: NE " + netElement3.getActualAddressDisplay() + " no longer connected");
                        continue;
                    }
                    if (this.db.on()) {
                        this.db.println("selectTopoAgents: checking NE " + netElement3.getActualAddressDisplay() + ", ver " + netElement3.getSwVersion());
                    }
                    if (string.compareTo(netElement3.getSwVersion()) >= 0) continue;
                    for (Long l : netElement3.getOspfAreas()) {
                        if (!topologyAgent.containsArea(l) || string2.compareTo(netElement3.getSwVersion()) >= 0) continue;
                        string2 = netElement3.getSwVersion();
                        netElement = netElement3;
                        if (!this.db.on()) continue;
                        this.db.println("selectTopoAgents: making NE " + netElement3.getActualAddressDisplay() + " latest");
                    }
                }
                if (netElement == null) continue;
                if (this.db.on()) {
                    this.db.println("selectTopoAgents: replacing TA (" + topologyAgent.getTopoHost().getActualAddressDisplay() + ", " + topologyAgent.getTopoHost().getSwVersion() + ") with TA (" + netElement.getActualAddressDisplay() + ", " + string2 + ")");
                }
                topologyAgent.setActive(false);
                if (this.db.on()) {
                    this.db.println("selectTopoAgents: found potential TopoAgent # 3");
                }
                this.addPotentialTopoAgent(netElement);
            }
        }
    }

    private void resetAllAreasAndAgents() {
        for (Object object : this.getAllOspfAreas()) {
            if (this.db.on()) {
                this.db.println("resetAllAreasAndAgents: setting area " + ((OspfArea)object).getAreaId() + " to FALSE");
            }
            ((OspfArea)object).setActive(false);
        }
        for (Object object : this.getTopoAgents()) {
            ((TopologyAgent)((Object)object)).setAllAreas(true);
            ((TopologyAgent)((Object)object)).setActive(true);
        }
    }

    private void purgeRedundantTopoAgents() {
        if (this.db.on()) {
            this.db.println("purgeRedundantTopoAgents: enabling active TAs, disabling inactive TAs");
        }
        for (TopologyAgent topologyAgent : this.getTopoAgents()) {
            if (topologyAgent.isActive()) {
                topologyAgent.enable();
                continue;
            }
            topologyAgent.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllOspfAreas() {
        LinkedList linkedList;
        Map map = this.ospfAreas;
        synchronized (map) {
            linkedList = new LinkedList(this.ospfAreas.values());
        }
        return linkedList;
    }

    private OspfArea getOspfArea(long l) {
        return (OspfArea)this.ospfAreas.get(new Long(l));
    }

    protected void setAreaActive(long l, boolean bl) {
        OspfArea ospfArea = this.getOspfArea(l);
        if (ospfArea != null) {
            ospfArea.setActive(bl);
        } else if (this.db.on()) {
            this.db.println("setAreaActive: cannot set area " + l + " to " + bl);
        }
    }

    protected void waitForOSPFConvergence() {
        block5: {
            if (this.waitForOspfConvergence) {
                try {
                    if (this.db.on()) {
                        this.db.println("waitForOSPFConvergence: sleeping for " + this.calculateTopologyConvergenceTime() + " sec.");
                    }
                    Thread.sleep(this.calculateTopologyConvergenceTime() * 1000);
                    if (this.db.on()) {
                        this.db.println("waitForOSPFConvergence: finished sleeping");
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!this.db.on()) break block5;
                    this.db.println("waitForOSPFConvergence: caught interruptedException");
                }
            }
        }
    }

    private class TopoAgentActiveAreaComparator
    implements Comparator {
        private TopoAgentActiveAreaComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof TopologyAgent && object2 instanceof TopologyAgent) {
                TopologyAgent topologyAgent = (TopologyAgent)((Object)object);
                TopologyAgent topologyAgent2 = (TopologyAgent)((Object)object2);
                return ComparisonUtil.compare((int)topologyAgent2.getNumActiveAreas(), (int)topologyAgent.getNumActiveAreas());
            }
            if (!(object instanceof TopologyAgent)) {
                throw new ClassCastException(object.getClass().getName() + " is not an instance of " + "TopologyAgent");
            }
            throw new ClassCastException(object2.getClass().getName() + " is not an instance of " + "TopologyAgent");
        }
    }

    private class TopoAgentAreaComparator
    implements Comparator {
        private TopoAgentAreaComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof TopologyAgent && object2 instanceof TopologyAgent) {
                TopologyAgent topologyAgent = (TopologyAgent)((Object)object);
                TopologyAgent topologyAgent2 = (TopologyAgent)((Object)object2);
                return ComparisonUtil.compare((int)topologyAgent2.getNumAreas(), (int)topologyAgent.getNumAreas());
            }
            if (!(object instanceof TopologyAgent)) {
                throw new ClassCastException(object.getClass().getName() + " is not an instance of " + "TopologyAgent");
            }
            throw new ClassCastException(object2.getClass().getName() + " is not an instance of " + "TopologyAgent");
        }
    }

    public class TopologyDebug
    extends SDebug {
        public TopologyDebug(String string) {
            super(string);
        }

        public TopologyDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void sendUpdate() {
            if (Topology.this.topoId != 0) {
                Topology.this.refreshTopology();
            }
        }

        public final void dump() {
            Iterator iterator = Topology.this.getTopoAgents().iterator();
            Iterator iterator2 = Topology.this.topologyNetElems.values().iterator();
            Iterator iterator3 = Topology.this.topologyLinks.values().iterator();
            Topology.this.db.println("Topology Agent(s) : count => " + Topology.this.topoAgents.size());
            while (iterator.hasNext()) {
                TopologyAgent topologyAgent = (TopologyAgent)((Object)iterator.next());
                if (!Topology.this.db.on()) continue;
                Topology.this.db.println("    " + topologyAgent.getTopoHost().getActualAddressDisplay() + ", active => " + topologyAgent.isActive());
            }
            Topology.this.db.println("Topology Network ELement(s) : count => " + Topology.this.topologyNetElems.size());
            while (iterator2.hasNext()) {
                INetElement iNetElement = (INetElement)iterator2.next();
                Topology.this.db.println(iNetElement.prettyString());
            }
            Topology.this.db.println("Topology Link(s) : count => " + Topology.this.topologyLinks.values().size());
            while (iterator3.hasNext()) {
                INetLink iNetLink = (INetLink)iterator3.next();
                Topology.this.db.println(iNetLink.prettyString());
            }
            Topology.this.db.println("latest NE SW version = " + Topology.this.latestSwVersion);
            Topology.this.db.println("clientQueued = " + Topology.this.clientQueued);
            Topology.this.db.println("updateRequired = " + Topology.this.updateRequired);
            Topology.this.db.println("transferRequired = " + Topology.this.transferRequired);
            Topology.this.db.println("transferComplete = " + Topology.this.transferComplete);
            Topology.this.db.println("stopped = " + Topology.this.stopped);
        }

        public final void dumpAreas() {
            for (OspfArea ospfArea : Topology.this.ospfAreas.values()) {
                Topology.this.db.println(ospfArea.prettyString());
            }
        }

        public final void dumpAgents() {
            for (TopologyAgent topologyAgent : Topology.this.getTopoAgents()) {
                Topology.this.db.println("+++++++++++++++++++++++++++++++++++++++++++++++");
                Topology.this.db.println(topologyAgent.prettyString());
            }
        }

        public final void dumpAreaToTopoAgentMap() {
            for (Long l : Topology.this.ospfAreaToTopoAgentMap.keySet()) {
                Topology.this.db.println("++++++++++++++++++++++++++++++++++++++++");
                Topology.this.db.println("OSPF area => " + l.intValue());
                for (TopologyAgent topologyAgent : (LinkedList)Topology.this.ospfAreaToTopoAgentMap.get(l)) {
                    if (!Topology.this.db.on()) continue;
                    Topology.this.db.println("    TopoAgent " + topologyAgent.getTopoHost().getActualAddressDisplay());
                }
            }
        }

        public final void dumpRedundantLinks() {
            Topology.this.db.println("Redundant Links:");
            for (INetLink iNetLink : Topology.this.getRedundantLinks()) {
                Topology.this.db.println(iNetLink.prettyString());
            }
        }

        public final void dumpNLObservers() {
            for (INetLink iNetLink : Topology.this.topologyLinks.values()) {
                if (!(iNetLink instanceof AbstractNetLink)) continue;
                Topology.this.db.println(iNetLink.prettyString());
                ((AbstractNetLink)iNetLink).printObservers();
            }
        }

        public final void dumpNEObservers() {
            for (NetElement netElement : Topology.this.topologyNetElems.values()) {
                Topology.this.db.println(netElement.prettyString());
                netElement.printObservers();
            }
        }

        public final void dumpPotentialElems() {
            Topology.this.db.println("Observing these potential TopoAgents:");
            for (NetElement netElement : Topology.this.potentialElems) {
                if (!Topology.this.db.on()) continue;
                Topology.this.db.println("  " + netElement.getActualAddressDisplay());
            }
        }

        public final void dumpRecentlyConnectedElems() {
            Topology.this.db.println("Recently connected NEs:");
            for (NetElement netElement : Topology.this.recentlyConnectedElems) {
                if (!Topology.this.db.on()) continue;
                Topology.this.db.println("  " + netElement.getActualAddressDisplay());
            }
        }

        public final void reset() {
            if (Topology.this.topoId != 0) {
                Topology.this.resetTopology();
            }
        }
    }
}

