/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkCapacityType;
import cerent.cms.model.ILinkType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfLSA;
import cerent.cms.model.IOspfLSTopology;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.IProtectionType;
import cerent.cms.model.LinkCapacityType;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.User;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.OspfArea;
import cerent.cms.topo.Topology;
import cerent.util.EnumStrings;
import cerent.util.IIPAddressTranslator;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TopologyAgent
extends CmsObservable
implements IObserver {
    private int nodeId = 0;
    private boolean isActive = false;
    private NetElement topologyHost = null;
    private IOspfTopologyModel topoModel = null;
    private Map areas = null;
    private int activeAreaCount = 0;
    private Map topoAgentLinks;
    private Map topoAgentElems;
    private boolean connected = false;
    private TopologyAgentDebug dbTA = null;
    private boolean isMoaSupported = false;
    private boolean isOSPFTLVSupported = false;
    private boolean isABR = false;
    private boolean enabled = false;
    private boolean stopped = false;
    private boolean destroyed = false;
    private Topology topo = null;
    private Set reachableNetElems = null;
    private Collection unreachableNetElems = null;
    private static final IIPAddressTranslator trans = IPAddressTranslator.instance();

    protected TopologyAgent(NetElement netElement, Topology topology, SDebug sDebug) {
        this.dbTA = new TopologyAgentDebug(sDebug, "TopoAgent" + NetElement.getDebugName(netElement.getHostName()));
        if (sDebug.on()) {
            this.dbTA.set(true);
        }
        if (this.dbTA.on()) {
            this.dbTA.println("TopologyAgent: creating new TopoAgent");
        }
        this.topologyHost = netElement;
        this.topo = topology;
        netElement.setTopoHost(true);
        this.activeAreaCount = 0;
        netElement.addObserver(this);
        this.areas = Collections.synchronizedMap(new TreeMap());
        this.topoAgentLinks = Collections.synchronizedMap(new TreeMap(new NetLinkComparator()));
        this.topoAgentElems = Collections.synchronizedMap(new TreeMap());
        this.reachableNetElems = Collections.synchronizedSet(new HashSet());
        this.unreachableNetElems = Collections.synchronizedCollection(new HashSet());
        this.setConnectionState(netElement.getConnectionState() && netElement.isInited());
        this.setABRState(netElement.isABR());
        this.topoAgentElems.put(new Integer(netElement.getNodeId()), netElement);
        this.acquireTopoModel();
    }

    protected void refresh() {
        this.doMoaDiscovery();
    }

    public String prettyString() {
        String string = "IsActive: ";
        string = this.isActive ? string + "true " : string + "false ";
        string = string + "TopoHost: " + this.topologyHost.prettyString();
        string = string + "\nAreas:\n";
        for (OspfArea ospfArea : this.areas.values()) {
            string = string + "\t" + ospfArea.prettyString() + "\n";
        }
        return string;
    }

    public boolean getIsMoaSupported() {
        return this.isMoaSupported;
    }

    public boolean getIsOSPFTLVSupported() {
        return this.isOSPFTLVSupported;
    }

    public boolean getIs6CharBlsrRingNameSupported() {
        INodeModel iNodeModel = this.topologyHost.getNodeModel();
        return iNodeModel.provides(Feature.BLSR_PATRIOT_EXTENSIONS);
    }

    private void setIsMoaSupported() {
        this.isMoaSupported = this.topologyHost.getNodeModel().provides(Feature.MULTI_OSPF_AREAS);
        if (this.dbTA.on()) {
            this.dbTA.println("setIsMoaSupported: isMoaSupported => " + this.isMoaSupported);
        }
    }

    private void setIsOSPFTLVSupported() {
        this.isOSPFTLVSupported = this.topologyHost.getNodeModel().provides(Feature.OSPF_TLV);
        if (this.dbTA.on()) {
            this.dbTA.println("setIsOSPFTLVSupported: isOSPFTLVSupported => " + this.isOSPFTLVSupported);
        }
    }

    private void setIs6CharBlsrNameSupported() {
    }

    public boolean getIsVirtualLinkSupported() {
        INodeModel iNodeModel = this.topologyHost.getNodeModel();
        return iNodeModel.provides(Feature.VLINK_PROVISIONING);
    }

    private void setVirtualLinkSupported() {
    }

    public boolean getIsSideSupported() {
        INodeModel iNodeModel = this.topologyHost.getNodeModel();
        return iNodeModel.provides(Feature.OPTICAL_SIDE);
    }

    private void setSideSupported() {
    }

    private void setConnectionState(boolean bl) {
        if (this.connected == bl) {
            return;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("setConnectionState: old => " + this.connected + ", new => " + bl);
        }
        this.connected = bl;
        if (bl) {
            this.setActive(true);
            this.setIsMoaSupported();
            this.setIsOSPFTLVSupported();
            this.discoverAreas();
        } else {
            this.setAllAreas(false);
            this.setActive(false);
        }
        this.setChanged();
    }

    private void setABRState(boolean bl) {
        if (this.isABR == bl) {
            return;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("setABRState: old => " + this.isABR + ", new => " + bl);
        }
        this.isABR = bl;
        this.setChanged();
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NetElement) {
            NetElement netElement = (NetElement)iObservable;
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.dbTA.on()) {
                    this.dbTA.println("update: received CHANGED event for " + netElement.getActualAddressDisplay());
                }
                this.setConnectionState(netElement.getConnectionState() && netElement.isInited());
                this.setABRState(netElement.isABR());
                this.acquireTopoModel();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.dbTA.on()) {
                    this.dbTA.println("update: received DELETE event for " + netElement.getActualAddressDisplay());
                }
                this.setConnectionState(false);
                this.destroy(true);
            }
        } else if (iObservable instanceof IOspfTopologyModel) {
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.dbTA.on) {
                    this.dbTA.println("update: received a CHANGED event from the topo model from " + this.topologyHost.getActualAddressDisplay());
                }
                this.topo.queueOSPFUpdateEvent(this);
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.dbTA.on) {
                    this.dbTA.println("update: received a DELETE event from the topo model from " + this.topologyHost.getActualAddressDisplay());
                }
                this.releaseTopoModel();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setActive(boolean bl) {
        block6: {
            if (this.isActive == bl) {
                return;
            }
            if (bl) {
                if (this.connected) {
                    this.isActive = bl;
                    break block6;
                } else {
                    if (this.dbTA.on()) {
                        this.dbTA.println("setActive: not connected, cannot set to active");
                    }
                    return;
                }
            }
            this.isActive = bl;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("setActive: state changed, active => " + this.isActive);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected synchronized void setAreaIsActive(long l, boolean bl) {
        OspfArea ospfArea = (OspfArea)this.areas.get(new Long(l));
        if (ospfArea != null) {
            ospfArea.setActive(bl);
        }
    }

    public boolean getAreaIsActive(long l) {
        boolean bl = false;
        LinkedList linkedList = (LinkedList)this.getAreas();
        for (OspfArea ospfArea : linkedList) {
            if (ospfArea.getAreaId() != l) continue;
            bl = ospfArea.isActive();
            break;
        }
        return bl;
    }

    public boolean containsArea(OspfArea ospfArea) {
        return this.areas.containsKey(new Long(ospfArea.getAreaId()));
    }

    public boolean containsArea(long l) {
        return this.areas.containsKey(new Long(l));
    }

    protected void setAllAreas(boolean bl) {
        if (bl && !this.connected) {
            if (this.dbTA.on()) {
                this.dbTA.println("setAllAreas: not connected, cannot set areas active");
            }
            return;
        }
        for (OspfArea ospfArea : this.areas.values()) {
            if (this.dbTA.on()) {
                this.dbTA.println("setAllAreas: setting area " + ospfArea.getAreaId() + " to " + (bl ? "active" : "inactive"));
            }
            ospfArea.setActive(bl);
        }
    }

    protected NetElement getTopoHost() {
        return this.topologyHost;
    }

    public int getElementCount() {
        return this.topoAgentElems.size();
    }

    public int getLinkCount() {
        return this.topoAgentLinks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getElements() {
        LinkedList linkedList;
        Map map = this.topoAgentElems;
        synchronized (map) {
            linkedList = new LinkedList(this.topoAgentElems.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getTopoAgentElems() {
        if (this.dbTA.on()) {
            this.dbTA.println("getTopoAgentElems: topoAgentElems original size => " + this.topoAgentElems.size());
        }
        Map map = Collections.synchronizedMap(new TreeMap());
        Map map2 = this.topoAgentElems;
        synchronized (map2) {
            map.putAll(this.topoAgentElems);
        }
        if (this.dbTA.on()) {
            this.dbTA.println("getTopoAgentElems: topoAgentElems copy size => " + map.size());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLinks() {
        LinkedList linkedList;
        Map map = this.topoAgentLinks;
        synchronized (map) {
            linkedList = new LinkedList(this.topoAgentLinks.values());
        }
        return linkedList;
    }

    public boolean linkExist(INetLink iNetLink) {
        return this.topoAgentLinks.containsKey(iNetLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getTopoAgentLinks() {
        if (this.dbTA.on()) {
            this.dbTA.println("getTopoAgentLinks: topoAgentLinks original size => " + this.topoAgentLinks.size());
        }
        Map map = Collections.synchronizedMap(new TreeMap(new NetLinkComparator()));
        Map map2 = this.topoAgentLinks;
        synchronized (map2) {
            map.putAll(this.topoAgentLinks);
        }
        if (this.dbTA.on()) {
            this.dbTA.println("getTopoAgentLinks: topoAgentLinks copy size => " + map.size());
        }
        return map;
    }

    public Collection getElementsForArea(long l) {
        LinkedList<NetElement> linkedList = new LinkedList<NetElement>();
        for (NetElement netElement : this.getElements()) {
            if (!netElement.containsOspfArea(l)) continue;
            linkedList.add(netElement);
        }
        return linkedList;
    }

    public Collection getLinksForArea(long l) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        for (INetLink iNetLink : this.getLinks()) {
            if (iNetLink.getOspfAreaId() != l) continue;
            linkedList.add(iNetLink);
        }
        return linkedList;
    }

    protected INetElement findNetElem(int n) {
        return (INetElement)this.topoAgentElems.get(new Integer(n));
    }

    public boolean equals(Object object) {
        if (object instanceof TopologyAgent) {
            TopologyAgent topologyAgent = (TopologyAgent)((Object)object);
            return topologyAgent.getTopoHost().getNodeId() == this.getTopoHost().getNodeId();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    private void getNewTopo() {
        IOspfLSTopology iOspfLSTopology = null;
        if (!this.isActive) {
            if (this.dbTA.on()) {
                this.dbTA.println("getNewTopo: TopoAgent inactive, returning");
            }
            return;
        }
        this.reachableNetElems.clear();
        this.reachableNetElems.add(this.topologyHost);
        for (OspfArea ospfArea : this.getActiveAreas()) {
            IOspfLSA[] iOspfLSAArray;
            try {
                iOspfLSAArray = this.topologyHost.getOspfTopologyModel();
                if (iOspfLSAArray == null) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("getNewTopo: topoModel is null, returning");
                    }
                    return;
                }
                iOspfLSTopology = this.getIsMoaSupported() ? iOspfLSAArray.areaTopology((int)ospfArea.getAreaId()) : iOspfLSAArray.getTopology();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.dbTA.on()) continue;
                this.dbTA.println("getNewTopo: caught exception => " + abstractCmsIOException.getMessage());
                TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
                continue;
            }
            iOspfLSAArray = iOspfLSTopology.getLsaList();
            int n = iOspfLSAArray.length;
            if (this.dbTA.on()) {
                this.dbTA.println("getNewTopo: getting Topology from topo host " + this.topologyHost.getActualAddressDisplay());
                this.dbTA.println("getNewTopo: getting Topology for area => " + ospfArea.getAreaId());
                this.dbTA.println("getNewTopo: LSA count = " + n);
            }
            long l = ospfArea.getAreaId();
            this.startLinkUpdate(l);
            if (n <= 1) {
                this.finishLinkUpdate(l);
                if (this.getIsVirtualLinkSupported()) {
                    this.getOspfVLs();
                }
                return;
            }
            this.updateChangedNodeIds(iOspfLSTopology);
            Network network = Network.instance();
            for (int i = 0; i < n; ++i) {
                IOspfLSA iOspfLSA = iOspfLSAArray[i];
                IOspfAdv[] iOspfAdvArray = iOspfLSA.getAdvList();
                if (this.dbTA.on()) {
                    this.dbTA.println("getNewTopo: Adv count = " + iOspfAdvArray.length);
                }
                if (!network.isMember(iOspfLSA, null, l, this)) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("skipping by request LSA: " + iOspfLSA);
                    }
                    if (!this.stopped) continue;
                    network.lastMember(l, this);
                    return;
                }
                int n2 = iOspfAdvArray.length;
                for (int j = 0; j < n2; ++j) {
                    block28: {
                        if (this.dbTA.on) {
                            this.dbTA.println("=====================================");
                            this.dbTA.println("getNewTopo: Node IP: " + trans.getActualAddressDisplay(Topology.IpAddrString(iOspfLSA.getNodeIp())) + ", Node ID: " + Integer.toHexString(iOspfLSA.getNodeId()));
                        }
                        IOspfAdv iOspfAdv = iOspfAdvArray[j];
                        if (this.dbTA.on) {
                            this.dumpAdv(l, iOspfAdv);
                        }
                        if (!network.isMember(iOspfLSA, iOspfAdv, l, this)) {
                            if (this.dbTA.on()) {
                                this.dbTA.println("skipping by request ADV: " + iOspfAdv);
                            }
                            if (!this.stopped) continue;
                            network.lastMember(l, this);
                            return;
                        }
                        try {
                            this.updateLink(iOspfLSA.getNodeId(), iOspfLSA.getNodeIp(), iOspfAdv, ospfArea.getAreaId());
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            if (!this.dbTA.on()) break block28;
                            this.dbTA.println("getNewTopo: Caught exception " + abstractCmsIOException.getMessage());
                            TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                    }
                    if (!this.stopped) continue;
                    network.lastMember(l, this);
                    return;
                }
                NetElement netElement = (NetElement)this.topo.findNetElem(iOspfLSA.getNodeId());
                if (netElement != null) {
                    if (netElement.isABR()) {
                        if (this.dbTA.on()) {
                            this.dbTA.println("getNewTopo: Node " + netElement.getActualAddressDisplay() + " is an ABR");
                        }
                        if (!this.stopped) {
                            this.topo.discoveredABR(netElement);
                        }
                    } else if (this.dbTA.on()) {
                        this.dbTA.println("getNewTopo: Node " + netElement.getActualAddressDisplay() + " is not an ABR");
                    }
                }
                if (this.isActive && !this.destroyed) continue;
                network.lastMember(l, this);
                return;
            }
            if (n > 0) {
                network.lastMember(l, this);
            }
            this.finishLinkUpdate(ospfArea.getAreaId());
        }
        this.findUnreachableNetElems();
        this.topo.removeRedundantLinks();
    }

    private void updateChangedNodeIds(IOspfLSTopology iOspfLSTopology) {
        Network network = Network.instance();
        int n = iOspfLSTopology.getLsaList().length;
        ArrayList<INetElement> arrayList = new ArrayList<INetElement>();
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress;
            IOspfLSA iOspfLSA;
            block7: {
                arrayList.clear();
                iOspfLSA = iOspfLSTopology.getLsaList()[i];
                if (network.findNetElem(iOspfLSA.getNodeId()) != null) continue;
                for (int j = 0; j < iOspfLSA.getAdvList().length; ++j) {
                    IOspfAdv iOspfAdv = iOspfLSA.getAdvList()[j];
                    INetElement iNetElement = network.findNetElem(iOspfAdv.getNodeId());
                    if (iNetElement == null) continue;
                    arrayList.add(iNetElement);
                }
                if (arrayList.size() <= 0) continue;
                inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(Topology.IpAddrString(iOspfLSA.getNodeIp()));
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.dbTA.on()) break block7;
                    this.dbTA.println("updateChangedNodeIds: Caught InetAddress::getByName exception " + unknownHostException.getMessage());
                    TopologyAgentDebug.printStackTrace((Throwable)unknownHostException);
                }
            }
            INetElement iNetElement = network.findNetElem(inetAddress, arrayList);
            if (iNetElement == null) continue;
            try {
                if (this.dbTA.on()) {
                    this.dbTA.println("updateChangedNodeIds: updating " + iNetElement.getActualAddressDisplay() + " with nodeId " + Integer.toHexString(iOspfLSA.getNodeId()));
                }
                IPAddressTranslator.instance().updateNodeId(iNetElement.getHostName(), iOspfLSA.getNodeId());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                if (!this.dbTA.on()) continue;
                this.dbTA.println("updateChangedNodeIds: Caught IPAddressTranslator::updateNodeId exception " + unknownHostException.getMessage());
                TopologyAgentDebug.printStackTrace((Throwable)unknownHostException);
            }
        }
    }

    private void getOspfVLs() {
        IOspfTopologyModel iOspfTopologyModel = null;
        if (this.dbTA.on()) {
            this.dbTA.println("getOspfVLs:");
        }
        if ((iOspfTopologyModel = this.topologyHost.getOspfTopologyModel()) == null) {
            if (this.dbTA.on()) {
                this.dbTA.println("getOspfVLs: topoModel is null");
            }
            return;
        }
        IOspfLSA iOspfLSA = iOspfTopologyModel.getOspfVlinks();
        this.startLinkUpdate(0L);
        if (this.dbTA.on()) {
            this.dbTA.println("getOspfVLs: Adv count = " + iOspfLSA.getAdvList().length);
        }
        for (int i = 0; i < iOspfLSA.getAdvList().length; ++i) {
            if (this.dbTA.on) {
                this.dbTA.println("=====================================");
                this.dbTA.println("getOspfVLs: Node IP: " + Topology.IpAddrString(iOspfLSA.getNodeIp()) + ", Node ID: " + Integer.toHexString(iOspfLSA.getNodeId()));
            }
            IOspfAdv iOspfAdv = iOspfLSA.getAdvList()[i];
            if (this.dbTA.on) {
                this.dumpAdv(0L, iOspfAdv);
            }
            try {
                this.updateLink(iOspfLSA.getNodeId(), iOspfLSA.getNodeIp(), iOspfAdv, 0L);
                continue;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.dbTA.println("getOspfVLs: Caught exception " + abstractCmsIOException.getMessage());
                TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        this.finishLinkUpdate(0L);
        this.topo.removeRedundantLinks();
    }

    private void dumpAdv(long l, IOspfAdv iOspfAdv) {
        this.dbTA.println("dumpAdv:    linktype: " + EnumStrings.getString(ILinkType.class, (int)iOspfAdv.getLinkType()));
        if (this.getIsOSPFTLVSupported()) {
            this.dbTA.println("dumpAdv:    linkCapacity: " + EnumStrings.getString(ILinkCapacityType.class, (int)iOspfAdv.getLinkCapacity()));
            this.dbTA.println("dumpAdv:    my xcCapable: " + iOspfAdv.isXcCapable());
            this.dbTA.println("dumpAdv:    nbr xcCapable: " + iOspfAdv.isNbrXcCapable());
        }
        this.dbTA.println("dumpAdv:    nbr nodeId: " + Integer.toHexString(iOspfAdv.getNodeId()));
        this.dbTA.println("dumpAdv:    nbr nodeIp: " + trans.getActualAddressDisplay(Topology.IpAddrString(iOspfAdv.getNodeIp())));
        if (this.getIsMoaSupported()) {
            this.dbTA.println("dumpAdv:    OSPF area: " + Topology.IpAddrString(iOspfAdv.getAreaId()));
        } else {
            this.dbTA.println("dumpAdv:    OSPF area: " + l);
        }
        if (iOspfAdv.getLinkType() == 6) {
            this.dbTA.println("dumpAdv:    my linkId: " + iOspfAdv.getIfIx());
            this.dbTA.println("dumpAdv:    nbr linkId: " + iOspfAdv.getNeighborIfIx());
        } else {
            this.dbTA.println("dumpAdv:    my ifIx   : " + iOspfAdv.getIfIx());
            this.dbTA.println("dumpAdv:    nbr ifIx  : " + iOspfAdv.getNeighborIfIx());
        }
        this.dbTA.println("dumpAdv:    my entIx  : " + Integer.toHexString(iOspfAdv.getEntIx()));
        this.dbTA.println("dumpAdv:    nbr entIx : " + Integer.toHexString(iOspfAdv.getNbrEntIx()));
        this.dbTA.println("dumpAdv:    protType  : " + EnumStrings.getString(IProtectionType.class, (int)iOspfAdv.getProtType()));
        if (iOspfAdv.getProtType() == 0 || iOspfAdv.getProtType() == 4) {
            this.dbTA.println("dumpAdv:    blsr nodeId: " + iOspfAdv.getBlsrNodeId());
            if (this.getIs6CharBlsrRingNameSupported()) {
                this.dbTA.println("dumpAdv:    blsr ringName: " + iOspfAdv.getBlsrRingName());
            } else {
                try {
                    this.dbTA.println("dumpAdv:    blsr ringName: " + Short.toString(iOspfAdv.getBlsrRingId()));
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.dbTA.println("dumpAdv: caught exception => ");
                    TopologyAgentDebug.printStackTrace((Throwable)unsupportedOperation);
                }
            }
        }
        this.dbTA.println("dumpAdv:    cost      : " + iOspfAdv.getCost());
        if (iOspfAdv.getLinkType() == 6) {
            this.dbTA.println("dumpAdv:    linkDirection      : " + iOspfAdv.getLinkDir());
        }
        if (iOspfAdv.getLinkType() == 4) {
            this.dbTA.println("dumpAdv:    optlinkDir : " + (iOspfAdv.isOptLinkEast() ? "E-W" : "W-E"));
        }
    }

    private void doMoaDiscovery() {
        if (this.dbTA.on()) {
            this.dbTA.println("doMoaDiscovery: starting MOA discovery");
        }
        this.discoverAreas();
        this.getNewTopo();
        if (this.dbTA.on()) {
            this.dbTA.println("doMoaDiscovery: area size: " + this.getAreas().size());
        }
        if (this.getAreas().isEmpty() && this.getIsVirtualLinkSupported()) {
            this.getOspfVLs();
        }
        if (this.dbTA.on()) {
            this.dbTA.println("doMoaDiscovery: MOA discovery completed");
        }
    }

    protected void discoverAreas() {
        if (!this.isConnected()) {
            if (this.dbTA.on()) {
                this.dbTA.println("discoverAreas: not connected, returning");
            }
            return;
        }
        boolean bl = false;
        LinkedList<Long> linkedList = new LinkedList<Long>();
        if (this.getIsMoaSupported()) {
            int[] nArray;
            try {
                IOspfTopologyModel iOspfTopologyModel = this.topologyHost.getOspfTopologyModel();
                if (iOspfTopologyModel == null) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("discoverAreas: topoModel is null, returning");
                    }
                    return;
                }
                nArray = iOspfTopologyModel.getOspfAreas().getOspfAreaList();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbTA.on()) {
                    this.dbTA.println("discoverAreas: caught exception => " + abstractCmsIOException.getMessage());
                    TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                nArray = new int[]{};
            }
            if (this.dbTA.on()) {
                this.dbTA.println("discoverAreas: length => " + nArray.length);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (this.addArea(nArray[i])) {
                    bl = true;
                }
                linkedList.add(new Long(nArray[i]));
            }
        } else {
            long l;
            if (this.dbTA.on()) {
                this.dbTA.println("discoverAreas: using old method");
            }
            try {
                l = Topology.ipAddrToLong(this.topologyHost.getNodeModel().getOspfLanConfigModel().getDccOspfAreaId());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbTA.on()) {
                    this.dbTA.println("discoverAreas: caught exception => " + abstractCmsIOException.getMessage());
                    TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                l = 0L;
            }
            catch (AbstractMethodError abstractMethodError) {
                l = 0L;
            }
            if (this.addArea(l)) {
                bl = true;
            }
            linkedList.add(new Long(l));
        }
        this.activeAreaCount = this.getNumActiveAreas();
        if (this.areas.size() != linkedList.size()) {
            if (this.dbTA.on()) {
                this.dbTA.println("discoverAreas: # of areas changed, old = " + this.areas.size() + ", new = " + linkedList.size());
            }
            for (OspfArea ospfArea : this.getAreas()) {
                if (linkedList.contains(new Long(ospfArea.getAreaId()))) continue;
                if (this.dbTA.on()) {
                    this.dbTA.println("discoverAreas: area " + ospfArea.getAreaId() + " no longer part of TA");
                }
                this.clearLinks(ospfArea, true);
                this.deleteArea(ospfArea.getAreaId());
                this.topo.deleteOspfArea(this, ospfArea);
            }
        }
        if (bl) {
            this.topo.addOspfAreas(this);
        }
    }

    private boolean addArea(long l) {
        OspfArea ospfArea = new OspfArea(this.dbTA, l, true);
        if (!this.areas.containsKey(new Long(l))) {
            if (this.dbTA.on()) {
                this.dbTA.println("addArea: adding area " + ospfArea.prettyString());
            }
            this.areas.put(new Long(ospfArea.getAreaId()), ospfArea);
            return true;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("addArea: area " + l + " already known");
        }
        return false;
    }

    protected void deleteArea(long l) {
        this.areas.remove(new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAreaIds() {
        LinkedList linkedList = null;
        Map map = this.areas;
        synchronized (map) {
            linkedList = new LinkedList(this.areas.keySet());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAreas() {
        LinkedList linkedList = null;
        Map map = this.areas;
        synchronized (map) {
            linkedList = new LinkedList(this.areas.values());
        }
        return linkedList;
    }

    public List getActiveAreas() {
        LinkedList<OspfArea> linkedList = new LinkedList<OspfArea>();
        for (OspfArea ospfArea : this.getAreas()) {
            if (!ospfArea.isActive()) continue;
            linkedList.add(ospfArea);
        }
        return linkedList;
    }

    public int getNumActiveAreas() {
        return this.getActiveAreas().size();
    }

    public int getNumAreas() {
        return this.areas.size();
    }

    protected String getAreasAsString() {
        String string = "\n";
        for (OspfArea ospfArea : this.getAreas()) {
            string = string + "  Area " + ospfArea.getAreaId() + " => " + ospfArea.isActive() + "\n";
        }
        return string;
    }

    protected Collection getReachableNetElems() {
        return this.reachableNetElems;
    }

    protected boolean isReachable(INetElement iNetElement) {
        return this.reachableNetElems.contains(iNetElement);
    }

    protected boolean isRedundant() {
        boolean bl = false;
        for (OspfArea ospfArea : this.areas.values()) {
            if (!ospfArea.isActive()) continue;
            bl = true;
            break;
        }
        if (bl) {
            return false;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("isRedundant: TopoAgent contains no active areas");
        }
        return true;
    }

    protected void enable() {
        if (!this.isActive()) {
            if (this.dbTA.on()) {
                this.dbTA.println("enable: TA inactive, cannot enable");
            }
            return;
        }
        if (this.enabled) {
            if (this.dbTA.on()) {
                this.dbTA.println("enable: TopoAgent already enabled");
            }
            if (this.activeAreaCount != this.getNumActiveAreas()) {
                if (this.dbTA.on()) {
                    this.dbTA.println("enable: Active area count changed, old = " + this.activeAreaCount + ", new = " + this.getNumActiveAreas());
                }
                this.activeAreaCount = this.getNumActiveAreas();
                this.topo.queueOSPFUpdateEvent(this);
            }
        } else {
            if (this.dbTA.on()) {
                this.dbTA.println("enable: enabling TopoAgent");
            }
            this.enabled = true;
            this.topologyHost.setTopoHost(true);
            this.activeAreaCount = this.getNumActiveAreas();
            this.topo.waitForOSPFConvergence();
            this.topo.queueOSPFUpdateEvent(this);
        }
    }

    protected void disable() {
        if (this.dbTA.on()) {
            this.dbTA.println("disable: disabling TopoAgent");
        }
        if (this.topologyHost.isABR()) {
            if (this.topologyHost != null) {
                this.topologyHost.setTopoHost(false);
            }
            if (this.enabled) {
                this.clearLinks(true);
            }
        } else {
            this.destroy(true);
        }
        this.enabled = false;
    }

    protected void stop() {
        if (this.dbTA.on()) {
            this.dbTA.println("stop: stopping TopoAgent");
        }
        this.stopped = true;
    }

    public void destroy(boolean bl) {
        if (this.destroyed) {
            return;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("destroy: starting destroy procedure");
        }
        this.setActive(false);
        this.stop();
        this.clearLinks(bl);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        this.deleteTopoHost();
        this.areas.clear();
        this.topoAgentElems.clear();
        this.topoAgentLinks.clear();
        this.dbTA.dispose();
        this.destroyed = true;
    }

    private void clearLinks(boolean bl) {
        if (this.getAreas().isEmpty() && this.isOSPFTLVSupported) {
            if (this.dbTA.on()) {
                this.dbTA.println("clearLinks: no Areas - VL count: " + this.getLinkCount());
            }
            for (Object object : this.getLinks()) {
                if (bl && this.topo.inNumberOfTopoAgent((INetLink)object) == 1) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("clearLinks: NL " + ((AbstractNetLink)object).prettyString() + " marked down");
                    }
                    ((AbstractNetLink)object).newState(2);
                    this.topo.delete((INetLink)object);
                }
                this.delete((INetLink)object);
            }
        }
        for (Object object : this.getAreas()) {
            this.clearLinks((OspfArea)object, bl);
        }
    }

    private void clearLinks(OspfArea ospfArea, boolean bl) {
        if (this.dbTA.on()) {
            this.dbTA.println("clearLinks: for area " + ospfArea.getAreaId());
        }
        for (AbstractNetLink abstractNetLink : this.getLinksForArea(ospfArea.getAreaId())) {
            if (bl) {
                if (this.topo.inNumberOfTopoAgent(abstractNetLink) == 1) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("clearLinks: NL " + abstractNetLink.prettyString() + " marked down");
                    }
                    abstractNetLink.newState(2);
                    this.topo.delete(abstractNetLink);
                }
            } else if (abstractNetLink.isPca() && this.topo.inNumberOfTopoAgent(abstractNetLink) == 1) {
                if (this.dbTA.on()) {
                    this.dbTA.println("clearLinks: NL " + abstractNetLink.prettyString() + " marked down");
                }
                abstractNetLink.newState(2);
                this.topo.delete(abstractNetLink);
            }
            this.delete(abstractNetLink);
        }
    }

    private void replaceTopoHost() {
        if (this.dbTA.on()) {
            this.dbTA.println("replaceTopoHost: replacing topo host");
        }
        this.connected = false;
        this.setAllAreas(false);
        this.setActive(false);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void deleteTopoHost() {
        if (this.dbTA.on()) {
            this.dbTA.println("deleteTopoHost: deleting topologyHost");
        }
        this.releaseTopoModel();
        if (this.topologyHost != null) {
            this.topologyHost.deleteObserver(this);
            if (this.topologyHost.getTopoId() == this.topo.getTopoId()) {
                if (this.dbTA.on()) {
                    this.dbTA.println("deleteTopoHost: deleting topo host " + this.topologyHost.getActualAddressDisplay());
                }
                this.topologyHost.setTopoHost(false);
            }
        }
    }

    private void acquireTopoModel() {
        if (this.topoModel == null && this.topologyHost != null) {
            this.topoModel = this.topologyHost.getOspfTopologyModel();
            if (this.topoModel != null) {
                this.topoModel.addObserver((IObserver)this);
                if (this.dbTA.on()) {
                    this.dbTA.println("acquireTopoModel: acquired topoModel");
                }
            }
        }
    }

    private void releaseTopoModel() {
        if (this.topoModel != null) {
            if (this.dbTA.on()) {
                this.dbTA.println("releaseTopoModel: topoModel released");
            }
            this.topoModel.deleteObserver((IObserver)this);
            this.topoModel = null;
        }
    }

    private void updateLink(int n, IIpAddr iIpAddr, IOspfAdv iOspfAdv, long l) {
        LinkModel linkModel;
        INetLink iNetLink;
        Object object;
        int n2;
        boolean bl;
        boolean bl2;
        NetElement netElement;
        NetElement netElement2;
        block55: {
            InetAddress inetAddress;
            InetAddress inetAddress2;
            netElement2 = null;
            netElement = null;
            String string = Topology.IpAddrString(iIpAddr);
            boolean bl3 = bl2 = iOspfAdv.getLinkType() == 6;
            if (bl2) {
                try {
                    inetAddress2 = InetAddress.getByName(string);
                    inetAddress = IPAddressTranslator.instance().findVirtualAddress(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                    this.dbTA.println("updateLink: caught UnknownHostException " + unknownHostException.getMessage());
                    return;
                }
                if (inetAddress == null) {
                    if (this.dbTA.on()) {
                        this.dbTA.println("updateLink: ERROR virtual link src " + trans.getActualAddressDisplay(string) + "(" + Integer.toHexString(n) + ")" + " is unknown");
                    }
                    return;
                }
                if (n == 0) {
                    n = IPAddressTranslator.instance().getActualNodeId(inetAddress);
                }
            }
            if (this.dbTA.on()) {
                this.dbTA.println("updateLink: processing src " + trans.getActualAddressDisplay(string) + "(" + Integer.toHexString(n) + ")" + " isVirtualLink " + bl2);
            }
            netElement2 = this.topo.addNetElement(n, iIpAddr);
            if (this.stopped) {
                return;
            }
            if (bl2) {
                Network network = Network.instance();
                netElement = (NetElement)network.getNetElem(iOspfAdv.getNodeId());
                if (netElement == null) {
                    String string2;
                    String string3;
                    User user = NetworkModel.instance().getUser();
                    try {
                        inetAddress2 = InetAddress.getByName(Topology.IpAddrString(iOspfAdv.getNodeIp()));
                        inetAddress = IPAddressTranslator.instance().findVirtualAddress(inetAddress2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.dbTA.println("updateLink: caught UnknownHostException " + unknownHostException.getMessage());
                        return;
                    }
                    if (inetAddress == null) {
                        string3 = Topology.IpAddrString(iOspfAdv.getNodeIp());
                        string2 = "00000000";
                    } else {
                        string3 = inetAddress2.getHostAddress();
                        string2 = Integer.toHexString(IPAddressTranslator.instance().getActualNodeId(inetAddress));
                    }
                    if (this.dbTA.on()) {
                        this.dbTA.println("updateLink: processing dst " + trans.getActualAddressDisplay(string3) + "(" + string2 + ")");
                    }
                    if (!network.filterNode(string3)) {
                        block54: {
                            try {
                                netElement = (NetElement)network.addNetElement(string3, user.getName(), user.getPassword());
                            }
                            catch (Exception exception) {
                                if (!this.dbTA.on()) break block54;
                                this.dbTA.println("addNetElement to network encountered exception");
                                TopologyAgentDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        Network.instance().createTopology(netElement);
                    }
                }
            } else {
                netElement = this.topo.addNetElement(iOspfAdv.getNodeId(), iOspfAdv.getNodeIp());
            }
            if (this.stopped) {
                return;
            }
            if (netElement2 == null || netElement == null) {
                if (this.dbTA.on()) {
                    this.dbTA.println("updateLink: src or dst NE is null, cannot create NL");
                }
                return;
            }
            if (iOspfAdv.getEntIx() == 0 || iOspfAdv.getNbrEntIx() == 0) {
                if (this.dbTA.on()) {
                    this.dbTA.println("updateLink: ignoring LSA because of invalid (0) entity index");
                }
                if (!bl2) {
                    this.putNetElement(netElement2);
                    this.putNetElement(netElement);
                    return;
                }
            }
            bl = iOspfAdv.getProtType() != 5 && iOspfAdv.getProtType() != 6 && !bl2;
            n2 = 0;
            try {
                n2 = iOspfAdv.getRevertMode();
            }
            catch (AbstractMethodError abstractMethodError) {
                if (!this.dbTA.on()) break block55;
                this.dbTA.println("getRevertMode() not supported");
            }
        }
        boolean bl4 = true;
        boolean bl5 = true;
        int n3 = iOspfAdv.getLinkType();
        int n4 = 0;
        if (this.getIsOSPFTLVSupported()) {
            bl4 = iOspfAdv.isXcCapable();
            bl5 = iOspfAdv.isNbrXcCapable();
            n3 = LinkCapacityType.getLinkPhysicalType((int)iOspfAdv.getLinkCapacity());
            n4 = iOspfAdv.getLinkType();
        } else {
            block56: {
                object = null;
                if (netElement2.getConnectionState()) {
                    object = netElement2.getNodeModel();
                } else if (netElement.getConnectionState()) {
                    object = netElement.getNodeModel();
                }
                if (object != null) {
                    try {
                        if (object.getTdmProtocolTypeObj().isSonet()) {
                            n4 = 1;
                            break block56;
                        }
                        n4 = 2;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.dbTA.on()) {
                            this.dbTA.println("updateLink: exception, setting link type to UNKNOWN");
                            TopologyAgentDebug.printStackTrace((Throwable)abstractCmsIOException);
                        }
                        break block56;
                    }
                }
                if (this.dbTA.on()) {
                    this.dbTA.println("updateLink: NM is null, UNKNOWN link type");
                }
            }
            n3 = iOspfAdv.getLinkType();
        }
        object = "";
        if (this.getIs6CharBlsrRingNameSupported()) {
            object = iOspfAdv.getBlsrRingName();
        } else {
            try {
                object = Short.toString(iOspfAdv.getBlsrRingId());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.dbTA.println("updateLink: caught  exception => ");
                TopologyAgentDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        if (bl2) {
            n5 = iOspfAdv.getIfIx();
            n6 = iOspfAdv.getNeighborIfIx();
            n7 = iOspfAdv.getLinkDir();
        }
        int n8 = iOspfAdv.getCost();
        if (bl2) {
            n8 = 1024;
        }
        if ((iNetLink = this.topo.addNetLink(netElement2, netElement, linkModel = new LinkModel(netElement2.getNodeModel(), iOspfAdv.getEntIx(), null, netElement.getNodeModel(), iOspfAdv.getNbrEntIx(), null, bl2 ? 6 : 1, n3, n4, bl4, bl5, n5, n6, iOspfAdv.getProtType(), (String)object, iOspfAdv.getBlsrNodeId(), 0, iOspfAdv.getProtRole(), n8, n2, n7), bl)).getLinkModel() != linkModel) {
            linkModel.destroy();
        }
        ((AbstractNetLink)iNetLink).setChecking(false);
        if (this.dbTA.on()) {
            this.dbTA.println("updateLink: refreshing NL " + iNetLink.prettyString());
        }
        ((AbstractNetLink)iNetLink).refresh(iOspfAdv.getProtType(), (String)object, iOspfAdv.getBlsrNodeId(), n8, n3, iOspfAdv.getProtRole(), n2);
        this.putNetElement(netElement2);
        if (!bl2) {
            this.putNetElement(netElement);
        }
        this.putNetLink(iNetLink);
        ((AbstractNetLink)iNetLink).setOspfAreaId(l);
        if (iNetLink instanceof OscNetLink) {
            OscNetLink oscNetLink = (OscNetLink)iNetLink;
            if (this.getIs6CharBlsrRingNameSupported()) {
                if (!oscNetLink.getSrc().getNodeModel().provides(Feature.OPTICAL_SIDE)) {
                    oscNetLink.setOptAttribs(iOspfAdv.getOptRingName(), iOspfAdv.isOptLinkEast());
                } else {
                    oscNetLink.setOptAttribs();
                }
            } else {
                String string = "";
                try {
                    string = Short.toString(iOspfAdv.getOptRingId());
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.dbTA.println("updateLink: WARNING UNSUPPORTED OPERATION");
                    TopologyAgentDebug.printStackTrace((Throwable)unsupportedOperation);
                }
                oscNetLink.setOptAttribs(string, iOspfAdv.isOptLinkEast());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLinkUpdate(long l) {
        if (this.dbTA.on()) {
            this.dbTA.println("startLinkUpdate: setting all NL to checking");
        }
        Map map = this.topoAgentLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.topoAgentLinks.values()) {
                if (iNetLink.getOspfAreaId() != l || iNetLink.getLinkType() == 2) continue;
                if (this.dbTA.on()) {
                    this.dbTA.println("startLinkUpdate: checking " + iNetLink.prettyString());
                }
                ((AbstractNetLink)iNetLink).setChecking(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLinkUpdate(long l) {
        if (this.stopped) {
            return;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("finishLinkUpdate");
        }
        LinkedList<Object> linkedList = new LinkedList();
        Map map = this.topoAgentLinks;
        synchronized (map) {
            linkedList = new LinkedList(this.topoAgentLinks.values());
        }
        for (INetLink iNetLink : linkedList) {
            if (iNetLink.getOspfAreaId() != l) continue;
            if (this.dbTA.on()) {
                this.dbTA.println("finishLinkUpdate: for link " + iNetLink.prettyString());
            }
            if (iNetLink.getLinkType() == 2) continue;
            if (this.dbTA.on()) {
                this.dbTA.println("finishLinkUpdate: inChecking = " + ((AbstractNetLink)iNetLink).inChecking());
            }
            if (((AbstractNetLink)iNetLink).inChecking()) {
                ((AbstractNetLink)iNetLink).newState(2);
                this.topo.delete(iNetLink);
                continue;
            }
            ((AbstractNetLink)iNetLink).newState(1);
        }
    }

    private void findUnreachableNetElems() {
        if (this.reachableNetElems.size() != this.topoAgentElems.size()) {
            if (this.dbTA.on()) {
                this.dbTA.println("findUnreachableNetElems: Reachable NEs missing");
            }
            this.unreachableNetElems = this.getElements();
            this.unreachableNetElems.removeAll(this.reachableNetElems);
            for (INetElement iNetElement : this.unreachableNetElems) {
            }
        } else if (this.dbTA.on()) {
            this.dbTA.println("findUnreachableNetElems: All NEs accounted for");
        }
    }

    private void putNetElement(NetElement netElement) {
        if (this.stopped) {
            if (this.dbTA.on()) {
                this.dbTA.println("putNetElement: topo stopped, ignoring request");
            }
            return;
        }
        if (this.dbTA.on()) {
            this.dbTA.println("putNetElement: attempting to add NE " + netElement.getActualAddressDisplay() + ", topo ID => " + netElement.getTopoId() + ", Node ID => " + netElement.getNodeId());
        }
        this.reachableNetElems.add(netElement);
        if (netElement.getTopoId() != this.topo.getTopoId() && netElement.getTopology() != null) {
            if (this.dbTA.on()) {
                this.dbTA.println("putNetElement: NE belongs to another topo " + netElement.getTopoId());
            }
            this.topo.discoveredForeignOwnedNE(netElement);
            if (!this.stopped) {
                netElement.setTopology(this.topo, this.topo.getTopoId());
                this.topoAgentElems.put(new Integer(netElement.getNodeId()), netElement);
                this.topo.addToTopology(netElement);
                if (this.dbTA.on()) {
                    this.dbTA.println("putNetElement: NE added to this topo , size => " + this.topoAgentElems.size());
                }
            } else if (this.dbTA.on()) {
                this.dbTA.println("putNetElement: TopoAgent stopped");
            }
        } else {
            netElement.setTopology(this.topo, this.topo.getTopoId());
            if (!this.topoAgentElems.containsKey(new Integer(netElement.getNodeId()))) {
                this.topoAgentElems.put(new Integer(netElement.getNodeId()), netElement);
                if (this.dbTA.on()) {
                    this.dbTA.println("putNetElement: NE belongs to this topo ,added to list, size => " + this.topoAgentElems.size());
                }
            } else if (this.dbTA.on()) {
                this.dbTA.println("putNetElement: NE belongs to this topo , already in list, size => " + this.topoAgentElems.size());
            }
            this.topo.addToTopology(netElement);
        }
    }

    protected void addNetElement(NetElement netElement) {
        netElement.setTopology(this.topo, this.topo.getTopoId());
        this.putNetElement(netElement);
    }

    protected void addNetLink(INetLink iNetLink) {
        ((AbstractNetLink)iNetLink).setTopology(this.topo, this.topo.getTopoId());
        this.putNetLink(iNetLink);
    }

    private void putNetLink(INetLink iNetLink) {
        if (this.stopped) {
            if (this.dbTA.on()) {
                this.dbTA.println("putNetLink: topo stopped, ignoring request");
            }
            return;
        }
        ((AbstractNetLink)iNetLink).setTopology(this.topo, this.topo.getTopoId());
        if (!this.topoAgentLinks.containsKey(iNetLink)) {
            ((AbstractNetLink)iNetLink).setChecking(false);
            ((AbstractNetLink)iNetLink).newState(1);
            this.topoAgentLinks.put(iNetLink, iNetLink);
            if (this.dbTA.on()) {
                this.dbTA.println("putNetLink: added NL " + iNetLink.prettyString() + " to list, size = " + this.topoAgentLinks.size());
            }
            this.topo.addToTopology(iNetLink);
        }
    }

    protected void processOSPFUpdateEvent() {
        this.doMoaDiscovery();
    }

    protected void delete(INetElement iNetElement) {
        if (this.dbTA.on()) {
            this.dbTA.println("delete: deleting NE " + iNetElement.getActualAddressDisplay());
        }
        this.topoAgentElems.remove(new Integer(iNetElement.getNodeId()));
    }

    protected void delete(INetLink iNetLink) {
        if (this.dbTA.on()) {
            this.dbTA.println("delete: deleting NL " + iNetLink.prettyString());
        }
        this.topoAgentLinks.remove(iNetLink);
    }

    public class TopologyAgentDebug
    extends SDebug {
        public TopologyAgentDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dumpAll() {
            TopologyAgent.this.dbTA.println("===========================================");
            TopologyAgent.this.dbTA.println("IsActive => " + TopologyAgent.this.isActive());
            TopologyAgent.this.dbTA.println("Topology Host => " + TopologyAgent.this.topologyHost.getActualAddressDisplay());
            TopologyAgent.this.dbTA.println("connected => " + TopologyAgent.this.connected);
            TopologyAgent.this.dbTA.println("enabled => " + TopologyAgent.this.enabled);
            TopologyAgent.this.dbTA.println("isMoaSupported => " + TopologyAgent.this.getIsMoaSupported());
            TopologyAgent.this.dbTA.println("topoModel => " + TopologyAgent.this.topoModel);
            TopologyAgent.this.dbTA.println("ABR => " + TopologyAgent.this.topologyHost.isABR());
            TopologyAgent.this.dbTA.println("OSPF areas:");
            this.dumpTopoAgentAreas(TopologyAgent.this.getAreas());
            TopologyAgent.this.dbTA.println("NE list: count => " + TopologyAgent.this.topoAgentElems.size());
            this.dumpTopoAgentNEs();
            TopologyAgent.this.dbTA.println("NL list: count => " + TopologyAgent.this.topoAgentLinks.size());
            this.dumpTopoAgentNLs();
        }

        public final void dumpTopoAgentAreas(Collection collection) {
            for (OspfArea ospfArea : collection) {
                if (!TopologyAgent.this.dbTA.on()) continue;
                TopologyAgent.this.dbTA.println("  Area " + ospfArea.getAreaId() + " => " + ospfArea.isActive());
            }
        }

        public final void dumpTopoAgentNEs() {
            for (NetElement netElement : TopologyAgent.this.getElements()) {
                if (!TopologyAgent.this.dbTA.on()) continue;
                TopologyAgent.this.dbTA.println("  " + netElement.getActualAddressDisplay());
            }
        }

        public final void dumpTopoAgentNLs() {
            for (INetLink iNetLink : TopologyAgent.this.getLinks()) {
                if (!TopologyAgent.this.dbTA.on()) continue;
                TopologyAgent.this.dbTA.println("  " + iNetLink.prettyString());
            }
        }
    }
}

