/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.ILinkModel;
import cerent.cms.model.INetLinkType;
import cerent.cms.model.IPoolModel;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.DummyLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.util.EnumStrings;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UPSRLoopLink
extends RoutableNetLink {
    private int framingType;

    public UPSRLoopLink(INetElement iNetElement, INetElement iNetElement2, int n) {
        super(iNetElement, iNetElement2);
        this.framingType = n;
    }

    public int getSrcEntityIndex() {
        return 0;
    }

    public int[] getSrcPortNumber() {
        return new int[0];
    }

    public int getSrcSlotNumber() {
        return 0;
    }

    public IHoNum getSrcHo() {
        return HoLoFactory.createFirstHoNum(this.framingType);
    }

    public int getDstEntityIndex() {
        return 0;
    }

    public int[] getDstPortNumber() {
        return new int[0];
    }

    public int getDstSlotNumber() {
        return 0;
    }

    public IHoNum getDstHo() {
        return HoLoFactory.createFirstHoNum(this.framingType);
    }

    public ILinkModel getLinkModel() {
        return null;
    }

    public int getLinkType() {
        return 5;
    }

    public ArrayList getLinksList() {
        ArrayList<UPSRLoopLink> arrayList = new ArrayList<UPSRLoopLink>();
        arrayList.add(this);
        return arrayList;
    }

    public int getPhysicalType() {
        return 0;
    }

    public int getProtectionType() {
        return 3;
    }

    public void setProtectionType(int n) {
    }

    public boolean isSdccLink() {
        return false;
    }

    public int getProtectionGroup() {
        return 0;
    }

    public void setPhysicalType(int n) {
    }

    public void setCost(int n) {
    }

    public int getCost() {
        return 0;
    }

    public IPoolModel getSrcPool() {
        return null;
    }

    public IPoolModel getDstPool() {
        return null;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        return this.getLabelSet(n, n2);
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        return this.getLabelSet(n, n2);
    }

    private ILabelSet getLabelSet(int n, int n2) {
        if (this.db.on()) {
            this.db.println("getLabelSet: Link : " + this.prettyString());
        }
        DummyLabelSet dummyLabelSet = new DummyLabelSet();
        int n3 = NetCircuitManager.instance().calcFramingType(n2, n);
        dummyLabelSet.addLabel((ILabel)HoLoFactory.createFirstHoNum(n3));
        return dummyLabelSet;
    }

    public int state() {
        return 1;
    }

    public boolean isProtected() {
        return false;
    }

    public String prettyString() {
        return this.src.prettyString() + "->" + this.dst.prettyString() + " ( " + EnumStrings.getString(INetLinkType.class, (int)this.getLinkType()) + " ) ";
    }

    public boolean isPhysical() {
        return false;
    }

    public boolean isLOTunnel() {
        return false;
    }

    public boolean isLAP() {
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isPca() {
        return false;
    }

    public boolean isPca(INetElement iNetElement) {
        return false;
    }

    public boolean inWorkingBLSR() {
        return false;
    }

    public boolean isBlsrCapable() {
        return false;
    }

    public boolean isLOCapable() {
        return true;
    }

    public INetLinkSpan getAvailSpan(int n, int n2, boolean bl) throws NoRoute {
        return null;
    }

    public INetLinkSpan[] getAllAvailSpans(int n, int n2) {
        return new INetLinkSpan[0];
    }

    public boolean isDeleted() {
        return false;
    }

    public List getAvailableHoNumbers(int n, int n2) {
        return new LinkedList();
    }

    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return new LinkedList();
    }

    public boolean canSupportCircuitSize(int n, int n2) {
        return true;
    }

    public boolean canSupportCircuitDirection(int n) {
        return true;
    }

    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    public void dispose() {
    }

    public long getTimestamp() {
        return 0L;
    }

    public Topology getTopology() {
        return null;
    }

    public int getTopoId() {
        return 0;
    }

    public void setOspfAreaId(long l) {
    }

    protected boolean inChecking() {
        return true;
    }

    public long getOspfAreaId() {
        return -1L;
    }

    public void setSla(short s) {
    }

    public Integer getSla() {
        return new Integer(0);
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) {
        return true;
    }

    protected void setChecking(boolean bl) {
    }

    public void newState(int n) {
    }

    public void acquireSrcSlotAndPort() {
    }

    public void acquireDstSlotAndPort() {
    }

    public int getEndProtectionSwitchState(boolean bl) {
        return -1;
    }

    protected void initializeDebug() {
        this.db = new AbstractNetLink.AbstractNetLinkDebug("UPSRLoopNL_" + UPSRLoopLink.getDebugName(this.src.getHostName()) + this.dst.getHostName());
        if (this.db.on()) {
            this.db.println("UPSRLoopLink: Creating UPSRLookLink");
        }
    }
}

