/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.LinkCapacityType;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchAdv;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.util.EnumStrings;
import cerent.util.InetUtil;
import cerent.util.SDebug;

public class UnknownNetLink
extends NonRoutableNetLink {
    private boolean isValid = false;

    public UnknownNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new UnknownNetLink, sdccLink = " + bl);
        }
        this.determineLinkType();
    }

    protected void initializeDebug() {
        this.db = new UnknownNetLinkDebug("NLu" + UnknownNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + UnknownNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
    }

    protected void acquireSrcSlotAndPort() {
    }

    protected void acquireDstSlotAndPort() {
    }

    public boolean isValid() {
        if (this.db.on()) {
            this.db.println("isValid: isValid => " + this.isValid);
        }
        return this.isValid;
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).newState(this.newState());
    }

    private void determineLinkType() {
        if (this.src.getNodeModel().provides(Feature.OSPF_TLV)) {
            IOspfAdv iOspfAdv = this.getLSA();
            if (iOspfAdv != null) {
                int n = LinkCapacityType.getLinkPhysicalType((int)iOspfAdv.getLinkCapacity());
                int n2 = iOspfAdv.getLinkType();
                this.linkModel.setIsXcCapable(iOspfAdv.isXcCapable());
                this.linkModel.setIsNbrXcCapable(iOspfAdv.isNbrXcCapable());
                this.linkModel.setPhysicalType(n);
                this.linkModel.setPhysicalLinkType(n2);
                if (this.db.on()) {
                    this.db.println("determineLinkType: retrieved following attributes from LSA   \nphyType => " + n + "  \nphysicalLinkType => " + n2 + "  \nisXcCapable => " + iOspfAdv.isXcCapable() + "  \nisNbrXcCapable => " + iOspfAdv.isNbrXcCapable());
                }
                this.isValid = true;
                this.src.deleteObserver(this);
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        } else {
            try {
                INodeModel iNodeModel = null;
                if (this.src.getConnectionState()) {
                    iNodeModel = this.src.getNodeModel();
                } else if (this.dst.getConnectionState()) {
                    iNodeModel = this.dst.getNodeModel();
                }
                if (iNodeModel != null) {
                    int n = iNodeModel.getTdmProtocolTypeObj().isSonet() ? 1 : 2;
                    this.linkModel.setPhysicalLinkType(n);
                    if (this.db.on()) {
                        this.db.println("determineLinkType: phyLinkType => " + n);
                    }
                    this.isValid = true;
                    this.src.deleteObserver(this);
                    this.dst.deleteObserver(this);
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                } else {
                    if (this.db.on()) {
                        this.db.println("determineLinkType: neither NE connected");
                    }
                    this.src.addObserver(this);
                    this.dst.addObserver(this);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    this.db.println("determineLinkType: caught AbstractCmsIOException => " + abstractCmsIOException.getMessage());
                }
                this.src.addObserver(this);
                this.dst.addObserver(this);
            }
        }
    }

    private IOspfAdv getLSA() {
        IOspfAdv iOspfAdv;
        block12: {
            iOspfAdv = null;
            IOspfTopologyModel iOspfTopologyModel = this.src.getNodeModel().getOspfTopologyModel();
            if (iOspfTopologyModel != null) {
                if (this.db.on()) {
                    this.db.println("acquireLSA: acquired topoModel");
                }
                try {
                    iOspfAdv = iOspfTopologyModel.getAdv(InetUtil.makeIpAddr(this.src.getHostName()), this.getSrcEntityIndex());
                    if (iOspfAdv != null) {
                        if (this.db.on()) {
                            this.db.println("acquireLSA: LSA acquired");
                        }
                        break block12;
                    }
                    if (this.db.on()) {
                        this.db.println("acquireLSA: adv is null, disposing");
                    }
                    this.dispose();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (this.db.on()) {
                        this.db.println("acquireLSA: caught exception => " + abstractCmsIOException.getMessage());
                    }
                    this.src.addObserver(this);
                }
                catch (NoSuchAdv noSuchAdv) {
                    if (this.db.on()) {
                        this.db.println("acquireLSA: caught exception => " + noSuchAdv.getMessage());
                    }
                    this.dispose();
                }
            } else {
                if (this.db.on()) {
                    this.db.println("acquireLSA: topoModel is null, observing NM Conn Notifyier");
                }
                this.src.addObserver(this);
            }
        }
        return iOspfAdv;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: NL disposed");
        }
        this.src.deleteObserver(this);
        this.dst.deleteObserver(this);
        super.dispose();
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED update event");
                }
                this.determineLinkType();
            }
        } else if (object instanceof NetElement) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NE " + ((NetElement)object).getHostName());
                }
                this.determineLinkType();
            } else if (this.db.on()) {
                this.db.println("update: received DELETED event from NE " + ((NetElement)object).getHostName());
                this.db.println("update: NOT IMPLEMENTED");
            }
        }
    }

    public class UnknownNetLinkDebug
    extends SDebug {
        public UnknownNetLinkDebug(String string) {
            super(string);
        }

        public final void dump() {
            UnknownNetLink.this.db.println("======================================");
            UnknownNetLink.this.db.println("Src = " + UnknownNetLink.this.src.getHostName());
            UnknownNetLink.this.db.println("Dst = " + UnknownNetLink.this.dst.getHostName());
            UnknownNetLink.this.db.println("State = " + (UnknownNetLink.this.newState() == 1 ? "Up" : "Down"));
            UnknownNetLink.this.db.println("Topology ID = " + UnknownNetLink.this.topoId);
            UnknownNetLink.this.db.println("NetLink Type = " + UnknownNetLink.this.getLinkTypeObj());
            UnknownNetLink.this.db.println("Protection Type = " + UnknownNetLink.this.getProtectionTypeObj());
            UnknownNetLink.this.db.println("Physical Type = " + UnknownNetLink.this.getPhysicalTypeObj().getDisplayString(UnknownNetLink.this.isSonetCapable()));
            UnknownNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)UnknownNetLink.this.getPhysicalLinkType()));
            UnknownNetLink.this.db.println("Src XC Capable = " + UnknownNetLink.this.linkModel.isXcCapable());
            UnknownNetLink.this.db.println("Dst XC Capable = " + UnknownNetLink.this.linkModel.isNbrXcCapable());
            UnknownNetLink.this.db.println("Src Slot = " + UnknownNetLink.this.srcSlot);
            UnknownNetLink.this.db.println("Src Port = " + UnknownNetLink.this.srcPort);
            UnknownNetLink.this.db.println("Dst Slot = " + UnknownNetLink.this.dstSlot);
            UnknownNetLink.this.db.println("Dst Port = " + UnknownNetLink.this.dstPort);
            UnknownNetLink.this.db.println("Cost = " + UnknownNetLink.this.linkModel.cost());
        }

        public final void dumpObservers() {
            UnknownNetLink.this.db.println("======================================");
            UnknownNetLink.this.db.println("UnknownNetLink Observers:");
            UnknownNetLink.this.printObservers();
        }
    }
}

