/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeShelfModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IAbstractPane;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public abstract class AbstractPane
extends Pane
implements IAbstractPane {
    protected Observable tvObs;
    public static final String RETRIEVED_LABEL = "Retrieved: ";
    private static DateFormat dateFormat = null;
    protected TabbedView parentTV;
    protected IModel uiModel;
    protected IUiToolkit uiToolkit;
    protected String fullName = null;
    private boolean destroyed = false;
    protected boolean showing = false;
    protected Set refreshObjects = Collections.synchronizedSet(new HashSet());
    protected JTable table = null;
    protected TabbedView subTabs = null;
    private SecurityLevel defaultSecurityLevel = SecurityLevel.SUPERUSER;
    protected static final SDebug db = new SDebug("AbstractPane");

    public TabbedView getSubTabs() {
        return this.subTabs;
    }

    public AbstractPane(String string, TabbedView tabbedView) {
        this(string, null, tabbedView);
    }

    public AbstractPane(String string) {
        this(string, null, null);
    }

    public AbstractPane(String string, IModel iModel, TabbedView tabbedView) {
        this.setName(string);
        this.parentTV = tabbedView;
        this.uiModel = iModel;
        if (this.uiModel == null && this.parentTV != null) {
            this.uiModel = this.parentTV.getUiModel();
        }
        this.getUiToolkit();
        if (db.on()) {
            db.println("About to set tvObs.  Parent is " + this.parentTV);
        }
        Observable observable = this.tvObs = this.parentTV == null ? null : this.parentTV.getObservable();
        if (db.on()) {
            db.println("tvObs = " + this.tvObs);
        }
    }

    protected void getUiToolkit() {
        if (this.uiModel != null && this.uiModel.getNodeModel() != null) {
            this.uiToolkit = this.uiModel.getNodeModel().getUiToolkit();
        }
    }

    public static JPanel createHorizontalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public void setParentTV(TabbedView tabbedView) {
        this.parentTV = tabbedView;
    }

    public IModel getUiModel() {
        return this.uiModel;
    }

    public TabbedView getParentView() {
        return this.parentTV;
    }

    public JTable getTable() {
        return this.table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setShowing(boolean bl) throws Exception {
        if (this.showing != bl) {
            if (db.on()) {
                db.println("setShowing(" + this.showing + "): " + (Object)((Object)this));
            }
            if (this.subTabs != null) {
                try {
                    if (db.on()) {
                        db.println("subTabs.setShowing(" + bl + "): " + (Object)((Object)this));
                    }
                    this.subTabs.setShowing(bl);
                }
                catch (Exception exception) {
                    this.showing = true;
                    if (!db.on()) throw exception;
                    db.println("setShowing exception on subTabs:" + exception.getMessage() + "\n" + "final showing state=" + this.showing);
                    throw exception;
                }
            } else if (db.on()) {
                db.println("no subtabs: " + (Object)((Object)this));
            }
            try {
                if (bl) {
                    if (db.on()) {
                        db.println("enteringPage: " + (Object)((Object)this));
                    }
                    this.enteringPage();
                } else {
                    if (db.on()) {
                        db.println("leavingPage: " + (Object)((Object)this));
                    }
                    this.leavingPage();
                }
                this.showing = bl;
                return;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) return;
                db.println("caught " + (Object)((Object)abstractCmsIOException) + " in Pane.setShowing");
                return;
            }
            catch (Exception exception) {
                if (bl) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
                    return;
                }
                this.showing = true;
                try {
                    if (this.subTabs != null) {
                        this.subTabs.setShowing(true);
                    }
                }
                catch (Exception exception2) {
                    db.finest("Exception in subTabs.setShowing() " + exception2);
                }
                if (!db.on()) throw exception;
                db.println("setShowing:" + exception.getMessage());
                throw exception;
            }
        }
        if (!db.on()) return;
        db.println("showing==isShowing: " + (Object)((Object)this));
    }

    public abstract void leavingPage() throws Exception;

    public abstract void enteringPage() throws Exception;

    public abstract void refresh() throws Exception;

    protected void registerWithModel() {
        IObservableManager iObservableManager = this.getObservableManager();
        if (this.uiModel instanceof Observable) {
            if (iObservableManager != null) {
                iObservableManager.addObservable((Observable)this.uiModel);
            } else {
                ((Observable)this.uiModel).addObserver((Observer)((Object)this));
            }
            if (this.uiModel instanceof INodeShelfModel && !(this.uiModel instanceof INodeModel)) {
                INodeShelfModel iNodeShelfModel = (INodeShelfModel)this.uiModel;
                if (iObservableManager != null) {
                    iObservableManager.addObservable((Observable)iNodeShelfModel.getNodeModel());
                } else {
                    iNodeShelfModel.getNodeModel().addObserver((Observer)((Object)this));
                }
            }
        }
        this.registerForLineUpdates();
    }

    protected IObservableManager getObservableManager() {
        return null;
    }

    protected void registerForLineUpdates() {
        if (this.tvObs != null) {
            if (db.on()) {
                db.println("Register " + (Object)((Object)this) + " for updates from " + this.tvObs);
            }
            this.tvObs.addObserver((Observer)((Object)this));
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.uiModel != null && this.uiModel instanceof Observable) {
                ((Observable)this.uiModel).deleteObserver((Observer)((Object)this));
            }
            if (this.tvObs != null) {
                this.tvObs.deleteObserver((Observer)((Object)this));
            }
            this.dispose();
            if (this.subTabs != null) {
                this.subTabs.destroy();
            }
            this.removeAll();
            this.parentTV = null;
        }
    }

    public void dispose() {
    }

    public void update(Observable observable, Object object) {
        if (observable != null && observable.equals(this.tvObs)) {
            if (db.on()) {
                db.println("Calling refreshMyLines on " + (Object)((Object)this));
            }
            this.refreshMyLines(object);
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.SYSTEM_TIME_CHANGED) && this.uiModel.getNodeModel().provides(Feature.SYSTEM_TIME)) {
                this.changeMessage(observable, object);
            } else if (n.equals(ModelUpdateType.CHANGED)) {
                this.changeMessage(observable, object);
            } else if (n.equals(ModelUpdateType.DELETED)) {
                this.deleteMessage(observable, object);
            } else if (n.equals(ModelUpdateType.ADDED)) {
                this.structureChangeMessage(observable, object);
            }
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        if (this.getUiModel() != null) {
            this.requestRefresh((Object)this, null);
        }
    }

    protected void requestRefresh(Object object, Runnable runnable) {
        if (!this.isRefreshRequested(object)) {
            SwingUtilities.invokeLater(new PaneRefresher(this, object, runnable));
        } else if (db.on()) {
            db.println("requestRefresh: refresh already requested");
        }
    }

    protected boolean isRefreshRequested(Object object) {
        return this.refreshObjects.contains(object);
    }

    protected void setRefreshRequested(Object object, boolean bl) {
        if (bl) {
            this.refreshObjects.add(object);
        } else {
            this.refreshObjects.remove(object);
            object = null;
        }
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    protected void setCursor(int n) {
        if (this.uiToolkit == null) {
            this.getUiToolkit();
        }
        if (this.uiToolkit != null) {
            this.uiToolkit.setCursor(n);
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
    }

    public Dimension getMinimumSize() {
        return new Dimension(500, 200);
    }

    protected void structureChangeMessage(Observable observable, Object object) {
    }

    public void enableComponent(JComponent jComponent) {
        if (this.uiModel == null) {
            jComponent.setEnabled(false);
        } else {
            this.enableComponent(jComponent, this.uiModel);
        }
    }

    protected void enableComponent(JComponent jComponent, IModel iModel) {
        this.enableComponent(jComponent, iModel, this.defaultSecurityLevel);
    }

    protected void enableComponent(JComponent jComponent, IModel iModel, SecurityLevel securityLevel) {
        jComponent.setEnabled(AbstractPane.isUserAuthorized(iModel, securityLevel));
    }

    protected void setDefaultPrivilegeLevel(SecurityLevel securityLevel) {
        if (securityLevel != null) {
            this.defaultSecurityLevel = securityLevel;
        }
    }

    protected SecurityLevel getDefaultPrivilegeLevel() {
        return this.defaultSecurityLevel;
    }

    public boolean isUserAuthorized() {
        return this.isUserAuthorized(this.uiModel);
    }

    protected boolean isUserAuthorized(SecurityLevel securityLevel) {
        return AbstractPane.isUserAuthorized(this.uiModel, securityLevel);
    }

    protected boolean isUserAuthorized(IModel iModel) {
        return AbstractPane.isUserAuthorized(iModel, this.defaultSecurityLevel);
    }

    public static boolean isUserAuthorized(IModel iModel, SecurityLevel securityLevel) {
        if (iModel != null) {
            INodeModel iNodeModel = iModel.getNodeModel();
            if (iNodeModel == null) {
                return false;
            }
            if (AbstractPane.isPrivilegeSufficent(iNodeModel.getSecurityLevel(), securityLevel)) {
                return true;
            }
        } else if (db.on()) {
            db.println("Access denied: null Model");
        }
        return false;
    }

    private static final boolean isPrivilegeSufficent(SecurityLevel securityLevel, SecurityLevel securityLevel2) {
        int n = -1;
        if (securityLevel != null) {
            n = securityLevel.value();
        }
        if (n == 3) {
            return true;
        }
        boolean bl = false;
        switch (securityLevel2.value()) {
            case 0: {
                return true;
            }
            case 1: {
                bl = n == 1 || n == 2;
                break;
            }
            case 2: {
                boolean bl2 = bl = n == 2;
            }
        }
        if (!bl && db.on()) {
            db.println("Access denied : insuf priv (required=" + securityLevel2.value() + ", curr=" + n + ")");
        }
        return bl;
    }

    public String getFullName() {
        if (this.fullName == null) {
            if (this.parentTV != null && this.parentTV.getParent() instanceof AbstractPane) {
                AbstractPane abstractPane = (AbstractPane)((Object)this.parentTV.getParent());
                this.fullName = abstractPane.getFullName() + "/" + this.getName();
            } else {
                this.fullName = "/" + this.getName();
            }
        }
        return this.fullName;
    }

    protected void stopTableCellEditing() {
        if (this.table != null && this.table.getCellEditor() != null) {
            try {
                this.table.getCellEditor().stopCellEditing();
            }
            catch (Exception exception) {
                this.table.getCellEditor().cancelCellEditing();
            }
        }
    }

    protected void cancelTableCellEditing() {
        if (this.table != null && this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    protected void printStackTrace(Exception exception) {
        SDebug.printStackTrace((Throwable)exception);
    }

    protected static String getFormattedDateTime(Date date) {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(1, 1);
        }
        return dateFormat.format(date);
    }

    protected static String getFormattedDateTime() {
        return AbstractPane.getFormattedDateTime(new Date());
    }

    public CSHelpID getHelpID() {
        return null;
    }

    protected void refreshMyLines(Object object) {
    }

    public static class PaneRefresher
    implements Runnable {
        private Object obj;
        private Runnable refresher;
        private AbstractPane _ap;

        public PaneRefresher(AbstractPane abstractPane, Object object, Runnable runnable) {
            this.obj = object;
            this.refresher = runnable;
            this._ap = abstractPane;
            this._ap.setRefreshRequested(object, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                try {
                    try {
                        if (this._ap.isDestroyed()) {
                            Object var3_1 = null;
                            this.obj = null;
                            this.refresher = null;
                            this._ap = null;
                            return;
                        }
                        this._ap.setRefreshRequested(this.obj, false);
                        if (this._ap.getUiModel() != null) {
                            if (this.refresher != null) {
                                if (AbstractPane.db.on) {
                                    db.println("PaneRefresher.run: running a refresher");
                                }
                                this.refresher.run();
                                break block13;
                            } else {
                                if (AbstractPane.db.on) {
                                    db.println("PaneRefresher.run: calling refresh()");
                                }
                                this._ap.refresh();
                            }
                            break block13;
                        }
                        if (AbstractPane.db.on) {
                            db.println("PaneRefresher.run: uiModel is null, NOP");
                        }
                    }
                    catch (Exception exception) {
                        if (!this._ap.isDestroyed()) {
                            SDebug.printStackTrace((Throwable)exception);
                            ErrorMsg.displayError((Component)((Object)this._ap), (EID)CEMC.EID_FAIL_REFRESH_PANE);
                        }
                        Object var3_3 = null;
                        this.obj = null;
                        this.refresher = null;
                        this._ap = null;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.obj = null;
                    this.refresher = null;
                    this._ap = null;
                    throw throwable;
                }
            }
            Object var3_2 = null;
            this.obj = null;
            this.refresher = null;
            this._ap = null;
        }
    }
}

