/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeHelper;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.ExplorerViewPane;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.SecurityActivePane;
import cerent.cms.ui.SecurityPolicyPane;
import cerent.cms.ui.SecurityUsersPane;
import cerent.cms.ui.SoftMaintPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.VirtualLinkPane;
import cerent.cms.ui.aic.AicMaintVWPane;
import cerent.cms.ui.circuits.CircuitsTabbedView;
import cerent.cms.ui.circuits.FVCircuitsTabbedView;
import cerent.cms.ui.provalarms.ProvAlarmsPane;
import cerent.cms.ui.vlan.ProfileVlanDbPane;
import cerent.cms.ui.vlan.VlanStpDialog;
import cerent.cms.ui.vlan.VlanStpPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class DefaultGuestPaneFactory
implements IGuestPaneFactory,
ITabName {
    private static final String FTG_PKG_PREFIX = "cerent.cms.model.ftg.";
    private static final String FTG_UTIL_CLASS = "cerent.cms.model.ftg.FTGUtils";
    private static final String FTG_ADAPTION_METHOD = "guestPaneFtgAdaptIfNeeded";
    private static final DefaultGuestPaneFactory instance = new DefaultGuestPaneFactory();
    private static SDebug db = new SDebug("DefaultGuestPaneFactory");

    public static DefaultGuestPaneFactory instance() {
        return instance;
    }

    public JComponent getGuestPane(int n) {
        return this.getGuestPane(n, null);
    }

    public JComponent getGuestPane(int n, TabbedView tabbedView) {
        Object object = null;
        switch (n) {
            case 1: 
            case 15: {
                IModel iModel = tabbedView.getUiModel();
                if (iModel instanceof NetworkModel) {
                    iModel = null;
                }
                iModel = DefaultGuestPaneFactory.ftgAdaptIfNeeded(iModel);
                if (n == 15) {
                    object = new FVCircuitsTabbedView("Circuits", iModel, tabbedView);
                    break;
                }
                object = new CircuitsTabbedView("Circuits", iModel, tabbedView);
                break;
            }
            case 4: {
                IModel iModel = tabbedView.getUiModel();
                if (iModel instanceof NetworkModel) {
                    object = new SoftMaintPane("Software", null, tabbedView);
                    break;
                }
                INodeModel iNodeModel = Network.instance().getNodeModel(iModel.getNodeModel().getNodeId());
                object = new SoftMaintPane("Software", iNodeModel, tabbedView);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                object = new AicMaintVWPane("Virtual Wires", tabbedView);
                break;
            }
            case 9: {
                object = new AicMaintVWPane("Virtual Wires", tabbedView, 16);
                break;
            }
            case 6: {
                IModel iModel = tabbedView.getUiModel();
                if (!(iModel instanceof NetworkModel)) {
                    iModel = Network.instance().getNodeModel(iModel.getNodeModel().getNodeId());
                }
                object = new SecurityUsersPane("Users", iModel, tabbedView);
                break;
            }
            case 7: {
                IModel iModel = tabbedView.getUiModel();
                if (!(iModel instanceof NetworkModel)) {
                    iModel = Network.instance().getNodeModel(iModel.getNodeModel().getNodeId());
                }
                object = new SecurityActivePane("Active Logins", iModel, tabbedView);
                break;
            }
            case 8: {
                IModel iModel = tabbedView.getUiModel();
                if (!(iModel instanceof NetworkModel)) {
                    iModel = Network.instance().getNodeModel(iModel.getNodeModel().getNodeId());
                }
                object = new SecurityPolicyPane("Policy", iModel, tabbedView);
                break;
            }
            case 10: {
                object = new VlanStpPane("Circuits", tabbedView);
                break;
            }
            case 11: {
                Collection collection = Network.instance().getElements();
                Iterator iterator = collection.iterator();
                INodeModel[] iNodeModelArray = new INodeModel[collection.size()];
                int n2 = 0;
                while (iterator.hasNext()) {
                    INetElement iNetElement = (INetElement)iterator.next();
                    iNodeModelArray[n2++] = iNetElement.getNodeModel();
                }
                object = new ProvAlarmsPane("Alarm Profiles", tabbedView, iNodeModelArray, true);
                break;
            }
            case 12: {
                object = new VirtualLinkPane("PPC", true, tabbedView);
                break;
            }
            case 13: {
                object = ExplorerViewPane.getInstance();
                break;
            }
            case 14: {
                object = new ProfileVlanDbPane("SVLAN DB", tabbedView, true);
                break;
            }
        }
        return object;
    }

    public JDialog getGuestDialog(int n, Component component, Object[] objectArray) {
        VlanStpDialog vlanStpDialog = null;
        switch (n) {
            case 1: {
                vlanStpDialog = new VlanStpDialog(component, objectArray);
            }
        }
        return vlanStpDialog;
    }

    private static IModel ftgAdaptIfNeeded(IModel iModel) {
        IModel iModel2;
        block8: {
            iModel2 = null;
            try {
                Class<?> clazz = Class.forName(FTG_UTIL_CLASS);
                Class[] classArray = new Class[]{IModel.class};
                Method method = clazz.getDeclaredMethod(FTG_ADAPTION_METHOD, classArray);
                Object[] objectArray = new Object[]{iModel};
                return (IModel)method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (db.on()) {
                    db.println("got exception: " + throwable.getMessage());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (db.on()) {
                    db.println("got exception: " + classNotFoundException.getMessage());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (db.on()) {
                    db.println("got exception: " + noSuchMethodException.getMessage());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!db.on()) break block8;
                db.println("got exception: " + illegalAccessException.getMessage());
            }
        }
        return iModel2;
    }

    private DefaultGuestPaneFactory() {
    }

    public INodeHelper getNodeHelper() {
        return NodeHelper.getInstance();
    }
}

