/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.topo.Network;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class NetVlanInfoCellRenderer
implements ListCellRenderer,
TableCellRenderer {
    public static final String LIST_CELL_PROTOTYPE = "Administration (42)";
    private boolean hideTopoId = false;
    private DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
    private DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
    private static final SDebug db = new SDebug("NetVlanInfoCellRenderer");

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.dlcr.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof NetVlanInfo) {
            this.dlcr.setText(NetVlanInfoCellRenderer.getString((NetVlanInfo)object, this.hideTopoId));
        }
        return this.dlcr;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.dtcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof NetVlanInfo) {
            this.dtcr.setText(NetVlanInfoCellRenderer.getString((NetVlanInfo)object, this.hideTopoId));
        }
        return this.dtcr;
    }

    public static String getString(NetVlanInfo netVlanInfo, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("Topo host: ");
            stringBuffer.append(Network.instance().getTopoHost(netVlanInfo.topoId).getName());
            stringBuffer.append(" - ");
        }
        if (netVlanInfo.vlan == null) {
            return " ";
        }
        stringBuffer.append(netVlanInfo.vlan.getName());
        stringBuffer.append(" (");
        stringBuffer.append(netVlanInfo.vlan.getId());
        stringBuffer.append(")");
        if (db.on()) {
            db.println("getString:  " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public void setHideTopoId(boolean bl) {
        this.hideTopoId = bl;
    }
}

