/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;

public class NodeSelector
extends UComboBox {
    private TreeSet treeSet;
    private static SDebug db = new SDebug("NodeSelector");

    public NodeSelector() {
        this.setRenderer(new NodeCellRenderer());
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(1, 2, 0);
        this.updateNodeList(circuitCreatInfo, null);
    }

    public NodeSelector(CircuitCreatInfo circuitCreatInfo) {
        this.setRenderer(new NodeCellRenderer());
        if (circuitCreatInfo != null) {
            this.updateNodeList(circuitCreatInfo, null);
        }
    }

    public void updatePGNodeList() {
        this.updateNodeList(new CircuitCreatInfo(4, 12, 0), null);
        Iterator iterator = this.treeSet.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel = (INodeModel)iterator.next();
            if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.NO_PORT_GROUPING)) continue;
            iterator.remove();
            this.removeItem(iNodeModel);
        }
    }

    public void updateNodeList(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit) {
        Object object4;
        Object object2;
        INetElement[] iNetElementArray;
        int n = 120;
        int n2 = 8;
        boolean bl = false;
        if (iNetCircuit != null && circuitCreatInfo.isDiag()) {
            int n3;
            INodeModel iNodeModel = iNetCircuit.getSrcCircuitNode().getNodeModel();
            this.removeAllItems();
            this.addItem(iNodeModel);
            String string = NodeCellRenderer.getName(iNodeModel);
            if (string != null && (n3 = n2 * string.length()) > n) {
                NodeSelector.setPreferredWidth((JComboBox)((Object)this), (int)n3);
            }
            return;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iNetCircuit == null) {
            iNetElementArray = Network.instance().getElements().toArray(new INetElement[0]);
        } else {
            Object object3;
            object2 = new RoutePrefs();
            ((RoutePrefs)object2).setSrc(iNetCircuit.getSrcNetElement());
            ((RoutePrefs)object2).setCircuitSize(iNetCircuit.getCircuitSize());
            ((RoutePrefs)object2).setCircuitType(iNetCircuit.getCircuitType());
            ((RoutePrefs)object2).setRequiredSpans(iNetCircuit.getRequiredSpans());
            ((RoutePrefs)object2).setcktSrcEntityIndex(((INetCircuitEnd)iNetCircuit.getSources().get(0)).getEntityIndex());
            ((RoutePrefs)object2).setPathOnly(false);
            if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                int n4 = iNetCircuit.getCircuitType();
                if (n4 == 10) {
                    ((RoutePrefs)object2).setCircuitType(1);
                } else if (n4 == 12) {
                    ((RoutePrefs)object2).setCircuitType(4);
                } else if (n4 == 11) {
                    ((RoutePrefs)object2).setCircuitType(2);
                } else if (n4 == 13) {
                    ((RoutePrefs)object2).setCircuitType(5);
                }
                object3 = ((RoutePrefs)object2).getFwdDropPrefs();
                ((DropPrefs)object3).setCommonFiber(false);
                object4 = ((DropPrefs)object3).getFirstMemberGroupPrefs();
                ((MemberGroupPrefs)object4).setMemberBandwidth(iNetCircuit.getCircuitSize());
                ((MemberGroupPrefs)object4).setMemberCount(circuitCreatInfo.forwardMembers());
            }
            if (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType() || iCircuitType.isOchTrailTunnelCircuitType() || iCircuitType.isSVLANType()) {
                Collection collection = Network.instance().getElements();
                object3 = collection.iterator();
                while (object3.hasNext()) {
                    object4 = (INetElement)object3.next();
                    if (circuitCreatInfo.singleNodeOchnc() || iCircuitType.isSVLANType() && circuitCreatInfo.isProtected() && iNetCircuit.getState() == 0) {
                        if (object4.getNodeId() == iNetCircuit.getSrcCircuitNode().getNetElement().getNodeId()) continue;
                        object3.remove();
                        continue;
                    }
                    if (iCircuitType.isSVLANType() && (iNetCircuit.getState() == 5 || iNetCircuit.getState() == 6) || object4.getNodeId() != iNetCircuit.getSrcCircuitNode().getNetElement().getNodeId()) continue;
                    object3.remove();
                    break;
                }
                iNetElementArray = collection.toArray(new INetElement[0]);
            } else {
                iNetElementArray = Network.instance().getAvailDropNodes((RoutePrefs)object2);
            }
        }
        this.treeSet = new TreeSet(new NodeComparator());
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        object2 = NetCircuitManager.instance();
        boolean bl2 = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType() && iNetCircuit != null;
        for (int i = 0; i < iNetElementArray.length; ++i) {
            int n5;
            object4 = iNetElementArray[i];
            INodeModel iNodeModel = object4.getNodeModel();
            if (iCircuitType.isSVLANType()) {
                List<IEntityModel> list;
                boolean bl3;
                if (!iNodeModel.provides(Feature.SVLAN_CKT)) continue;
                if (circuitCreatInfo.isProtected() && iNetCircuit != null) {
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                ISvlanCircuitModels iSvlanCircuitModels = iNodeModel.getSvlanCircuitModels();
                boolean bl4 = bl3 = iNetCircuit != null && iNetCircuit.getState() != 0;
                if (iSvlanCircuitModels == null || (list = Arrays.asList(iSvlanCircuitModels.getAvailEntitiesForSvlanCkt(circuitCreatInfo.svlan(), circuitCreatInfo.isProtected(), bl3))).size() <= 0) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (!iNodeModel.provides(Feature.EVEN_BAND_CIRCUIT) && Wavelength.getParityString(Wavelength.getWlAttribute(n5 = circuitCreatInfo.cktOptChannel())).compareTo("even") == 0) continue;
            if (iCircuitType.isOchncType()) {
                if (!iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) continue;
                if (iNetCircuit == null) {
                    if (!OchncHelper.isAvailableForOchncSource(iNodeModel, circuitCreatInfo)) continue;
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (!OchncHelper.isAvailableForOchncDrop(iNodeModel, circuitCreatInfo)) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (iCircuitType.isOchccCircuitType()) {
                List list = OchTrailHelper.filterNodeForOchcc(circuitCreatInfo, iNetCircuit, iNodeModel);
                if (list.size() <= 0) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (iCircuitType.isOchTrailTunnelCircuitType()) {
                List list = OchTrailHelper.filterNodeForOchTrail(circuitCreatInfo, iNetCircuit, iNodeModel);
                if (list.size() <= 0) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (object4.canSupportCircuitSize(circuitCreatInfo.type(), circuitCreatInfo.size()) && (!bl2 || object4.loXCon())) {
                if (iCircuitType.isLoCircuitType() && ((NetCircuitManager)object2).canAddToNodeList(iNodeModel, iNetCircuit, circuitCreatInfo)) {
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLAPCircuitType()) {
                    this.treeSet.add(iNodeModel);
                    continue;
                }
                if (!iCircuitType.isLAPCircuitType() || !iNodeModel.provides(Feature.VT_GROOMING)) continue;
                this.treeSet.add(iNodeModel);
                continue;
            }
            if (!((NetCircuitManager)object2).canAddToNodeList(iNodeModel, iNetCircuit, circuitCreatInfo)) continue;
            this.treeSet.add(iNodeModel);
        }
        for (Object object4 : this.treeSet) {
            int n6;
            this.addItem(object4);
            String string = NodeCellRenderer.getName((INodeModel)object4);
            if (string == null || (n6 = n2 * string.length()) <= n) continue;
            n = n6;
            bl = true;
        }
        if (bl) {
            NodeSelector.setPreferredWidth((JComboBox)((Object)this), (int)n);
        }
    }

    public INodeModel[] getNodes() {
        int n = this.getItemCount();
        INodeModel[] iNodeModelArray = new INodeModel[n];
        for (int i = 0; i < n; ++i) {
            iNodeModelArray[i] = (INodeModel)this.getItemAt(i);
        }
        return iNodeModelArray;
    }

    private class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object object, Object object2) {
            INodeModel iNodeModel = (INodeModel)object;
            INodeModel iNodeModel2 = (INodeModel)object2;
            return iNodeModel.getHostName().compareTo(iNodeModel2.getHostName());
        }
    }
}

