/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.ncp.PPCRepairOperator;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.ppc.PPCRepGuessTerms;
import cerent.cms.ui.ppc.PPCRepPreamble;
import cerent.cms.ui.ppc.PPCRepTerms;
import cerent.cms.ui.ppc.PPCRepairInfo;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class PPCRepairDialog
extends WzDialog {
    private static final String TITLE = "PPC Repair";
    public static final int VIGN_WIDTH = 200;
    public static final String WZPANE_PPC_REP_PREAMBLE = "PPC Repair Introduction";
    public static final String WZPANE_PPC_REP_DISCOVER = "Discover IP Changes";
    public static final String WZPANE_PPC_REP_TERMS = "PPC Terminations to Repair";
    private PPCRepairInfo info;

    public static PPCRepairDialog instance(Component component) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        return new PPCRepairDialog(frame, TITLE);
    }

    public PPCRepairDialog(Frame frame, String string) {
        super(frame, string, new WzDiagDebug("PPCLinkCreationDialog"), true, true);
        int n = 700;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
        this.info = new PPCRepairInfo();
    }

    protected void createPanesAndSetCurrent() {
        this.wzPaneMap.put(WZPANE_PPC_REP_PREAMBLE, new PPCRepPreamble(this, this.db, WZPANE_PPC_REP_PREAMBLE));
        this.wzPaneMap.put(WZPANE_PPC_REP_DISCOVER, new PPCRepGuessTerms(this, this.db, WZPANE_PPC_REP_DISCOVER));
        this.wzPaneMap.put(WZPANE_PPC_REP_TERMS, new PPCRepTerms(this, this.db, WZPANE_PPC_REP_TERMS));
        this.setCurrentPane(WZPANE_PPC_REP_PREAMBLE);
    }

    protected void apply() throws Exception {
        List<IVirtualLinkModel> list = this.info.getTerms();
        if (list == null || list.size() == 0) {
            CerentDialog.infoDialog((Component)this, (String)"No PPC to repair", (String)"Completed");
        } else {
            PPCRepairOperator pPCRepairOperator = PPCRepairOperator.newInstance();
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!pPCRepairOperator.fixTerminations(this.info.getIpChange(), this.info.getTerms(), linkedList)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : linkedList) {
                    stringBuilder.append(string).append("\n\n");
                }
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_PPC_REPAIR_FAILURE, stringBuilder.toString());
                throw new Exception();
            }
            CerentDialog.infoDialog((Component)this, (String)"All PPCs repaired", (String)"Completed");
        }
    }

    public boolean handleFinishException(Exception exception) {
        return true;
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(!bl, bl);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void setNextEnabled(boolean bl) {
        this.setButtonsEnabled(bl, !bl);
    }

    public PPCRepairInfo getInfo() {
        return this.info;
    }

    private static String toString(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf() ? "shelf " : "slot ");
    }
}

