/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPrefsPropertyPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.StringPropertyEditor;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.launcher.JreChooser;
import com.cisco.ctc.core.launcher.JreProperties;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsJrePropertyPane
extends AbstractPrefsPropertyPane
implements ActionListener {
    private static final SDebug db = new SDebug("PrefsJrePropertyPane");
    private AbstractPropertySheet parentSheet;
    private JButton browseBtn = null;
    private StringPropertyEditor pathFld = null;
    private JreProperties jp = JreProperties.instance();

    public PrefsJrePropertyPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences) {
        super(string, abstractPropertySheet, preferences);
        this.parentSheet = abstractPropertySheet;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected boolean onValidate(Container container) {
        return true;
    }

    public void store(JreVersion jreVersion, String string) {
        block2: {
            try {
                this.jp.setJrePath(jreVersion, string);
                this.jp.setCtcJreVersion(this.getSystemVersionOrdinal(), jreVersion);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private Comparable getSystemVersionOrdinal() {
        INgrp iNgrp = ClassLoaderManager.instance().getSystemNgrp();
        Comparable comparable = iNgrp.getManifestVersionOrdinal();
        if (db.on()) {
            db.println("core version ordinal in getSystemVersionOrdinal() : " + comparable);
        }
        return comparable;
    }

    public void load() {
        String string = this.jp.getJrePath(JreVersion.USER_VERSION);
        if (db.on()) {
            db.println("Jre from ref is " + string);
        }
        if (string == null) {
            string = System.getProperty("java.home");
            if (db.on()) {
                db.println("No Jre available from ref. Get from system " + string);
            }
        }
        if (this.pathFld != null) {
            this.pathFld.setValue(string);
        }
    }

    private void initialize() throws Exception {
        this.setLayout(null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setSize(450, 60);
        jPanel.setLocation(10, 10);
        jPanel.setBorder(BorderFactory.createTitledBorder("Current Java"));
        JLabel jLabel = new JLabel("Version:");
        JLabel jLabel2 = new JLabel(JreVersion.USER_VERSION.toString());
        jLabel.setSize(70, 20);
        jLabel2.setSize(150, 20);
        jLabel.setLocation(15, 15);
        jLabel2.setLocation(80, 15);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel("Path:");
        JLabel jLabel4 = new JLabel(System.getProperty("java.home"));
        jLabel3.setSize(70, 20);
        jLabel4.setSize(400, 20);
        jLabel3.setLocation(15, 35);
        jLabel4.setLocation(80, 35);
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        this.add(jPanel);
        JLabel jLabel5 = new JLabel("Select a different Java Version (effective when CTC is restarted)");
        jLabel5.setSize(400, 20);
        jLabel5.setLocation(15, 80);
        this.add(jLabel5);
        this.pathFld = new StringPropertyEditor("");
        this.pathFld.setSize(340, 22);
        this.pathFld.setEnabled(false);
        this.pathFld.setLocation(15, 105);
        this.add(this.pathFld);
        this.browseBtn = new JButton("Browse...");
        this.browseBtn.setSize(90, 22);
        this.browseBtn.addActionListener(this);
        this.browseBtn.setLocation(370, 105);
        this.add(this.browseBtn);
        this.load();
        this.notifyAllPropertyEditors(this);
        this.parentSheet.resetApply();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ClassLoaderManager.instance().getSystemSwVersion();
        if (db.on()) {
            db.println("Core version got from CLM: " + string);
        }
        ICoreVersionUtil iCoreVersionUtil = CoreVersionUtil.instance();
        Comparable comparable = iCoreVersionUtil.createNeVersionOrdinal(string);
        if (db.on()) {
            db.println("Core ordinal version: " + comparable);
        }
        JreChooser jreChooser = new JreChooser(null, (IJreReqs)JreReqs.CURRENT, iCoreVersionUtil.prettyDottedString(comparable));
        jreChooser.setVisible(true);
        JreVersion jreVersion = null;
        String string2 = null;
        jreVersion = jreChooser.getJavaVersion();
        if (db.on()) {
            db.println("New selected JRE is " + jreVersion);
        }
        if (jreVersion != null) {
            try {
                string2 = jreChooser.getJavaDirectory().getCanonicalPath();
                if (db.on()) {
                    db.println("New selected JRE dir is " + string2);
                }
            }
            catch (IOException iOException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
                string2 = jreChooser.getJavaDirectory().getAbsolutePath();
            }
            this.store(jreVersion, string2);
            this.pathFld.setValue(string2);
        } else if (db.on()) {
            db.println("Selected JRE from chooser is null");
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.PrefsJrePropertyPane;
    }
}

