/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.AbstractSdhStEndpointPanel;
import cerent.cms.ui.StEndpointPane;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SdhAu3LoNum;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu3StEndpointPanel
extends AbstractSdhStEndpointPanel {
    public SdhAu3StEndpointPanel(String string, StEndpointPane stEndpointPane) {
        super(string, stEndpointPane);
    }

    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.vc3LB = new JLabel("VC3:", 4);
        this.vc3CB = this.addCB(this.vc3LB, "vc3CB", gridBagConstraints);
        this.tug2LB = new JLabel("TUG2:", 4);
        this.tug2CB = this.addCB(this.tug2LB, "tug2CB", gridBagConstraints);
        this.vc11_12LB = new JLabel("", 4);
        this.vc11_12CB = this.addCB(this.vc11_12LB, "vc11_12CB", gridBagConstraints);
        this.hoParts.add(this.vc3CB);
        this.vc11_12LoParts = new ArrayList();
        this.vc11_12LoParts.add(this.tug2LB);
        this.vc11_12LoParts.add(this.tug2CB);
        this.vc11_12LoParts.add(this.vc11_12LB);
        this.vc11_12LoParts.add(this.vc11_12CB);
        this.loParts.addAll(this.vc11_12LoParts);
    }

    protected List getLoParts() {
        if (this.loParts.size() == 0) {
            if (this.vc11_12LoParts.size() == 0) {
                this.vc11_12LoParts.add(this.tug2LB);
                this.vc11_12LoParts.add(this.tug2CB);
                this.vc11_12LoParts.add(this.vc11_12LB);
                this.vc11_12LoParts.add(this.vc11_12CB);
            }
            this.loParts.addAll(this.vc11_12LoParts);
        }
        return this.loParts;
    }

    protected void reset() {
        super.reset();
        this.resetLoNum();
    }

    protected void resetLoNum() {
        this.loNum = null;
        this.vc11_12 = null;
        this.tug2 = null;
    }

    protected void setLoComponents(ILoNum iLoNum) {
        this.tug2CB.setSelectedItem(this.tug2);
        this.vc11_12CB.setSelectedItem(this.vc11_12);
    }

    protected JComboBox getHoCB() {
        return this.vc3CB;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.shelfCB) {
            super.actionPerformed(actionEvent);
        } else if (object == this.slotCB) {
            super.actionPerformed(actionEvent);
        } else if (object == this.portCB) {
            SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
            if (this.isNull(sortablePortString, "newPort")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
            }
            this.port = sortablePortString;
            try {
                this.setEntity((IEntityModel)this.portMap.get(this.port));
            }
            catch (AnnotatedException annotatedException) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                }
                this.clearEntity(annotatedException, false);
            }
        } else if (object == this.vc3CB) {
            IHoNum iHoNum = (IHoNum)this.vc3CB.getSelectedItem();
            if (this.isNull(iHoNum, "newVc3")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: vc3 " + this.vc3 + " -> " + iHoNum);
            }
            this.hoNum = iHoNum;
            this.endpoint.setHoNum(this.hoNum);
            Object v = this.endpointMap.get(this.hoNum);
            if (this.isNull(v, "endpointMap value for VC4 " + this.hoNum.toString())) {
                return;
            }
            if (!(v instanceof INetCircuitEnd) && v instanceof SortedMap) {
                this.tug2Map = (SortedMap)v;
                this.setCBList(this.tug2CB, this.tug2Map.keySet());
                if (this.tug2Map.size() == 1) {
                    this.tug2CB.setSelectedItem(this.tug2Map.firstKey());
                    this.tug2CB.setEnabled(false);
                }
                this.setCBList(this.vc11_12CB, null);
            }
        } else if (object == this.tug2CB) {
            Integer n = (Integer)this.tug2CB.getSelectedItem();
            if (this.isNull(n, "newTug2")) {
                return;
            }
            n = (Integer)this.getValidSelectedItem(this.tug2CB, n);
            if (db.on()) {
                db.println(this.title + " actionPerformed: tug2 " + this.tug2 + " -> " + n);
            }
            this.tug2 = n;
            this.vc11_12Map = (SortedMap)this.tug2Map.get(this.tug2);
            this.setCBList(this.vc11_12CB, this.vc11_12Map.keySet());
            if (this.vc11_12Map.size() == 1) {
                this.vc11_12CB.setSelectedItem(this.vc11_12Map.firstKey());
                this.vc11_12CB.setEnabled(false);
            }
        } else if (object == this.vc11_12CB) {
            Integer n = (Integer)this.vc11_12CB.getSelectedItem();
            if (this.isNull(n, "newVc11_12")) {
                return;
            }
            n = (Integer)this.getValidSelectedItem(this.vc11_12CB, n);
            if (db.on()) {
                db.println(this.title + " actionPerformed: vc11_12 " + this.vc11_12 + " -> " + n);
            }
            this.vc11_12 = n;
            this.loNum = HoLoFactory.createSdhAu3LoNum(this.getCircuitInfoSize(), this.tug2, this.vc11_12);
            this.endpoint.setLoNum(this.loNum);
        }
    }

    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
        TreeMap<Integer, INetCircuitEnd> treeMap = null;
        if (this.getCircuitInfoType() != 5 && this.getCircuitInfoType() != 13) {
            throw new IllegalArgumentException("The circuit type should be VC_LO_CIRCUIT.");
        }
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iNetCircuitEnd.getLoNum();
        if (sdhAu3LoNum != null) {
            Integer n = new Integer(sdhAu3LoNum.getTug2());
            Integer n2 = new Integer(sdhAu3LoNum.getVc11_12());
            if (sdhAu3LoNum.getCorrespondingCircuitSize() != this.getCircuitInfoSize()) {
                throw new IllegalArgumentException("A circuit size mismatch occurred. The circuit size should be " + this.getCircuitInfoSize() + ", but " + sdhAu3LoNum.getCorrespondingCircuitSize() + " is being returned.");
            }
            Object object = this.vc3Map.put(this.vc3, sortedMap);
            if (object != null && db.on()) {
                db.println(this.title + " getDropPoints: multiple endpoints with " + "VC3 = " + iNetCircuitEnd.getHoNum() + ", Tug 2 = " + ((SdhAu3LoNum)iNetCircuitEnd.getLoNum()).getTug2());
            }
            if ((treeMap = (TreeMap<Integer, INetCircuitEnd>)sortedMap.get(n)) == null) {
                treeMap = new TreeMap<Integer, INetCircuitEnd>();
                sortedMap.put(n, treeMap);
            }
            if ((object = treeMap.put(n2, iNetCircuitEnd)) != null && db.on()) {
                db.println(this.title + " getDropPoints: multiple endpoints with " + "VC3 = " + iNetCircuitEnd.getHoNum() + ", Tug 2 = " + n + ", VC11_12 = " + n2);
            }
        }
    }

    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        if (sortedMap == null) {
            return false;
        }
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iLoNum;
        Integer n = new Integer(sdhAu3LoNum.getTug2());
        Integer n2 = new Integer(sdhAu3LoNum.getVc11_12());
        SortedMap sortedMap2 = (SortedMap)sortedMap.get(n);
        if (sortedMap2 == null) {
            return false;
        }
        return sortedMap2.containsKey(n2);
    }

    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        Integer n2 = (Integer)sortedMap.firstKey();
        SortedMap sortedMap2 = (SortedMap)sortedMap.get(n2);
        Integer n3 = (Integer)sortedMap2.firstKey();
        return HoLoFactory.createSdhAu3LoNum(n, n2, n3);
    }

    protected void localRefresh(ICircuitType iCircuitType, int n) {
        if (!iCircuitType.isLoCircuitType() && !iCircuitType.isLoVcatCircuitType()) {
            this.endpoint.setLoNum(null);
            this.vc11_12 = null;
            this.tug2 = null;
            SdhAu3StEndpointPanel.setComponentsVisible(this.loParts, false);
        } else {
            SdhAu3StEndpointPanel.setComponentsVisible(this.vc11_12LoParts, true);
            if (n == 9) {
                this.vc11_12LB.setText("VC11:");
            } else {
                this.vc11_12LB.setText("VC12:");
            }
        }
    }
}

