/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModel;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class SecurityActiveDataSource
extends AbstractRowDataSource {
    private IModel _model;
    private ArrayList _values;
    static String NOT_APPLICABLE = "N/A";
    private static final String[] _columnNames = new String[]{"Node", "User", "Source", "Session Type", "Login Time", "Last Activity Time"};
    private static final Class[] _columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
    private static final SDebug db = new SDebug("SecurityActiveDataSource");
    private static final IIpAddr SERIAL_ADDR = InetUtil.makeIpAddr("255.255.255.255");

    SecurityActiveDataSource(IModel iModel) {
        this._model = iModel;
        this._values = new ArrayList();
        if (db.on()) {
            db.println("empty");
        }
    }

    private static String getDisplayableIpAddress(IIpAddr iIpAddr) {
        String string = SERIAL_ADDR.compareTo((Object)iIpAddr) == 0 ? "Craft Port" : InetUtil.makeDottedString(iIpAddr);
        return string;
    }

    private void fetchValues(NodeModel nodeModel, ArrayList arrayList) {
        if (nodeModel.provides(Feature.SECURITY_USER_STATUS)) {
            try {
                IActiveUserInfoModel[] iActiveUserInfoModelArray = nodeModel.getSecurityModel().getActiveUsers();
                Object var4_5 = null;
                for (int i = 0; i < iActiveUserInfoModelArray.length; ++i) {
                    if (nodeModel.provides(Feature.SECURITY_VERSIONING)) {
                        if (db.on()) {
                            db.println("adding: " + iActiveUserInfoModelArray[i]);
                        }
                        arrayList.add(new ActiveUserInfo(nodeModel, iActiveUserInfoModelArray[i]));
                        continue;
                    }
                    ActiveUserInfo activeUserInfo = this.findUser(arrayList, iActiveUserInfoModelArray[i], nodeModel);
                    if (activeUserInfo == null) {
                        if (db.on()) {
                            db.println("adding: " + iActiveUserInfoModelArray[i]);
                        }
                        arrayList.add(new ActiveUserInfo(nodeModel, iActiveUserInfoModelArray[i]));
                        continue;
                    }
                    if (db.on()) {
                        db.println("update: " + iActiveUserInfoModelArray[i]);
                    }
                    activeUserInfo.update(nodeModel);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                // empty catch block
            }
        }
    }

    private ActiveUserInfo findUser(ArrayList arrayList, IActiveUserInfoModel iActiveUserInfoModel, NodeModel nodeModel) {
        String string = SecurityActiveDataSource.getDisplayableIpAddress(iActiveUserInfoModel.getClientIpAddress());
        for (ActiveUserInfo activeUserInfo : arrayList) {
            if (!activeUserInfo.getUserName().equals(iActiveUserInfoModel.getUserId()) || !activeUserInfo.getClientIp().equals(string) || !activeUserInfo.getNodes().get(0).equals(nodeModel) || !activeUserInfo.getSessionType().equals(NOT_APPLICABLE)) continue;
            return activeUserInfo;
        }
        return null;
    }

    private NodeModel nodeModel(Object object) {
        if (object instanceof INetElement) {
            return (NodeModel)((INetElement)object).getNodeModel();
        }
        return (NodeModel)object;
    }

    void refreshFromModel(SortableRowTableModel sortableRowTableModel) {
        block5: {
            try {
                ArrayList arrayList = new ArrayList();
                if (this._model instanceof NetworkModel) {
                    Iterator iterator = Network.instance().getElements().iterator();
                    while (iterator.hasNext()) {
                        this.fetchValues(this.nodeModel(iterator.next()), arrayList);
                    }
                } else {
                    this.fetchValues(this.nodeModel(this._model), arrayList);
                }
                SwingUtilities.invokeAndWait(new Refresher(sortableRowTableModel, arrayList));
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("exception: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    boolean nodeDoesNotSupportGetUsers() {
        if (this._model instanceof NetworkModel) {
            Iterator iterator = Network.instance().getElements().iterator();
            while (iterator.hasNext()) {
                if (this.nodeModel(iterator.next()).provides(Feature.SECURITY_USER_STATUS)) continue;
                return true;
            }
        } else if (!this.nodeModel(this._model).provides(Feature.SECURITY_USER_STATUS)) {
            return true;
        }
        return false;
    }

    ColumnRenderer[] getRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[_columnNames.length];
        for (int i = 0; i < _columnNames.length; ++i) {
            columnRendererArray[i] = new Renderer(i);
        }
        return columnRendererArray;
    }

    public synchronized Object getObjectAtRow(int n) {
        return this._values.get(n);
    }

    public synchronized int getRowCount() {
        return this._values.size();
    }

    public Class getRowObjectClass() {
        return ActiveUserInfo.class;
    }

    private class Renderer
    implements ColumnRenderer {
        private final int _column;

        Renderer(int n) {
            this._column = n;
        }

        public String getName() {
            return _columnNames[this._column];
        }

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(_columnClasses[this._column]).getTableCellRendererComponent(jTable, ((ActiveUserInfo)object).getValueAt(n2), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof ActiveUserInfo) {
                if (object2 instanceof ActiveUserInfo) {
                    return ((ActiveUserInfo)object).cmpValueAt((ActiveUserInfo)object2, n);
                }
                return -1;
            }
            return 1;
        }
    }

    private class Refresher
    implements Runnable {
        private SortableRowTableModel _tm;
        private ArrayList _newValues;

        Refresher(SortableRowTableModel sortableRowTableModel, ArrayList arrayList) {
            this._tm = sortableRowTableModel;
            this._newValues = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SecurityActiveDataSource securityActiveDataSource = SecurityActiveDataSource.this;
            synchronized (securityActiveDataSource) {
                SecurityActiveDataSource.this._values = this._newValues;
            }
            this._tm.dataSourceChanged();
            this._tm = null;
            this._newValues = null;
        }
    }

    static class ActiveUserInfo {
        private ArrayList _nodes = new ArrayList();
        private IActiveUserInfoModel _model;
        private String _nodeName;
        private String _userName;
        private String _clientIp;
        private String _sessionType;
        private String _loginTime;
        private String _activityTime;

        ActiveUserInfo(NodeModel nodeModel, IActiveUserInfoModel iActiveUserInfoModel) {
            AbstractVersionedFeature abstractVersionedFeature;
            AbstractVersionedFeature abstractVersionedFeature2;
            this._nodes.add(nodeModel);
            this._model = iActiveUserInfoModel;
            this._nodeName = nodeModel.getName();
            this._userName = iActiveUserInfoModel.getUserId();
            this._clientIp = SecurityActiveDataSource.getDisplayableIpAddress(iActiveUserInfoModel.getClientIpAddress());
            this._sessionType = NOT_APPLICABLE;
            this._loginTime = NOT_APPLICABLE;
            this._activityTime = NOT_APPLICABLE;
            if (nodeModel.provides(Feature.SECURITY_VERSIONING) && AbstractVersionedFeature.isCompatibilityPresent((AbstractVersionedFeature)(abstractVersionedFeature2 = NetSecurityModel.instance().getSecurityVersion()), (AbstractVersionedFeature)(abstractVersionedFeature = nodeModel.getSecurityModel().getSecurityVersion()))) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                this._sessionType = iActiveUserInfoModel.getSessionType();
                this._loginTime = simpleDateFormat.format(iActiveUserInfoModel.getLoginTime());
                this._activityTime = simpleDateFormat.format(iActiveUserInfoModel.getActivityTime());
            }
        }

        void update(NodeModel nodeModel) {
            if (!this._nodes.contains(nodeModel)) {
                this._nodes.add(nodeModel);
            }
        }

        ArrayList getNodes() {
            return this._nodes;
        }

        IActiveUserInfoModel getModel() {
            return this._model;
        }

        String getNodeName() {
            return this._nodeName;
        }

        String getUserName() {
            return this._userName;
        }

        String getClientIp() {
            return this._clientIp;
        }

        String getSessionType() {
            return this._sessionType;
        }

        String getLoginTime() {
            return this._loginTime;
        }

        String getActivityTime() {
            return this._activityTime;
        }

        Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getNodeName();
                }
                case 1: {
                    return this.getUserName();
                }
                case 2: {
                    return this.getClientIp();
                }
                case 3: {
                    return this.getSessionType();
                }
                case 4: {
                    return this.getLoginTime();
                }
                case 5: {
                    return this.getActivityTime();
                }
            }
            return null;
        }

        int cmpValueAt(ActiveUserInfo activeUserInfo, int n) {
            switch (n) {
                case 0: {
                    return this.getNodeName().compareTo(activeUserInfo.getNodeName());
                }
                case 1: {
                    return this.getUserName().compareTo(activeUserInfo.getUserName());
                }
                case 2: {
                    return this.getClientIp().compareTo(activeUserInfo.getClientIp());
                }
                case 3: {
                    return this.getSessionType().compareTo(activeUserInfo.getSessionType());
                }
                case 4: {
                    return this.getLoginTime().compareTo(activeUserInfo.getLoginTime());
                }
                case 5: {
                    return this.getActivityTime().compareTo(activeUserInfo.getActivityTime());
                }
            }
            return -1;
        }
    }
}

