/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.topo.INetServerTrailManager;
import cerent.cms.topo.NetServerTrailManager;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.ui.StAttrPane;
import cerent.cms.ui.StEndpointPane;
import cerent.cms.ui.WizardDialog;
import cerent.util.ILabel;
import cerent.util.SDebug;
import java.awt.Dimension;
import java.awt.Frame;

public class ServerTrailDialog
extends WizardDialog {
    private static final SDebug db = new SDebug("ServerTrailDialog");
    ICircuitType circuitType;
    ICircuitSize circuitSize;
    CircuitCreatInfo circuitInfo;
    ServerTrailPrefs stPrefs;
    INodeModel srcNode;
    INetCircuitEnd srcEndpoint;
    INodeModel dstNode;
    INetCircuitEnd dstEndpoint;
    public static String TITLE = "Server Trail Creation";
    public static String ST_ATTRS = "Attributes";
    public static String ST_SOURCE = "Source";
    public static String ST_DEST = "Destination";
    private StEndpointPane sourcePane;
    private StEndpointPane destPane;
    private INetServerTrailManager netSvMgr = NetServerTrailManager.instance();

    public ServerTrailDialog(Frame frame) {
        super(frame, TITLE, true, true);
        int n = 150;
        int n2 = 300;
        this.addStatusPanel(new WizardDialog.StatusPanel("/images/CTC_dialogVignette.gif", new Dimension(150, 300)));
        this.init();
        this.setBackEnabled(false);
        int n3 = n + 400;
        int n4 = n2 + 20;
        this.setSize(new Dimension(n3, n4));
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void init() {
        this.addPage(new StAttrPane(ST_ATTRS, this));
        this.sourcePane = new StEndpointPane(ST_SOURCE, this, ST_SOURCE);
        this.addPage(this.sourcePane);
        this.destPane = new StEndpointPane(ST_DEST, this, ST_DEST);
        this.addPage(this.destPane);
    }

    protected void apply() throws Exception {
        this.stPrefs.setSrc(this.srcEndpoint.getNetElement());
        this.stPrefs.setDest(this.dstEndpoint.getNetElement());
        this.stPrefs.setSrcEntity(this.srcEndpoint.getEntityIndex());
        this.stPrefs.setDestEntity(this.dstEndpoint.getEntityIndex());
        if (this.stPrefs.isLoTrail()) {
            this.stPrefs.setSrcPoolStart((ILabel)this.srcEndpoint.getHoLoNum());
            this.stPrefs.setDestPoolStart((ILabel)this.dstEndpoint.getHoLoNum());
        } else {
            this.stPrefs.setSrcPoolStart((ILabel)this.srcEndpoint.getHoNum());
            this.stPrefs.setDestPoolStart((ILabel)this.dstEndpoint.getHoNum());
        }
        this.netSvMgr.createServerTrailLink(this.stPrefs);
    }

    protected void handleBack(String string) {
        if (string.equals(ST_SOURCE)) {
            db.fine("Dispose source and destination panes.");
            this.sourcePane.dispose();
            this.destPane.dispose();
        }
        super.handleBack(string);
    }
}

