/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.HoServerTrailModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.LoServerTrailModel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.model.ServerTrailProtection;
import cerent.cms.ncp.ServerTrailRepairOperator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ServerTrailRepairDialog;
import cerent.cms.ui.ServerTrailRepairInfo;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.util.IAsyncObserver;
import cerent.util.gui.ServerTrailUtil;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ServerTrailRepairTerms
extends WzPane
implements IAsyncObserver {
    private static final String CAPTION = "Select Finish to repair the following Server Trails.";
    protected JTable table = null;
    private ServerTrailTableModel tableModel;
    private List<ServerTrailModel> tableDataList;

    public ServerTrailRepairTerms(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    public void validatePage() {
        ServerTrailRepairInfo serverTrailRepairInfo = ((ServerTrailRepairDialog)this.parent).getInfo();
        serverTrailRepairInfo.setTerms(this.tableDataList);
    }

    public void enteringPane() {
        super.enteringPane();
        ServerTrailRepairOperator serverTrailRepairOperator = ServerTrailRepairOperator.newInstance();
        ServerTrailRepairOperator.IpChange ipChange = ((ServerTrailRepairDialog)this.parent).getInfo().getIpChange();
        this.tableDataList = serverTrailRepairOperator.findTermToBeFixed(ipChange);
        this.tableModel.fireTableDataChanged();
        ((ServerTrailRepairDialog)this.parent).setFinishEnabled(true);
    }

    protected String getNextPaneName() {
        return null;
    }

    protected void initPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(CAPTION);
        jTextArea.setMargin(new Insets(5, 5, 5, 5));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jPanel.add((Component)jTextArea, "North");
        this.tableDataList = new LinkedList<ServerTrailModel>();
        this.tableModel = new ServerTrailTableModel();
        this.table = new UTable((TableModel)this.tableModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.prepareColumns();
        jPanel.add((Component)uScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    protected void prepareColumns() {
        ServerTrailRenderer serverTrailRenderer = new ServerTrailRenderer();
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            this.table.getColumn(this.tableModel.getColumnName(i)).setCellRenderer(serverTrailRenderer);
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.ServerTrailRepairTermsPane;
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
    }

    protected class ServerTrailRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = jTable.convertColumnIndexToModel(n2);
            switch (n3) {
                case 0: {
                    if (object != null) break;
                    object = "Could not retrieve";
                    break;
                }
                case 1: 
                case 2: {
                    if (object == null) {
                        object = "Could not retrieve";
                        break;
                    }
                    object = ServerTrailUtil.getEndpointString((IPathDefModel)object);
                    break;
                }
                case 3: {
                    if (object == null) break;
                    int n4 = (Integer)object;
                    object = CircuitSize.getCircuitSize((int)n4).getCircuitSizeString();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (object == null) break;
                    int n5 = (Integer)object;
                    object = ServerTrailProtection.getServerTrailProtection((int)n5);
                    break;
                }
                case 6: {
                    break;
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    protected class ServerTrailTableModel
    extends AbstractTableModel {
        public static final int ID_INDEX = 0;
        public static final int SRC_INDEX = 1;
        public static final int DST_INDEX = 2;
        public static final int SIZE_INDEX = 3;
        public static final int NUM_TRAILS_INDEX = 4;
        public static final int PROT_INDEX = 5;
        public static final int SRLG_INDEX = 6;
        public final String[] columnNames = new String[]{"ID", "Source", "Destination", "Size", "# of Trails", "Protection", "SRLG"};

        protected ServerTrailTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return ServerTrailRepairTerms.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (ServerTrailRepairTerms.this.tableDataList != null && n < ServerTrailRepairTerms.this.tableDataList.size()) {
                ServerTrailModel serverTrailModel = (ServerTrailModel)ServerTrailRepairTerms.this.tableDataList.get(n);
                switch (n2) {
                    case 0: {
                        if (serverTrailModel.getSrcNode() != null) {
                            return "Node: " + serverTrailModel.getSrcNode().getName() + " ID: " + serverTrailModel.getServerTrailLinkId().getUniqueId();
                        }
                        return null;
                    }
                    case 1: {
                        if (serverTrailModel instanceof HoServerTrailModel) {
                            return ((HoServerTrailModel)serverTrailModel).getSrcTrailStart();
                        }
                        return ((LoServerTrailModel)serverTrailModel).getSrcTrailStart();
                    }
                    case 2: {
                        if (serverTrailModel instanceof HoServerTrailModel) {
                            return ((HoServerTrailModel)serverTrailModel).getDstTrailStart();
                        }
                        return ((LoServerTrailModel)serverTrailModel).getDstTrailStart();
                    }
                    case 3: {
                        return new Integer(serverTrailModel.getTrailSize());
                    }
                    case 4: {
                        return new Integer(serverTrailModel.getNumberOfTrails());
                    }
                    case 5: {
                        return new Integer(serverTrailModel.getProtectionType());
                    }
                    case 6: {
                        return serverTrailModel.getSharedRiskLinkGroup();
                    }
                }
                return "";
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

