/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConstCom;
import cerent.cms.ui.NodeSelectPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.UserCreatePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UserCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create User";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    UserCreatePane createPane;
    private static List nodeModelList;
    private static NodeSelectPane nodeSelPane;
    private boolean ok = false;
    private static final SDebug db;

    public static UserCreationDialog instance(Pane pane, List list) {
        Object[] objectArray = new Object[]{pane, list};
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new UserCreationDialog(frame, TITLE, objectArray);
    }

    private UserCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        nodeModelList = (List)objectArray[1];
        if (nodeModelList != null && nodeModelList.size() > 1) {
            nodeSelPane = new NodeSelectPane(nodeModelList);
            jPanel.add((Component)this.getCreatePanel(), "North");
            jPanel.add((Component)nodeSelPane, "Center");
            this.setSize(new Dimension(475, 310));
        } else {
            jPanel.add((Component)this.getCreatePanel(), "Center");
            nodeSelPane = null;
            this.setSize(new Dimension(440, 210));
        }
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public List getSelectedList() {
        if (nodeSelPane != null) {
            return nodeSelPane.getSelectedList();
        }
        return nodeModelList;
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok = true;
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_ERROR_CREATING_USER);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected boolean apply() throws Exception {
        return this.validateFields();
    }

    public boolean ok() {
        return this.ok;
    }

    public String getUserName() {
        return this.createPane.getUserName();
    }

    public String getPassword() {
        return this.createPane.getPassword();
    }

    public String getConfirmPassword() {
        return this.createPane.getConfirmPassword();
    }

    public SecurityLevel getSecurityLevel() {
        return this.createPane.getSecurityLevel();
    }

    private JPanel getCreatePanel() {
        this.createPane = new UserCreatePane();
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConstCom.UserCreationDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean validateFields() {
        Object object;
        String string;
        boolean bl = true;
        String string2 = this.getUserName();
        if (string2.length() < 6) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_USER_NAME_LENGTH_PARAM_1, (Object)Integer.toString(6));
            bl = false;
        }
        if (bl && (string = this.getPassword()).compareTo((String)(object = this.getConfirmPassword())) != 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_PASSWORD_MISMATCH);
            bl = false;
        }
        if (bl && this.createPane.isPasswordSimple(string2)) {
            string = this.createPane.getExceptionMessage();
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_ILLEGAL_PASSWORD_PARAM_1, (Object)string);
            bl = false;
        }
        if (bl && null == this.getSecurityLevel()) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NO_SECURITY_LEVEL);
            bl = false;
        }
        if (bl) {
            int n = 0;
            object = this.getPassword().toCharArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if ("~=!@$^&*()_-`'{}[]|:;\\/<>,.?\"".indexOf((int)object[i]) <= -1) continue;
                ++n;
            }
            if (!(string2.length() <= 10 && this.getPassword().length() <= 10 && n == 0 || CerentDialog.yesNoDialog((Component)((Object)this), (String)"While valid for CTC, the user name and/or password either exceeds 10 \ncharacters, or contains special characters that do not conform to Telcordia TR-835 \nand some management functions may be disabled.\nIs it OK to continue with this user name and password combination?", (String)"User Name and/or Password Illegal for TL1"))) {
                bl = false;
            }
        }
        return bl;
    }

    static {
        db = new SDebug("UserCreationDialog");
    }
}

