/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.ui.apc.ApcDomainNode;
import cerent.cms.ui.apc.ApcDomainSelectionPane;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class ApcDomainTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String CTC_ICON = "/images/icons/CTC_icon.gif";
    private static final String DOMAIN_ICON = "/images/icons/telnet16.gif";
    private static final String DOMAINS_ICON = "/images/icons/network16.gif";
    private static final String DOMAINS_WARNING_ICON = "/images/icons/warning16.gif";
    private static final String SPAN_ICON = "/images/icons/link/ots.gif";
    private ApcDomainSelectionPane selectionPane;
    private static ImageIcon rootIcon = null;
    private static ImageIcon rootWarningIcon = null;
    private static ImageIcon domainIcon = null;
    private static ImageIcon ctcIcon = null;
    private static ImageIcon spanIcon = null;

    public ApcDomainTreeCellRenderer(ApcDomainSelectionPane apcDomainSelectionPane) {
        this.setEnabled(true);
        this.selectionPane = apcDomainSelectionPane;
        rootWarningIcon = new ImageIcon(this.getClass().getResource(DOMAINS_WARNING_ICON));
        rootIcon = new ImageIcon(this.getClass().getResource(DOMAINS_ICON));
        domainIcon = new ImageIcon(this.getClass().getResource(DOMAIN_ICON));
        ctcIcon = new ImageIcon(this.getClass().getResource(CTC_ICON));
        spanIcon = new ImageIcon(this.getClass().getResource(SPAN_ICON));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        ApcDomainNode apcDomainNode = (ApcDomainNode)defaultMutableTreeNode.getUserObject();
        if (apcDomainNode.isRoot()) {
            if (this.selectionPane.isNeedToUpdate()) {
                this.setIcon(rootWarningIcon);
            } else {
                this.setIcon(rootIcon);
            }
        } else {
            if (apcDomainNode.isDomainNode()) {
                this.setIcon(domainIcon);
                this.setText(apcDomainNode.getName());
                if (apcDomainNode.getAPCState() == 2 || apcDomainNode.getAPCState() == 3) {
                    this.setForeground(Color.RED);
                } else if (bl) {
                    this.setForeground(this.getTextSelectionColor());
                    this.setBackgroundSelectionColor(this.getBackgroundSelectionColor());
                } else {
                    this.setForeground(this.getTextNonSelectionColor());
                    this.setBackgroundNonSelectionColor(this.getBackgroundNonSelectionColor());
                }
                return this;
            }
            if (apcDomainNode.isSpan()) {
                this.setIcon(spanIcon);
                this.setText(apcDomainNode.getName());
            } else {
                this.setIcon(ctcIcon);
            }
        }
        this.setText(apcDomainNode.getName());
        return this;
    }
}

