/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.DuplicateNodeId;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRipTblEntry;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.NodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmProtocolType;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingInfo;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.model.blsr.ByteInUseException;
import cerent.cms.model.blsr.NeitherExtensionByteEditableException;
import cerent.cms.model.blsr.OnlyK3Exception;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.SquelchTableDialog;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.blsr.AbstractBlsrMap;
import cerent.cms.ui.blsr.BlsrMapFactory;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapLinkCookie;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.blsr.BlsrMapPort;
import cerent.cms.ui.blsr.BlsrPort;
import cerent.cms.ui.blsr.IBlsrMapPane;
import cerent.cms.ui.blsr.RingEditDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.ActionOrganizer;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UDialog;
import cerent.util.gui.UPopupMenu;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapPort;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.omg.CORBA.BAD_PARAM;

public class BlsrEditMap
extends AbstractBlsrMap
implements ActionListener,
Observer {
    private static final SDebug db = new SDebug("BlsrEditMap");
    private IBlsrMapPane blsrMapPane;
    private RingEditDialog container;
    public static final String CMD_SET_NODE_ID = "Set Node ID...";
    public static final String CMD_SQUELCH_TABLE = "Squelch Table...";
    public static final String CMD_RIP_TABLE = "Rip Table...";
    public static final String CMD_SET_EAST_PROTECTION_OP = "Set East Protection Operation...";
    public static final String CMD_SET_WEST_PROTECTION_OP = "Set West Protection Operation...";
    public static final String CMD_OPEN_WEST_PORT = "Open West Port";
    public static final String CMD_OPEN_EAST_PORT = "Open East Port";
    public static final String CMD_SET_EXTENSION_BYTE = "Set Extension Byte...";
    public static final String CMD_LINK_CIRCUITS = "Circuits";
    private MapPort popupMapPort;
    private MapNode popupMapNode;
    private MapLink popupMapLink;
    private HashMap observedBlsrNodes;
    private HashSet observedBlsrSpans;
    private BlsrSpanExtensionByteObserver extensionByteObserver;
    private BlsrSpanChannelStateChangeObserver channelStateChangeObserver;
    private boolean disposed = false;
    private String BLSR_TERM;

    BlsrEditMap(RingEditDialog ringEditDialog, TDMTerminology tDMTerminology) {
        super(db, 0, BlsrMapFactory.instance());
        this.reInitMapToDetailed();
        this.container = ringEditDialog;
        this.BLSR_TERM = tDMTerminology.getRingTerms(1);
        this.observedBlsrNodes = new HashMap();
        this.observedBlsrSpans = new HashSet();
        this.extensionByteObserver = new BlsrSpanExtensionByteObserver();
        this.channelStateChangeObserver = new BlsrSpanChannelStateChangeObserver();
    }

    public void init(IBlsrMapPane iBlsrMapPane) {
        if (BlsrEditMap.db.on) {
            db.println("init (pane=" + iBlsrMapPane + ")");
        }
        this.blsrMapPane = iBlsrMapPane;
    }

    public void linkSelected(MapLink mapLink, boolean bl) {
        if (BlsrEditMap.db.on) {
            db.finest("BlsrEditMap::linkSelected(link=" + mapLink + ", sel=" + bl + ")");
        }
        if (this.blsrMapPane != null) {
            this.blsrMapPane.linkSelected(mapLink, bl);
        }
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (BlsrEditMap.db.on) {
            db.finest("BlsrEditMap::nodeSelected(node=" + mapNode + ", sel=" + bl + ")");
        }
        this.blsrMapPane.nodeSelected(mapNode, bl);
    }

    public void extensionByteChanged(BlsrSpan blsrSpan, Integer n) {
        this.updateBlsrMapLinkState(blsrSpan);
    }

    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(new ProcessUpdateThread(observable, object));
    }

    public void processUpdate(Observable observable, Object object) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> processUpdate(Observable=" + observable + ", Object=" + object + ")");
        }
        if (!this.disposed) {
            if (observable instanceof BlsrNode) {
                BlsrNode blsrNode = (BlsrNode)((Object)observable);
                BlsrMapNode blsrMapNode = (BlsrMapNode)this.observedBlsrNodes.get(blsrNode);
                if (BlsrEditMap.db.on) {
                    db.println("in processUpdate() - blsrNode is:" + blsrNode + " bmn is: " + blsrMapNode);
                }
                if (object instanceof Short && blsrMapNode != null) {
                    short s = (Short)object;
                    switch (s) {
                        case 2: {
                            if (BlsrEditMap.db.on) {
                                db.println("NODE_ID_CHANGED");
                            }
                            blsrMapNode.setBlsrNodeId(blsrNode.getNodeId());
                            break;
                        }
                        case 7: {
                            if (BlsrEditMap.db.on) {
                                db.println("WEST_PROTECTION_OP_CHANGED");
                            }
                            this.applyLettersToNode(blsrMapNode);
                            break;
                        }
                        case 8: {
                            if (BlsrEditMap.db.on) {
                                db.println("EAST_PROTECTION_OP_CHANGED");
                            }
                            this.applyLettersToNode(blsrMapNode);
                        }
                    }
                } else if (BlsrEditMap.db.on) {
                    db.println("Error -- got an update from a BlsrNode, but the object was not a Short!");
                }
            }
        } else if (BlsrEditMap.db.on) {
            db.println("processUpdate ignored - we are disposing!");
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< processUpdate(Observable=" + observable + ", Object=" + object + ")");
        }
    }

    public BlsrRingModel getRingModel() {
        if (BlsrEditMap.db.on) {
            db.finer(">>> getRingModel()");
        }
        BlsrRingModel blsrRingModel = null;
        if (this.blsrMapPane != null) {
            blsrRingModel = this.blsrMapPane.getBlsrRingModel();
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< getRingModel()");
        }
        return blsrRingModel;
    }

    private void addBlsrSpan(BlsrSpan blsrSpan) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> ***** addBlsrSpan() called with arg BlsrSpan=" + blsrSpan);
        }
        BlsrNode blsrNode = blsrSpan.getEastSide();
        BlsrNode blsrNode2 = blsrSpan.getWestSide();
        if (null != blsrNode && !blsrNode.isDestroyed() && null != blsrNode2 && !blsrNode2.isDestroyed()) {
            blsrSpan.getBlsrExtensionByteNotifier().addObserver(this.extensionByteObserver);
            blsrSpan.getChannelStateNotifier().addObserver(this.channelStateChangeObserver);
            this.observedBlsrSpans.add(blsrSpan);
            NodeModel nodeModel = null;
            NodeModel nodeModel2 = null;
            BlsrMapNode blsrMapNode = null;
            BlsrMapNode blsrMapNode2 = null;
            INetLink iNetLink = null;
            if (null != blsrNode && null != blsrNode2 && !blsrNode.isDestroyed() && !blsrNode2.isDestroyed()) {
                nodeModel = blsrNode.getNodeModel();
                nodeModel2 = blsrNode2.getNodeModel();
                blsrMapNode = this.getBlsrMapNode(nodeModel);
                blsrMapNode2 = this.getBlsrMapNode(nodeModel2);
                if (null == blsrMapNode && null != nodeModel && null != blsrNode) {
                    this.addNode(nodeModel, true, blsrNode);
                }
                if (null == blsrMapNode2 && null != nodeModel2 && null != blsrNode2) {
                    this.addNode(nodeModel2, true, blsrNode2);
                }
                blsrMapNode = this.getBlsrMapNode(nodeModel);
                blsrMapNode2 = this.getBlsrMapNode(nodeModel2);
                if (null != blsrMapNode && null != blsrMapNode2) {
                    block31: {
                        BlsrMapLink blsrMapLink;
                        BlsrMapLinkCookie blsrMapLinkCookie;
                        BlsrPort blsrPort;
                        BlsrPort blsrPort2;
                        if (blsrSpan.isProtectSpan()) {
                            ITdmPortModel iTdmPortModel = blsrNode2.getWestProtectPort();
                            blsrPort2 = blsrMapNode2.getBlsrPort(iTdmPortModel, 1);
                            ITdmPortModel iTdmPortModel2 = blsrNode.getEastProtectPort();
                            blsrPort = blsrMapNode.getBlsrPort(iTdmPortModel2, 1);
                            blsrMapLinkCookie = new BlsrMapLinkCookie(blsrSpan, nodeModel, blsrPort, nodeModel2, blsrPort2);
                            this.addLink(blsrSpan, nodeModel, nodeModel2, null, blsrMapLinkCookie);
                            blsrMapLink = this.getBlsrMapLink(blsrSpan);
                        } else {
                            ITdmPortModel iTdmPortModel = blsrNode2.getWestPort();
                            blsrPort2 = blsrMapNode2.getBlsrPort(iTdmPortModel, 0);
                            ITdmPortModel iTdmPortModel3 = blsrNode.getEastPort();
                            blsrPort = blsrMapNode.getBlsrPort(iTdmPortModel3, 0);
                            blsrMapLinkCookie = new BlsrMapLinkCookie(blsrSpan, nodeModel, blsrPort, nodeModel2, blsrPort2);
                            iNetLink = this.getNetLink(blsrSpan);
                            this.addLink(iNetLink, nodeModel, nodeModel2, null, blsrMapLinkCookie);
                            blsrMapLink = this.getBlsrMapLink(blsrSpan);
                        }
                        BlsrMapPort blsrMapPort = (BlsrMapPort)blsrMapNode2.getPortWithUserObject(blsrPort2);
                        BlsrMapPort blsrMapPort2 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort);
                        if (BlsrEditMap.db.on) {
                            db.println("eastNodeModel is: " + nodeModel);
                            db.println("westNodeModel is: " + nodeModel2);
                            db.println("eastBlsrNode is: " + blsrNode);
                            db.println("westBlsrNode is: " + blsrNode2);
                            db.println("eastBlsrMapNode is: " + blsrMapNode);
                            db.println("westBlsrMapNode is: " + blsrMapNode2);
                            db.println("eastBlsrMapPort is: " + blsrMapPort2);
                            db.println("westBlsrMapPort is: " + blsrMapPort);
                            db.println("blsrMapLink is: " + blsrMapLink);
                        }
                        if (null != blsrMapLink) {
                            this.updateBlsrMapLinkState(blsrSpan);
                            if (null != blsrMapPort2 && null != blsrMapPort) {
                                blsrMapLink.setSourcePort(blsrMapPort2);
                                blsrMapLink.setTargetPort(blsrMapPort);
                            } else if (BlsrEditMap.db.on) {
                                db.println("*** eastBlsrMapPort or westBlsrMapPort is null ***");
                                db.println("eastBlsrMapPort=" + blsrMapPort2 + " and westBlsrMapPort=" + blsrMapPort);
                            }
                        } else if (BlsrEditMap.db.on) {
                            db.println("*** blsrMapLink is null ***");
                        }
                        try {
                            if (BlsrEditMap.db.on) {
                                db.println("eastBlsrMapPort=" + blsrMapPort2);
                                db.println("westBlsrMapPort=" + blsrMapPort);
                                db.println("blsrMapLink is: " + blsrMapLink);
                                db.println("blsrMapLink.getSrcLabel():" + blsrMapLink.getSrcLabel());
                                db.println("blsrMapLink.getTargetLabel():" + blsrMapLink.getTargetLabel());
                                db.println("blsrMapLink.getAnnotationText():" + blsrMapLink.getAnnotationText());
                                db.println("blsrMapLink.getSource():" + blsrMapLink.getSource());
                                db.println("blsrMapLink.getSourcePort():" + blsrMapLink.getSourcePort());
                                db.println("blsrMapLink.getTarget():" + blsrMapLink.getTarget());
                                db.println("blsrMapLink.getTargetPort():" + blsrMapLink.getTargetPort());
                                db.println("blsrMapLink.getUserObject():" + blsrMapLink.getUserObject());
                            }
                        }
                        catch (Exception exception) {
                            if (!BlsrEditMap.db.on) break block31;
                            db.println("Exception caught in db println block: " + exception);
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    this.applyLettersToNode(blsrMapNode);
                    this.applyLettersToNode(blsrMapNode2);
                } else if (BlsrEditMap.db.on) {
                    if (null == blsrMapNode) {
                        db.println("eastBlsrMapNode was null!");
                    }
                    if (null == blsrMapNode2) {
                        db.println("westBlsrMapNode was null!");
                    }
                }
            } else if (BlsrEditMap.db.on) {
                if (null == blsrNode) {
                    db.println("eastBlsrNode was null!");
                } else if (blsrNode.isDestroyed()) {
                    db.println("eastBlsrNode was destroyed!");
                }
                if (null == blsrNode2) {
                    db.println("westBlsrNode was null!");
                } else if (blsrNode2.isDestroyed()) {
                    db.println("westBlsrNode was destroyed!");
                }
            }
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< ***** addBlsrSpan() called with arg BlsrSpan=" + blsrSpan);
        }
    }

    public void updateBlsrMapLinkState(BlsrSpan blsrSpan) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> updateBlsrMapLinkState(span=" + blsrSpan + ")");
        }
        if (null != blsrSpan) {
            BlsrMapLink blsrMapLink = this.getBlsrMapLink(blsrSpan);
            if (null != blsrMapLink) {
                boolean bl;
                block19: {
                    bl = true;
                    try {
                        bl = blsrSpan.isExtensionByteInSync();
                    }
                    catch (Exception exception) {
                        db.println("Caught " + exception + " when calling isExtByteInSync!");
                        if (!db.on()) break block19;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                boolean bl2 = this.getRingModel().getBlsrRingInfo().isFourFiber();
                if (bl || bl2 && !blsrSpan.isProtectSpan()) {
                    db.fine("ext byte is in sync (" + bl + ") or " + "is4F (" + bl2 + ") and is working span (" + !blsrSpan.isProtectSpan() + ")");
                    short s = blsrSpan.getChannelState();
                    switch (s) {
                        case 0: {
                            if (BlsrEditMap.db.on) {
                                db.println("setting link to ACTIVE state/color");
                            }
                            blsrMapLink.setState(4);
                            break;
                        }
                        case 1: {
                            if (BlsrEditMap.db.on) {
                                db.println("setting link to STANDBY state/color");
                            }
                            blsrMapLink.setState(5);
                            break;
                        }
                        default: {
                            db.println("ERROR -- setting link to STANDBY state/color but it is really UNKNOWN!!!");
                            blsrMapLink.setState(4);
                            break;
                        }
                    }
                } else {
                    if (BlsrEditMap.db.on) {
                        db.println("extension byte is NOT in sync!");
                    }
                    blsrMapLink.setState(6);
                }
                blsrMapLink.reDraw();
                this.updateView();
            } else if (BlsrEditMap.db.on) {
                db.println("blsrMapLink is null!");
            }
        } else if (BlsrEditMap.db.on) {
            db.println("span is null!");
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< updateBlsrMapLinkState(span=" + blsrSpan + ")");
        }
    }

    private void applyLettersToNode(BlsrMapNode blsrMapNode) {
        BlsrMapNode blsrMapNode2 = (BlsrMapNode)blsrMapNode.getRealNode();
        MapNode[] mapNodeArray = blsrMapNode2.getVNodes();
        this.applyLettersToASingleNode(blsrMapNode2);
        if (db.on()) {
            db.println("applyLettersToASingleNode: " + blsrMapNode2);
        }
        for (int i = 0; i < mapNodeArray.length; ++i) {
            if (!(mapNodeArray[i] instanceof BlsrMapNode)) continue;
            BlsrMapNode blsrMapNode3 = (BlsrMapNode)mapNodeArray[i];
            this.applyLettersToASingleNode(blsrMapNode3);
            if (!db.on()) continue;
            db.println("applyLettersToASingleNode (virt): " + blsrMapNode3);
        }
    }

    private void applyLettersToASingleNode(BlsrMapNode blsrMapNode) {
        int n;
        IBlsrProtectionOp iBlsrProtectionOp;
        if (BlsrEditMap.db.on) {
            db.finer(">>> applyLettersToNode(BlsrMapNode=" + blsrMapNode + ")");
        }
        BlsrNode blsrNode = (BlsrNode)blsrMapNode.getUserCookie();
        ITdmPortModel iTdmPortModel = blsrNode.getWestPort();
        ITdmPortModel iTdmPortModel2 = blsrNode.getEastPort();
        BlsrPort blsrPort = blsrMapNode.getBlsrPort(iTdmPortModel, 0);
        BlsrPort blsrPort2 = blsrMapNode.getBlsrPort(iTdmPortModel2, 0);
        BlsrMapPort blsrMapPort = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort);
        BlsrMapPort blsrMapPort2 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort2);
        if (blsrMapPort == null) {
            blsrMapPort = (BlsrMapPort)blsrMapNode.getPortWithUserObject(iTdmPortModel);
        }
        if (blsrMapPort2 == null) {
            blsrMapPort2 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(iTdmPortModel2);
        }
        if (blsrMapPort != null) {
            iBlsrProtectionOp = blsrNode.getWestProtectionOp();
            n = iBlsrProtectionOp.getKOp();
            switch (n) {
                case 0: {
                    blsrMapPort.setLetter(' ');
                    break;
                }
                case 8: {
                    blsrMapPort.setLetter(' ');
                    break;
                }
                case 7: {
                    blsrMapPort.setLetter('E');
                    break;
                }
                case 6: {
                    blsrMapPort.setLetter('E');
                    break;
                }
                case 3: {
                    blsrMapPort.setLetter('F');
                    break;
                }
                case 2: {
                    blsrMapPort.setLetter('F');
                    break;
                }
                case 1: {
                    blsrMapPort.setLetter('L');
                    break;
                }
                case 5: {
                    blsrMapPort.setLetter('M');
                    break;
                }
                case 4: {
                    blsrMapPort.setLetter('M');
                    break;
                }
                default: {
                    if (BlsrEditMap.db.on) {
                        db.println("Unknown protection operation... " + n);
                    }
                    blsrMapPort.setLetter('O');
                }
            }
        }
        if (blsrMapPort2 != null) {
            iBlsrProtectionOp = blsrNode.getEastProtectionOp();
            n = iBlsrProtectionOp.getKOp();
            switch (n) {
                case 0: {
                    blsrMapPort2.setLetter(' ');
                    break;
                }
                case 8: {
                    blsrMapPort2.setLetter(' ');
                    break;
                }
                case 7: {
                    blsrMapPort2.setLetter('E');
                    break;
                }
                case 6: {
                    blsrMapPort2.setLetter('E');
                    break;
                }
                case 3: {
                    blsrMapPort2.setLetter('F');
                    break;
                }
                case 2: {
                    blsrMapPort2.setLetter('F');
                    break;
                }
                case 1: {
                    blsrMapPort2.setLetter('L');
                    break;
                }
                case 5: {
                    blsrMapPort2.setLetter('M');
                    break;
                }
                case 4: {
                    blsrMapPort2.setLetter('M');
                    break;
                }
                default: {
                    if (BlsrEditMap.db.on) {
                        db.println("Unknown protection operation... " + n);
                    }
                    blsrMapPort2.setLetter('O');
                }
            }
        }
        blsrMapNode.reDraw();
        this.updateView();
        if (BlsrEditMap.db.on) {
            db.finer("<<< applyLettersToNode(BlsrMapNode=" + blsrMapNode + ")");
        }
    }

    public void doubleClicked(MapLink mapLink) {
        if (BlsrEditMap.db.on) {
            db.println("doubleClicked(mapLInk=" + mapLink + ")");
        }
        if (this.blsrMapPane != null) {
            this.blsrMapPane.doubleClicked(mapLink);
        }
    }

    public synchronized void dispose() {
        if (BlsrEditMap.db.on) {
            db.finer(">>> dispose()");
        }
        this.localDispose();
        this.extensionByteObserver = null;
        this.channelStateChangeObserver = null;
        this.container = null;
        this.blsrMapPane = null;
        super.dispose();
        if (BlsrEditMap.db.on) {
            db.finer("<<< dispose()");
        }
    }

    public synchronized void localDispose() {
        block8: {
            if (BlsrEditMap.db.on) {
                db.finer(">>> localDispose()");
            }
            try {
                if (!this.observedBlsrNodes.isEmpty()) {
                    for (Object object : this.observedBlsrNodes.keySet()) {
                        object.deleteObserver((Observer)this);
                        if (!BlsrEditMap.db.on) continue;
                        db.println(" -- just deleted myself as an observer for BlsrNode:" + object);
                    }
                    this.observedBlsrNodes.clear();
                }
                if (!this.observedBlsrSpans.isEmpty()) {
                    for (Object object : this.observedBlsrSpans) {
                        ((BlsrSpan)object).getBlsrExtensionByteNotifier().deleteObserver(this.extensionByteObserver);
                        ((BlsrSpan)object).getChannelStateNotifier().deleteObserver(this.channelStateChangeObserver);
                    }
                    this.observedBlsrSpans.clear();
                }
                this.reInitMapToDetailed();
            }
            catch (Exception exception) {
                if (!BlsrEditMap.db.on) break block8;
                db.println("Exception thrown is: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< localDispose()");
        }
    }

    public synchronized void showBlsr() {
        BlsrRingModel blsrRingModel;
        if (BlsrEditMap.db.on) {
            db.finer(">>> showBlsr()");
        }
        if ((blsrRingModel = this.getRingModel()) != null) {
            if (db.on()) {
                db.println("***************************************");
                db.println("calling showBlsr() with ringModel: " + blsrRingModel);
                BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
                for (int i = 0; i < blsrNodeArray.length; ++i) {
                    db.println("  node is: " + blsrNodeArray[i]);
                }
                BlsrSpan[] blsrSpanArray = blsrRingModel.getWorkingBlsrSpans();
                for (int i = 0; i < blsrSpanArray.length; ++i) {
                    db.println("  workingSpan is: " + blsrSpanArray[i]);
                }
                try {
                    BlsrSpan[] blsrSpanArray2 = blsrRingModel.getProtectBlsrSpans();
                    for (int i = 0; i < blsrSpanArray2.length; ++i) {
                        db.println("  protectSpan is: " + blsrSpanArray2[i]);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    db.println("IllegalStateException caught in showBlsr(): " + illegalStateException);
                    db.println("  This can happen when a ring is being deleted.");
                }
                db.println("***************************************");
            }
            this.showBlsr(blsrRingModel);
        } else if (BlsrEditMap.db.on) {
            db.println("showBlsr() called and ringModel is null!");
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< showBlsr()");
        }
    }

    private synchronized void showBlsr(BlsrRingModel blsrRingModel) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> showBlsr(BlsrRingModel=" + blsrRingModel + ") ringModel.getRingName()=" + blsrRingModel.getRingName());
        }
        if (!this.disposed) {
            Object object;
            boolean bl = true;
            String string = this.getCurrentDomainName();
            this.localDispose();
            BlsrSpan[] blsrSpanArray = blsrRingModel.getWorkingBlsrSpans();
            if (blsrSpanArray.length == 0) {
                if (BlsrEditMap.db.on) {
                    db.println("NO EXISTING WORKING SPANS!!!");
                }
                bl = false;
                object = blsrRingModel.getBlsrNodes();
                if (((BlsrNode[])object).length == 0) {
                    if (BlsrEditMap.db.on) {
                        db.println("NO NODES EITHER!!!");
                    }
                    this.disposed = true;
                } else {
                    this.addOnlyNodes((BlsrNode[])object);
                }
            } else {
                for (int i = 0; i < blsrSpanArray.length; ++i) {
                    object = blsrSpanArray[i];
                    if (BlsrEditMap.db.on) {
                        db.println("span is: " + blsrSpanArray[i] + " and it's hashCode is: " + blsrSpanArray[i].hashCode());
                    }
                    this.addBlsrSpan((BlsrSpan)object);
                }
            }
            if (bl) {
                BlsrNode blsrNode;
                block32: {
                    try {
                        object = blsrRingModel.getProtectBlsrSpans();
                        if (((BlsrNode[])object).length == 0) {
                            if (BlsrEditMap.db.on) {
                                db.println("NO EXISTING PROTECT SPANS!!!");
                            }
                        } else {
                            if (BlsrEditMap.db.on) {
                                db.println("The number of protect spans is: " + ((BlsrNode[])object).length);
                            }
                            for (int i = 0; i < ((BlsrNode[])object).length; ++i) {
                                BlsrNode blsrNode2 = object[i];
                                if (BlsrEditMap.db.on) {
                                    db.println("protectSpans is: " + object[i] + " and it's hashCode is: " + ((BlsrSpan)((Object)object[i])).hashCode());
                                }
                                blsrNode = ((BlsrSpan)((Object)blsrNode2)).getEastSide();
                                BlsrNode blsrNode3 = ((BlsrSpan)((Object)blsrNode2)).getWestSide();
                                if (!blsrNode.isDestroyed() && !blsrNode3.isDestroyed()) {
                                    this.addBlsrSpan((BlsrSpan)((Object)blsrNode2));
                                    continue;
                                }
                                if (!BlsrEditMap.db.on) continue;
                                db.println("  for a protect span -- one of the nodes IS ALREADY DESTROYED!!!");
                            }
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!BlsrEditMap.db.on) break block32;
                        db.println("IllegalStateException caught.  This can happen when the ring is being deleted.");
                    }
                }
                object = this.getMapNodes();
                BlsrMapNode blsrMapNode = null;
                Object var7_12 = null;
                blsrNode = null;
                for (int i = 0; i < ((BlsrNode[])object).length; ++i) {
                    blsrMapNode = (BlsrMapNode)((Object)object[i]);
                    BlsrNode blsrNode4 = (BlsrNode)blsrMapNode.getUserCookie();
                    if (null == blsrNode4 || blsrNode4.isDestroyed()) continue;
                    blsrMapNode.setBlsrNodeId(blsrNode4.getNodeId());
                    this.observeNode(blsrNode4, blsrMapNode);
                    BlsrSpan blsrSpan = blsrNode4.getEastMain();
                    if (null != blsrSpan) {
                        BlsrPort blsrPort = blsrMapNode.getBlsrPort(blsrNode4.getEastPort(), 0);
                        BlsrPort blsrPort2 = blsrMapNode.getBlsrPort(blsrNode4.getWestPort(), 0);
                        BlsrPort blsrPort3 = blsrMapNode.getBlsrPort(blsrNode4.getEastProtectPort(), 1);
                        BlsrPort blsrPort4 = blsrMapNode.getBlsrPort(blsrNode4.getWestProtectPort(), 1);
                        BlsrMapPort blsrMapPort = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort);
                        BlsrMapPort blsrMapPort2 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort2);
                        BlsrMapPort blsrMapPort3 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort3);
                        BlsrMapPort blsrMapPort4 = (BlsrMapPort)blsrMapNode.getPortWithUserObject(blsrPort4);
                        if (db.on()) {
                            db.println("++++++++++++++++++++++++++++++");
                            db.println("eastBlsrPort is:" + blsrPort);
                            db.println("westBlsrPort is:" + blsrPort2);
                            db.println("eastProtectBlsrPort is:" + blsrPort3);
                            db.println("westProtectBlsrPort is:" + blsrPort4);
                            db.println("eastWorkingBlsrMapPort is:" + blsrMapPort);
                            db.println("westWorkingBlsrMapPort is:" + blsrMapPort2);
                            db.println("eastProtectBlsrMapPort is:" + blsrMapPort3);
                            db.println("westProtectBlsrMapPort is:" + blsrMapPort4);
                            db.println("++++++++++++++++++++++++++++++");
                        }
                        if (blsrMapPort != null) {
                            blsrMapPort.setEastWest(2);
                        }
                        if (blsrMapPort3 != null) {
                            blsrMapPort3.setEastWest(3);
                        }
                        if (blsrMapPort2 != null) {
                            blsrMapPort2.setEastWest(0);
                        }
                        if (blsrMapPort4 == null) continue;
                        blsrMapPort4.setEastWest(1);
                        continue;
                    }
                    if (!BlsrEditMap.db.on) continue;
                    db.println("Got a null eastSpan! For node=" + blsrNode4);
                }
            }
            if (string != null) {
                try {
                    this.displayDomain(string);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    this.displayDomain("");
                }
            }
        } else if (BlsrEditMap.db.on) {
            db.println("ignoring call to showBlsr - we're disposing!");
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< showBlsr(BlsrRingModel=" + blsrRingModel + ")   ringModel.getRingName()=" + blsrRingModel.getRingName());
        }
    }

    private boolean isWestPort(Object object) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> isWestPort(Object=" + object + ")");
        }
        boolean bl = false;
        if (object instanceof BlsrMapPort) {
            BlsrMapPort blsrMapPort = (BlsrMapPort)object;
            ITdmPortModel iTdmPortModel = blsrMapPort.getITdmPortModelFromKey(blsrMapPort.getUserObject());
            BlsrMapNode blsrMapNode = (BlsrMapNode)blsrMapPort.getParentNode();
            BlsrNode blsrNode = (BlsrNode)blsrMapNode.getUserCookie();
            ITdmPortModel iTdmPortModel2 = blsrNode.getWestPort();
            ITdmPortModel iTdmPortModel3 = blsrNode.getWestProtectPort();
            bl = iTdmPortModel.equals(iTdmPortModel2) || iTdmPortModel.equals(iTdmPortModel3);
        } else if (BlsrEditMap.db.on) {
            db.println("This object is not a BlsrMapPort: " + object);
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< isWestPort(Object=" + object + ")");
        }
        return bl;
    }

    public void initPopupMenu(Object object, ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu) {
        super.initPopupMenu(object, actionOrganizer, uPopupMenu);
        if (object instanceof MapPort) {
            this.popupMapPort = (MapPort)object;
            this.popupMapNode = this.popupMapPort.getParentNode();
            this.initPortPopupMenu(actionOrganizer, uPopupMenu, this.isWestPort(this.popupMapPort));
        } else if (object instanceof DetailedMapNode) {
            INodeModel iNodeModel;
            this.popupMapNode = (MapNode)object;
            if (this.isProvisioningAllowed()) {
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_NODE_ID, 78);
            }
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_SQUELCH_TABLE, 83);
            Object object2 = ((DetailedMapNode)object).getUserObject();
            if (object2 instanceof INodeModel && (iNodeModel = (INodeModel)object2).provides(Feature.BLSR_UPSR_DRI)) {
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_RIP_TABLE, 82);
            }
        } else if (object instanceof MapLink) {
            this.popupMapLink = (MapLink)object;
            if (null != this.popupMapLink && this.popupMapLink instanceof BlsrMapLink) {
                BlsrMapLink blsrMapLink = (BlsrMapLink)this.popupMapLink;
                BlsrSpan blsrSpan = blsrMapLink.getBlsrSpan();
                if (null != blsrSpan) {
                    boolean bl = this.getRingModel().getBlsrRingInfo().isFourFiber();
                    if ((blsrSpan.isExtensionByteEditable() || !blsrSpan.isExtensionByteInSync()) && this.isProvisioningAllowed() && (!bl || bl && blsrSpan.isProtectSpan())) {
                        actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_EXTENSION_BYTE, 88);
                        IEntityModel iEntityModel = blsrMapLink.getSrcEntity();
                        IEntityModel iEntityModel2 = blsrMapLink.getDstEntity();
                        if (iEntityModel != null && iEntityModel.getEqType() == 61 || iEntityModel2 != null && iEntityModel2.getEqType() == 61) {
                            actionOrganizer.setEnabled(CMD_SET_EXTENSION_BYTE, false);
                        }
                    }
                } else if (BlsrEditMap.db.on) {
                    db.println("The blsrSpan is null!");
                }
            }
        }
    }

    public void doubleClicked(MapPort mapPort) {
        if (mapPort instanceof BlsrMapPort) {
            this.jumpToPortView((BlsrMapPort)mapPort);
        }
    }

    private void jumpToPortView(MapPort mapPort) {
        if (mapPort instanceof BlsrMapPort) {
            BlsrMapPort blsrMapPort = (BlsrMapPort)mapPort;
            try {
                ITdmPortModel iTdmPortModel = blsrMapPort.getITdmPortModelFromKey(blsrMapPort.getUserObject());
                BlsrMapNode blsrMapNode = (BlsrMapNode)blsrMapPort.getParentNode();
                BlsrNode blsrNode = (BlsrNode)blsrMapNode.getUserCookie();
                NodeModel nodeModel = blsrNode.getNodeModel();
                int n = 0;
                if (nodeModel.provides(Feature.MULTISHELF) && nodeModel.isMultishelf()) {
                    n = iTdmPortModel.getShelfId();
                }
                ViewName viewName = new ViewName(new int[]{nodeModel.getNodeId(), n, iTdmPortModel.getSlot()});
                this.tryJumpView(viewName);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void initPortPopupMenu(ActionOrganizer actionOrganizer, UPopupMenu uPopupMenu, boolean bl) {
        if (bl) {
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_OPEN_WEST_PORT, 79);
        } else {
            actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_OPEN_EAST_PORT, 79);
        }
        if (this.isMaintenanceAllowed()) {
            if (bl) {
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_WEST_PROTECTION_OP, 87);
            } else {
                actionOrganizer.addMenuItem((JComponent)uPopupMenu, null, CMD_SET_EAST_PROTECTION_OP, 69);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (BlsrEditMap.db.on) {
            db.finer(">>> actionPerformed(e=" + actionEvent + ")");
        }
        if ((string = actionEvent.getActionCommand()).equals(CMD_SET_NODE_ID)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_SET_NODE_ID");
            }
            BlsrNode blsrNode = (BlsrNode)this.popupMapNode.getUserCookie();
            NodeIdDialog nodeIdDialog = new NodeIdDialog(this.container, this.getRingModel(), blsrNode);
            nodeIdDialog.setVisible(true);
        } else if (string.equals(CMD_SQUELCH_TABLE)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_SQUELCH_TABLE");
            }
            BlsrNode blsrNode = (BlsrNode)this.popupMapNode.getUserCookie();
            NodeModel nodeModel = blsrNode.getNodeModel();
            boolean bl = Feature.provides((INodeModel)nodeModel, (Feature)Feature.VT_SQUELCHING);
            IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(nodeModel).createEntityCellRenderer((INodeModel)nodeModel, "slot ");
            SquelchTableDialog squelchTableDialog = new SquelchTableDialog(this.container, iEntityCellRenderer, blsrNode.getBlsrModel(), bl &= blsrNode.getNodeModel().getTdmProtocolTypeObj().isSonet());
            squelchTableDialog.setVisible(true);
        } else if (string.equals(CMD_RIP_TABLE)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_RIP_TABLE");
            }
            BlsrNode blsrNode = (BlsrNode)this.popupMapNode.getUserCookie();
            RipTableDialog ripTableDialog = new RipTableDialog(this.container, this.getRingModel(), blsrNode);
            ripTableDialog.setVisible(true);
        } else if (string.equals(CMD_OPEN_EAST_PORT) || string.equals(CMD_OPEN_WEST_PORT)) {
            this.jumpToPortView(this.popupMapPort);
        } else if (string.equals(CMD_SET_EAST_PROTECTION_OP)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_SET_EAST_PROTECTION_OP");
            }
            if (BlsrEditMap.db.on) {
                db.println("popupMapNode=" + this.popupMapNode);
            }
            BlsrNode blsrNode = (BlsrNode)this.popupMapNode.getUserCookie();
            if (BlsrEditMap.db.on) {
                db.println("blsrNode is: " + blsrNode);
            }
            SetProtectionOpDialog setProtectionOpDialog = new SetProtectionOpDialog(this.container, this.getRingModel(), blsrNode, false);
            setProtectionOpDialog.setVisible(true);
        } else if (string.equals(CMD_SET_WEST_PROTECTION_OP)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_SET_WEST_PROTECTION_OP");
            }
            if (BlsrEditMap.db.on) {
                db.println("popupMapNode=" + this.popupMapNode);
            }
            BlsrNode blsrNode = (BlsrNode)this.popupMapNode.getUserCookie();
            if (BlsrEditMap.db.on) {
                db.println("blsrNode is: " + blsrNode);
            }
            SetProtectionOpDialog setProtectionOpDialog = new SetProtectionOpDialog(this.container, this.getRingModel(), blsrNode, true);
            setProtectionOpDialog.setVisible(true);
        } else if (string.equals(CMD_SET_EXTENSION_BYTE)) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_SET_EXTENSION_BYTE");
            }
            if (this.popupMapLink != null && this.popupMapLink instanceof BlsrMapLink) {
                BlsrMapLink blsrMapLink = (BlsrMapLink)this.popupMapLink;
                BlsrSpan blsrSpan = blsrMapLink.getBlsrSpan();
                if (blsrSpan != null && blsrSpan instanceof BlsrSpan) {
                    BlsrSpan blsrSpan2 = blsrSpan;
                    if (BlsrEditMap.db.on) {
                        db.println("the BlsrSpan is: " + blsrSpan2);
                    }
                    SetExtensionByteDialog setExtensionByteDialog = new SetExtensionByteDialog(this.container, this.getRingModel(), blsrSpan2);
                    setExtensionByteDialog.setVisible(true);
                } else if (BlsrEditMap.db.on) {
                    db.println("popupMapLink getBlsrSpan() object is not a BlsrSpan: " + blsrSpan);
                }
            } else if (BlsrEditMap.db.on) {
                db.println("popupMapLink is not a BlsrMapLink: " + this.popupMapLink);
            }
        } else if (string == CMD_LINK_CIRCUITS) {
            if (BlsrEditMap.db.on) {
                db.println("CMD_LINK_CIRCUITS");
            }
        } else {
            super.actionPerformed(actionEvent);
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< actionPerformed(e=" + actionEvent + ")");
        }
    }

    private void addOnlyNodes(BlsrNode[] blsrNodeArray) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> addOnlyNodes()");
        }
        BlsrNode blsrNode = null;
        for (int i = 0; i < blsrNodeArray.length; ++i) {
            blsrNode = blsrNodeArray[i];
            this.addBlsrNode(blsrNode);
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< addOnlyNodes()");
        }
    }

    private void observeNode(BlsrNode blsrNode, BlsrMapNode blsrMapNode) {
        if (BlsrEditMap.db.on) {
            db.println(" -- just became an observer for BlsrNode:" + blsrNode);
        }
        blsrNode.addObserver(this);
        this.observedBlsrNodes.put(blsrNode, blsrMapNode);
    }

    private void addBlsrNode(BlsrNode blsrNode) {
        if (BlsrEditMap.db.on) {
            db.finer(">>> addBlsrNode(aNode=" + blsrNode + ")");
        }
        if (null != blsrNode && !blsrNode.isDestroyed()) {
            this.addNode(blsrNode.getNodeModel(), true, blsrNode);
            BlsrMapNode blsrMapNode = (BlsrMapNode)this.getMapNode(blsrNode.getNodeModel());
            if (null != blsrMapNode) {
                BlsrRingInfo blsrRingInfo;
                this.observeNode(blsrNode, blsrMapNode);
                ITdmPortModel iTdmPortModel = null;
                ITdmPortModel iTdmPortModel2 = null;
                ITdmPortModel iTdmPortModel3 = null;
                ITdmPortModel iTdmPortModel4 = null;
                iTdmPortModel = blsrNode.getEastPort();
                iTdmPortModel2 = blsrNode.getWestPort();
                MapPort mapPort = blsrMapNode.addPort(null, null);
                mapPort.init(iTdmPortModel, null);
                MapPort mapPort2 = blsrMapNode.addPort(null, null);
                mapPort2.init(iTdmPortModel2, null);
                BlsrRingModel blsrRingModel = this.getRingModel();
                if (null != blsrRingModel && null != (blsrRingInfo = blsrRingModel.getBlsrRingInfo())) {
                    if (blsrRingInfo.isFourFiber()) {
                        iTdmPortModel3 = blsrNode.getEastProtectPort();
                        iTdmPortModel4 = blsrNode.getWestProtectPort();
                        MapPort mapPort3 = blsrMapNode.addPort(null, null);
                        mapPort3.init(iTdmPortModel3, null);
                        MapPort mapPort4 = blsrMapNode.addPort(null, null);
                        mapPort4.init(iTdmPortModel4, null);
                    }
                    this.applyLettersToNode(blsrMapNode);
                }
            }
        }
        if (BlsrEditMap.db.on) {
            db.finer("<<< addBlsrNode(aNode=" + blsrNode + ")");
        }
    }

    public void updateView() {
        if (!this.disposed) {
            super.updateView();
        }
    }

    private class BlsrSpanChannelStateChangeUpdaterThread
    implements Runnable {
        private Observable o = null;
        private Object arg = null;

        public BlsrSpanChannelStateChangeUpdaterThread(Observable observable, Object object) {
            this.o = observable;
            this.arg = object;
        }

        public void run() {
            if (db.on) {
                db.finer(">>> BlsrSpanChannelStateChangeObserver update");
            }
            if (this.arg instanceof BlsrSpan) {
                short s;
                BlsrSpan blsrSpan = (BlsrSpan)this.arg;
                if (db.on) {
                    db.println("=========== Got a message from a BlsrSpan...  ===============");
                    db.println("It was: " + blsrSpan);
                }
                if (0 == (s = blsrSpan.getChannelState())) {
                    if (db.on) {
                        db.println("The channel state should change to: ACTIVE");
                    }
                } else if (1 == s) {
                    if (db.on) {
                        db.println("The channel state should change to: STANDBY");
                    }
                } else if (db.on) {
                    db.println("The channel state should change to: UNKNOWN -> " + s);
                }
                BlsrEditMap.this.updateBlsrMapLinkState(blsrSpan);
            } else if (db.on) {
                db.println("arg is not a BlsrSpan: " + this.arg);
            }
            if (db.on) {
                db.finer("<<< BlsrSpanChannelStateChangeObserver update");
            }
        }
    }

    private class BlsrSpanExtensionByteUpdaterThread
    implements Runnable {
        private Observable o = null;
        private Object arg = null;

        public BlsrSpanExtensionByteUpdaterThread(Observable observable, Object object) {
            this.o = observable;
            this.arg = object;
        }

        public void run() {
            if (db.on) {
                db.finer(">>> BlsrSpanExtensionByteObserver update");
            }
            BlsrSpan blsrSpan = ((BlsrSpan.LineModelNotifier)((Object)this.o)).getSpan();
            Integer n = (Integer)this.arg;
            BlsrEditMap.this.extensionByteChanged(blsrSpan, n);
            if (db.on) {
                db.finer("<<< BlsrSpanExtensionByteObserver update");
            }
        }
    }

    private class ProcessUpdateThread
    implements Runnable {
        private Observable ob = null;
        private Object o = null;

        public ProcessUpdateThread(Observable observable, Object object) {
            this.ob = observable;
            this.o = object;
        }

        public void run() {
            BlsrEditMap.this.processUpdate(this.ob, this.o);
        }
    }

    private class SetExtensionByteDialog
    extends UDialog
    implements ActionListener {
        private BlsrRingModel ringModel;
        private BlsrSpan blsrSpan;
        private JButton closeButton;
        private UComboBox extensionCB;
        private DefaultComboBoxModel comboBoxModel;
        private final int SELECTION_INCONSISTENT = 0;
        private final int SELECTION_K3 = 1;
        private final int SELECTION_Z2 = 2;
        private final int SELECTION_E2 = 3;
        private final int SELECTION_F1 = 4;

        public SetExtensionByteDialog(Frame frame, BlsrRingModel blsrRingModel, BlsrSpan blsrSpan) {
            super(frame, "SetExtensionByteDialog", true);
            this.SELECTION_INCONSISTENT = 0;
            this.SELECTION_K3 = 1;
            this.SELECTION_Z2 = 2;
            this.SELECTION_E2 = 3;
            this.SELECTION_F1 = 4;
            this.setTitle("Set Extension Byte for span: " + blsrSpan);
            this.ringModel = blsrRingModel;
            this.blsrSpan = blsrSpan;
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            JButton jButton = new JButton("OK");
            jButton.setActionCommand("okButton");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Close");
            jButton2.setActionCommand("closeButton");
            jButton2.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            this.comboBoxModel = new DefaultComboBoxModel();
            this.comboBoxModel.addElement("INCONSISTENT");
            this.comboBoxModel.addElement("K3");
            this.comboBoxModel.addElement("Z2");
            this.comboBoxModel.addElement("E2");
            this.comboBoxModel.addElement("F1");
            this.extensionCB = new UComboBox((ComboBoxModel)this.comboBoxModel);
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            gridBagPanel.align(17);
            gridBagPanel.fillNone();
            gridBagPanel.pad(10, 20);
            gridBagPanel.add((Component)new JLabel("New Extension Byte setting:"), 0, 0);
            gridBagPanel.fill(2);
            gridBagPanel.add((Component)this.extensionCB, 1, 0);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)gridBagPanel, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.pack();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                try {
                    int n = this.blsrSpan.getExtensionByte();
                    this.setCBSelection(n);
                    if (db.on) {
                        db.println("isExtensionByteEditable():" + this.blsrSpan.isExtensionByteEditable());
                        db.println("isExtensionByteInSync():" + this.blsrSpan.isExtensionByteInSync());
                        db.println("getExtensionByte():" + n);
                    }
                }
                catch (Exception exception) {
                    if (db.on) {
                        db.println("Exception caught was: " + exception);
                    }
                    this.extensionCB.setSelectedIndex(0);
                }
            }
            super.setVisible(bl);
        }

        private void setCBSelection(int n) {
            switch (n) {
                case 0: {
                    this.extensionCB.setSelectedIndex(1);
                    break;
                }
                case 1: {
                    this.extensionCB.setSelectedIndex(2);
                    break;
                }
                case 2: {
                    this.extensionCB.setSelectedIndex(3);
                    break;
                }
                case 3: {
                    this.extensionCB.setSelectedIndex(4);
                    break;
                }
                default: {
                    this.extensionCB.setSelectedIndex(0);
                }
            }
        }

        private int getExtgensionByteFromCB() {
            int n = this.extensionCB.getSelectedIndex();
            int n2 = -1;
            switch (n) {
                case 0: {
                    n2 = -1;
                    break;
                }
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 1;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            if (db.on) {
                db.println("getExtensionByteFromCB is returning:" + n2);
            }
            return n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("okButton")) {
                int n = this.getExtgensionByteFromCB();
                if (db.on) {
                    db.println("I would Set the value here... value would be: " + n);
                }
                try {
                    if (n != -1) {
                        this.blsrSpan.setExtensionByte(n);
                    } else {
                        String string2 = "The extension byte value will be ignored because it cannot be set to INCONSISTENT.";
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_EXTENSION_BYTE_SETTING_PARAM_1, (Object)string2);
                    }
                }
                catch (OnlyK3Exception onlyK3Exception) {
                    String string3 = "The only valid choice is the K3 byte because only one side of the span is editable.";
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_EXTENSION_BYTE_SETTING_PARAM_1, (Object)string3);
                }
                catch (ByteInUseException byteInUseException) {
                    String string4 = "An overhead circuit is in use on this span.\n";
                    string4 = string4 + "Since the overhead circuit is using that byte, this setting is not allowed.";
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_EXTENSION_BYTE_SETTING_PARAM_1, (Object)string4);
                }
                catch (NeitherExtensionByteEditableException neitherExtensionByteEditableException) {
                    String string5 = "Neither side of this span is modifiable.";
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_SET_EXTENSION_BYTE_PARAM_1, (Object)string5);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    String string6 = "This value (" + n + ") is not a legal setting for the extension byte.";
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_EXTENSION_BYTE_SETTING_PARAM_1, (Object)string6);
                }
                catch (Exception exception) {
                    db.println("Unexpected exception caught:" + exception);
                }
                if (db.on) {
                    db.println("Value was set to: " + n);
                }
                this.setVisible(false);
                this.dispose();
            }
            if (string.equals("closeButton")) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private class RipTableModel
    extends AbstractTableModel {
        private BlsrNode blsrNode;
        private BlsrRingModel ringModel;
        private IRipTblEntry[] ripEntries;
        private String stsTerm;
        private String[] columnNames;
        private static final int NON_RINGED_NODE_ID = 255;
        private final String BLANK_STRING = new String();
        private ITdmProtocolType pType;
        Object MISMATCH_OBJECT = null;

        public RipTableModel(BlsrNode blsrNode, BlsrRingModel blsrRingModel) {
            this.blsrNode = blsrNode;
            this.ringModel = blsrRingModel;
            NodeModel nodeModel = blsrNode.getNodeModel();
            this.pType = TdmProtocolType.getTdmProtocolType((int)nodeModel.getTdmProtocolType());
            this.ripEntries = blsrNode.getRipData();
            this.stsTerm = nodeModel.getTDMTerminology().getGeneralTerms(0);
            if (this.stsTerm == null) {
                this.stsTerm = "";
            }
            this.columnNames = new String[9];
            this.columnNames[0] = this.stsTerm + " Number";
            this.columnNames[1] = "East In " + this.stsTerm + " Pri";
            this.columnNames[2] = "East In " + this.stsTerm + " Term";
            this.columnNames[3] = "East Out " + this.stsTerm + " Pri";
            this.columnNames[4] = "East Out " + this.stsTerm + " Term";
            this.columnNames[5] = "West In " + this.stsTerm + " Pri";
            this.columnNames[6] = "West In " + this.stsTerm + " Term";
            this.columnNames[7] = "West Out " + this.stsTerm + " Pri";
            this.columnNames[8] = "West Out " + this.stsTerm + " Term";
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            if (this.pType.isSonet()) {
                return this.ripEntries.length;
            }
            return this.ripEntries.length / 3;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        private Object formatNodeId(short s) {
            Object object = null;
            object = s == 255 ? (Object)null : new Integer(s);
            return object;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            boolean bl = !this.pType.isSonet();
            int n3 = n * 3;
            int n4 = n3 + 1;
            int n5 = n3 + 2;
            switch (n2) {
                case 0: {
                    boolean bl2 = this.ringModel.getBlsrRingInfo().isFourFiber();
                    if (!bl2) {
                        int n6 = this.getRowCount();
                        object = new Integer(n6 + n + 1);
                    } else {
                        object = new Integer(n + 1);
                    }
                    if (!db.on() || !bl) break;
                    object = "[row = " + n + ": " + n3 + " -> " + n4 + " -> " + n5 + "] " + object;
                    break;
                }
                case 1: {
                    if (bl) {
                        short s = this.ripEntries[n3].getEastInStsPri();
                        short s2 = this.ripEntries[n4].getEastInStsPri();
                        short s3 = this.ripEntries[n5].getEastInStsPri();
                        if (s != s2 || s2 != s3) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getEastInStsPri());
                    break;
                }
                case 2: {
                    if (bl) {
                        short s = this.ripEntries[n3].getEastInStsTerm();
                        short s4 = this.ripEntries[n4].getEastInStsTerm();
                        short s5 = this.ripEntries[n5].getEastInStsTerm();
                        if (s != s4 || s4 != s5) {
                            return this.MISMATCH_OBJECT;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getEastInStsTerm());
                    break;
                }
                case 3: {
                    if (bl) {
                        short s = this.ripEntries[n3].getEastOutStsPri();
                        short s6 = this.ripEntries[n4].getEastOutStsPri();
                        short s7 = this.ripEntries[n5].getEastOutStsPri();
                        if (s != s6 || s6 != s7) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getEastOutStsPri());
                    break;
                }
                case 4: {
                    if (bl) {
                        short s = this.ripEntries[n3].getEastOutStsTerm();
                        short s8 = this.ripEntries[n4].getEastOutStsTerm();
                        short s9 = this.ripEntries[n5].getEastOutStsTerm();
                        if (s != s8 || s8 != s9) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getEastOutStsTerm());
                    break;
                }
                case 5: {
                    if (bl) {
                        short s = this.ripEntries[n3].getWestInStsPri();
                        short s10 = this.ripEntries[n4].getWestInStsPri();
                        short s11 = this.ripEntries[n5].getWestInStsPri();
                        if (s != s10 || s10 != s11) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getWestInStsPri());
                    break;
                }
                case 6: {
                    if (bl) {
                        short s = this.ripEntries[n3].getWestInStsTerm();
                        short s12 = this.ripEntries[n4].getWestInStsTerm();
                        short s13 = this.ripEntries[n5].getWestInStsTerm();
                        if (s != s12 || s12 != s13) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getWestInStsTerm());
                    break;
                }
                case 7: {
                    if (bl) {
                        short s = this.ripEntries[n3].getWestOutStsPri();
                        short s14 = this.ripEntries[n4].getWestOutStsPri();
                        short s15 = this.ripEntries[n5].getWestOutStsPri();
                        if (s != s14 || s14 != s15) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getWestOutStsPri());
                    break;
                }
                case 8: {
                    if (bl) {
                        short s = this.ripEntries[n3].getWestOutStsTerm();
                        short s16 = this.ripEntries[n4].getWestOutStsTerm();
                        short s17 = this.ripEntries[n5].getWestOutStsTerm();
                        if (s != s16 || s16 != s17) {
                            object = this.MISMATCH_OBJECT;
                            break;
                        }
                        object = this.formatNodeId(s);
                        break;
                    }
                    object = this.formatNodeId(this.ripEntries[n].getWestOutStsTerm());
                    break;
                }
                default: {
                    object = null;
                }
            }
            return object;
        }
    }

    private class RipTableDialog
    extends UDialog
    implements ActionListener {
        private BlsrRingModel ringModel;
        private BlsrNode blsrNode;
        private JTable ripTable;
        private JButton closeButton;
        private RipTableModel ripTableModel;

        public RipTableDialog(Frame frame, BlsrRingModel blsrRingModel, BlsrNode blsrNode) {
            super(frame, "RipTableDialog", true);
            this.setTitle("Rip Table for node: " + CoreConstants.GetActualAddress((String)blsrNode.getNodeModel().getHostName()) + "  Name=" + blsrRingModel.getRingName());
            this.ringModel = blsrRingModel;
            this.blsrNode = blsrNode;
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            JButton jButton = new JButton("Close");
            jButton.setActionCommand("closeButton");
            jButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jButton);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            jPanel.setLayout(new BorderLayout());
            this.ripTable = new UTable(null);
            UScrollPane uScrollPane = new UScrollPane((Component)this.ripTable);
            jPanel.add((Component)uScrollPane, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.pack();
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.ripTableModel = new RipTableModel(this.blsrNode, this.ringModel);
                this.ripTable.setModel(this.ripTableModel);
            }
            super.setVisible(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("closeButton")) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private class SetProtectionOpDialog
    extends UDialog
    implements ActionListener {
        private BlsrRingModel ringModel;
        private BlsrNode blsrNode;
        private JButton okButton;
        private JButton cancelButton;
        private DefaultComboBoxModel comboBoxModel;
        private UComboBox protectionOpCB;
        private boolean isWest;
        private IBlsrProtectionOp initialProtectionOp;

        public SetProtectionOpDialog(Frame frame, BlsrRingModel blsrRingModel, BlsrNode blsrNode, boolean bl) {
            super(frame, "Set Protection Operation", true);
            if (bl) {
                this.setTitle("Set West Protection Operation");
            } else {
                this.setTitle("Set East Protection Operation");
            }
            this.ringModel = blsrRingModel;
            this.blsrNode = blsrNode;
            this.isWest = bl;
            if (db.on) {
                db.println("In constructor of SetProtectionOpDialog now... ringModel=" + blsrRingModel + ", blsrNode=" + blsrNode + ", isWest=" + bl);
            }
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            this.comboBoxModel = new DefaultComboBoxModel();
            this.comboBoxModel.addElement("Initial List");
            this.protectionOpCB = new UComboBox((ComboBoxModel)this.comboBoxModel);
            this.protectionOpCB.setPreferredSize(new Dimension(this.protectionOpCB.getPreferredSize().width * 2, this.protectionOpCB.getPreferredSize().height));
            JButton jButton = new JButton("OK");
            jButton.setActionCommand("okButton");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setActionCommand("cancelButton");
            jButton2.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(25));
            jPanel2.add(jButton2);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
            jPanel.setLayout(new BorderLayout());
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            gridBagPanel.align(17);
            gridBagPanel.fillNone();
            gridBagPanel.pad(10, 20);
            gridBagPanel.add((Component)new JLabel("Please select protection operation: "), 0, 0);
            gridBagPanel.fill(2);
            gridBagPanel.add((Component)this.protectionOpCB, 1, 0);
            gridBagPanel.fill(2);
            gridBagPanel.align(10);
            gridBagPanel.add(jPanel2, 0, 1, 2, 1);
            jPanel.add((Component)gridBagPanel, "Center");
        }

        private boolean isPrivilegeSufficent(SecurityLevel securityLevel, SecurityLevel securityLevel2) {
            int n = securityLevel.value();
            if (n == 3) {
                return true;
            }
            boolean bl = false;
            switch (securityLevel2.value()) {
                case 0: {
                    return true;
                }
                case 1: {
                    bl = n == 1 || n == 2;
                    break;
                }
                case 2: {
                    boolean bl2 = bl = n == 2;
                }
            }
            if (!bl && db.on()) {
                db.println("Access denied : insuf priv (required=" + securityLevel2.value() + ", curr=" + n + ")");
            }
            return bl;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                boolean bl2 = this.ringModel.getBlsrRingInfo().isFourFiber();
                this.initialProtectionOp = this.isWest ? this.blsrNode.getWestProtectionOp() : this.blsrNode.getEastProtectionOp();
                NodeModel nodeModel = this.blsrNode.getNodeModel();
                SecurityLevel securityLevel = nodeModel.getSecurityLevel();
                SecurityLevel securityLevel2 = SecurityLevel.MAINTENANCE;
                this.comboBoxModel.removeAllElements();
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = this.isPrivilegeSufficent(securityLevel, securityLevel2);
                bl3 = this.initialProtectionOp.getKOp() == 0 || this.initialProtectionOp.getKOp() == 8;
                bl4 = this.initialProtectionOp.getKOp() == 6;
                bl5 = this.initialProtectionOp.getKOp() == 7;
                bl6 = this.initialProtectionOp.getKOp() == 4;
                bl7 = this.initialProtectionOp.getKOp() == 5;
                bl8 = this.initialProtectionOp.getKOp() == 2;
                boolean bl11 = bl9 = this.initialProtectionOp.getKOp() == 3;
                if (db.on) {
                    db.println("currentlyClear is: " + bl3);
                }
                Attribute[] attributeArray = bl3 ? (bl2 ? (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.min")) : (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.min"))) : (bl4 ? (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.exerSpan.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.exerSpan.min")) : (bl5 ? (!bl2 ? (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.exerRing.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.exerRing.min")) : (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.exerRing.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.exerRing.min"))) : (bl6 ? (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.manSpan.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.manSpan.min")) : (bl7 ? (!bl2 ? (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.manRing.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.manRing.min")) : (bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.manRing.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.manRing.min"))) : (bl8 && bl10 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.forceSpan.full") : (bl9 && bl10 ? (!bl2 ? NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.2F.forceRing.full") : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.4F.forceRing.full")) : NetworkDefaults.getAttributeMap().getAttributeArray("blsrOp.clear")))))));
                for (int i = 0; i < attributeArray.length; ++i) {
                    Attribute attribute = attributeArray[i];
                    this.comboBoxModel.addElement(attribute);
                }
            } else if (null != this.protectionOpCB) {
                this.protectionOpCB.removeAllItems();
            }
            super.setVisible(bl);
        }

        private boolean hasThisNodeId(BlsrRingModel blsrRingModel, short s) {
            boolean bl = false;
            BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
            for (int i = 0; i < blsrNodeArray.length && !bl; ++i) {
                BlsrNode blsrNode = blsrNodeArray[i];
                if (blsrNode.getNodeId() != s) continue;
                bl = true;
            }
            return bl;
        }

        private void setNewProtectionOp(int n) {
            String string;
            Object object;
            String string2;
            int n2 = this.initialProtectionOp.getKOp();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            String string3 = "Is it OK to continue?";
            String string4 = "Are you sure?";
            String string5 = "Confirm " + BlsrEditMap.this.BLSR_TERM + " Operation";
            switch (n) {
                case 8: {
                    bl4 = true;
                    break;
                }
                case 0: {
                    if (n2 == n) break;
                    bl4 = true;
                    break;
                }
                case 7: {
                    bl4 = true;
                    break;
                }
                case 6: {
                    bl4 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl4 = true;
                    break;
                }
                case 1: {
                    bl3 = true;
                    break;
                }
                case 5: {
                    bl = true;
                    break;
                }
                case 4: {
                    bl4 = true;
                }
            }
            if (bl || bl2) {
                string2 = "Traffic might not switch away from the span.\n";
                string2 = string2 + "Verify the proper switch of traffic before performing\n";
                string2 = string2 + "potentially service-affecting work on this span.\n\n";
                string2 = string2 + string3;
                bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)string5);
            }
            if (bl5) {
                if (bl2 || bl3) {
                    object = ErrorMsg.getString((EID)NEMC.WID_FORCE_OP_PROMPT);
                    object = (String)object + string3;
                    bl5 = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)object, (String)string5);
                } else if (bl4) {
                    string2 = BlsrEditMap.this.BLSR_TERM + " line operations " + " will be modified.\n\n";
                    string2 = string2 + string3;
                    bl5 = CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)string5);
                }
            }
            if (bl5 && null != (object = BlsrEditMap.this.getRingModel())) {
                if (((BlsrRingModel)object).getState() == 2) {
                    string = ErrorMsg.getString((EID)NEMC.WID_BLSR_RING_STATUS_INCOMPLETE);
                    string = string + string3;
                    bl5 = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)string5);
                } else if (!((BlsrRingModel)object).isRingProtectionClear() && n != 0) {
                    string = ErrorMsg.getString((EID)NEMC.WID_BLSR_PROTECT_OP_WARN);
                    string = string + string3;
                    bl5 = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)string5);
                }
            }
            if (bl5) {
                this.initialProtectionOp.setKOp(n);
                if (this.isWest) {
                    try {
                        this.blsrNode.setWestProtectionOp(this.initialProtectionOp);
                    }
                    catch (InvalidProtectionOp invalidProtectionOp) {
                        if (db.on()) {
                            db.println("Unable to set protection op for West span");
                        }
                        string = "The switch operation could not be performed. A higher priority request might be present.";
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_APPLYING_OPERATION_MSG_PARAM_1, (Object)string);
                    }
                    catch (InternalCommError internalCommError) {
                        if (db.on()) {
                            db.println("Card communication failure.");
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CARD_COMMUNICATION_FAILURE);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        string = abstractCmsIOException.getMessage();
                        if (db.on()) {
                            db.println(string);
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_APPLYING_OPERATION_MSG_PARAM_1, (Object)string);
                    }
                } else {
                    try {
                        this.blsrNode.setEastProtectionOp(this.initialProtectionOp);
                    }
                    catch (InvalidProtectionOp invalidProtectionOp) {
                        if (db.on()) {
                            db.println("Unable to set protection op for East span");
                        }
                        string = "The switch operation could not be performed. A higher priority request might be present.";
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_APPLYING_OPERATION_MSG_PARAM_1, (Object)string);
                    }
                    catch (InternalCommError internalCommError) {
                        if (db.on()) {
                            db.println("Card communication failure.");
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CARD_COMMUNICATION_FAILURE);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        string = abstractCmsIOException.getMessage();
                        if (db.on()) {
                            db.println(string);
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ERROR_APPLYING_OPERATION_MSG_PARAM_1, (Object)string);
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("okButton")) {
                Attribute attribute = (Attribute)this.comboBoxModel.getSelectedItem();
                int n = this.initialProtectionOp.getKOp();
                int n2 = attribute.getValue();
                switch (n2) {
                    case 0: {
                        this.setNewProtectionOp(0);
                        break;
                    }
                    case 7: {
                        this.setNewProtectionOp(7);
                        break;
                    }
                    case 6: {
                        this.setNewProtectionOp(6);
                        break;
                    }
                    case 3: {
                        this.setNewProtectionOp(3);
                        break;
                    }
                    case 2: {
                        this.setNewProtectionOp(2);
                        break;
                    }
                    case 1: {
                        this.setNewProtectionOp(1);
                        break;
                    }
                    case 5: {
                        this.setNewProtectionOp(5);
                        break;
                    }
                    case 4: {
                        this.setNewProtectionOp(4);
                    }
                }
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("cancelButton")) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private class NodeIdDialog
    extends UDialog
    implements ActionListener {
        private BlsrRingModel ringModel;
        private BlsrNode blsrNode;
        private JTextField newIdTF;
        private JButton okButton;
        private JButton cancelButton;

        public NodeIdDialog(Frame frame, BlsrRingModel blsrRingModel, BlsrNode blsrNode) {
            super(frame, "Edit Node ID", true);
            this.ringModel = blsrRingModel;
            this.blsrNode = blsrNode;
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            this.newIdTF = new JTextField(8);
            JButton jButton = new JButton("OK");
            jButton.setActionCommand("okButton");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setActionCommand("cancelButton");
            jButton2.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(25));
            jPanel2.add(jButton2);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
            jPanel.setLayout(new BorderLayout());
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            gridBagPanel.align(17);
            gridBagPanel.fillNone();
            gridBagPanel.pad(10, 20);
            gridBagPanel.add((Component)new JLabel("Please enter a new Node ID: "), 0, 0);
            gridBagPanel.fill(2);
            gridBagPanel.add((Component)this.newIdTF, 1, 0);
            gridBagPanel.fill(2);
            gridBagPanel.align(10);
            gridBagPanel.add(jPanel2, 0, 1, 2, 1);
            jPanel.add((Component)gridBagPanel, "Center");
        }

        private boolean hasThisNodeId(BlsrRingModel blsrRingModel, short s) {
            boolean bl = false;
            BlsrNode[] blsrNodeArray = blsrRingModel.getBlsrNodes();
            for (int i = 0; i < blsrNodeArray.length && !bl; ++i) {
                BlsrNode blsrNode = blsrNodeArray[i];
                if (blsrNode.getNodeId() != s) continue;
                bl = true;
            }
            return bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block10: {
                String string = actionEvent.getActionCommand();
                if (string.equals("okButton")) {
                    short s = -1;
                    String string2 = this.newIdTF.getText();
                    try {
                        s = Short.parseShort(string2);
                        if (s < 0 || s > 31) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ENTER_BLSR_NODEID_MAX_PARAM_1, (Object)"31");
                            break block10;
                        }
                        if (this.hasThisNodeId(this.ringModel, s)) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NODE_ID_IN_USE);
                            break block10;
                        }
                        try {
                            this.blsrNode.setNodeId(s);
                        }
                        catch (DuplicateNodeId duplicateNodeId) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NODE_ID_IN_USE);
                        }
                        catch (BlsrSpanSwitched blsrSpanSwitched) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_BLSR_SWITCH_ACTIVE_CAN_NOT_CHANGE_NODE_ID_PARAM_1, (Object)BlsrEditMap.this.BLSR_TERM);
                        }
                        this.setVisible(false);
                        this.dispose();
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_ENTER_BLSR_NODEID_MAX_PARAM_1, (Object)"31");
                    }
                } else if (string.equals("cancelButton")) {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        }
    }

    private class BlsrSpanChannelStateChangeObserver
    implements Observer {
        private BlsrSpanChannelStateChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            SwingUtilities.invokeLater(new BlsrSpanChannelStateChangeUpdaterThread(observable, object));
        }
    }

    private class BlsrSpanExtensionByteObserver
    implements Observer {
        private BlsrSpanExtensionByteObserver() {
        }

        public void update(Observable observable, Object object) {
            SwingUtilities.invokeLater(new BlsrSpanExtensionByteUpdaterThread(observable, object));
        }
    }
}

