/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapNodeCookie;
import cerent.cms.ui.blsr.BlsrMapPort;
import cerent.cms.ui.blsr.BlsrPort;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkConnector;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapToolkit;
import java.util.HashMap;
import javax.swing.JComponent;

public class BlsrMapNode
extends NetMapNode {
    private static final SDebug db = new SDebug("BlsrMapNode");
    private HashMap workingBlsrPorts = new HashMap();
    private HashMap protectBlsrPorts = new HashMap();
    public static final int WORKING = 0;
    public static final int PROTECT = 1;
    private BlsrNode blsrNode;
    private int blsrNodeId = -1;

    public BlsrMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public void init(Object object, double d, double d2, Object object2) {
        super.init(object, d, d2, object2);
        if (this.getUserCookie() instanceof BlsrMapNodeCookie) {
            BlsrMapNodeCookie blsrMapNodeCookie = (BlsrMapNodeCookie)this.getUserCookie();
            this.blsrNode = blsrMapNodeCookie.getBlsrNode();
        }
    }

    public BlsrNode getBlsrNode() {
        return this.blsrNode;
    }

    public String getText() {
        String string = super.getName();
        if (this.blsrNodeId != -1) {
            string = string + "(" + this.blsrNodeId + ")";
        }
        return string;
    }

    public String getToolTipText() {
        String string = "";
        if (this.blsrNode != null) {
            string = this.blsrNode.toString();
        } else {
            string = super.getToolTipText();
            if (BlsrMapNode.db.on) {
                db.println("userCookie is not a BlsrNode - using tooltip from super.");
            }
        }
        return string;
    }

    private BlsrPort getBlsrPortFromBlsrMapLink(BlsrMapLink blsrMapLink) {
        if (blsrMapLink != null && this.getUserObject() instanceof INodeModel) {
            INodeModel iNodeModel = (INodeModel)this.getUserObject();
            if (db.on()) {
                db.finer("Trying to get a BLSR port from a BLSR Map Link:");
                db.finer("\tMapLink: " + blsrMapLink);
                db.finer("\tEastNodeModel: " + blsrMapLink.getEastNodeModel());
                db.finer("\tWestNodeModel: " + blsrMapLink.getWestNodeModel());
                db.finer("\tEastBlsrPort: " + blsrMapLink.getEastBlsrPort());
                db.finer("\tWestBlsrPort: " + blsrMapLink.getWestBlsrPort());
            }
            if (iNodeModel == blsrMapLink.getEastNodeModel()) {
                return blsrMapLink.getEastBlsrPort();
            }
            if (iNodeModel == blsrMapLink.getWestNodeModel()) {
                return blsrMapLink.getWestBlsrPort();
            }
        }
        return null;
    }

    protected MapPort createMapPort(DetailedMapNode detailedMapNode, MapLink mapLink, MapLinkConnector mapLinkConnector) {
        BlsrMapPort blsrMapPort;
        block20: {
            blsrMapPort = null;
            if (mapLink != null && mapLink instanceof BlsrMapLink) {
                try {
                    BlsrMapLink blsrMapLink = (BlsrMapLink)mapLink;
                    INetLink iNetLink = blsrMapLink.getNetLink();
                    if (iNetLink != null) {
                        if (db.on()) {
                            db.println("Creating port, portkey is ITdmPortModel");
                        }
                        ITdmPortModel iTdmPortModel = null;
                        int n = this.getNodeRoleInNetLink(iNetLink);
                        if (n == 1) {
                            iTdmPortModel = blsrMapLink.getSrcPortModel();
                        } else if (n == 2) {
                            iTdmPortModel = blsrMapLink.getDstPortModel();
                        } else {
                            db.println("Could not find role of " + this.getUserObject() + " in the INetLink " + iNetLink);
                        }
                        if (iTdmPortModel != null) {
                            if (db.on()) {
                                db.println("Create port, portkey is " + iTdmPortModel);
                            }
                            blsrMapPort = new BlsrMapPort(detailedMapNode, mapLinkConnector);
                            blsrMapPort.init(iTdmPortModel, null);
                        } else {
                            BlsrPort blsrPort = this.getBlsrPortFromBlsrMapLink(blsrMapLink);
                            if (blsrPort != null) {
                                if (db.on()) {
                                    db.println("Create port, portkey is BlsrPort");
                                }
                                blsrMapPort = new BlsrMapPort(detailedMapNode, mapLinkConnector);
                                blsrMapPort.init(blsrPort, null);
                            } else {
                                db.println("Cannot get TdmPortModel or East/WestBlsrPort info for node " + this + " and link " + blsrMapLink);
                            }
                        }
                        break block20;
                    }
                    BlsrPort blsrPort = this.getBlsrPortFromBlsrMapLink(blsrMapLink);
                    if (blsrPort != null) {
                        if (db.on()) {
                            db.println("Create port, portkey is BlsrPort");
                        }
                        blsrMapPort = new BlsrMapPort(detailedMapNode, mapLinkConnector);
                        blsrMapPort.init(blsrPort, null);
                        break block20;
                    }
                    db.println("Cannot get BlsrPort for node " + this);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else if (mapLink == null) {
                blsrMapPort = new BlsrMapPort(detailedMapNode, mapLinkConnector);
            } else {
                db.println(this + "::createMapPort() failed.");
                db.println("\tCannot handle a MapLink of " + mapLink);
            }
        }
        return blsrMapPort;
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.mtk.isDetailed()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Node", 79);
        }
    }

    public void setBlsrNodeId(int n) {
        if (BlsrMapNode.db.on) {
            db.println("setBlsrNodeId(newBlsrNodeId=" + n + ") called");
        }
        this.blsrNodeId = n;
        this.setDesc(null);
        if (n > -1) {
            this.addDesc("(" + n + ")");
        }
    }

    public BlsrPort getBlsrPort(ITdmPortModel iTdmPortModel, int n) {
        BlsrPort blsrPort = null;
        switch (n) {
            case 0: {
                blsrPort = (BlsrPort)this.workingBlsrPorts.get(iTdmPortModel);
                if (null != blsrPort) break;
                blsrPort = new BlsrPort(iTdmPortModel, true);
                this.workingBlsrPorts.put(iTdmPortModel, blsrPort);
                break;
            }
            case 1: {
                blsrPort = (BlsrPort)this.protectBlsrPorts.get(iTdmPortModel);
                if (null != blsrPort) break;
                blsrPort = new BlsrPort(iTdmPortModel, false);
                this.protectBlsrPorts.put(iTdmPortModel, blsrPort);
                break;
            }
            default: {
                blsrPort = null;
            }
        }
        return blsrPort;
    }

    protected void receivedAlarmUpdate() {
        this.mtk.updateView();
    }

    protected void updateZeroSelectors() {
        int n;
        if (this.hasInternalPorts() && (n = this.numInternalPorts()) > 0) {
            for (int i = 0; i < n; ++i) {
                int n2;
                MapPort mapPort = this.getInternalPort(i);
                switch (i) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                mapPort.setSide(n2);
                mapPort.updatePositionInNode();
            }
        }
    }
}

