/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ProvisionError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.HoLoSliceDialog;
import cerent.cms.ui.circuits.OchncLinesPanel;
import cerent.cms.ui.circuits.RollEndpointsPane;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.HoLoHelper;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class AbstractCcdEndpointPanel
extends JPanel
implements ActionListener {
    protected INetCircuitEnd endpoint;
    protected List excludedEndpoints;
    protected JPanel endPointsPanel;
    protected OchncLinesPanel otsLinesPanel;
    protected JLabel shelfLB;
    protected JLabel slotLB;
    protected JLabel portLB;
    protected JComboBox shelfCB;
    protected JComboBox slotCB;
    protected JComboBox portCB;
    protected List hoParts = new ArrayList();
    protected List loParts = new ArrayList();
    protected IHoNum hoNum;
    protected ILoNum loNum;
    protected String shelf;
    protected String slot;
    protected SortablePortString port;
    protected INodeModel node;
    protected SortedMap entityMap;
    protected SortedMap shelfMap;
    protected SortedMap endpointMap;
    ArrayList pureEndpointList = new ArrayList();
    ArrayList otherPortsList = new ArrayList();
    protected SortedMap portMap;
    protected CcdEndpointsPane parent;
    protected AbstractCircuitDialog cktDialog;
    protected String title;
    protected boolean isEther;
    protected boolean isSecondary;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected boolean isMultiShelf;
    private boolean blockUpdateDs1PortCB;
    private JPanel portRowPanel;
    protected JComboBox ds1PortCB;
    protected boolean useDs1PortCB;
    protected SortedMap ds1EndpointMap = new TreeMap();
    protected JList memberList = null;
    protected JButton editMemberBtn = null;
    protected JPanel holoRowPanel = null;
    private boolean bRprMode = false;
    protected static final SDebug db = new SDebug("AbstractEndpointPanel");

    public AbstractCcdEndpointPanel(String string, AbstractCircuitDialog abstractCircuitDialog, CcdEndpointsPane ccdEndpointsPane) {
        this.setName(string);
        if (db.on()) {
            db.println(string + "<init>");
        }
        this.parent = ccdEndpointsPane;
        this.cktDialog = abstractCircuitDialog;
        if (this.getCircuitInfoType() == 9 || this.getCircuitInfoType() == 14 || this.getCircuitInfoType() == 15) {
            this.endPointsPanel = new JPanel();
            this.setLayout(new GridLayout(1, 2));
            this.add(this.endPointsPanel);
            this.otsLinesPanel = new OchncLinesPanel((SDebug)ccdEndpointsPane.getDbg(), this.getCircuitInfo());
            this.add(this.otsLinesPanel);
        } else {
            this.endPointsPanel = this;
        }
        if (string != null) {
            this.endPointsPanel.setBorder(BorderFactory.createTitledBorder(string));
            this.isSecondary = string.startsWith("Secondary ");
        }
        this.title = string;
        this.gbl.setConstraints(this, this.gbc);
        this.endPointsPanel.setLayout(this.gbl);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(1, 1, 1, 1);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 1;
        this.shelfLB = new JLabel("Shelf:", 4);
        this.shelfCB = this.addCB(this.shelfLB, "shelfCB", this.gbc);
        this.shelfLB.setVisible(false);
        this.shelfCB.setVisible(false);
        this.slotLB = new JLabel("Slot:", 4);
        this.slotCB = this.addCB(this.slotLB, "slotCB", this.gbc);
        this.portLB = new JLabel("Port:", 4);
        this.portCB = this.addCB(this.portLB, "portCB", this.gbc);
        this.portRowPanel = (JPanel)this.endPointsPanel.getComponent(this.endPointsPanel.getComponentCount() - 1);
        this.ds1PortCB = new JComboBox();
        this.ds1PortCB.setName("ds1PortCB");
        this.ds1PortCB.addActionListener(this);
        this.addMemberList(this.gbc);
        this.addComponents(this.gbc);
        this.reset();
    }

    protected INetCircuit getCircuit() {
        return this.parent.getCircuit();
    }

    protected CircuitCreatInfo getCircuitInfo() {
        return this.parent.getCircuitInfo();
    }

    protected int getCircuitInfoType() {
        return this.getCircuitInfo().type();
    }

    protected int getCircuitInfoSize() {
        return this.getCircuitInfo().size();
    }

    protected int getCircuitInfoDir() {
        return this.getCircuitInfo().dir();
    }

    protected boolean getCircuitInfoTL1Compatible() {
        return this.getCircuitInfo().tl1Compatible();
    }

    protected boolean getPortGrouping() {
        return this.parent.getPortGrouping();
    }

    protected boolean getMonitor() {
        return this.parent.getMonitor();
    }

    protected boolean isDiag() {
        return this.getCircuitInfo().isDiag();
    }

    protected abstract void addComponents(GridBagConstraints var1);

    protected List getHoParts() {
        if (this.hoParts.size() == 0) {
            this.hoParts.add(this.getHoCB());
        }
        return this.hoParts;
    }

    protected abstract List getLoParts();

    protected void reset() {
        if (db.on()) {
            db.println(this.title + " reset");
        }
        this.endpoint = new NetCircuitEnd();
        this.excludedEndpoints = new ArrayList();
        this.shelf = null;
        this.slot = null;
        this.port = null;
        this.hoNum = null;
        this.resetLoNum();
        this.resetComponents();
        if (this.otsLinesPanel != null) {
            this.otsLinesPanel.reset();
        }
    }

    protected void resetLoNum() {
        this.loNum = null;
    }

    protected void resetComponents() {
        this.setCBList(this.shelfCB, null);
        this.setCBList(this.slotCB, null);
        this.setCBList(this.portCB, null);
        this.setCBList(this.ds1PortCB, null);
        this.setCBList(this.getHoParts(), null);
        this.setCBList(this.getLoParts(), null);
    }

    protected JComboBox addCB(String string, String string2, GridBagConstraints gridBagConstraints) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setName(string2);
        jComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.add(jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    protected JComboBox addCB(JLabel jLabel, String string, GridBagConstraints gridBagConstraints) {
        JComboBox jComboBox = new JComboBox();
        jLabel.setPreferredSize(new Dimension(50, 20));
        jComboBox.setName(string);
        jComboBox.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setPreferredSize(new Dimension(300, 22));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, "West");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add(jComboBox, "Center");
        this.endPointsPanel.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jComboBox;
    }

    private void addMemberList(GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel("Member:", 4);
        jLabel.setPreferredSize(new Dimension(50, 20));
        this.memberList = new JList();
        this.memberList.setCellRenderer(new SliceCellRenderer());
        this.memberList.setBackground(jLabel.getBackground());
        this.memberList.setVisibleRowCount(10);
        this.memberList.setEnabled(false);
        this.memberList.setName("memberList");
        JScrollPane jScrollPane = new JScrollPane(this.memberList);
        this.holoRowPanel = new JPanel(new BorderLayout(0, 0));
        this.holoRowPanel.setPreferredSize(new Dimension(260, 120));
        this.holoRowPanel.setMinimumSize(new Dimension(260, 120));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.add(jLabel);
        this.holoRowPanel.add((Component)jPanel, "West");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        this.holoRowPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 10, 10));
        this.editMemberBtn = new JButton("Edit Members...");
        jPanel2.add(this.editMemberBtn);
        this.editMemberBtn.addActionListener(this);
        this.holoRowPanel.add((Component)jPanel2, "South");
        this.endPointsPanel.add((Component)this.holoRowPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.holoRowPanel.setVisible(false);
    }

    void setNode(INodeModel iNodeModel) {
        this.node = iNodeModel;
        if (this.endpoint.getNodeModel() != iNodeModel) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                this.isMultiShelf = true;
                this.shelfLB.setVisible(true);
                this.shelfCB.setVisible(true);
            } else {
                this.isMultiShelf = false;
                this.shelfLB.setVisible(false);
                this.shelfCB.setVisible(false);
            }
            if (this.getCircuitInfo().isOVcat() && !this.parent.inSourcePane()) {
                this.reset();
            }
            this.endpoint.setNodeModel(iNodeModel);
            this.refresh();
        }
    }

    void selectEndpoint(INetCircuitEnd iNetCircuitEnd) {
        IEntityModel iEntityModel;
        block4: {
            if (db.on()) {
                db.println(this.title + " selectEndpoint endpt is " + iNetCircuitEnd);
            }
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuit().getCircuitType(), iNetCircuitEnd);
            this.endpoint = netCircuitEnd;
            iEntityModel = null;
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block4;
                db.println("Can't find the entity model");
            }
        }
        this.shelf = this.getShelfString(iEntityModel);
        this.slot = this.getSlotString(iEntityModel);
        this.port = iEntityModel.getGenericClass() == 7 ? new SortablePortString(iEntityModel) : null;
        IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iNetCircuitEnd.getHoNum());
        this.hoNum = iNetCircuitEnd.getHoNum() != null ? iHoNum : null;
        this.shelfCB.setSelectedItem(this.shelf);
        this.slotCB.setSelectedItem(this.slot);
        this.portCB.setSelectedItem(this.port);
        this.getHoCB().setSelectedItem(this.hoNum);
        this.setLoNumsFromEndpoint();
        this.selectLoComponentsFromEndpoint();
        if (this.otsLinesPanel != null) {
            this.otsLinesPanel.setSelectedEntity(this.endpoint, this.getCircuit() == null);
        }
    }

    protected abstract void selectLoComponentsFromEndpoint();

    protected String getSlotString(IEntityModel iEntityModel) {
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(this.node).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null);
    }

    protected String getShelfString(IEntityModel iEntityModel) {
        if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.MULTISHELF)) {
            return Integer.toString(iEntityModel.getShelfId());
        }
        return "1";
    }

    void setEndpoint(INetCircuitEnd iNetCircuitEnd) {
        if (db.on()) {
            db.println(this.title + " setEndpoint endpt is " + iNetCircuitEnd);
        }
        this.endpoint = iNetCircuitEnd;
        IEntityModel iEntityModel = null;
        iEntityModel = this.getEntityModel();
        this.shelf = this.getShelfString(iEntityModel);
        this.slot = this.getSlotString(iEntityModel);
        this.port = iEntityModel.getGenericClass() == 7 ? new SortablePortString(iEntityModel) : null;
        IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, this.endpoint.getHoNum());
        this.hoNum = this.endpoint.getHoNum() != null ? iHoNum : null;
        this.setCBList(this.shelfCB, this.shelf != null ? Collections.singleton(this.shelf) : null);
        this.shelfCB.setSelectedItem(this.shelf);
        this.setCBList(this.slotCB, this.slot != null ? Collections.singleton(this.slot) : null);
        this.slotCB.setSelectedItem(this.slot);
        this.setCBList(this.portCB, this.port != null ? Collections.singleton(this.port) : null);
        this.portCB.setSelectedItem(this.port);
        this.setCBList(this.getHoCB(), this.getHoCB() != null ? Collections.singleton(this.hoNum) : null);
        this.getHoCB().setSelectedItem(this.hoNum);
        this.setLoNumsFromEndpoint();
        this.setLoComponentsFromEndpoint();
        if (this.otsLinesPanel != null) {
            this.otsLinesPanel.setSelectedEntity(this.endpoint, this.getCircuit() == null);
        }
    }

    protected void setLoNumsFromEndpoint() {
        ILoNum iLoNum = this.loNum = this.endpoint.getLoNum() != null ? this.endpoint.getLoNum() : null;
        if (this.loNum != null) {
            IFramingType iFramingType = FramingType.getFramingType((int)this.loNum.getFramingType());
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)iFramingType.getLoCircuitType());
            this.localRefresh(iCircuitType, this.loNum.getCircuitSize());
        }
    }

    protected abstract void setLoComponentsFromEndpoint();

    public void setExcludedEndpoints(List list) {
        if (db.on()) {
            db.println(this.title + " setExcludedEnpoints list is " + ((AbstractCollection)((Object)list)).toString());
        }
        this.excludedEndpoints = list;
    }

    public void validatePage() throws Exception {
        this.debugEndpoint(this.title + " validatePage: ");
        if (!this.fullySelected()) {
            throw new Exception(this.getName() + " is not fully specified.");
        }
        if (this.otsLinesPanel != null && !this.otsLinesPanel.isValid()) {
            throw new Exception(this.otsLinesPanel.getErrorMessage());
        }
        this.endpoint.setLoNum(this.loNum);
        if (db.on()) {
            db.println(this.title + " validatePage: endpoint OK");
        }
        if (this.parent.getAutorangeInfo() != null && this.endpointMap != null) {
            int n;
            if (this.useDs1PortCB) {
                this.pureEndpointList.clear();
                this.pureEndpointList.addAll(this.ds1EndpointMap.values());
            } else {
                this.pureEndpointList = new ArrayList();
                this.recurseEndpointMap(this.endpointMap);
            }
            SortedMap sortedMap = (SortedMap)this.entityMap.get(this.slot);
            boolean bl = false;
            this.otherPortsList.clear();
            for (Object k : sortedMap.keySet()) {
                if (!(k instanceof SortablePortString)) continue;
                SortablePortString sortablePortString = (SortablePortString)k;
                if (sortablePortString.equals(this.port)) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                this.otherPortsList.add(sortablePortString.getEntityModel());
            }
            if (db.on()) {
                db.println("validating this endpoint is SL=" + this.endpoint.getSlotNumber() + " HO=" + this.endpoint.getHoNum() + " LO=" + this.endpoint.getLoNum());
            }
            if (this.port != null && (n = this.otherPortsList.indexOf(this.port.getEntityModel())) >= 0) {
                this.otherPortsList.remove(n);
            }
        }
    }

    ArrayList getEndpointsList() {
        if (this.pureEndpointList != null) {
            return (ArrayList)this.pureEndpointList.clone();
        }
        return null;
    }

    ArrayList getOtherPortsList() {
        if (this.otherPortsList != null) {
            return (ArrayList)this.otherPortsList.clone();
        }
        return null;
    }

    protected void recurseEndpointMap(Object object) {
        if (object instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)object;
            for (Object k : sortedMap.keySet()) {
                if (k == null) continue;
                Object v = sortedMap.get(k);
                this.recurseEndpointMap(v);
            }
        } else {
            this.pureEndpointList.add(object);
        }
    }

    protected boolean fullySelected() {
        if (this.isMultiShelf && this.shelf == null) {
            return false;
        }
        if (this.slot == null) {
            return false;
        }
        if (this.holoRowPanel.isVisible() && this.memberList.getModel().getSize() <= 0) {
            return false;
        }
        if (this.parent.inSourcePane()) {
            if (!this.holoRowPanel.isVisible()) {
                if (!this.isSecondary) {
                    this.parent.getCircuitInfo().setMemberSrcHoLoNums(null);
                } else {
                    this.parent.getCircuitInfo().setMemberSecSrcHoLoNums(null);
                }
            }
        } else if (!this.holoRowPanel.isVisible()) {
            if (!this.isSecondary) {
                this.parent.getCircuitInfo().setMemberDropHoLoNums(null);
            } else {
                this.parent.getCircuitInfo().setMemberSecDropHoLoNums(null);
            }
        }
        if (this.holoRowPanel.isVisible() && this.memberList != null && this.memberList.getModel().getSize() != this.parent.getVcatTxMembers()) {
            return false;
        }
        if (this.getHoCB().isVisible() && this.getHoCB().isEnabled() && this.hoNum == null && !this.isEther && !this.isDiag()) {
            return false;
        }
        if (this.isMultiShelf && this.shelfCB.isEnabled() && this.shelfCB.getSelectedIndex() < 0) {
            return false;
        }
        if (this.slotCB.isEnabled() && this.slotCB.getSelectedIndex() < 0) {
            return false;
        }
        if (this.portCB.isEnabled() && this.portCB.getSelectedIndex() < 0) {
            return false;
        }
        return !this.getHoCB().isEnabled() || this.getHoCB().getSelectedIndex() >= 0;
    }

    protected String getStatusText() {
        if (this.slot == "Ethergroup" || this.slot == "PRBS Generator") {
            return this.slot;
        }
        return CircuitEndCellRenderer.asSlashSeparatedString(this.endpoint);
    }

    public void refresh() {
        if (db.on()) {
            db.println(this.title + " refresh");
        }
        if (this.otsLinesPanel != null) {
            this.otsLinesPanel.reset();
        }
        if (this.parent.excludePane == null && this.getMonitor()) {
            if (db.on()) {
                db.println(this.title + " refresh: monitor source, returning");
            }
            return;
        }
        this.debugEndpoint(this.title + " refresh: ");
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfoType());
        this.localRefresh(iCircuitType, this.getCircuitInfoSize());
        if (this.endpoint.getNodeModel() != null) {
            Object object;
            Object object2;
            this.getDropPorts();
            TreeSet treeSet = null;
            if (this.isMultiShelf) {
                object2 = null;
                object2 = (String)this.shelfCB.getSelectedItem();
                object = new TreeSet(this.shelfMap.keySet());
                this.setCBList(this.shelfCB, (Collection)object);
                if (this.shelfMap.keySet().size() == 1) {
                    object2 = (String)this.shelfMap.keySet().iterator().next();
                }
                if (object2 != null) {
                    this.shelfCB.setSelectedItem(object2);
                    this.shelfCB.setEnabled(this.shelfMap.keySet().size() > 1);
                    this.entityMap = (TreeMap)this.shelfMap.get(object2);
                }
            }
            treeSet = new TreeSet(this.entityMap.keySet());
            if (this.getCircuitInfoTL1Compatible()) {
                treeSet.remove("Ethergroup");
                object2 = treeSet.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (((String)object).indexOf("ETH100") == -1) continue;
                    object2.remove();
                }
            }
            this.setCBList(this.slotCB, treeSet);
            if (this.slot == null && this.entityMap.keySet().size() == 1) {
                this.slot = (String)this.entityMap.keySet().iterator().next();
            }
            if (this.slot != null) {
                this.slotCB.setSelectedItem(this.slot);
                this.slotCB.setEnabled(this.slotCB.getModel().getSize() > 1);
                if (this.port != null) {
                    this.portCB.setSelectedItem(this.port);
                }
            } else {
                this.setCBList(this.portCB, null);
                this.setCBList(this.ds1PortCB, null);
                this.setCBList(this.getHoParts(), null);
                this.setCBList(this.getLoParts(), null);
            }
        } else {
            this.setCBList(this.shelfCB, null);
            this.setCBList(this.slotCB, null);
            this.setCBList(this.portCB, null);
            this.setCBList(this.ds1PortCB, null);
            this.setCBList(this.getHoParts(), null);
            this.setCBList(this.getLoParts(), null);
        }
    }

    protected abstract void localRefresh(ICircuitType var1, int var2);

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.shelfCB) {
            String string = (String)this.shelfCB.getSelectedItem();
            if (this.isNull(string, "newShelf")) {
                return;
            }
            if (db.on()) {
                db.println(this.title + " actionPerformed: shelf " + this.shelf + " -> " + string);
            }
            this.shelf = string;
            this.entityMap = (SortedMap)this.shelfMap.get(this.shelf);
            if (this.isNull(this.entityMap, "entityMap")) {
                this.setCBList(this.slotCB, null);
                return;
            }
            if (this.entityMap.size() == 0) {
                if (db.on()) {
                    db.println(this.title + " entityMap is empty");
                }
                return;
            }
            this.setCBList(this.slotCB, this.entityMap.keySet());
            if (this.entityMap.size() == 1) {
                String string2 = (String)this.entityMap.firstKey();
                this.slotCB.setSelectedItem(string2);
            }
        } else if (object == this.slotCB) {
            String string = (String)this.slotCB.getSelectedItem();
            if (!(this.cktDialog instanceof AddVcatMembersDialog) && string != null && this.notSupportSecondaryEndpoint(string) && !this.getCircuitInfo().isBackHaulCircuit()) {
                this.parent.setAltPanelEnabled(false);
            }
            this.updateDs1PortCB();
        } else if (object == this.editMemberBtn) {
            Object object2;
            IPathStateInfo[] iPathStateInfoArray = new IPathStateInfo[]{};
            try {
                object2 = NetCircuitManager.instance();
                iPathStateInfoArray = ((NetCircuitManager)object2).getAllPathStateInfo(this.node, this.getEntityModel(), this.getCircuitInfo());
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                db.fine("Error retrieving getAllPathStateInfo()");
            }
            if (db.on()) {
                db.println("IPathStateInfo[] from ncm.getAllPathStateInfo()");
                for (IPathStateInfo iPathStateInfo : iPathStateInfoArray) {
                    db.println("HO: " + iPathStateInfo.getHoNum() + "\tLO: " + iPathStateInfo.getLoNum() + "\tState: " + iPathStateInfo.getPathState());
                }
            }
            if (iPathStateInfoArray != null) {
                object2 = new HoLoSliceDialog(this.cktDialog, this.getSlotModuleModel(), this.getCircuitInfo(), iPathStateInfoArray);
                object2.show();
                IHoLoNum[] iHoLoNumArray = ((HoLoSliceDialog)object2).getHoLoNum();
                if (iHoLoNumArray != null) {
                    this.memberList.setListData(iHoLoNumArray);
                }
                this.setMemberHoLoNums();
                ((HoLoSliceDialog)object2).localDispose();
            }
        } else if (object == this.ds1PortCB) {
            if (!this.useDs1PortCB) {
                if (db.on()) {
                    db.println(this.title + " actionPerformed: ds1PortCB ignored");
                }
                return;
            }
            INetCircuitEnd iNetCircuitEnd = null;
            Object object3 = this.ds1PortCB.getSelectedItem();
            if (object3 != null) {
                iNetCircuitEnd = (INetCircuitEnd)this.ds1EndpointMap.get(object3);
            }
            if (this.isNull(iNetCircuitEnd, "newCktEnd")) {
                return;
            }
            IHoNum iHoNum = iNetCircuitEnd.getHoNum();
            ILoNum iLoNum = iNetCircuitEnd.getLoNum();
            if (db.on()) {
                db.println(this.title + " actionPerformed: newCktEnd Sts: " + this.hoNum + " -> " + iHoNum + " Vt: " + this.loNum + " -> " + iLoNum);
            }
            this.blockUpdateDs1PortCB = true;
            this.getHoCB().setSelectedItem(iHoNum);
            this.setLoComponents(iLoNum);
            this.blockUpdateDs1PortCB = false;
        } else if (this.useDs1PortCB && !this.blockUpdateDs1PortCB && (this.getHoParts().contains(object) || this.getLoParts().contains(object))) {
            IEntityModel iEntityModel = this.getEntityModel();
            if (iEntityModel != null && this.hoNum != null && this.loNum != null && this.fullySelected()) {
                Integer n = new Integer(this.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, this.loNum, this.hoNum));
                if (!n.equals(this.ds1PortCB.getSelectedItem())) {
                    this.ds1PortCB.setSelectedItem(n);
                }
            } else {
                this.ds1PortCB.setSelectedItem(null);
            }
        }
    }

    private boolean notSupportSecondaryEndpoint(String string) {
        if (!this.isSecondary) {
            if (string.indexOf("ML-MR") > 0 && Feature.provides((INodeModel)this.parent.nodeModel, (Feature)Feature.BACKHAUL_CIRCUITS)) {
                this.parent.getCircuitInfo().setBackHaulCircuit(true);
            } else {
                this.parent.getCircuitInfo().setBackHaulCircuit(false);
            }
        }
        return string.indexOf("ML") > 0 || string.indexOf("G1000") > 0 || string.indexOf("FC-MR") > 0 || string.indexOf("ETH100") > 0 || string.indexOf("CE") > 0;
    }

    protected void clearEntity(final AnnotatedException annotatedException, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AbstractCcdEndpointPanel.this.port != null || bl && AbstractCcdEndpointPanel.this.slot != null) {
                    if (bl && AbstractCcdEndpointPanel.this.isMultiShelf) {
                        AbstractCcdEndpointPanel.this.shelf = null;
                        if (db.on()) {
                            db.println(AbstractCcdEndpointPanel.this.title + " Runnable: clearing shelfCB");
                        }
                        AbstractCcdEndpointPanel.this.shelfCB.setSelectedItem(null);
                    }
                    if (bl) {
                        AbstractCcdEndpointPanel.this.slot = null;
                        if (db.on()) {
                            db.println(AbstractCcdEndpointPanel.this.title + " Runnable: clearing slotCB");
                        }
                        AbstractCcdEndpointPanel.this.slotCB.setSelectedItem(null);
                        if (db.on()) {
                            db.println(AbstractCcdEndpointPanel.this.title + " Runnable: emptying portCB");
                        }
                        AbstractCcdEndpointPanel.this.setCBList(AbstractCcdEndpointPanel.this.portCB, null);
                        AbstractCcdEndpointPanel.this.setCBList(AbstractCcdEndpointPanel.this.ds1PortCB, null);
                    }
                    AbstractCcdEndpointPanel.this.port = null;
                    if (db.on()) {
                        db.println(AbstractCcdEndpointPanel.this.title + " Runnable: clearing portCB");
                    }
                    AbstractCcdEndpointPanel.this.portCB.setSelectedItem(null);
                    SDebug.printStackTrace((Throwable)annotatedException);
                    ErrorMsg.displayError((Component)AbstractCcdEndpointPanel.this, (EID)NEMC.EID_ENDPOINT_SELECTION_ERROR);
                    AbstractCcdEndpointPanel.this.repaint();
                }
            }
        });
    }

    private void getDropPorts() {
        boolean bl = this.slot == "Ethergroup";
        this.shelf = null;
        this.slot = null;
        this.port = null;
        IEntityModel iEntityModel = this.getEntityModel();
        int n = iEntityModel != null ? iEntityModel.getEqType() : -1;
        IEntityModel iEntityModel2 = null;
        List list = null;
        list = this.title.indexOf("Secondary ") < 0 ? this.parent.availPorts : this.parent.altAvailPorts;
        this.shelfMap = new TreeMap();
        this.entityMap = new TreeMap();
        for (IEntityModel iEntityModel3 : list) {
            TreeMap<SortablePortString, IEntityModel> treeMap;
            TreeMap<String, TreeMap<SortablePortString, IEntityModel>> treeMap2;
            TreeMap<SortablePortString, IEntityModel> treeMap3;
            SortablePortString sortablePortString;
            IModuleModel iModuleModel;
            block24: {
                if (iEntityModel3 == null) {
                    if (!db.on()) continue;
                    db.println(this.title + " getDropPorts: null entity returned from getAvailDropPorts");
                    continue;
                }
                if (this.parent != null && this.getPortGrouping()) {
                    if (!PortGrouping.isValidEntity(iEntityModel3)) continue;
                    if (this.parent.excludePane != null || this.parent instanceof RollEndpointsPane) {
                        try {
                            iModuleModel = ((INetCircuitEnd)this.excludedEndpoints.get(0)).getEntityModel();
                            if (!Feature.provides((INodeModel)iEntityModel3.getNodeModel(), (Feature)Feature.PORT_GROUPING) || !iEntityModel3.isCompatiblePGEntity((IEntityModel)iModuleModel)) {
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block24;
                            db.println("Can't find the source");
                        }
                    }
                }
            }
            if (this.getCircuitInfoType() == 4 && PortGrouping.isValidElectricalCard(iEntityModel3)) continue;
            if (iEntityModel3.getGenericClass() == 7) {
                iModuleModel = iEntityModel3.getModuleModel();
                sortablePortString = new SortablePortString(iEntityModel3);
            } else if (iEntityModel3.getGenericClass() == 6) {
                iModuleModel = (IModuleModel)iEntityModel3;
                sortablePortString = new SortablePortString();
            } else {
                if (!db.on()) continue;
                db.println(this.title + " getDropPorts: unexpected entity: " + iEntityModel3);
                continue;
            }
            if (this.isSecondary && (iModuleModel.getEqType() == 14 || iModuleModel.getEqType() == 15 || iModuleModel.getEqType() == 62 || iModuleModel.getEqType() == 102 || iModuleModel.getEqType() == 238 || iModuleModel.getEqType() == 221 || iModuleModel.getEqType() == 103 || iModuleModel.getEqType() == 163 || iModuleModel.getEqType() == 164 || iModuleModel.getEqType() == 187 || iModuleModel.getEqType() == 283 || iModuleModel.getEqType() == 229 || iModuleModel.getEqType() == 284) || this.isSecondary && !(this.cktDialog instanceof AddVcatMembersDialog) && this.cktDialog.getCircuitInfo().isBackHaulCircuit() && iModuleModel.getEqType() != 285 || this.getCircuitInfoDir() == 0 && (iModuleModel.getEqType() == 62 || iModuleModel.getEqType() == 102 || iModuleModel.getEqType() == 238 || iModuleModel.getEqType() == 221 || iModuleModel.getEqType() == 103 || iModuleModel.getEqType() == 163 || iModuleModel.getEqType() == 164 || iModuleModel.getEqType() == 187 || iModuleModel.getEqType() == 285)) continue;
            String string = this.getSlotString(iEntityModel3);
            String string2 = this.getShelfString(iEntityModel3);
            if (iEntityModel3.equals(iEntityModel)) {
                this.shelf = string2;
                this.slot = string;
                if (iEntityModel3.getGenericClass() == 7) {
                    this.port = new SortablePortString(iEntityModel3);
                }
            } else if (iEntityModel2 == null && iEntityModel3 != null && iEntityModel3.getEqType() == n && iEntityModel3.getIndex() == iEntityModel.getIndex() + 1) {
                iEntityModel2 = iEntityModel3;
            }
            if ((treeMap3 = (TreeMap<SortablePortString, IEntityModel>)this.entityMap.get(string)) == null) {
                treeMap3 = new TreeMap<SortablePortString, IEntityModel>();
                this.entityMap.put(string, treeMap3);
            }
            if (treeMap3.put(sortablePortString, iEntityModel3) != null && db.on()) {
                db.println(this.title + " getDropPorts: multiple entities with " + "slot = " + string + ", port = " + sortablePortString);
            }
            if ((treeMap2 = (TreeMap<String, TreeMap<SortablePortString, IEntityModel>>)this.shelfMap.get(string2)) == null) {
                treeMap2 = new TreeMap<String, TreeMap<SortablePortString, IEntityModel>>();
                this.shelfMap.put(string2, treeMap2);
            }
            if ((treeMap = (TreeMap<SortablePortString, IEntityModel>)treeMap2.get(string)) == null) {
                treeMap = new TreeMap<SortablePortString, IEntityModel>();
                treeMap2.put(string, treeMap);
            }
            treeMap.put(sortablePortString, iEntityModel3);
        }
        if (this.getCircuit() == null && this.isDiag()) {
            this.entityMap = new TreeMap();
            this.entityMap.put("PRBS Generator", null);
        }
        if (this.parent.ethergroupChoiceAllowed && !this.isSecondary) {
            this.entityMap.put("Ethergroup", null);
            if (bl) {
                this.slot = "Ethergroup";
            }
        }
        if (this.slot == null && iEntityModel2 != null) {
            this.slot = this.getSlotString(iEntityModel2);
            if (iEntityModel2.getGenericClass() == 7) {
                this.port = new SortablePortString(iEntityModel2);
            }
        }
    }

    protected void setEntity(IEntityModel iEntityModel) throws AnnotatedException {
        IModuleModel iModuleModel;
        if (this.isMultiShelf) {
            db.info(this.title + " setEntity: shelf = " + this.shelf + ", slot = " + this.slot + ", port = " + this.port);
        } else {
            db.info(this.title + " setEntity: slot = " + this.slot + ", port = " + this.port);
        }
        if (!iEntityModel.equals(this.getEntityModel())) {
            this.endpoint.setEntityIndex(iEntityModel.getEntityIndex());
            this.endpoint.setHoNum(null);
            this.endpoint.setLoNum(null);
        }
        this.hoNum = null;
        this.resetLoNum();
        this.isEther = false;
        if (!this.needToSetDropPoints()) {
            return;
        }
        this.getDropPoints();
        this.updateDs1PortCB();
        if (!(this.cktDialog instanceof AddVcatMembersDialog && ((AddVcatMembersDialog)this.cktDialog).getCircuitInfo().isBackHaulCircuit() || this.endpointMap.size() != 0)) {
            this.setCBList(this.getHoCB(), null);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_ENDPOINTS_AVAILABLE);
            return;
        }
        if (this.endpointMap.size() == 1 && this.endpointMap.firstKey() == null) {
            if (db.on()) {
                db.println(this.title + " setEntity: only STS choice is 0, assuming unstitched");
            }
            if (!this.isDiag()) {
                this.isEther = true;
            }
            if (!this.getCircuitInfo().isBackHaulCircuit()) {
                this.parent.setAltPanelEnabled(false);
            }
            this.setCBList(this.getHoCB(), null);
            this.setCBList(this.getLoParts(), null);
            return;
        }
        this.parent.setAltPanelEnabled(!this.getMonitor());
        this.setCBList(this.getHoCB(), this.endpointMap.keySet());
        if (this.endpointMap.size() == 1) {
            iModuleModel = iEntityModel.getModuleModel();
            if ((iModuleModel.getEqType() == 234 || iModuleModel.getEqType() == 233) && iEntityModel.getEqType() == 34) {
                NetCircuitEnd netCircuitEnd = null;
                ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfoType());
                if (iCircuitType.isLoCircuitType()) {
                    SortedMap sortedMap = (SortedMap)this.endpointMap.get(this.endpointMap.firstKey());
                    netCircuitEnd = (NetCircuitEnd)sortedMap.get(sortedMap.firstKey());
                } else {
                    netCircuitEnd = (NetCircuitEnd)this.endpointMap.get(this.endpointMap.firstKey());
                }
                int n = this.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, netCircuitEnd.getLoNum(), netCircuitEnd.getHoNum());
                int n2 = n % 28 == 0 ? n / 28 : n / 28 + 1;
                IHoNum iHoNum = HoLoFactory.idlSts2HoNum(netCircuitEnd.getHoNum().getFramingType(), n2);
                ArrayList<IHoNum> arrayList = new ArrayList<IHoNum>();
                arrayList.add(iHoNum);
                this.setCBList(this.getHoCB(), arrayList);
                this.getHoCB().setSelectedItem(iHoNum);
            } else {
                this.getHoCB().setSelectedItem(this.endpointMap.firstKey());
            }
            this.getHoCB().setEnabled(false);
        } else if (this.hoNum != null) {
            this.getHoCB().setSelectedItem(this.hoNum);
        } else if (this.endpoint.getHoNum() != null) {
            if (db.on()) {
                db.println(this.title + " setEntity: auto-incrementing hoNum");
            }
            if (this.parent != null && this.getCircuitInfo() != null) {
                this.setNextAvailableHo(iEntityModel);
            }
        }
        if (this.hoNum == null) {
            this.setCBList(this.loParts, null);
        } else if (this.loNum != null) {
            this.setLoComponents(this.loNum);
        } else if (this.endpoint.getLoNum() != null && this.endpoint.getLoNum().getCircuitSize() == this.getCircuitInfoSize()) {
            iModuleModel = this.getNextAvailableLo(this.endpoint.getHoLoNum(), iEntityModel);
            if (db.on()) {
                db.println(this.title + " setEntity: auto-incrementing loNum " + "from " + this.endpoint.getHoLoNum().prettyString("-") + " to " + iModuleModel.prettyString());
            }
            this.setLoComponents((ILoNum)iModuleModel);
        }
        if (this.useDs1PortCB) {
            this.setCBList(this.ds1PortCB, this.ds1EndpointMap.keySet());
            if (this.hoNum != null && this.loNum != null) {
                this.ds1PortCB.setSelectedItem(new Integer(this.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, this.loNum, this.hoNum)));
            }
        }
    }

    private String getOtherRPRSpanName(INetCircuit iNetCircuit) {
        INetCircuitEnd iNetCircuitEnd = iNetCircuit.getPrimarySource();
        IEntityModel iEntityModel = null;
        Object var4_4 = null;
        IPortModel iPortModel = null;
        NetCircuit netCircuit = null;
        NetCircuitEnd netCircuitEnd = null;
        String string = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null) {
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            int n = iModuleModel.getEqType();
            if (n == 102 || n == 103 || n == 285 || n == 221) {
                if (n == 285) {
                    int n2 = 165;
                } else {
                    int n3 = 105;
                }
                int n4 = iEntityModel.getPort();
                iPortModel = ((NetCircuitEnd)iNetCircuitEnd).getOtherPosPortModelFromPair();
            }
            netCircuitEnd = new NetCircuitEnd(iNetCircuitEnd.getNodeModel(), (IEntityModel)iPortModel, iNetCircuitEnd.getHoLoNum(), false);
            netCircuit = (NetCircuit)NetCircuitManager.instance().getCircuitFromCircuitEnd(netCircuitEnd);
            if (netCircuit != null) {
                string = netCircuit.getCircuitName();
            }
        }
        return string;
    }

    public void validateRPRCircuitSize() {
        this.updateRprMode();
        if (this.bRprMode && this.parent != null) {
            int n;
            if (AbstractCcdEndpointPanel.db.on) {
                db.println(this.title + " actionPerformed: bRprMode = true");
            }
            INetCircuit iNetCircuit = this.parent != null ? this.getCircuit() : null;
            int n2 = n = this.getCircuitInfoSize();
            try {
                if (iNetCircuit != null) {
                    n2 = iNetCircuit.validateML2CircuitSize();
                }
            }
            catch (CircuitProvError circuitProvError) {
                db.println(this.title + " actionPerformed: ncp call validateML2CircuitSize failed, CircuitProvError " + circuitProvError);
            }
            if (n2 != n) {
                String string = this.getOtherRPRSpanName(iNetCircuit);
                ErrorMsg.displayWarning(this, (EID)NEMC.WID_CIRCUIT_SIZES_DIFFER_WARNING, string == null ? "" : string, CircuitSize.getCircuitSize((int)n).getCircuitSizeString(), CircuitSize.getCircuitSize((int)n2).getCircuitSizeString());
            }
        }
    }

    protected abstract void setLoComponents(ILoNum var1);

    protected void getDropPoints() throws AnnotatedException {
        List list;
        try {
            list = this.getCircuit() != null ? this.getCircuit().getAvailDropPoints(this.endpoint.getNodeModel(), this.getEntityModel()) : NetCircuitManager.instance().getAvailSourcePoints(this.endpoint.getNodeModel(), this.getEntityModel(), this.getCircuitInfo());
        }
        catch (Exception exception) {
            throw new AnnotatedException("The list of available drop points cannot be obtained from the node " + this.endpoint.getNodeModel().getName() + ".", exception);
        }
        this.endpointMap = new TreeMap();
        this.ds1EndpointMap.clear();
        if (this.isNull(list, "availDropPoints")) {
            return;
        }
        IModuleModel iModuleModel = null;
        boolean bl = this.useDs1EndpointAsPort(this.getSlotModuleModel());
        if (bl) {
            IEntityModel iEntityModel = this.getEntityModel();
            bl = iEntityModel != null && (iModuleModel = iEntityModel.getModuleModel()) != null;
        }
        for (INetCircuitEnd iNetCircuitEnd : list) {
            int n;
            Object object;
            if (iNetCircuitEnd == null) {
                if (!db.on()) continue;
                db.println(this.title + " getDropPoints: null entity returned from getAvailDropPorts");
                continue;
            }
            if (this.parent != null && this.getPortGrouping() && (this.parent.excludePane != null || this.parent instanceof RollEndpointsPane) && iNetCircuitEnd.equals(object = (INetCircuitEnd)this.excludedEndpoints.get(0))) continue;
            try {
                object = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                object = null;
            }
            IHoNum iHoNum = CircuitEndCellRenderer.convertToExternalHoNumber(object, iNetCircuitEnd.getHoNum());
            if (HoLoComparator.instance().isEqual(iNetCircuitEnd.getHoNum(), this.endpoint.getHoNum())) {
                if (this.hoNum == null) {
                    this.hoNum = iHoNum;
                }
                if (HoLoComparator.instance().isEqual(iNetCircuitEnd.getLoNum(), this.endpoint.getLoNum()) && iNetCircuitEnd.getLoNum() != null) {
                    this.loNum = iNetCircuitEnd.getLoNum();
                }
            }
            if (iNetCircuitEnd.getLoNum() == null) {
                INetCircuitEnd iNetCircuitEnd2 = this.endpointMap.put(iHoNum, iNetCircuitEnd);
            } else {
                boolean bl2;
                SortedMap sortedMap = (SortedMap)this.endpointMap.get(iHoNum);
                boolean bl3 = bl2 = sortedMap == null;
                if (bl2) {
                    sortedMap = this.createNewLoMap();
                    this.endpointMap.put(iHoNum, sortedMap);
                }
                this.putInLoMap(sortedMap, iNetCircuitEnd);
            }
            if (!bl || (n = this.getPortForPath(iModuleModel, this.getEntityModel(), iNetCircuitEnd.getLoNum(), iNetCircuitEnd.getHoNum())) == 0) continue;
            this.ds1EndpointMap.put(n, iNetCircuitEnd);
        }
    }

    protected abstract SortedMap createNewLoMap();

    protected abstract void putInLoMap(SortedMap var1, INetCircuitEnd var2);

    protected abstract boolean inLoMap(SortedMap var1, ILoNum var2);

    protected abstract ILoNum getFirstLoFromLoMap(SortedMap var1, int var2);

    protected void setCBList(List list, Collection collection) {
        for (Object e : list) {
            if (!(e instanceof JComboBox)) continue;
            this.setCBList((JComboBox)e, collection);
        }
    }

    protected void setCBList(JComboBox jComboBox, Collection collection) {
        jComboBox.removeActionListener(this);
        if (collection != null) {
            Object[] objectArray = collection.toArray();
            if (db.on()) {
                db.println(this.title + " setCBList: " + jComboBox.getName() + " choices: " + ((AbstractCollection)collection).toString());
            }
            jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
        if (collection == null || this.parent.excludePane == null && this.getMonitor() || collection.isEmpty()) {
            if (db.on()) {
                db.println(this.title + " setCBList: disabling " + jComboBox.getName());
            }
            jComboBox.setEnabled(false);
        } else {
            jComboBox.setEnabled(true);
            jComboBox.addActionListener(this);
        }
        jComboBox.setSelectedItem(null);
    }

    protected IEntityModel getEntityModel() {
        IEntityModel iEntityModel;
        block2: {
            iEntityModel = null;
            try {
                iEntityModel = this.endpoint.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                if (!db.on()) break block2;
                db.println("Can't find the entity model");
            }
        }
        return iEntityModel;
    }

    protected void debugEndpoint(String string) {
        if (db.on()) {
            db.println(string + "endpoint.node = " + this.endpoint.getNodeModel());
            db.println(string + "endpoint.entity = " + this.getEntityModel());
            if (this.isMultiShelf) {
                db.println(string + "shelf = " + this.shelf);
            }
            db.println(string + "slot = " + this.slot);
            db.println(string + "port = " + this.port);
            db.println(string + "endpoint.hoNum = " + this.endpoint.getHoNum());
        }
    }

    protected boolean isNull(Object object, String string) {
        if (object == null) {
            if (db.on()) {
                db.println(this.title + " " + string + " is null");
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.shelfCB.hidePopup();
        this.slotCB.hidePopup();
        this.portCB.hidePopup();
        this.ds1PortCB.hidePopup();
        this.hideCBPopup(this.getHoParts());
        this.hideCBPopup(this.getLoParts());
        if (this.shelfMap != null) {
            this.shelfMap.clear();
        }
        if (this.entityMap != null) {
            this.entityMap.clear();
        }
        if (this.portMap != null) {
            this.portMap.clear();
        }
    }

    public void recycle() {
        if (this.shelfMap != null) {
            this.shelfMap.clear();
        }
        if (this.endpointMap != null) {
            this.endpointMap.clear();
        }
        if (this.ds1EndpointMap != null) {
            this.ds1EndpointMap.clear();
        }
        if (this.entityMap != null) {
            this.entityMap.clear();
        }
        if (this.portMap != null) {
            this.portMap.clear();
        }
        this.endpoint = null;
        this.excludedEndpoints.clear();
        if (this.shelfCB != null) {
            this.shelfCB.removeActionListener(this);
        }
        if (this.slotCB != null) {
            this.slotCB.removeActionListener(this);
        }
        if (this.portCB != null) {
            this.portCB.removeActionListener(this);
        }
        if (this.ds1PortCB != null) {
            this.ds1PortCB.removeActionListener(this);
        }
        this.port = null;
        this.parent = null;
        this.hoNum = null;
        this.loNum = null;
        this.removeAll();
    }

    protected static void setComponentsVisible(List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setVisible(bl);
        }
    }

    protected abstract JComboBox getHoCB();

    private void hideCBPopup(List list) {
        for (Object e : list) {
            if (!(e instanceof JComboBox)) continue;
            ((JComboBox)e).hidePopup();
        }
    }

    protected IHoLoNum getNextHoLoNum(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoLoNum);
        return HoLoFactory.addOffset(iHoLoNum2, 1);
    }

    protected Object getValidSelectedItem(JComboBox jComboBox, Object object) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
        if (defaultComboBoxModel.getIndexOf(object) < 0) {
            jComboBox.setSelectedIndex(0);
            return defaultComboBoxModel.getElementAt(0);
        }
        return object;
    }

    private void setNextAvailableHo(IEntityModel iEntityModel) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.getCircuitInfoType());
        int n = this.endpoint.getHoNum().getFramingType();
        int n2 = iCircuitType.isLoCircuitType() ? CircuitSize.getLoTunnelSize((int)n).getEnum() : this.getCircuitInfoSize();
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        IHoNum iHoNum = CircuitEndCellRenderer.convertFromExternalHoNumber(iEntityModel, this.endpoint.getHoNum());
        int n3 = iCircuitSize.getFramingTypeHoPathWidth(n);
        IHoNum iHoNum2 = this.getNextAvailableHo(iHoNum, n3);
        this.getHoCB().setSelectedItem(iHoNum2);
    }

    private IHoNum getNextAvailableHo(IHoNum iHoNum, int n) {
        IHoNum iHoNum2 = iHoNum;
        while (true) {
            IHoNum iHoNum3;
            try {
                iHoNum3 = HoLoFactory.addOffset(iHoNum2, n);
            }
            catch (ArithmeticException arithmeticException) {
                break;
            }
            if (this.endpointMap.keySet().contains(iHoNum3)) {
                return iHoNum3;
            }
            iHoNum2 = iHoNum3;
        }
        return (IHoNum)this.endpointMap.firstKey();
    }

    private ILoNum getNextAvailableLo(IHoLoNum iHoLoNum, IEntityModel iEntityModel) {
        IHoNum iHoNum = iHoLoNum.getHoNum();
        ILoNum iLoNum = iHoLoNum.getLoNum();
        SortedMap sortedMap = (SortedMap)this.endpointMap.get(iHoNum);
        for (int i = 1; i < 10; ++i) {
            IHoLoNum iHoLoNum2;
            try {
                iHoLoNum2 = this.getNextHoLoNum(iHoLoNum, iEntityModel);
            }
            catch (ArithmeticException arithmeticException) {
                break;
            }
            if (!iHoLoNum2.getHoNum().equals(iHoNum)) break;
            if (this.inLoMap(sortedMap, iHoLoNum2.getLoNum())) {
                return iHoLoNum2.getLoNum();
            }
            iHoLoNum = iHoLoNum2;
        }
        return this.getFirstLoFromLoMap(sortedMap, iLoNum.getCircuitSize());
    }

    protected boolean useDs1EndpointAsPort(IModuleModel iModuleModel) {
        if (this.slot != null && this.slot.indexOf("RAN") >= 0 && iModuleModel != null) {
            int n = this.getCircuitInfoSize();
            return n == 0 || n == 10;
        }
        return false;
    }

    protected void updateRprMode() {
        IEntityModel iEntityModel = this.getEntityModel();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        this.bRprMode = Feature.provides((INodeModel)this.node, (Feature)Feature.RPR_802_17) && this.slot != null && iEntityModel != null ? iEntityModel.inRPRMode() : false;
        if (AbstractCcdEndpointPanel.db.on) {
            db.println("bRprMode set to " + this.bRprMode);
        }
    }

    private void updateDs1PortCB() {
        boolean bl = this.useDs1EndpointAsPort(this.getSlotModuleModel());
        db.fine("updateDs1PortCB: ds1EndpointAsPort = " + bl + ", useDs1PortCB = " + this.useDs1PortCB);
        if (bl ^ this.useDs1PortCB) {
            this.useDs1PortCB = bl;
            if (this.useDs1PortCB) {
                db.fine("Replace portCB with ds1PortCB");
                this.portRowPanel.remove(this.portCB);
                this.portRowPanel.add((Component)this.ds1PortCB, "Center");
                this.setCBList(this.ds1PortCB, null);
            } else {
                db.fine("Replace ds1PortCB with portCB");
                this.portRowPanel.remove(this.ds1PortCB);
                this.portRowPanel.add((Component)this.portCB, "Center");
            }
            this.portRowPanel.validate();
        }
    }

    protected int getPortForPath(IModuleModel iModuleModel, IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        int n = 0;
        if (Feature.delegateProvides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.C310MA)) {
            int[] nArray;
            IPortModel iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoNum);
            if (iPortModel != null && (nArray = iPortModel.getPortNum()) != null && nArray.length == 1) {
                n = nArray[0];
            }
        } else {
            n = iModuleModel.getPortForPath(iLoNum, iHoNum);
        }
        return n;
    }

    protected IModuleModel getSlotModuleModel() {
        SortedMap sortedMap = (SortedMap)this.entityMap.get(this.slot);
        if (sortedMap == null || sortedMap.size() == 0) {
            return null;
        }
        IEntityModel iEntityModel = (IEntityModel)sortedMap.get(sortedMap.firstKey());
        return iEntityModel == null ? null : iEntityModel.getModuleModel();
    }

    protected void setMemberHoLoNums() {
        int n = this.memberList.getModel().getSize();
        if (n == 0) {
            return;
        }
        IHoLoNum[] iHoLoNumArray = new IHoLoNum[n];
        for (int i = 0; i < iHoLoNumArray.length; ++i) {
            iHoLoNumArray[i] = (IHoLoNum)this.memberList.getModel().getElementAt(i);
            if (!db.on()) continue;
            db.println("Selected member[" + i + "]=" + iHoLoNumArray[i].getHoNum() + "-" + iHoLoNumArray[i].getLoNum());
        }
        if (!this.parent.isDestPane()) {
            if (this.isSecondary) {
                this.getCircuitInfo().setMemberSecSrcHoLoNums(iHoLoNumArray);
            } else {
                this.getCircuitInfo().setMemberSrcHoLoNums(iHoLoNumArray);
            }
        } else if (this.isSecondary) {
            this.getCircuitInfo().setMemberSecDropHoLoNums(iHoLoNumArray);
        } else {
            this.getCircuitInfo().setMemberDropHoLoNums(iHoLoNumArray);
        }
    }

    protected void retrieveMemberListData() {
        IHoLoNum[] iHoLoNumArray;
        block6: {
            iHoLoNumArray = null;
            try {
                IHoLoNum[] iHoLoNumArray2;
                if (this.parent.inSourcePane()) {
                    iHoLoNumArray2 = NetCircuitManager.instance();
                    iHoLoNumArray = iHoLoNumArray2.getSourceAutoSelectVcatPaths(this.node, this.getEntityModel(), this.getCircuitInfo());
                } else {
                    iHoLoNumArray2 = this.getCircuitInfo().getMemberSrcHoLoNums();
                    int n = this.getCircuitInfo().forwardMembers();
                    NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.getCircuit();
                    iHoLoNumArray = netVcatCircuit.getDropAutoSelectVcatPaths(this.node, this.getEntityModel(), iHoLoNumArray2, n);
                }
            }
            catch (ProvisionError provisionError) {
                if (!db.on()) break block6;
                db.println("Error retrieving getSourceAutoSelectVcatPaths()/getDropAutoSelectVcatPaths()");
            }
        }
        this.memberList.setListData(iHoLoNumArray);
        if (db.on()) {
            db.println("IHoLoNum[] from ncm.getSourceAutoSelectVcatPaths");
            for (IHoLoNum iHoLoNum : iHoLoNumArray) {
                db.println("HO: " + iHoLoNum.getHoNum() + "\tLO: " + iHoLoNum.getLoNum());
            }
        }
    }

    private boolean needToSetDropPoints() {
        return !CircuitType.getCircuitType((int)this.getCircuitInfoType()).isVcatCircuitType() || !this.isEntityMaunualModeCe2Card();
    }

    public INetCircuitEnd getProtEndPoint() {
        return null;
    }

    public INetCircuitEnd getReverseEndPoint() {
        return null;
    }

    protected boolean isEntityMaunualModeCe2Card() {
        boolean bl = false;
        IEntityModel iEntityModel = this.getEntityModel();
        if (iEntityModel == null) {
            return bl;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel == null) {
            return bl;
        }
        int n = iModuleModel.getEqType();
        if (!(n != 283 && n != 284 && n != 285 || iModuleModel.isAutoProvisionMode())) {
            bl = true;
        }
        return bl;
    }

    class SliceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            block3: {
                string = null;
                try {
                    int n2;
                    String string2;
                    if (object instanceof IHoLoNum && (string2 = (string = HoLoHelper.getSlashSeparatedDisplay((IHoLoNum)object)).substring((n2 = string.length()) - 1, n2)).equals("/")) {
                        string = string.substring(0, n2 - 1);
                    }
                }
                catch (Exception exception) {
                    if (!AbstractCcdEndpointPanel.db.on) break block3;
                    db.println("SliceCellRenderer.Exception");
                }
            }
            this.setText(string);
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

