/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.circuits.HoLoPane;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public abstract class AbstractSdhHoLoPane
extends HoLoPane {
    protected JLabel vc4LB;
    protected JLabel tug3LB;
    protected JLabel vc3LB;
    protected JLabel tug2LB;
    protected JLabel vc11_12LB;
    protected JComboBox vc4CB;
    protected JComboBox vc3CB;
    protected JComboBox tug2CB;
    protected JComboBox vc11_12CB;
    protected Map vc3Map;
    protected Map tug2Map;
    protected Map vc11_12Map;
    private SDebug dbg;

    public AbstractSdhHoLoPane(SDebug sDebug) {
        super(sDebug);
        this.dbg = sDebug;
    }

    public void enable(INetLink iNetLink, int n, int n2) {
        super.setNetLink(iNetLink);
        this.circuitSize = CircuitSize.getCircuitSize((int)n);
        this.circuitType = CircuitType.getCircuitType((int)n2);
        if (this.dbg.on()) {
            this.dbg.println("AbstractSdhHoLoPane:enable netLink size=" + n + " type =" + n2);
        }
        this.clearControls();
        if (this.getNetLink().isLOTunnel()) {
            this.getHoCB().setEnabled(false);
        } else {
            ArrayList arrayList = (ArrayList)this.getNetLink().getAvailableHoNumbers(n, n2);
            if (this.circuitType.isHoVcatCircuitType()) {
                this.filterHoNumbersForVcat(arrayList);
            }
            if (this.dbg.on()) {
                this.dbg.println("AbstractSdhHoLoPane: got HO list size=" + arrayList.size());
            }
            this.getHoCB().setEnabled(true);
            if (arrayList != null) {
                Object[] objectArray = arrayList.toArray();
                Arrays.sort(objectArray);
                this.getHoCB().setModel(new DefaultComboBoxModel<Object>(objectArray));
            }
            if (this.getHoCB().getItemCount() > 0) {
                this.getHoCB().setSelectedIndex(0);
            }
        }
        this.initCB();
    }
}

