/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.VcatNotReconfigurable;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.AdminStatePanel;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddVcatMemAttrsPane
extends WzCcdPane {
    AddVcatMembersDialog parentDlg;
    private UComboBox memNumCB;
    private JCheckBox tl1LikeChBox;
    private JLabel newSizeLabel;
    AdminStatePanel adminStatePanel;
    private static final String CUR_SIZE = "Current Circuit size     : ";
    private static final String NEW_SIZE = "New Circuit size         : ";
    private static final String MEM_NUMBERS = "Number of members to add : ";
    private static final String INITIAL_STATE = "Initial State:";
    private static final String TL1_LIKE = "Create cross-connects only (TL1-like)";

    public AddVcatMemAttrsPane(AddVcatMembersDialog addVcatMembersDialog, WzDiagDebug wzDiagDebug, String string) {
        super(addVcatMembersDialog, wzDiagDebug, string);
        this.parentDlg = addVcatMembersDialog;
    }

    protected void initPane() {
        int n;
        block15: {
            n = 0;
            this.memNumCB = new UComboBox();
            INetCircuitEnd iNetCircuitEnd = this.parentDlg.getSource();
            INetCircuitEnd iNetCircuitEnd2 = this.parentDlg.getDest();
            NetVcatCircuit netVcatCircuit = (NetVcatCircuit)this.parentDlg.getCircuit();
            INetVcatTermination iNetVcatTermination = netVcatCircuit.getVcatTermFromCktEnd(iNetCircuitEnd);
            INetVcatTermination iNetVcatTermination2 = null;
            if (!netVcatCircuit.isOpenEndedVcatCircuit()) {
                if (this.parentDlg.getCircuitInfo().isBackHaulCircuit()) {
                    try {
                        n = netVcatCircuit.getForwardVcatGroup().getAllowedBackHaulMembers();
                    }
                    catch (VcatNotReconfigurable vcatNotReconfigurable) {
                        if (this.db.on()) {
                            WzDiagDebug.printStackTrace((Throwable)vcatNotReconfigurable);
                        }
                    }
                } else {
                    iNetVcatTermination2 = netVcatCircuit.getVcatTermFromCktEnd(iNetCircuitEnd2);
                    if (iNetVcatTermination != null && iNetVcatTermination2 != null) {
                        try {
                            n = Math.min(iNetVcatTermination.getNumOfNewMembersAllowed(), iNetVcatTermination2.getNumOfNewMembersAllowed());
                        }
                        catch (VcatNotReconfigurable vcatNotReconfigurable) {
                            if (this.db.on()) {
                                WzDiagDebug.printStackTrace((Throwable)vcatNotReconfigurable);
                            }
                        }
                    }
                }
            } else {
                try {
                    n = iNetVcatTermination.getNumOfNewMembersAllowed();
                }
                catch (VcatNotReconfigurable vcatNotReconfigurable) {
                    if (!this.db.on()) break block15;
                    WzDiagDebug.printStackTrace((Throwable)vcatNotReconfigurable);
                }
            }
        }
        for (int i = 1; i <= n; ++i) {
            this.memNumCB.addItem((Object)new Integer(i));
        }
        String string = this.parentDlg.getCircuit().getCircuitSizeObj().getCircuitSizeString();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder("Size"));
        jPanel.setAlignmentX(0.0f);
        int n2 = ((NetVcatCircuit)this.parentDlg.getCircuit()).getConfiguredForwardMemberSize();
        String string2 = string + "-" + n2 + "v";
        jPanel.add(new JLabel(CUR_SIZE));
        jPanel.add(new JLabel(string2));
        jPanel.add(new JLabel(MEM_NUMBERS));
        jPanel.add((Component)this.memNumCB);
        this.memNumCB.addActionListener((ActionListener)this);
        if (n > 0) {
            n2 += ((Integer)this.memNumCB.getSelectedItem()).intValue();
        }
        String string3 = string + "-" + n2 + "v";
        jPanel.add(new JLabel(NEW_SIZE));
        this.newSizeLabel = new JLabel(string3);
        jPanel.add(this.newSizeLabel);
        JPanel jPanel2 = AddVcatMemAttrsPane.createHorizontalPanel(null);
        this.tl1LikeChBox = new JCheckBox(TL1_LIKE);
        this.initLikeTl1Default();
        jPanel2.add(this.tl1LikeChBox);
        jPanel2.setAlignmentX(0.0f);
        this.adminStatePanel = new AdminStatePanel("State", this.parentDlg.getCircuit(), false);
        this.initCircuitStateDefault();
        this.adminStatePanel.setApplyDropPorts(false);
        this.adminStatePanel.setApplyDropPortsApplicable(false);
        this.adminStatePanel.setAlignmentX(0.0f);
        JPanel jPanel3 = AddVcatMemAttrsPane.createVerticalPanel(null);
        jPanel3.add(jPanel);
        jPanel3.add(Box.createVerticalStrut(20));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalStrut(20));
        jPanel3.add(this.adminStatePanel);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(Box.createVerticalStrut(35));
        jPanel3.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "West");
    }

    public void validatePage() throws Exception {
        int n;
        this.parentDlg.setVcatTxMembers((Integer)this.memNumCB.getSelectedItem());
        this.parentDlg.setAddMemCount(this.parentDlg.getVcatTxMembers());
        this.parentDlg.getCircuitInfo().setForwardMembers(this.parentDlg.getVcatTxMembers());
        this.parentDlg.getCircuitInfo().setReverseMembers(this.parentDlg.getVcatTxMembers());
        if (this.adminStatePanel != null) {
            n = this.adminStatePanel.getAdminState();
            this.parentDlg.getCircuitInfo().setAdminState(n);
            int n2 = this.adminStatePanel.getAdminState();
            String string = NetAdminState.getAdminStateStringFromAdminState(n);
            String string2 = NetAdminState.getAdminStateStringFromAdminState(4);
            if (n2 == 0 || n2 == 3) {
                this.isOkToPostValidate = CerentDialog.yesNoWarningDialog((Component)this, (String)("Adding " + string + " members to a VCAT circuit\n" + "will affect the service of entire circuit for\n" + "a certain period of time.\n\n" + (this.isVcatTermLCAS() ? "To avoid traffic loss, select the " + string2 + " state\n" + "for the new members.  Place them in the " + string + "\n" + "state after the circuit has been created.\n\n" : "") + "Continue with member creation ?"), (String)"Add Members", (int)1);
            } else if (n2 == 1 && !this.isVcatTermLCAS()) {
                this.isOkToPostValidate = CerentDialog.yesNoWarningDialog((Component)this, (String)("Adding " + string + " members to a VCAT circuit\n" + "will affect the service of entire circuit until \n" + "the newly added members are placed in service.\n\n" + "Continue with member creation ?"), (String)"Add Members", (int)1);
            }
            if (!this.isOkToPostValidate) {
                return;
            }
        }
        n = this.tl1LikeChBox.isSelected() ? 1 : 0;
        this.parentDlg.getCircuitInfo().setTL1Compatible(n != 0);
        this.parentDlg.createNewMemCkts();
        if (!((NetVcatCircuit)this.parentDlg.getCircuit()).isOpenEndedVcatCircuit()) {
            this.parentDlg.addDestination(false);
        }
    }

    private boolean isVcatTermLCAS() {
        List list = ((NetVcatCircuit)this.parentDlg.getCircuit()).getAllVcatTerms();
        if (list.size() == 0) {
            return false;
        }
        for (INetVcatTermination iNetVcatTermination : list) {
            if (iNetVcatTermination.getLcasMode() != 2) continue;
            return true;
        }
        return false;
    }

    public void revalidateData() {
        this.db.fine("revalidateData");
        this.initCircuitStateDefault();
        this.initLikeTl1Default();
        if (this.memNumCB.getItemCount() < 1) {
            this.parentDlg.setNextEnabled(false);
            this.parentDlg.setFinishEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.memNumCB) {
            Integer n = (Integer)this.memNumCB.getSelectedItem();
            String string = this.parentDlg.getCircuit().getCircuitSizeObj().getCircuitSizeString();
            int n2 = ((NetVcatCircuit)this.parentDlg.getCircuit()).getConfiguredForwardMemberSize();
            String string2 = string + "-" + (n2 += n.intValue()) + "v";
            this.newSizeLabel.setText(string2);
        }
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nNumber of members to add: ");
        stringBuffer.append(((Integer)this.memNumCB.getSelectedItem()).toString());
        if (this.tl1LikeChBox.isSelected()) {
            stringBuffer.append("\nMode : TL1-Like");
        }
        stringBuffer.append("\nState: " + NetAdminState.getAdminStateStringFromAdminState(this.adminStatePanel.getAdminState()) + "\nApply ckt state to drop ports: " + this.adminStatePanel.getApplyDropPorts());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected String getNextPaneName() {
        boolean bl = true;
        IModuleModel iModuleModel = null;
        IModuleModel iModuleModel2 = null;
        try {
            iModuleModel = this.parentDlg.getSource().getEntityModel().getModuleModel();
            if (this.parentDlg.getCircuitInfo().isBackHaulCircuit()) {
                if (this.parentDlg.getAltSource() != null) {
                    iModuleModel2 = this.parentDlg.getAltSource().getEntityModel().getModuleModel();
                    if (iModuleModel2 != null && this.isCE2ManualMode(iModuleModel2)) {
                        return "Source";
                    }
                    if (this.isCE2ManualMode(iModuleModel)) {
                        return "Source";
                    }
                } else {
                    if (this.isCE2ManualMode(iModuleModel)) {
                        return "Source";
                    }
                    if (this.parentDlg.getAltDest() != null && !this.parentDlg.ckt.isOpenEndedVcatCircuit()) {
                        iModuleModel = this.parentDlg.getDest().getEntityModel().getModuleModel();
                        iModuleModel2 = this.parentDlg.getAltDest().getEntityModel().getModuleModel();
                        if (iModuleModel2 != null && this.isCE2ManualMode(iModuleModel2)) {
                            return "Destination";
                        }
                        if (this.isCE2ManualMode(iModuleModel)) {
                            return "Destination";
                        }
                    }
                }
            } else if (this.isCE2ManualMode(iModuleModel)) {
                return "Source";
            }
            if (this.parentDlg.ckt.isOpenEndedVcatCircuit()) {
                return "OpenVcat Destinations";
            }
            iModuleModel = this.parentDlg.getDest().getEntityModel().getModuleModel();
            if (this.isCE2ManualMode(iModuleModel)) {
                return "Destination";
            }
        }
        catch (ObjNotFound objNotFound) {
            WzDiagDebug.printStackTrace((Throwable)objNotFound);
        }
        return "Routing and Member Preferences";
    }

    private boolean isCE2ManualMode(IModuleModel iModuleModel) {
        boolean bl = false;
        if (iModuleModel.getEqType() == 284 || iModuleModel.getEqType() == 283 || iModuleModel.getEqType() == 285) {
            bl = !iModuleModel.isAutoProvisionMode();
        }
        return bl;
    }

    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("AddVcatMemAttrsPane:");
        if (this.tl1LikeChBox != null) {
            stringBuffer.append("TL1Like Checked: " + this.tl1LikeChBox.isSelected());
        }
        if (this.newSizeLabel != null) {
            stringBuffer.append("New Size: " + this.newSizeLabel.getText());
        }
        return stringBuffer.toString();
    }

    public CSHelpID getHelpID() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.parentDlg.getCircuitType());
        if (iCircuitType.isHoVcatCircuitType()) {
            return NetCSHelpConst.CcdHoVcatAttrsPane;
        }
        return NetCSHelpConst.CcdLoVcatAttrsPane;
    }

    public void removeListeners() {
        if (this.memNumCB != null) {
            this.memNumCB.addActionListener((ActionListener)this);
        }
    }

    public void dispose() {
        this.memNumCB = null;
        this.tl1LikeChBox = null;
        this.newSizeLabel = null;
        this.adminStatePanel = null;
        this.parentDlg = null;
    }

    private void initLikeTl1Default() {
        String string;
        block2: {
            string = "FALSE";
            try {
                INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
                string = iNodeModel.getDefaultValue("CTC.circuits.CreateLikeTL1");
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block2;
                this.db.severe("Can't retrieve NODE.circuits.State: " + exception.getMessage());
            }
        }
        this.tl1LikeChBox.setSelected(string.equalsIgnoreCase("TRUE"));
        this.db.info("Default createLikeTl1 is " + string);
    }

    private void initCircuitStateDefault() {
        int n;
        block2: {
            n = 3;
            try {
                INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel();
                n = Integer.parseInt(iNodeModel.getDefaultValue("NODE.circuits.State"));
            }
            catch (Exception exception) {
                if (!this.db.isSevereEnabled()) break block2;
                this.db.severe("Can't retrieve NODE.circuits.State: " + exception.getMessage());
            }
        }
        this.adminStatePanel.setAdminState(n);
        this.parentDlg.getCircuitInfo().setAdminState(n);
        this.db.info("Default circuit state is " + n);
    }
}

