/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.circuits.BulkRollAttrsPane;
import cerent.cms.ui.circuits.BulkRollEndpointPane;
import cerent.util.gui.DialogCache;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;

public class BulkRollDialog
extends WizardDialog {
    private static final String TITLE = "Bulk Roll";
    private static final int VIGN_WIDTH = 200;
    private static final int SHORT = 375;
    private static final int FROM = 1;
    private static final int TO = 2;
    private JButton okButton;
    private JButton cancelButton;
    protected int guiRollMode;
    protected String rollType;
    protected boolean forceRollCreation = false;
    public static final String GET_ROLL_ATTRS = "Roll Attributes";
    public static final String GET_ROLL_FROM_POINT_1 = "Roll from points for 1st node";
    public static final String GET_ROLL_TO_POINT_1 = "Roll to points for 1st node";
    BulkRollAttrsPane attrPane;
    BulkRollEndpointPane bulkRollFrom1;
    BulkRollEndpointPane bulkRollTo1;
    protected INodeModel rollNode = null;

    public static BulkRollDialog instance(Frame frame) {
        BulkRollDialog bulkRollDialog = (BulkRollDialog)DialogCache.getRecycledDialog((Window)frame, BulkRollDialog.class);
        if (bulkRollDialog == null) {
            bulkRollDialog = new BulkRollDialog(frame);
        } else {
            bulkRollDialog.reset();
            bulkRollDialog.setLocationRelativeTo(frame);
        }
        bulkRollDialog.createPanes();
        DialogCache.recycleDialog((JDialog)bulkRollDialog);
        return bulkRollDialog;
    }

    private BulkRollDialog(Frame frame) {
        super(frame, TITLE, true);
    }

    public INodeModel getRollNode() {
        return this.rollNode;
    }

    public void setRollNode(INodeModel iNodeModel) {
        System.out.println("Setting roll node to " + iNodeModel);
        this.rollNode = iNodeModel;
    }

    protected void createPanes() {
        this.addStatusPanel(new WizardDialog.StatusPanel(this, "/images/CTC_dialogVignette.gif", new Dimension(200, 375)));
        this.attrPane = new BulkRollAttrsPane(GET_ROLL_ATTRS, this);
        this.addPage(this.attrPane);
        this.bulkRollFrom1 = new BulkRollEndpointPane(GET_ROLL_FROM_POINT_1, 1, this);
        this.addPage(this.bulkRollFrom1);
        this.bulkRollTo1 = new BulkRollEndpointPane(GET_ROLL_TO_POINT_1, 2, this);
        this.addPage(this.bulkRollTo1);
        System.out.println("BRDialog roll node = " + this.rollNode);
    }

    protected void handleNext(String string) throws Exception {
        System.out.println("Showing page " + string);
        if (string == GET_ROLL_ATTRS) {
            this.showPage(GET_ROLL_FROM_POINT_1, false);
        } else if (string == GET_ROLL_FROM_POINT_1) {
            this.showPage(GET_ROLL_TO_POINT_1, false);
            this.setFinishEnabled(true);
        } else {
            super.handleNext(string);
        }
    }

    protected void reset() {
    }

    protected void apply() throws Exception {
    }
}

