/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.Network;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.util.SDebug;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CcdOchAttrsTableModel
extends AbstractTableModel {
    private static final SDebug db = new SDebug("CcdOchAttrsTableModel");
    private String[][] cacheValues = null;
    public static final int LINENUMBER_INDEX = 0;
    public static final int SERVICESTATE_INDEX = 1;
    public static final int OTN_INDEX = 2;
    public static final int FEC_INDEX = 3;
    public static final int SFBERLEVEL_INDEX = 4;
    public static final int SDBERLEVEL_INDEX = 5;
    public static final int AYSYMAP_INDEX = 6;
    public static final int REVERTIVE_INDEX = 7;
    public static final int TIME_INDEX = 8;
    public static final String[] COLUMN_NAMES = new String[]{" ", "Service State", "ITU-T G.709 OTN", "FEC", "SF BER", "SD BER", "Mapping", "Revertive", "Rev Time (min)"};
    private IEntityModel[] trunkModels;
    private ArrayList<OchTrailAttrsHelper.Mapping> mappingDataTypeFirstTrunk;
    private ArrayList<OchTrailAttrsHelper.Mapping> mappingDataTypeSecondTrunk;
    private boolean isRevertiveEnable = false;

    public CcdOchAttrsTableModel(IEntityModel[] iEntityModelArray) {
        this.trunkModels = iEntityModelArray;
        this.updateModel(iEntityModelArray, false);
    }

    protected void updateModel(IEntityModel[] iEntityModelArray, boolean bl) {
        this.isRevertiveEnable = bl;
        this.cacheValues = new String[2][COLUMN_NAMES.length];
        this.mappingDataTypeFirstTrunk = new ArrayList();
        this.fillHashMap(this.trunkModels[0].getModuleModel().getEqType(), this.mappingDataTypeFirstTrunk);
        this.mappingDataTypeSecondTrunk = new ArrayList();
        this.fillHashMap(this.trunkModels[1].getModuleModel().getEqType(), this.mappingDataTypeSecondTrunk);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    private void fillHashMap(int n, ArrayList<OchTrailAttrsHelper.Mapping> arrayList) {
        switch (n) {
            case 243: 
            case 273: 
            case 282: {
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_SYNCH);
                break;
            }
            case 182: 
            case 276: {
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_ODU_MUX);
                break;
            }
            case 181: 
            case 274: 
            case 275: {
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_SYNCH);
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_ASYNCH);
                break;
            }
            case 293: {
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_SYNCH);
                break;
            }
            default: {
                arrayList.add(OchTrailAttrsHelper.Mapping.MAPPING_NOTUSED);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 7) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.trunkModels.length;
    }

    @Override
    public int getColumnCount() {
        if (this.isRevertiveEnable) {
            return COLUMN_NAMES.length;
        }
        return COLUMN_NAMES.length - 2;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getPortDescriptionFor(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 1: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getServiceState(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 2: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getOTNStatus(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 3: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getFECStatus(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 4: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getOTNSfBerLevel(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 5: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getOTNSdBerLevel(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 6: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getAySyMappingStatus(n);
                    }
                    return this.cacheValues[n][n2];
                }
                case 7: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.getRevertive(n) ? "true" : "false";
                    }
                    return this.cacheValues[n][n2].equals("true") ? new Boolean(true) : new Boolean(false);
                }
                case 8: {
                    if (this.cacheValues[n][n2] == null) {
                        this.cacheValues[n][n2] = this.cacheValues[n][n2 - 1].equals("true") ? RevertiveBehaviorPanel.getReversionTimeString(this.getReversionTime(n)) : "";
                    }
                    return this.cacheValues[n][n2];
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("CcdOchTrunkTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    protected String getPortDescriptionFor(int n) {
        switch (n) {
            case 0: {
                return "Source";
            }
            case 1: {
                return "Destination";
            }
        }
        return null;
    }

    protected String getServiceState(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            if (iPlimTrkLineModel != null) {
                return iPlimTrkLineModel.getServiceSt().toString(iPortModel.getNodeModel().getTDMTerminology());
            }
            return OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getServiceSt().toString(iPortModel.getNodeModel().getTDMTerminology());
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return null;
        }
    }

    protected String getOTNStatus(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            if (iPlimTrkLineModel != null) {
                return iPlimTrkLineModel.getOTNStatus() ? "Enable" : "Disable";
            }
            return OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getOTNStatus() ? "Enable" : "Disable";
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return null;
    }

    protected String getFECStatus(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            int n2 = 0;
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            n2 = iPlimTrkLineModel != null ? iPlimTrkLineModel.getFECModeValue() : OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getFECModeValue();
            return OchTrailAttrsHelper.FecValues.getFecValueAsString(n2);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return null;
    }

    protected String getOTNSfBerLevel(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            short s = 0;
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            s = iPlimTrkLineModel != null ? iPlimTrkLineModel.getOTNSfBerLevel() : OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getOTNSfBerLevel();
            return OchTrailAttrsHelper.SfBerValues.getSfBerValueAsString(s);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return null;
    }

    protected String getOTNSdBerLevel(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            short s = 0;
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            s = iPlimTrkLineModel != null ? iPlimTrkLineModel.getOTNSdBerLevel() : OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getOTNSdBerLevel();
            return OchTrailAttrsHelper.SdBerValues.getSdBerValueAsString(s);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return null;
    }

    protected String getAySyMappingStatus(int n) {
        IPortModel iPortModel = (IPortModel)this.trunkModels[n];
        IPlimTrkLineModel iPlimTrkLineModel = null;
        try {
            iPlimTrkLineModel = OchTrailAttrsHelper.getIPlimTrkLineModel(iPortModel);
            int n2 = iPlimTrkLineModel != null ? iPlimTrkLineModel.getMappingTypeValue() : OchTrailAttrsHelper.getIDwdmTrkLineModel(iPortModel).getMappingTypeValue();
            return OchTrailAttrsHelper.Mapping.getMappingAsString(n2);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return null;
    }

    protected boolean getRevertive(int n) {
        IYCableModel iYCableModel;
        IElementModel iElementModel;
        boolean bl = false;
        NodeModel nodeModel = (NodeModel)Network.instance().getNodeModel(this.trunkModels[n].getNodeModel().getNodeId());
        try {
            iElementModel = nodeModel.getElementModels().getIElementModel(this.trunkModels[n]);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            return bl;
        }
        if (iElementModel instanceof IYCableModel && (iYCableModel = (IYCableModel)iElementModel).getReversion().getReversionMode() == 2) {
            bl = true;
        }
        return bl;
    }

    protected int getReversionTime(int n) {
        IYCableModel iYCableModel;
        IElementModel iElementModel;
        int n2 = 300;
        NodeModel nodeModel = (NodeModel)Network.instance().getNodeModel(this.trunkModels[n].getNodeModel().getNodeId());
        try {
            iElementModel = nodeModel.getElementModels().getIElementModel(this.trunkModels[n]);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            return n2;
        }
        if (iElementModel instanceof IYCableModel && (iYCableModel = (IYCableModel)iElementModel).getReversion().getReversionMode() == 2) {
            n2 = iYCableModel.getReversion().getReversionTime();
        }
        return n2;
    }

    public ArrayList<OchTrailAttrsHelper.Mapping> getMappingDataTypeFirstTrunk() {
        return this.mappingDataTypeFirstTrunk;
    }

    public ArrayList<OchTrailAttrsHelper.Mapping> getMappingDataTypeSecondTrunk() {
        return this.mappingDataTypeSecondTrunk;
    }
}

