/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeSelector;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AddVcatMembersDialog;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.Autoranger;
import cerent.cms.ui.circuits.CcdEndpointsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.gui.IgnorableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdOvcatEndpoints
extends CcdEndpointsPane {
    private JPanel addDropButtonPanel;
    private JPanel p1;
    private JPanel p2;
    private JPanel p3;
    private JPanel p4;
    private JPanel p5;
    protected JCheckBox useARCB;
    protected JComboBox memCB;
    protected JLabel memLB;
    protected JButton add_drop;
    Map drops;
    Map altDrops;
    private boolean useAuto = false;
    private boolean addedStatus = false;
    private boolean multidrop = false;
    protected int memCBSelection;
    protected int origSize = 0;
    private boolean cmnFiber = false;
    private int index = -1;
    private INodeModel commonNode = null;
    private boolean tl1like = false;
    private final String VCAT_TITLE = "VCAT Circuit Creation";
    private final String OVCAT_AUTORANGEDEST_VALUE = "ovcatAutoRangeWarningMsg";
    private final String OVCAT_AUTORANGEDEST_DESC = "VCAT:On selecting auto ranged destination will discard the previous end points";
    private final String AUTORANGEDEST_WRNG_MSG = "Clicking Auto-ranged Destinations will discard \nall of the previously selected endpoints.";

    public CcdOvcatEndpoints(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, String string2) {
        super(abstractCircuitDialog, wzDiagDebug, string, string2);
    }

    protected void initPane() {
        NetCircuit netCircuit2;
        Object object;
        if (!this.inSourcePane() && !this.isEmbedded && this.parent instanceof CircuitCreationDialog) {
            object = (CcdEndpointsPane)this.parent.getPaneByName("Source");
            this.excludeEndpoints((CcdEndpointsPane)object);
        }
        if (this.isOpenVcat() && this.parent instanceof AddVcatMembersDialog) {
            int n;
            object = null;
            List list = ((NetVcatCircuit)this.getAbstractCktDlg().ckt).getAllMemberCircuits();
            for (NetCircuit netCircuit2 : list) {
                if (netCircuit2.getState() == 0) continue;
                object = ((NetCircuitDropInfo)netCircuit2.getDrops().get(0)).getNetCktEnd();
                break;
            }
            if ((netCircuit2 = (NetVcatCircuit)this.getAbstractCktDlg().ckt).getVcatRoutingPref() == 0) {
                this.tl1like = true;
                n = ((NetVcatCircuit)netCircuit2).getPhysicalRoutingPref();
                if (n == 1) {
                    this.cmnFiber = true;
                }
            } else {
                n = netCircuit2.getVcatRoutingPref();
                if (n == 1) {
                    this.cmnFiber = true;
                }
            }
            if (this.cmnFiber) {
                try {
                    if (object != null) {
                        this.index = ((NetCircuitEnd)object).getEntityModel().getEntityIndex();
                        this.commonNode = ((NetCircuitEnd)object).getNodeModel();
                    }
                }
                catch (Exception exception) {
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        int n = this.getVcatTxMembers();
        this.drops = new HashMap();
        this.altDrops = new HashMap();
        this.multidrop = n > 1;
        this.addDropButtonPanel = new JPanel();
        this.p1 = new JPanel();
        this.p3 = new JPanel();
        this.p4 = new JPanel();
        this.setLayout(new BorderLayout(0, 10));
        this.p2 = CcdOvcatEndpoints.createHorizontalPanel(null);
        this.add((Component)this.p2, "North");
        this.add((Component)this.p3, "Center");
        this.add((Component)this.p1, "South");
        this.addDropButtonPanel.setLayout(new FlowLayout(0));
        this.add_drop = new JButton("Add Destination(s)");
        this.addDropButtonPanel.add(this.add_drop);
        this.add_drop.addActionListener(this);
        this.useARCB = new JCheckBox("Auto-ranged Destinations");
        this.useARCB.setAlignmentX(0.5f);
        this.useARCB.addActionListener(this);
        this.p1.add(this.addDropButtonPanel);
        this.p1.add(this.p4);
        this.p3.setLayout(new GridLayout(1, 0));
        this.memCB = new JComboBox();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            this.memCB.addItem(new String("Member No " + n2++));
        }
        this.memLB = new JLabel("Select Destination For: ", 4);
        this.memCB.addActionListener(this);
        this.p2.add(this.useARCB);
        this.p2.add(Box.createHorizontalStrut(24));
        this.p2.add(this.memLB);
        this.p2.add(this.memCB);
        this.leftPanel = CcdOvcatEndpoints.createVerticalPanel(null);
        this.p3.add(this.leftPanel);
        this.rightPanel = CcdOvcatEndpoints.createVerticalPanel(null);
        this.p3.add(this.rightPanel);
        if (this.getAbstractCktDlg().getVcatTxMembers() == 1) {
            this.addDropButtonPanel.setVisible(false);
            this.p2.setVisible(false);
            this.p4.setVisible(false);
        }
        JPanel jPanel = null;
        jPanel = CcdOvcatEndpoints.createHorizontalPanel(null);
        jPanel.add(this.lfiller);
        jPanel.add(new JLabel("Node: ", 4));
        this.nodeCB = new NodeSelector();
        jPanel.add((Component)((Object)this.nodeCB));
        this.nodeCB.addActionListener(this);
        netCircuit2 = CircuitType.getCircuitType((int)this.getCircuitInfo().type());
        if (netCircuit2.isOchncType() || netCircuit2.isOchccCircuitType() || netCircuit2.isOchTrailTunnelCircuitType()) {
            jPanel.add(this.rfiller);
        }
        this.leftPanel.add(jPanel);
        this.useAltCB = new JCheckBox("Use Secondary " + this.endpointName);
        this.rightPanel.add(this.useAltCB);
        this.useAltCB.setAlignmentX(0.5f);
        this.useAltCB.addActionListener(this);
        this.altNodePanel = CcdOvcatEndpoints.createHorizontalPanel(null);
        this.altNodePanel.add(Box.createHorizontalGlue());
        this.altNodePanel.add(new JLabel("Node: ", 4));
        this.altNodeCB = new NodeSelector(this.getCircuitInfo());
        this.altNodePanel.add((Component)((Object)this.altNodeCB));
        this.altNodeCB.addActionListener(this);
        this.rightPanel.add(this.altNodePanel);
        if (!this.showSecondary) {
            this.remove(this.rightPanel);
            this.setAlignmentX(0.0f);
        }
        this.reset();
    }

    protected void initForOpenVcat() {
        int n;
        int n2 = this.getVcatTxMembers();
        if (this.isInited() && this.multidrop && n2 == 1) {
            this.addDropButtonPanel.setVisible(false);
            this.p4.setVisible(false);
            this.p2.setVisible(false);
            this.multidrop = false;
        } else if (!this.multidrop && n2 > 1) {
            this.addDropButtonPanel.setVisible(true);
            this.p4.setVisible(true);
            this.p2.setVisible(true);
            this.multidrop = true;
            this.memCB.removeAllItems();
            n = 1;
            this.memCB.removeActionListener(this);
            for (int i = 0; i < n2; ++i) {
                this.memCB.addItem(new String("Member No " + n++));
            }
            this.memCB.addActionListener(this);
        } else {
            this.memCB.removeActionListener(this);
            this.memCB.removeAllItems();
            n = 1;
            for (int i = 0; i < n2; ++i) {
                this.memCB.addItem(new String("Member No " + n++));
            }
            this.memCB.addActionListener(this);
        }
        this.useARCB.setEnabled(true);
        try {
            if (!((IPortModel)this.getAbstractCktDlg().getSource().getEntityModel()).supportsSplitRouting() && this.altDrops.size() != 0) {
                this.altDrops.clear();
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
        }
        if (this.origSize == 0) {
            this.origSize = n2;
        } else if (this.origSize != n2) {
            this.origSize = n2;
            this.drops.clear();
            this.altDrops.clear();
            this.lastNodeModel = null;
            this.nodeModel = null;
            this.lastAltNodeModel = null;
            this.altNodeModel = null;
            this.reset();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block20: {
            Object object = actionEvent.getSource();
            super.actionPerformed(actionEvent);
            if (object == this.add_drop) {
                try {
                    if (this.mainPanel != null) {
                        this.mainPanel.validatePage();
                        if (this.altPanel != null && this.useAltCB.isSelected()) {
                            this.altPanel.validatePage();
                        }
                        this.add_drop.setEnabled(false);
                        if (this.useAltCB.isSelected()) {
                            this.fillinDrops(true);
                        } else {
                            this.fillinDrops(false);
                        }
                        this.add_drop.setEnabled(true);
                        if (this.getCircuitInfo().isOVcat() && !this.inSourcePane()) {
                            this.memCBSelection = this.memCB.getSelectedIndex();
                        }
                        this.lastNodeModel = this.nodeModel;
                        this.lastAltNodeModel = this.altNodeModel;
                        this.pushStatusInfo();
                        this.parent.validate();
                        if (this.drops.size() > 0) {
                            this.useARCB.setEnabled(false);
                        }
                        break block20;
                    }
                    throw new Exception(this.getName() + " is not fully specified.");
                }
                catch (Exception exception) {
                    this.handleNextException(exception);
                    if (!this.add_drop.isEnabled()) {
                        this.add_drop.setEnabled(true);
                    }
                    break block20;
                }
            }
            if (object == this.memCB) {
                this.reset();
                this.needEndpoints = true;
                this.memCBSelection = this.memCB.getSelectedIndex();
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(this.memCBSelection));
                if (iNetCircuitEnd != null) {
                    this.nodeCB.setSelectedItem(iNetCircuitEnd.getNodeModel());
                    this.mainPanel.selectEndpoint(iNetCircuitEnd);
                } else {
                    this.nodeCB.setSelectedItem(null);
                }
                if (this.altDrops.size() > 0) {
                    this.needEndpoints = true;
                    this.useAltCB.setSelected(true);
                    iNetCircuitEnd = (INetCircuitEnd)this.altDrops.get(new Integer(this.memCBSelection));
                    if (iNetCircuitEnd != null) {
                        this.altNodeCB.setSelectedItem(iNetCircuitEnd.getNodeModel());
                        this.altPanel.selectEndpoint(iNetCircuitEnd);
                        this.altPanel.setVisible(true);
                    } else {
                        this.altNodeCB.setSelectedItem(null);
                    }
                }
                this.lastNodeModel = this.nodeModel;
                this.lastAltNodeModel = this.altNodeModel;
            } else if (object == this.useARCB) {
                if (this.useARCB.isSelected()) {
                    IgnorableDialog.infoDialog((Component)this, (String)"Clicking Auto-ranged Destinations will discard \nall of the previously selected endpoints.", (String)"VCAT Circuit Creation", (String)"ovcatAutoRangeWarningMsg", (String)"VCAT:On selecting auto ranged destination will discard the previous end points");
                    this.memLB.setEnabled(false);
                    this.memCB.setEnabled(false);
                    this.add_drop.setEnabled(false);
                    AutorangeInfo autorangeInfo = new AutorangeInfo();
                    autorangeInfo.isEther = false;
                    autorangeInfo.isTunnel = false;
                    this.getAbstractCktDlg().setAutorangeInfo(autorangeInfo);
                    this.useAuto = true;
                } else {
                    this.memLB.setEnabled(true);
                    this.memCB.setEnabled(true);
                    this.memCB.setSelectedIndex(0);
                    this.add_drop.setEnabled(true);
                    this.getAbstractCktDlg().setAutorangeInfo(null);
                    this.useAuto = false;
                }
            }
        }
    }

    private boolean syncDrops() {
        NetCircuitEnd netCircuitEnd;
        INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(this.memCBSelection));
        if (iNetCircuitEnd != null && !iNetCircuitEnd.equals(this.mainPanel.endpoint)) {
            return false;
        }
        return !(this.useAltCB.isSelected() ? ((iNetCircuitEnd = (INetCircuitEnd)this.altDrops.get(new Integer(this.memCBSelection))) != null ? !iNetCircuitEnd.equals(this.altPanel.endpoint) : this.altPanel.endpoint != null && !((Object)(netCircuitEnd = new NetCircuitEnd())).equals(this.altPanel.endpoint)) : this.altDrops.size() > 0 && (iNetCircuitEnd = (INetCircuitEnd)this.altDrops.get(new Integer(this.memCBSelection))) != null && !iNetCircuitEnd.equals(this.altPanel.endpoint));
    }

    private void fillinDrops(boolean bl) throws Exception {
        INetCircuitEnd iNetCircuitEnd;
        int n = this.memCB.getSelectedIndex();
        if (this.altDrops.size() > 0 && this.altDrops.containsValue(this.mainPanel.endpoint)) {
            INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)this.altDrops.get(new Integer(n));
            if (iNetCircuitEnd2 != null && iNetCircuitEnd2.equals((NetCircuitEnd)this.mainPanel.endpoint)) {
                throw new Exception("The primary and secondary destinations cannot be identical");
            }
            throw new Exception("The destination selected is already specified\nas a secondary destination for a member circuit");
        }
        if (this.drops.containsValue(this.mainPanel.endpoint)) {
            iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(n));
            if (iNetCircuitEnd == null || !iNetCircuitEnd.equals((NetCircuitEnd)this.mainPanel.endpoint)) {
                throw new Exception("Two member circuits cannot have the same destination");
            }
        } else {
            iNetCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.mainPanel.endpoint);
            this.drops.put(new Integer(n), iNetCircuitEnd);
        }
        if (bl) {
            if (this.drops.containsValue(this.altPanel.endpoint)) {
                iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(n));
                if (iNetCircuitEnd != null && iNetCircuitEnd.equals((NetCircuitEnd)this.altPanel.endpoint)) {
                    throw new Exception("The primary and secondary destinations cannot be identical");
                }
                throw new Exception("The secondary destination selected is already specified\nas a destination for a member circuit");
            }
            if (this.altDrops.containsValue(this.altPanel.endpoint)) {
                iNetCircuitEnd = (INetCircuitEnd)this.altDrops.get(new Integer(n));
                if (iNetCircuitEnd == null || !iNetCircuitEnd.equals((NetCircuitEnd)this.altPanel.endpoint)) {
                    throw new Exception("Two member circuits cannot have the same secondary destination");
                }
            } else {
                iNetCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.altPanel.endpoint);
                this.altDrops.put(new Integer(n), iNetCircuitEnd);
            }
        } else {
            this.altDrops.remove(new Integer(n));
        }
    }

    private boolean selectedAllDrops() {
        int n = this.getAbstractCktDlg().getVcatTxMembers();
        return this.drops.size() == n;
    }

    private boolean sanityCheckAutoRange() {
        for (INetCircuitEnd iNetCircuitEnd : this.drops.values()) {
            if (!this.altDrops.containsValue(iNetCircuitEnd)) continue;
            return false;
        }
        return true;
    }

    public INetCircuitEnd[] getDrops() {
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[this.drops.size()];
        for (int i = 0; i < this.drops.size(); ++i) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.drops.get(new Integer(i));
            iNetCircuitEndArray[i] = netCircuitEnd;
        }
        return iNetCircuitEndArray;
    }

    public INetCircuitEnd[] getAltDrops() {
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[this.drops.size()];
        for (int i = 0; i < this.drops.size(); ++i) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.altDrops.get(new Integer(i));
            iNetCircuitEndArray[i] = netCircuitEnd;
        }
        return iNetCircuitEndArray;
    }

    public boolean areSecDropsPresent() {
        return this.altDrops.size() > 0;
    }

    public void pushStatusInfo() {
        if (((WzStatusPanel)this.parent.gettheStatusPanel()).containsComponentWithTitle(this.endpointName)) {
            this.parent.popStatusInfo();
        }
        this.parent.pushStatusInfo(this.getStatusComponent());
    }

    protected void handlePostValidate() {
    }

    public boolean handleBack() {
        if (((WzStatusPanel)this.parent.gettheStatusPanel()).containsComponentWithTitle(this.endpointName)) {
            this.parent.popStatusInfo();
        }
        return super.handleBack();
    }

    void setAltPanelEnabled(boolean bl) {
        super.setAltPanelEnabled(bl);
        try {
            if (!((IPortModel)this.getAbstractCktDlg().getSource().getEntityModel()).supportsSplitRouting() || this.getAbstractCktDlg() instanceof AddVcatMembersDialog && this.cmnFiber && !this.tl1like) {
                this.useAltCB.setSelected(false);
                this.useAltCB.setEnabled(false);
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
        }
    }

    public String getNextPaneName() {
        if (this.parent instanceof AddVcatMembersDialog) {
            return "Routing and Member Preferences";
        }
        return "VCat Circuit Routing Preferences";
    }

    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (this.isOpenVcat() && !this.inSourcePane()) {
            String string = null;
            int n = this.getAbstractCktDlg().getVcatTxMembers();
            for (int i = 0; i < n; ++i) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(i));
                if (iNetCircuitEnd != null) {
                    string = i + 1 + ":" + iNetCircuitEnd.getNodeModel().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
                    arrayList.add(new String[]{null, string});
                }
                INetCircuitEnd iNetCircuitEnd2 = null;
                iNetCircuitEnd2 = (INetCircuitEnd)this.altDrops.get(new Integer(i));
                if (iNetCircuitEnd2 == null) continue;
                string = i + 1 + ":" + iNetCircuitEnd2.getNodeModel().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd2) + "(secondary)";
                arrayList.add(new String[]{null, string});
            }
        }
        return CcdOvcatEndpoints.getGridPanel(arrayList);
    }

    public boolean isDestPane() {
        return this.endpointName.equals("Destinations");
    }

    public void validatePage() throws Exception {
        Object object;
        Object object2;
        if (this.nodeModel == null) {
            throw new Exception("The " + this.endpointName + " node must be selected.");
        }
        if (this.isOpenVcat() && !this.inSourcePane()) {
            this.memCBSelection = this.memCB.getSelectedIndex();
            this.origSize = this.getAbstractCktDlg().getVcatTxMembers();
            if (this.origSize > 1 && !this.useAuto && !this.syncDrops()) {
                throw new Exception("Drop has been changed. Add Drops before moving forward");
            }
            if ((this.origSize == 1 || this.useAuto) && !this.syncDrops()) {
                if (!this.useAltCB.isSelected()) {
                    this.altDrops.clear();
                }
                this.pushStatusInfo();
                this.parent.validate();
            }
        }
        this.lastNodeModel = this.nodeModel;
        if (this.useAltCB.isSelected()) {
            this.lastAltNodeModel = this.altNodeModel;
        } else {
            this.altNodeModel = null;
            this.lastAltNodeModel = null;
        }
        if (this.needEndpoints) {
            this.mainPanel.validatePage();
            if (this.altPanel != null && this.useAltCB.isSelected()) {
                this.altPanel.validatePage();
                if (this.mainPanel.endpoint.equals(this.altPanel.endpoint)) {
                    String string = "The " + this.endpointName + "s cannot be identical.";
                    throw new Exception(string);
                }
            }
        }
        if (this.endpointName.equals("Source")) {
            object2 = this.getAbstractCktDlg().getAltSourceNode();
            if (object2 != null) {
                this.checkLap(this.getAbstractCktDlg().getSourceNode(), this.getAbstractCktDlg().getSource().getEntityModel(), this.getAbstractCktDlg().getSource().getHoNum(), this.getAbstractCktDlg().getAltSourceNode(), this.getAbstractCktDlg().getAltSource().getEntityModel(), this.getAbstractCktDlg().getAltSource().getHoNum());
            }
        } else if (this.endpointName.equals("Destination") && (object2 = this.getAbstractCktDlg().getAltDestNode()) != null) {
            this.checkLap(this.getAbstractCktDlg().getDestNode(), this.getAbstractCktDlg().getDest().getEntityModel(), this.getAbstractCktDlg().getDest().getHoNum(), this.getAbstractCktDlg().getAltDestNode(), this.getAbstractCktDlg().getAltDest().getEntityModel(), this.getAbstractCktDlg().getAltDest().getHoNum());
        }
        if (this.endpointName.equals("Destination")) {
            object2 = this.getAbstractCktDlg().getSourceNode();
            object = this.getAbstractCktDlg().getAltSourceNode();
            INodeModel iNodeModel = this.getAbstractCktDlg().getDestNode();
            INodeModel iNodeModel2 = this.getAbstractCktDlg().getAltDestNode();
            if (object2 != null && object != null && iNodeModel != null && iNodeModel2 != null && object2 != object && object2 != iNodeModel && object2 != iNodeModel2 && object != iNodeModel && object != iNodeModel2 && iNodeModel != iNodeModel2) {
                if (this.db.on()) {
                    this.db.println("validate src1= " + object2.getName());
                    this.db.println("validate src2= " + object.getName());
                    this.db.println("validate dst1= " + iNodeModel.getName());
                    this.db.println("validate dst2= " + iNodeModel2.getName());
                }
                String string = "Circuit creation does not permit four unique nodes to be designated \nas endpoints. Please modify the sources and/or destinations so that\nthe endpoints consist of three or fewer unique nodes.";
                throw new Exception(string);
            }
        }
        if (this.getMainPanel() != null) {
            if (this.getMainPanel().slot == "Ethergroup") {
                this.maybeModifyEthergroupAdminState();
            }
            try {
                if (this.altPanel != null && this.useAltCB.isSelected()) {
                    this.checkDataCardAdminState(this.mainPanel.endpoint, this.altPanel.endpoint);
                } else {
                    this.checkDataCardAdminState(this.mainPanel.endpoint, null);
                }
            }
            catch (ObjNotFound objNotFound) {
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
            try {
                this.checkRPRValidateCircuitSize(this.mainPanel.endpoint);
            }
            catch (ObjNotFound objNotFound) {
                WzDiagDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        object2 = this.getCircuit();
        this.processAutoRangedCktEnds(false);
        if (!this.inSourcePane() && this.isOpenVcat() && this.useAltCB.isSelected() && this.useAuto) {
            this.processAutoRangedCktEnds(true);
            if (!this.sanityCheckAutoRange()) {
                this.drops.clear();
                object = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.mainPanel.endpoint);
                this.drops.put(new Integer(0), object);
                this.altDrops.clear();
                object = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.altPanel.endpoint);
                this.altDrops.put(new Integer(0), object);
                this.pushStatusInfo();
                this.parent.validate();
                throw new Exception("Primary and secondary endpoints are conflicting.");
            }
        }
        if (this.isOpenVcat() && !this.inSourcePane()) {
            if (!((IPortModel)this.getAbstractCktDlg().getSource().getEntityModel()).supportsSplitRouting() && !this.checkForCommonFiber()) {
                throw new Exception("Please use same port for drops for common fiber routing");
            }
            if (this.getAbstractCktDlg().getVcatTxMembers() == 1) {
                this.drops.put(new Integer(0), this.mainPanel.endpoint);
                if (this.useAltCB.isSelected()) {
                    this.altDrops.put(new Integer(0), this.altPanel.endpoint);
                }
            }
            if (!this.selectedAllDrops()) {
                this.isOkToPostValidate = false;
                throw new Exception("Please select drops for all members");
            }
            if (this.origSize > 1 && !this.useAuto && !this.syncDrops()) {
                throw new Exception("Drop has been changed. Add Drops before moving forward");
            }
            this.checkit();
        }
        if (object2 != null && this.parent != null && !this.isEmbedded) {
            this.getAbstractCktDlg().addDestination(false);
        }
    }

    private boolean checkAutoRangeCktEnds() {
        int n;
        int n2;
        INetCircuitEnd[] iNetCircuitEndArray = this.getDrops();
        INetCircuitEnd[] iNetCircuitEndArray2 = this.getAltDrops();
        int n3 = iNetCircuitEndArray.length;
        int n4 = iNetCircuitEndArray2.length;
        if (n3 > 1 && iNetCircuitEndArray[0] != null) {
            n2 = iNetCircuitEndArray[0].getEntityIndex();
            for (n = 1; n < n3; ++n) {
                if (n2 == iNetCircuitEndArray[n].getEntityIndex()) continue;
                return false;
            }
        }
        if (this.getAltNodeModel() != null && n4 > 1 && iNetCircuitEndArray2[0] != null) {
            n2 = iNetCircuitEndArray2[0].getEntityIndex();
            for (n = 1; n < n4; ++n) {
                if (n2 == iNetCircuitEndArray2[n].getEntityIndex()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkForCommonFiber() {
        INetCircuitEnd[] iNetCircuitEndArray = this.getDrops();
        int n = iNetCircuitEndArray.length;
        if (n > 1 && iNetCircuitEndArray[0] != null) {
            int n2 = iNetCircuitEndArray[0].getEntityIndex();
            int n3 = iNetCircuitEndArray[0].getNodeModel().getNodeId();
            for (int i = 1; i < n; ++i) {
                if (n2 == iNetCircuitEndArray[i].getEntityIndex() && n3 == iNetCircuitEndArray[i].getNodeModel().getNodeId()) continue;
                return false;
            }
        }
        return true;
    }

    protected void checkit() throws Exception {
        if (this.parent instanceof AddVcatMembersDialog && this.cmnFiber && !this.tl1like) {
            if (this.index != -1 && !this.checkForCommonFiber(this.index)) {
                throw new Exception("Common port must for members of this VCAT Circuit");
            }
            if (this.index == -1 && !this.checkForCommonFiber()) {
                throw new Exception("Common port must for members of this VCAT Circuit");
            }
        }
        if (this.parent instanceof AddVcatMembersDialog) {
            ((AddVcatMembersDialog)this.parent).setDest(this.getDrops()[0]);
        }
    }

    public boolean checkForCommonFiber(int n) {
        INetCircuitEnd[] iNetCircuitEndArray = this.getDrops();
        int n2 = iNetCircuitEndArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n == iNetCircuitEndArray[i].getEntityIndex() && this.commonNode.getNodeId() == iNetCircuitEndArray[i].getNodeModel().getNodeId()) continue;
                return false;
            }
        }
        return true;
    }

    private void processAutoRangedCktEnds(boolean bl) throws Exception {
        block23: {
            int n;
            int n2;
            NetCircuitEnd netCircuitEnd;
            Iterator iterator;
            CircuitCreatInfo circuitCreatInfo;
            if (!this.isOpenVcat() || this.inSourcePane() || !this.useAuto) break block23;
            AutorangeInfo autorangeInfo = this.getAutorangeInfo();
            if (!bl) {
                autorangeInfo.clearDests();
                autorangeInfo.destNode = this.getNodeModel();
                if (!autorangeInfo.isEther && !autorangeInfo.isTunnel) {
                    autorangeInfo.priDest = this.getMainPanelEndpoint();
                    autorangeInfo.priDestPortList = this.mainPanel.getOtherPortsList();
                    autorangeInfo.priDestList = this.mainPanel.getEndpointsList();
                    autorangeInfo.priDestList.removeAll(this.getUpTo(autorangeInfo.priDestList, autorangeInfo.priDest));
                }
            } else {
                autorangeInfo.clearDests();
                autorangeInfo.destNode = this.getAltNodeModel();
                if (!autorangeInfo.isEther && !autorangeInfo.isTunnel) {
                    autorangeInfo.priDest = this.getAltPanelEndpoint();
                    autorangeInfo.priDestPortList = this.altPanel.getOtherPortsList();
                    autorangeInfo.priDestList = this.altPanel.getEndpointsList();
                    autorangeInfo.priDestList.removeAll(this.getUpTo(autorangeInfo.priDestList, autorangeInfo.priDest));
                }
            }
            int n3 = ((NetVcatCircuit)this.getAbstractCktDlg().ckt).getMemberCktType();
            String string = "";
            CircuitCreatInfo circuitCreatInfo2 = this.getAbstractCktDlg().getCircuitInfo();
            autorangeInfo.cktInfo = circuitCreatInfo = new CircuitCreatInfo(n3, circuitCreatInfo2.size(), circuitCreatInfo2.dir(), circuitCreatInfo2.monitor(), string, circuitCreatInfo2.adminState(), circuitCreatInfo2.tl1Compatible(), circuitCreatInfo2.getTrafficDir());
            Autoranger autoranger = new Autoranger(autorangeInfo, this.getAbstractCktDlg().getVcatTxMembers() - 1, 2);
            List list = null;
            try {
                list = autoranger.getNetCktEnds();
            }
            catch (Exception exception) {
                this.handleNextException(exception);
                return;
            }
            if (list.size() < this.getAbstractCktDlg().getVcatTxMembers() - 1) {
                throw new Exception("Autorange didnt find enough endpoints.");
            }
            if (!((IPortModel)this.getAbstractCktDlg().getSource().getEntityModel()).supportsSplitRouting() && list.size() > 0) {
                iterator = list.iterator();
                netCircuitEnd = (NetCircuitEnd)this.mainPanel.endpoint;
                if (netCircuitEnd != null) {
                    n2 = netCircuitEnd.getEntityIndex();
                    for (n = 0; n < list.size(); ++n) {
                        netCircuitEnd = (NetCircuitEnd)iterator.next();
                        if (n2 == netCircuitEnd.getEntityIndex()) continue;
                        throw new Exception("Autorange didn't find enough endpoints within same port");
                    }
                }
            }
            if (this.getAbstractCktDlg() instanceof AddVcatMembersDialog && this.cmnFiber && !this.tl1like) {
                if (this.index != -1) {
                    if (list.size() > 0) {
                        n2 = this.index;
                        iterator = list.iterator();
                        netCircuitEnd = (NetCircuitEnd)this.mainPanel.endpoint;
                        if (netCircuitEnd != null && n2 != netCircuitEnd.getEntityIndex()) {
                            throw new Exception("Common port must for this vcat circuit.");
                        }
                        for (n = 0; n < list.size(); ++n) {
                            netCircuitEnd = (NetCircuitEnd)iterator.next();
                            if (this.index == netCircuitEnd.getEntityIndex()) continue;
                            throw new Exception("Common port must for this vcat circuit.");
                        }
                    }
                } else if (this.index == -1 && list.size() > 0) {
                    iterator = list.iterator();
                    netCircuitEnd = (NetCircuitEnd)this.mainPanel.endpoint;
                    if (netCircuitEnd != null) {
                        n2 = netCircuitEnd.getEntityIndex();
                        for (n = 0; n < list.size(); ++n) {
                            netCircuitEnd = (NetCircuitEnd)iterator.next();
                            if (n2 == netCircuitEnd.getEntityIndex()) continue;
                            throw new Exception("Autorange didn't find enough endpoints within same port");
                        }
                    }
                }
            }
            Iterator iterator2 = list.iterator();
            int n4 = 1;
            if (!bl) {
                this.drops.clear();
                netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.mainPanel.endpoint);
                this.drops.put(new Integer(0), netCircuitEnd);
                while (iterator2.hasNext()) {
                    this.drops.put(new Integer(n4++), iterator2.next());
                }
            } else {
                this.altDrops.clear();
                netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getAbstractCktDlg().getCircuitType(), (NetCircuitEnd)this.altPanel.endpoint);
                this.altDrops.put(new Integer(0), netCircuitEnd);
                while (iterator2.hasNext()) {
                    this.altDrops.put(new Integer(n4++), iterator2.next());
                }
            }
        }
    }

    public void revalidateData() {
        if (this.isOpenVcat() && !this.inSourcePane()) {
            this.initForOpenVcat();
            if (this.drops.size() > 0) {
                this.pushStatusInfo();
                this.memCB.removeActionListener(this);
                this.memCB.setSelectedIndex(this.memCBSelection);
                this.memCB.addActionListener(this);
            }
        }
        super.revalidateData();
        try {
            if (!((IPortModel)this.getAbstractCktDlg().getSource().getEntityModel()).supportsSplitRouting() || this.getAbstractCktDlg() instanceof AddVcatMembersDialog && this.cmnFiber && !this.tl1like) {
                this.useAltCB.setEnabled(false);
            }
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
        }
    }

    void setNode(INodeModel iNodeModel, boolean bl) {
        if (!bl) {
            if (iNodeModel == this.nodeModel) {
                if (this.db.on()) {
                    this.db.println(this.endpointName + " setNode: NOP, returning");
                }
                return;
            }
            this.nodeModel = iNodeModel;
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode: nodeModel = " + this.nodeModel);
            }
        } else {
            if (iNodeModel == this.altNodeModel) {
                if (this.db.on()) {
                    this.db.println(this.endpointName + " setNode (alt): NOP, returning");
                }
                return;
            }
            this.altNodeModel = iNodeModel;
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode (alt): altNodeModel = " + this.altNodeModel);
            }
        }
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            if (this.db.on()) {
                this.db.println(this.endpointName + " setNode: " + iNodeModel + " is disconnected");
            }
            this.clearNode(iNodeModel.getName() + " is disconnected: no endpoints are available");
        } else if (this.needEndpoints) {
            try {
                this.updateAvailPorts(iNodeModel, bl);
                if ((this.mainPanel == null || this.altPanel == null) && iNodeModel != null) {
                    this.setEndpointPanel(iNodeModel);
                }
                if (!bl) {
                    if (this.mainPanel != null) {
                        int n;
                        INetCircuitEnd iNetCircuitEnd;
                        this.mainPanel.setNode(iNodeModel);
                        if (this.memCB != null && this.memCB.isVisible() && this.isOpenVcat() && !this.inSourcePane() && (iNetCircuitEnd = (INetCircuitEnd)this.drops.get(new Integer(n = this.memCB.getSelectedIndex()))) != null && iNetCircuitEnd.getNodeModel() == iNodeModel) {
                            this.mainPanel.selectEndpoint(iNetCircuitEnd);
                        }
                    }
                    if (this.altPanel != null && !this.altNodePanel.isVisible()) {
                        this.setNode(iNodeModel, true);
                    }
                } else if (this.altPanel != null) {
                    int n;
                    INetCircuitEnd iNetCircuitEnd;
                    this.altPanel.setNode(iNodeModel);
                    if (this.memCB != null && this.memCB.isVisible() && this.isOpenVcat() && !this.inSourcePane() && (iNetCircuitEnd = (INetCircuitEnd)this.altDrops.get(new Integer(n = this.memCB.getSelectedIndex()))) != null && iNetCircuitEnd.getNodeModel() == iNodeModel) {
                        this.altPanel.selectEndpoint(iNetCircuitEnd);
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
    }

    public int getCmnFiberEntityIndex() {
        return this.index;
    }

    public INodeModel getCmnFiberNodeModel() {
        return this.commonNode;
    }

    public void dispose() {
        if (this.drops != null) {
            this.drops.clear();
        }
        if (this.altDrops != null) {
            this.altDrops.clear();
        }
        this.drops = null;
        this.altDrops = null;
        this.commonNode = null;
        super.dispose();
    }

    public void removeListeners() {
        if (this.memCB != null) {
            this.memCB.removeActionListener(this);
        }
        if (this.useARCB != null) {
            this.useARCB.removeActionListener(this);
        }
        if (this.add_drop != null) {
            this.add_drop.removeActionListener(this);
        }
        super.removeListeners();
    }

    public void close() {
        if (this.memCB != null) {
            this.memCB.hidePopup();
        }
        super.close();
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdOvcatEndpoints;
    }
}

