/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SrgViolation;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.BlsrDriDialog;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CircuitDesignMap;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.HoLoPane;
import cerent.cms.ui.circuits.HoLoPaneFactory;
import cerent.cms.ui.circuits.RoutingConstraint;
import cerent.cms.ui.circuits.UnprotectedToUpsrDialog;
import cerent.cms.ui.network.CircuitMapLink;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.OrderedListListener;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;

public class CcdReviewEditPane
extends CcdCircuitDesignPane
implements OrderedListListener,
KeyListener,
ListSelectionListener {
    protected HoLoPane hoLoPane;
    protected INodeModel currentNode;
    protected INodeModel srcNodeModel;
    protected INodeModel altSrcNodeModel;
    protected INodeModel dstNodeModel;
    protected INodeModel altDstNodeModel;
    protected IHoNum blsrHoNum;
    protected ILoNum blsrLoNum;
    private int modifiers;
    protected List activeCktSpans;
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private final ImageIcon CK_IMG = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"));
    protected JLabel driLabel = new JLabel("DRI", this.CK_IMG, 2);
    JTabbedPane jtp;
    DefaultListModel blsrDriListModel = new DefaultListModel();
    JList blsrDriList = new JList(this.blsrDriListModel);
    JButton addBlsrButton = new JButton("Add " + CircuitMapUtil.BLSRDRI_TERM + "...");
    JButton remBlsrButton = new JButton("Remove");
    static final String SECONDARY_PATH_STRING = "Part of secondary path";
    protected JCheckBox secondarySpanCB = new JCheckBox("Part of secondary path", false);

    public String getShortName() {
        return "Route Review/Edit";
    }

    public CcdReviewEditPane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
        this.blsrDriList.setCellRenderer(new MultiLineRenderer());
    }

    public void localCleanup() {
        if (this.db.on()) {
            this.db.println("localCleanup");
        }
        if (this.olm != null) {
            if (this.olm.getContent() != null && this.getAbstractCktDlg().getCircuit() != null) {
                for (int i = this.olm.getContent().size(); i > 0; --i) {
                    if (!(this.olm.getContent().get(i - 1) instanceof NetLinkSpan)) continue;
                    INetLinkSpan iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i - 1);
                    this.olm.remove(iNetLinkSpan);
                    this.deleteCircuitSpan(iNetLinkSpan);
                    if (!this.db.on()) continue;
                    this.db.println("localCleanup: removed span " + iNetLinkSpan);
                }
            }
            this.olm.clearAll();
            this.olm.syncButtons();
        }
        this.blsrDriListModel.clear();
        if (this.parent != null && this.getAbstractCktDlg().getRoutePrefs() != null) {
            this.getCurrentMemberPrefs(this.getAbstractCktDlg().getRoutePrefs()).clearDriNodePrefs();
        }
        if (this.hoLoPane != null) {
            this.hoLoPane.disablePane();
        }
        if (this.activeCktSpans != null) {
            this.activeCktSpans.clear();
        }
        this.unSetNode();
        this.unSetLink();
    }

    protected void setupBottomPanel() {
        this.bottomPanel = CcdReviewEditPane.createHorizontalPanel(null);
        this.jtp = new JTabbedPane();
        this.jtp.addTab("Included Spans", this.bottomPanel);
        this.mainSplitPane.setBottomComponent(this.jtp);
        JPanel jPanel = CcdReviewEditPane.createHorizontalPanel(null);
        this.jtp.addTab(CircuitMapUtil.BLSRDRI_TERM + " Nodes", jPanel);
        JPanel jPanel2 = CcdReviewEditPane.createVerticalPanel(null);
        JPanel jPanel3 = CcdReviewEditPane.createVerticalPanel(null);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        jPanel2.add(new JScrollPane(this.blsrDriList));
        JPanel jPanel4 = CcdReviewEditPane.createHorizontalPanel(null);
        jPanel4.setLayout(new GridLayout(2, 1, 2, 2));
        this.addBlsrButton.setHorizontalAlignment(0);
        this.addBlsrButton.setEnabled(true);
        this.addBlsrButton.addActionListener(this);
        this.remBlsrButton.setHorizontalAlignment(0);
        this.remBlsrButton.setEnabled(false);
        this.remBlsrButton.addActionListener(this);
        this.blsrDriList.addListSelectionListener(this);
        jPanel4.add(this.addBlsrButton);
        jPanel4.add(this.remBlsrButton);
        JPanel jPanel5 = new JPanel();
        this.gridbag = new GridBagLayout();
        jPanel5.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.gridbag.setConstraints(jPanel5, gridBagConstraints);
        jPanel5.add(jPanel4);
        jPanel3.add(jPanel5);
    }

    void getMoreUIs() {
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.setLayout(new GridLayout(3, 1, 2, 2));
        this.buttonPanel.add(this.secondarySpanCB);
        this.secondarySpanCB.setHorizontalAlignment(0);
        this.secondarySpanCB.setEnabled(false);
        this.secondarySpanCB.setVisible(false);
        this.addSpanButton = new JButton("Add Span");
        this.buttonPanel.add(this.addSpanButton);
        this.addSpanButton.setHorizontalAlignment(0);
        this.addSpanButton.setEnabled(false);
        this.addSpanButton.addActionListener(this);
        this.removeButton = this.olm.getButton("Remove");
        this.buttonPanel.add(this.removeButton);
        this.removeButton.setHorizontalAlignment(0);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.linkPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(" "));
        jPanel.add(this.driLabel);
        this.linkPanel.add((Component)jPanel, "North");
    }

    protected boolean isPossibleBlsrDri() {
        boolean bl = Preferences.instance().getBoolean("ctc.circuit.creation", "dri", false);
        boolean bl2 = bl && (this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoCircuitType() || this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isHoVcatCircuitType());
        return bl2;
    }

    protected void resetLinks(boolean bl, boolean bl2) {
        if (this.isPossibleBlsrDri()) {
            this.circuitMap.setPcaOverride(true);
        }
        super.resetLinks(bl, bl2);
    }

    protected String getNextPaneName() {
        return null;
    }

    protected String getStatusText() {
        return "Reviewing/Editing Circuit";
    }

    public boolean handleBack() {
        boolean bl = true;
        if (this.olm.getSize() > 0 || this.blsrDriListModel.size() > 0) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)"Route data will be lost.  Are you sure you want to go BACK?", (String)this.getName());
        }
        if (bl) {
            this.recycle();
            return super.handleBack();
        }
        this.getAbstractCktDlg().setFinishEnabled(true);
        return false;
    }

    public void enteringPane() {
        super.enteringPane();
        if (this.getAbstractCktDlg().getCircuit() == null) {
            if (this.db.on()) {
                this.db.println("ckt is null, should never happen");
            }
            return;
        }
        this.addBlsrButton.setEnabled(!this.getAbstractCktDlg().isAutoRoute());
        this.activeCktSpans = this.getActiveCircuitSpans();
        this.topPanel.addKeyListener(this);
        if (this.hoLoPane == null) {
            int n = this.getAbstractCktDlg().getCircuitType();
            int n2 = this.getAbstractCktDlg().getCircuitSize();
            int n3 = NetCircuitManager.instance().calcFramingType(n, n2);
            this.hoLoPane = HoLoPaneFactory.createPane(this.db, n3);
            this.linkPanel.add((Component)this.hoLoPane, "Center");
        }
        this.hoLoPane.init(this.circuitMap, this.addSpanButton);
        this.getAbstractCktDlg().setNextEnabled(false);
        this.srcNodeModel = this.getAbstractCktDlg().getSourceNode();
        this.altSrcNodeModel = this.getAbstractCktDlg().getAltSourceNode();
        this.dstNodeModel = this.getAbstractCktDlg().getDestNode();
        this.altDstNodeModel = this.getAbstractCktDlg().getAltDestNode();
        this.setCurrentNode(this.srcNodeModel);
        if (!this.getAbstractCktDlg().getCircuit().getCircuitTypeObj().isVcatCircuitType()) {
            this.cleanup();
            this.initialization();
            this.initBlsrDriUI();
            this.initBlsrDriNodeList();
        }
    }

    protected void initBlsrDriUI() {
        boolean bl = this.isPossibleBlsrDri();
        if (!bl && this.secondarySpanCB.isSelected()) {
            this.secondarySpanCB.setSelected(false);
        }
        this.jtp.getComponentAt(1).setEnabled(bl);
        this.jtp.setEnabledAt(1, bl);
        if (!bl && this.jtp.getSelectedIndex() == 1) {
            this.jtp.setSelectedIndex(0);
        }
        String string = bl ? null : "This tab is only enabled if you are creating a(n) " + CircuitMapUtil.HO_TERM + " DRI circuit.";
        this.jtp.setToolTipTextAt(1, string);
    }

    protected void initBlsrDriNodeList() {
        List list = this.getCurrentMemberPrefs(this.getAbstractCktDlg().getRoutePrefs()).getDriNodePrefs();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                DriNodes driNodes = (DriNodes)list.get(i);
                boolean bl = driNodes.isSecPca();
                int n = driNodes.getDriType();
                int n2 = 1;
                if (n == 1) {
                    n2 = 2;
                } else if (n == 2) {
                    n2 = 3;
                }
                RoutingConstraint routingConstraint = new RoutingConstraint(n2);
                routingConstraint.setUsePca(bl);
                List list2 = driNodes.getNodePairs();
                String string = "       ";
                String string2 = list2.size() > 1 ? "Traditional" : "Non-Traditional";
                string2 = string2 + " " + CircuitMapUtil.BLSRDRI_TERM;
                for (int j = 0; j < list2.size(); ++j) {
                    object = (DriNodePair)list2.get(j);
                    INetElement iNetElement = ((DriNodePair)object).getPrimary();
                    INetElement iNetElement2 = ((DriNodePair)object).getSecondary();
                    routingConstraint.addElementConstraint(iNetElement, iNetElement2);
                    string2 = string2 + "\n" + string + "Pri #" + (j + 1) + "= " + iNetElement.getName() + ", Sec #" + (j + 1) + "= " + iNetElement2.getName();
                }
                String string3 = driNodes.getFirstDriRing();
                if (string3.equals("")) {
                    string3 = "<" + CircuitMapUtil.UPSR_TERM + ">";
                }
                if (((String)(object = driNodes.getSecondDriRing())).equals("")) {
                    object = "<" + CircuitMapUtil.UPSR_TERM + ">";
                }
                string2 = string2 + "\n" + string + "First Ring: " + string3 + ", Second Ring: " + (String)object;
                if (this.db.on() && bl) {
                    this.db.println(string2 + " specified PCA.");
                    string2 = string2 + "\n" + string + BlsrDriDialog.USE_RIP_STRING;
                }
                routingConstraint.setLabel(string2);
                if (routingConstraint == null) continue;
                this.blsrDriListModel.addElement(routingConstraint);
                this.updateBlsrDriMapNodes();
            }
            this.secondarySpanCB.setVisible(this.blsrDriListModel.getSize() > 0);
        }
    }

    protected void initialization() {
        this.mapExistingSpans(this.getAbstractCktDlg().ckt.getCircuitSpans());
    }

    protected void mapExistingSpans(List list) {
        int n = list.size();
        if (this.db.on()) {
            this.db.println("Map " + n + " existing spans.");
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object;
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)list.get(i);
                NetLinkSpan netLinkSpan = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
                boolean bl = netLinkSpan.isSecondaryCircuit();
                if (this.db.on()) {
                    this.db.println("Iteration #" + i);
                    this.db.println("\tgot NetLinkSpan from ckt: " + netLinkSpan);
                    this.db.println("\tis secondary? " + bl);
                }
                INetLink iNetLink = this.getNetLink(netLinkSpan);
                MapLink mapLink = this.netToMapLink(netLinkSpan);
                if (this.db.on()) {
                    this.db.println("\tnetLink is " + iNetLink);
                    this.db.println("\tassociated mapLink is " + mapLink);
                }
                if (mapLink == null) {
                    if (iNetLink.isLAP()) {
                        this.circuitMap.addLink(iNetLink, null);
                        mapLink = this.netToMapLink(netLinkSpan);
                    } else {
                        if (!this.db.on()) continue;
                        this.db.println("\tgoing to next iteration");
                        continue;
                    }
                }
                if (netLinkSpan.getOmni()) {
                    mapLink.setBothArrows();
                } else {
                    mapLink.setTargetArrow();
                    object = (AbstractNetLink)mapLink.getUserObject();
                    if (object != iNetLink) {
                        mapLink.reverseArrow();
                    }
                }
                this.circuitMap.setNetMapLinkState("mapExistingSpans()", mapLink, 3);
                if (this.activeCktSpans.contains(netCircuitSpan)) {
                    object = this.getSpanDesc(mapLink, netLinkSpan);
                    object = bl ? (String)object + "(existing " + SECONDARY_PATH_STRING + ")" : (String)object + "(existing circuit span)";
                    this.olm.add(netLinkSpan, (String)object);
                    continue;
                }
                if (this.olm.getContent().contains(netLinkSpan)) continue;
                object = bl ? " (Part of secondary path)" : "";
                this.olm.add(netLinkSpan, this.getSpanDesc(mapLink, netLinkSpan) + (String)object);
            }
            this.removeButton.setEnabled(false);
        } else {
            INetCircuit iNetCircuit = this.getAbstractCktDlg().getCircuit().useLAP();
            if (iNetCircuit != null) {
                INetCircuitSpan iNetCircuitSpan = NetCircuitManager.instance().getLAPSpan(this.getAbstractCktDlg().getCircuit());
                NetLinkSpan netLinkSpan = (NetLinkSpan)iNetCircuitSpan.getNetLinkSpan();
                boolean bl = netLinkSpan.isSecondaryCircuit();
                INetLink iNetLink = iNetCircuitSpan.getLink();
                MapLink mapLink = this.netToMapLink(netLinkSpan);
                if (this.db.on()) {
                    this.db.println("\tnetLink is " + iNetLink);
                    this.db.println("\tassociated mapLink is " + mapLink);
                }
                if (mapLink == null) {
                    this.circuitMap.addLink(iNetLink, null);
                    mapLink = this.netToMapLink(netLinkSpan);
                }
                mapLink.setTargetArrow();
                AbstractNetLink abstractNetLink = (AbstractNetLink)mapLink.getUserObject();
                if (abstractNetLink != iNetLink) {
                    mapLink.reverseArrow();
                }
                this.circuitMap.setNetMapLinkState("mapExistingSpans()", mapLink, 3);
                if (!this.olm.getContent().contains(netLinkSpan)) {
                    String string = bl ? " (Part of secondary path)" : "";
                    this.olm.add(netLinkSpan, this.circuitMap.getLinkDesc(mapLink) + string);
                }
                this.addCircuitSpan(netLinkSpan);
                this.removeButton.setEnabled(false);
            } else {
                if (this.altSrcNodeModel != null) {
                    this.circuitMap.setSelected(this.getMapNode(this.altSrcNodeModel), true);
                    this.markLinktoNode(this.altSrcNodeModel);
                }
                this.circuitMap.setSelected(this.getMapNode(this.srcNodeModel), true);
                this.markLinktoNode(this.srcNodeModel);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addSpanButton) {
            this.addSpan();
            if (this.parent instanceof UnprotectedToUpsrDialog) {
                ((UnprotectedToUpsrDialog)this.parent).setSpanUpdated(true);
            }
        } else if (object == this.removeButton) {
            if (this.parent instanceof UnprotectedToUpsrDialog) {
                ((UnprotectedToUpsrDialog)this.parent).setSpanUpdated(true);
            }
        } else if (object == this.addBlsrButton) {
            this.addBlsrDri();
            this.secondarySpanCB.setVisible(this.blsrDriListModel.getSize() > 0);
        } else if (object == this.remBlsrButton) {
            this.removeBlsrDri();
            this.secondarySpanCB.setVisible(this.blsrDriListModel.getSize() > 0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.blsrDriList) {
            Object e = this.blsrDriList.getSelectedValue();
            this.remBlsrButton.setEnabled(e != null && !this.getAbstractCktDlg().isAutoRoute());
        }
    }

    private synchronized void removeBlsrDri() {
        RoutingConstraint routingConstraint;
        int n;
        int n2 = this.blsrDriList.getSelectedIndex();
        if (n2 > -1 && ((n = (routingConstraint = (RoutingConstraint)this.blsrDriListModel.get(n2)).getConstraintType()) == 2 || n == 3)) {
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = routingConstraint.getPriElemConstraintList();
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                arrayList.add(arrayList2.get(n3));
            }
            arrayList2 = routingConstraint.getSecElemConstraintList();
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                arrayList.add(arrayList2.get(n3));
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                INetElement iNetElement = (INetElement)arrayList.get(n3);
                MapNode mapNode = this.getMapNode(iNetElement);
                if (mapNode == null) continue;
                mapNode.setDesc(null);
            }
        }
        this.blsrDriListModel.remove(n2);
    }

    private void addBlsrDri() {
        MapNode[] mapNodeArray = this.circuitMap.getMapNodes();
        Vector<MapNode> vector = new Vector<MapNode>(mapNodeArray.length);
        for (int i = 0; i < mapNodeArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.blsrDriListModel.size(); ++j) {
                RoutingConstraint routingConstraint = (RoutingConstraint)this.blsrDriListModel.get(j);
                INetElement iNetElement = this.getNetElement(mapNodeArray[i]);
                if (iNetElement != null && !routingConstraint.containsNetElement(iNetElement, 2)) continue;
                bl = true;
            }
            if (bl) continue;
            INodeModel iNodeModel = this.getNodeModel(mapNodeArray[i]);
            if (iNodeModel != null && iNodeModel.provides(Feature.BLSR_UPSR_DRI)) {
                vector.add(mapNodeArray[i]);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("Not eligible for BLSR-DRI, either null or does not support feature:\n\t" + mapNodeArray[i] + "\tNodeModel=" + iNodeModel);
        }
        RoutingConstraint routingConstraint = BlsrDriDialog.getRoutingConstraint(vector, false, this.parent);
        if (routingConstraint != null) {
            this.blsrDriListModel.addElement(routingConstraint);
            this.updateBlsrDriMapNodes();
        }
    }

    protected synchronized void updateBlsrDriMapNodes() {
        for (int i = 0; i < this.blsrDriListModel.getSize(); ++i) {
            RoutingConstraint routingConstraint = (RoutingConstraint)this.blsrDriListModel.get(i);
            int n = routingConstraint.getConstraintType();
            if (!routingConstraint.isElemConstraint()) continue;
            ArrayList arrayList = routingConstraint.getPriElemConstraintList();
            ArrayList arrayList2 = null;
            if (n == 2 || n == 3) {
                arrayList2 = routingConstraint.getSecElemConstraintList();
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                INetElement iNetElement = (INetElement)arrayList.get(j);
                MapNode mapNode = this.getMapNode(iNetElement);
                if (mapNode == null) {
                    this.db.println("update nodes, node was null...");
                    continue;
                }
                mapNode.setDesc(null);
                mapNode.addDesc(RoutingConstraint.getBlsrDriString(routingConstraint, iNetElement));
                if (arrayList2 == null) continue;
                iNetElement = (INetElement)arrayList2.get(j);
                mapNode = this.getMapNode(iNetElement);
                mapNode.setDesc(null);
                mapNode.addDesc(RoutingConstraint.getBlsrDriString(routingConstraint, iNetElement));
            }
        }
    }

    public void selectionChanged(Object object, Object object2) {
        this.secondarySpanCB.setEnabled(false);
        this.secondarySpanCB.setSelected(false);
        if (this.db.on()) {
            this.db.finer("selection changed old = " + object);
            this.db.finer("                  new = " + object2);
        }
        if (object == object2) {
            this.db.finer("Selection is the same link; no action; leaving.");
            return;
        }
        this.driLabel.setVisible(false);
        if (object instanceof INetLinkSpan) {
            this.hoLoPane.disablePane();
        }
        if (object2 instanceof INetLinkSpan) {
            MapLink mapLink;
            if (((INetLinkSpan)object2).isSecondaryCircuit()) {
                this.secondarySpanCB.setSelected(true);
            }
            this.hoLoPane.enable((NetLinkSpan)object2);
            if (object2 != object && ((NetLinkSpan)object2).getOmni()) {
                this.driLabel.setVisible(true);
            }
            INetLink iNetLink = ((INetLinkSpan)object2).getLink();
            if (object instanceof NetLinkSpan && object != object2) {
                mapLink = this.getMapLink((NetLinkSpan)object);
                this.circuitMap.setSelected(mapLink, false);
            }
            mapLink = this.getMapLink((NetLinkSpan)object2);
            this.circuitMap.setSelected(mapLink, true);
            Iterator iterator = this.activeCktSpans.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink2 = ((INetCircuitSpan)iterator.next()).getLink();
                if (iNetLink2 != iNetLink) continue;
                if (this.db.on()) {
                    this.db.println("newSelection is active span");
                }
                this.removeButton.setEnabled(false);
            }
            if (iNetLink.isLAP()) {
                if (this.db.on()) {
                    this.db.println("newSelection is LAP span");
                }
                this.removeButton.setEnabled(false);
            }
        }
        if (this.olm.getJList().getSelectedIndex() < 0) {
            this.hoLoPane.disablePane();
        }
    }

    public void entryRemoved(Object object) {
        Object object2;
        INetLinkSpan iNetLinkSpan = (INetLinkSpan)object;
        this.deleteCircuitSpan(iNetLinkSpan);
        MapLink mapLink = this.getMapLink((NetLinkSpan)object);
        if (mapLink != null && ((INetLinkSpan[])(object2 = this.getSpansWithLink(mapLink))).length == 0) {
            mapLink.removeArrows();
            this.circuitMap.setNetMapLinkState("entryRemoved()", mapLink, 2);
            this.unSetLink();
            this.circuitMap.setSelected(mapLink, false);
        }
        object2 = this.getNetLink((NetLinkSpan)object);
        MapNode mapNode = this.getMapNode(object2.getSrc().getNodeModel());
        MapNode mapNode2 = this.getMapNode(object2.getDst().getNodeModel());
        this.circuitMap.setSelected(mapNode2, false);
        this.unSelectVnodes(mapNode2);
        if (this.isNodeSelectable(mapNode)) {
            this.circuitMap.setSelected(mapNode, true);
            this.selectVnodes(mapNode);
            this.markLinktoNode((INodeModel)mapNode.getUserObject());
        } else {
            if (this.altSrcNodeModel != null) {
                this.circuitMap.setSelected(this.getMapNode(this.altSrcNodeModel), true);
                this.selectVnodes(this.getMapNode(this.altSrcNodeModel));
                this.markLinktoNode(this.altSrcNodeModel);
            }
            this.circuitMap.setSelected(this.getMapNode(this.srcNodeModel), true);
            this.selectVnodes(this.getMapNode(this.srcNodeModel));
            this.markLinktoNode(this.srcNodeModel);
        }
    }

    public void orderSwapped(Object object, Object object2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableLinks() {
        CircuitDesignMap circuitDesignMap = this.circuitMap;
        synchronized (circuitDesignMap) {
            for (INetLink iNetLink : this.circuitMap.getLinkUserObjects()) {
                MapLink mapLink = this.circuitMap.getMapLink(iNetLink);
                if (mapLink instanceof NetMapLink) {
                    NetMapLink netMapLink = (NetMapLink)mapLink;
                    if (netMapLink.getState() == 3 || netMapLink.getState() == 1) continue;
                    mapLink.removeArrows();
                    this.circuitMap.setNetMapLinkState("disableLinks()", mapLink, 2);
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.finest("disableLinks(); given MapLink was not a NetMapLink:\n" + mapLink);
            }
        }
    }

    private void markLinktoNode(INodeModel iNodeModel) {
        MapLink mapLink = null;
        AbstractNetLink abstractNetLink = null;
        for (INetLink iNetLink : this.circuitMap.getLinkUserObjects()) {
            NetMapLink netMapLink;
            mapLink = this.circuitMap.getMapLink(iNetLink);
            Object object = mapLink.getUserObject();
            if (!(object instanceof AbstractNetLink)) continue;
            abstractNetLink = (AbstractNetLink)object;
            if (abstractNetLink == null) {
                abstractNetLink = (AbstractNetLink)this.circuitMap.findReverseLink(abstractNetLink);
            }
            if (!this.circuitMap.isLinkAcceptable(abstractNetLink)) continue;
            INodeModel iNodeModel2 = this.getNodeModel(mapLink.getSource());
            INodeModel iNodeModel3 = this.getNodeModel(mapLink.getTarget());
            if (iNodeModel2 == iNodeModel || iNodeModel3 == iNodeModel) {
                if (mapLink instanceof NetMapLink) {
                    netMapLink = (NetMapLink)mapLink;
                    if (netMapLink.getState() == 3 || netMapLink.getState() == 1) continue;
                    mapLink.setTargetArrow();
                    if (iNodeModel2 != iNodeModel) {
                        mapLink.reverseArrow();
                        this.circuitMap.updateView();
                    }
                    this.circuitMap.setNetMapLinkState("markLinkToNode0()", netMapLink, 2);
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.finest("markLinkToNode0(); given MapLink was not a NetMapLink:\n" + mapLink);
                continue;
            }
            if (mapLink instanceof NetMapLink) {
                netMapLink = (NetMapLink)mapLink;
                if (netMapLink.getState() == 3 || netMapLink.getState() == 1) continue;
                mapLink.removeArrows();
                this.circuitMap.setNetMapLinkState("markLinkToNode1()", netMapLink, 2);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.finest("markLinkToNode1(); given MapLink was not a NetMapLink:\n" + mapLink);
        }
    }

    protected boolean isNodeSelectable(MapNode mapNode) {
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        if (iNodeModel == this.srcNodeModel) {
            return true;
        }
        if (this.altSrcNodeModel != null && iNodeModel == this.altSrcNodeModel) {
            return true;
        }
        if (this.olm.getContent() != null) {
            INetLinkSpan iNetLinkSpan = null;
            for (int i = 0; i < this.olm.getContent().size(); ++i) {
                ILinkModel iLinkModel;
                if (!(this.olm.getContent().get(i) instanceof INetLinkSpan) || (iLinkModel = (iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i)).getLink().getLinkModel()).src() != iNodeModel && iLinkModel.dst() != iNodeModel) continue;
                return true;
            }
        }
        return false;
    }

    protected void addSpan() {
        INetLink iNetLink;
        INetLinkSpan iNetLinkSpan = this.hoLoPane.getNetLinkSpan();
        boolean bl = false;
        if (iNetLinkSpan instanceof NetLinkSpan) {
            ((NetLinkSpan)iNetLinkSpan).setOmni(this.driLabel.isVisible());
            ((NetLinkSpan)iNetLinkSpan).setSecondaryCircuit(this.secondarySpanCB.isSelected());
            bl = this.secondarySpanCB.isSelected();
        }
        if (!this.continueNonRevertive(iNetLink = this.hoLoPane.getNetLink())) {
            this.unSetLink();
            MapNode mapNode = this.getMapNode(iNetLink.getSrc().getNodeModel());
            this.circuitMap.setSelected(mapNode, true);
            this.selectVnodes(mapNode);
            this.setNode(mapNode);
            return;
        }
        if (iNetLink instanceof NetLink && ((NetLink)iNetLink).inBLSR() && !iNetLink.isPca()) {
            this.blsrHoNum = iNetLinkSpan.getSrcHoNum();
            this.blsrLoNum = iNetLinkSpan.getLoNum();
        }
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        if (iNetLinkSpan != null) {
            Object object;
            if (this.db.on()) {
                this.db.println("addSpan HO=" + iNetLinkSpan.getSrcHoNum() + " LO=" + iNetLinkSpan.getLoNum());
            }
            this.addCircuitSpan(iNetLinkSpan);
            MapLink mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
            this.circuitMap.setNetMapLinkState("addSpan()", mapLink, 3);
            if (!this.olm.getContent().contains(iNetLinkSpan)) {
                object = this.getSpanDesc(mapLink, (NetLinkSpan)iNetLinkSpan);
                if (bl) {
                    object = (String)object + " (" + SECONDARY_PATH_STRING + ")";
                }
                this.olm.add(iNetLinkSpan, (String)object);
                this.unSetLink();
            }
            this.hoLoPane.enable(iNetLinkSpan);
            object = this.getMapNode(iNetLink.getSrc().getNodeModel());
            this.markLinktoNode(this.getNodeModel((MapNode)object));
            this.circuitMap.setSelected((Node)object, false);
            this.unSelectVnodes((MapNode)object);
            MapNode mapNode = this.getMapNode(iLinkModel.dst());
            if (iLinkModel.dst() != this.dstNodeModel && iLinkModel.dst() != this.altDstNodeModel) {
                this.circuitMap.setSelected(mapNode, true);
                this.selectVnodes(mapNode);
            } else if (this.getAbstractCktDlg().isPathProt() && !iNetLink.isProtected()) {
                int n = 0;
                for (int i = this.olm.getContent().size(); i > 0; --i) {
                    INetLinkSpan iNetLinkSpan2;
                    INetLink iNetLink2;
                    if (!(this.olm.getContent().get(i - 1) instanceof NetLinkSpan) || (iNetLink2 = (iNetLinkSpan2 = (INetLinkSpan)this.olm.getContent().get(i - 1)).getLink()).getDst().getNodeModel() != this.dstNodeModel) continue;
                    ++n;
                }
                if (n < 2 && (!this.getAbstractCktDlg().getCircuitInfo().isOVcat() || this.getAbstractCktDlg().getCircuitInfo().isOVcat() && this.getAbstractCktDlg().areSecDropsPresent())) {
                    mapNode = this.getMapNode(this.srcNodeModel);
                    this.circuitMap.setSelected(mapNode, true);
                    this.selectVnodes(mapNode);
                } else {
                    this.markLinktoNode(null);
                }
            } else {
                this.markLinktoNode(null);
            }
            this.circuitMap.updateView();
        } else {
            this.db.println("hoLoPane.getNetLinkSpan() returned null");
        }
    }

    protected void setCurrentNode(INodeModel iNodeModel) {
        this.currentNode = iNodeModel;
    }

    public void validatePage() throws Exception {
        if (this.parent instanceof UnprotectedToUpsrDialog) {
            this.performSanityChecks();
            return;
        }
        if (this.blsrDriListModel.size() > 0) {
            this.validateUpsrReversion();
        }
        try {
            this.storeDriNodePrefs();
            if (this.db.on()) {
                ArrayList<Object> arrayList = this.olm.getContent();
                this.db.println("Dumping the OLM:");
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object = arrayList.get(i);
                    String string = object instanceof INetLinkSpan ? ((INetLinkSpan)object).prettyString() : object.toString();
                    this.db.println("#" + i + "\t" + string);
                }
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while storing node preferences.", exception);
        }
        this.performSanityChecks();
    }

    protected String getThisRouteString() {
        return "This circuit has ";
    }

    protected void performSanityChecks() throws SanityCheckException {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        INetCircuit iNetCircuit = abstractCircuitDialog.getCircuit();
        String string = "performSanityChecks(): ";
        if (this.db.on()) {
            this.db.println(string + "checking SRGs");
        }
        try {
            LinkedList linkedList = iNetCircuit.sanityCheckSRGs();
            if (linkedList != null && linkedList.size() > 0) {
                int n;
                if (this.db.on()) {
                    this.db.println(string + " SRG list is size " + linkedList.size());
                }
                String string2 = linkedList.size() == 1 ? "violation" : "violations";
                String string3 = linkedList.size() == 1 ? "Violation" : "Violations";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getThisRouteString() + "the following Shared Risk" + " Group " + string2 + ":\n\n");
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n = 0; n < linkedList.size(); ++n) {
                    SrgViolation srgViolation = (SrgViolation)linkedList.get(n);
                    arrayList.add(this.makeFriendlyViolation(srgViolation));
                }
                arrayList = new ArrayList(new LinkedHashSet(arrayList));
                for (n = 0; n < arrayList.size(); ++n) {
                    if (arrayList.size() > 1) {
                        stringBuffer.append("Violation #" + (n + 1) + ": ");
                    }
                    stringBuffer.append(arrayList.get(n) + "\n\n");
                }
                stringBuffer.append("Is it OK to continue with the circuit creation?");
                this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)stringBuffer.toString(), (String)("Shared Risk Group " + string3));
                if (!this.isOkToPostValidate()) {
                    return;
                }
            }
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            WzDiagDebug.printStackTrace((Throwable)sanityCheckFailed);
            throw new SanityCheckException("A failure occurred during the shared risk group check", "spans are", sanityCheckFailed);
        }
        if (this.parent instanceof UnprotectedToUpsrDialog) {
            return;
        }
        if (this.db.on()) {
            this.db.println(string + "checking manual routing");
        }
        try {
            iNetCircuit.sanityCheckManualRouting();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw new SanityCheckException("", "spans are", sanityCheckFailed);
        }
        if (this.db.on()) {
            this.db.println("all sanity checks succeeded.");
        }
    }

    protected String makeFriendlyViolation(SrgViolation srgViolation) {
        StringBuffer stringBuffer = new StringBuffer(srgViolation.getDescriptor() + "\n");
        Object object = srgViolation.getViolationObject();
        if (object instanceof INetLink) {
            stringBuffer.append("Span: ");
            stringBuffer.append(this.getLinkDesc((INetLink)object));
        } else {
            stringBuffer.append(object.toString());
        }
        return stringBuffer.toString();
    }

    protected String getLinkDesc(INetLink iNetLink) {
        MapLink mapLink = this.circuitMap.getMapLink(iNetLink);
        if (mapLink == null) {
            mapLink = this.circuitMap.getMapLink(iNetLink.getReverseLink());
        }
        if (mapLink == null) {
            return iNetLink.prettyString();
        }
        return this.circuitMap.getLinkDesc(mapLink);
    }

    boolean setLink(NetMapLink netMapLink) {
        Object object;
        int n;
        MapLink mapLink;
        if (this.db.on()) {
            this.db.println("setlink maplink = " + netMapLink);
        }
        this.driLabel.setVisible(false);
        if (netMapLink == null) {
            if (this.db.on()) {
                this.db.finer("unSetLink due to mapLink == null");
            }
            this.unSetLink();
            return true;
        }
        if (this.currentNode == null && netMapLink.getState() != 3) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SELECT_NODE);
            this.unSetLink();
            return false;
        }
        INetLink iNetLink = this.hoLoPane.getNetLink();
        if (iNetLink != null && (mapLink = this.circuitMap.getDirectionalMapLink(iNetLink)) != netMapLink) {
            if (this.db.on()) {
                this.db.finer("unSetLink due to mapLink != oldMapLink");
            }
            this.unSetLink();
        }
        if ((n = netMapLink.getState()) == 1) {
            return false;
        }
        int n2 = this.getAbstractCktDlg().getCircuitInfo().size();
        int n3 = this.getAbstractCktDlg().getCircuitInfo().type();
        iNetLink = (INetLink)netMapLink.getUserObject();
        MapLink mapLink2 = this.circuitMap.getDirectionalMapLink(iNetLink);
        boolean bl = false;
        try {
            object = CircuitType.getCircuitType((int)n3);
            if (!object.isVcatCircuitType()) {
                this.getAbstractCktDlg().getRoutePrefs().setCircuitSize(n2);
                this.getAbstractCktDlg().getRoutePrefs().setCircuitType(n3);
            }
            bl = iNetLink.availBW(this.getAbstractCktDlg().getRoutePrefs());
        }
        catch (Exception exception) {
            this.db.finer("Exception in setLink, mapLink=" + netMapLink + " " + exception);
        }
        if (n == 2 && !bl) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_PATHS_AVAILABLE);
            return false;
        }
        if (n == 3) {
            object = this.setSelectedSpanCurrent(mapLink2);
            if (object != null) {
                this.hoLoPane.enable((INetLinkSpan)object);
            }
            if (mapLink2.isSrcArrowEnabled() && mapLink2.isTargetArrowEnabled()) {
                this.driLabel.setVisible(true);
            }
        } else if (n == 0) {
            if (mapLink2.isSrcArrowEnabled()) {
                iNetLink = this.circuitMap.findReverseLink(iNetLink);
            }
            boolean bl2 = false;
            int n4 = this.getCurrentMemberPrefs(this.getAbstractCktDlg().getRoutePrefs()).getPathProtection();
            bl2 = n4 == 5;
            if (mapLink2.isSrcArrowEnabled() && mapLink2.isTargetArrowEnabled()) {
                if (mapLink2 instanceof CircuitMapLink) {
                    CircuitMapLink circuitMapLink = (CircuitMapLink)mapLink2;
                    if (circuitMapLink.getLastHeading() == 0) {
                        circuitMapLink.setTargetArrow();
                    } else {
                        circuitMapLink.setSrcArrow();
                    }
                } else {
                    mapLink2.setTargetArrow();
                }
                this.circuitMap.updateView();
            } else if (!iNetLink.isProtected() && !iNetLink.isPca() && bl2) {
                mapLink2.setBothArrows();
                this.driLabel.setVisible(true);
            } else {
                CerentDialog.infoDialog((Component)this, (String)"The span may only go away from the selected node.", (String)"select spans");
            }
            this.hoLoPane.enable(iNetLink, n2, n3);
            this.clearSelection();
        } else if (n == 1) {
            this.clearSelection();
            this.hoLoPane.disablePane();
        } else if (!mapLink2.isSrcArrowEnabled() && !mapLink2.isTargetArrowEnabled()) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SPAN_NOT_SELECTABLE);
            this.unSetLink();
        } else {
            mapLink2.setTargetArrow();
            object = this.getMapNode(iNetLink.getSrc().getNodeModel());
            MapNode mapNode = this.getMapNode(iNetLink.getDst().getNodeModel());
            if (object != this.getMapNode(this.currentNode)) {
                iNetLink = this.circuitMap.findReverseLink(iNetLink);
                mapLink2 = this.circuitMap.getDirectionalMapLink(iNetLink);
                mapLink2.reverseArrow();
                if (this.db.on()) {
                    this.db.println("\tThe NetLink src does not match  the current Node, so reversing arrow: " + mapNode + " ----> " + object);
                }
                this.circuitMap.updateView();
            }
            this.circuitMap.setNetMapLinkState("setLink()", mapLink2, 0);
            boolean bl3 = this.isPossibleBlsrDri();
            this.secondarySpanCB.setEnabled(bl3);
            this.hoLoPane.enable(iNetLink, n2, n3);
            if (iNetLink instanceof NetLink && ((NetLink)iNetLink).inBLSR() && !iNetLink.isPca() && this.blsrHoNum != null) {
                this.hoLoPane.selectHoCB(this.blsrHoNum);
                if (this.blsrLoNum != null) {
                    this.hoLoPane.selectLoCB(this.blsrLoNum);
                }
            }
            this.clearSelection();
        }
        return true;
    }

    void unSetLink() {
        INetLink iNetLink = null;
        if (this.hoLoPane != null) {
            iNetLink = this.hoLoPane.getNetLink();
        }
        MapLink mapLink = null;
        if (iNetLink != null) {
            mapLink = this.circuitMap.getDirectionalMapLink(iNetLink);
            if (this.db.on()) {
                this.db.finer("unsetlink mapLink = " + mapLink);
            }
            if (mapLink != null) {
                if (mapLink instanceof NetMapLink) {
                    NetMapLink netMapLink = (NetMapLink)mapLink;
                    if (netMapLink.getState() == 0) {
                        netMapLink.removeArrows();
                        this.circuitMap.setNetMapLinkState("unSetLink()", netMapLink, 2);
                    }
                } else if (this.db.on()) {
                    this.db.finest("unSetLink(); given MapLink was not a NetMapLink:\n" + mapLink);
                }
            }
        }
        if (this.hoLoPane != null) {
            this.hoLoPane.disablePane();
        }
        this.clearSelection();
        if (mapLink != null) {
            this.circuitMap.setSelected(mapLink, false);
        }
        this.secondarySpanCB.setEnabled(false);
        this.secondarySpanCB.setSelected(false);
    }

    protected void unSetNode() {
        if (this.currentNode != null) {
            if (this.db.on()) {
                this.db.finer("unSetNode() " + this.currentNode);
            }
            MapNode mapNode = this.getMapNode(this.currentNode);
            this.unSetNode(mapNode);
        }
    }

    private void unSetNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("unSetNode(mapNode) " + mapNode);
        }
        this.unSelectVnodes(mapNode);
        if (mapNode != null && mapNode.isSelected()) {
            this.circuitMap.setSelected(mapNode, false);
        }
        this.nodeLB.setText("");
        this.setCurrentNode(null);
        this.disableLinks();
        this.circuitMap.updateView();
    }

    boolean setNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("--> setNode " + mapNode);
        }
        this.driLabel.setVisible(false);
        if (mapNode == null) {
            this.unSetNode();
            return true;
        }
        if (this.currentNode != null && this.currentNode != this.getNodeModel(mapNode)) {
            this.unSetNode(this.getMapNode(this.currentNode));
        }
        this.markLinktoNode(this.getNodeModel(mapNode));
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        this.nodeLB.setText(iNodeModel.getName());
        this.setCurrentNode((INodeModel)mapNode.getUserObject());
        if (this.db.on()) {
            this.db.finer("<-- setNode " + mapNode);
        }
        return true;
    }

    public void recycle() {
        if (this.db.on()) {
            this.db.println("recycle");
        }
        this.localCleanup();
        if (this.isInited()) {
            this.hoLoPane.reset();
        }
        this.currentNode = null;
        this.dstNodeModel = null;
        this.srcNodeModel = null;
        this.altSrcNodeModel = null;
        this.altDstNodeModel = null;
        this.spanList = null;
        if (this.topPanel != null) {
            this.topPanel.removeKeyListener(this);
        }
        super.recycle();
    }

    void reset() {
        if (this.db.on()) {
            this.db.println("reset");
        }
        if (this.circuitMap != null) {
            this.cleanup();
        }
    }

    protected INetLinkSpan setSelectedSpanCurrent(MapLink mapLink) {
        INetLinkSpan iNetLinkSpan = null;
        for (int i = 0; i < this.olm.getContent().size(); ++i) {
            if (!(this.olm.getContent().get(i) instanceof NetLinkSpan) || this.circuitMap.getDirectionalMapLink((iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i)).getLink()) != mapLink) continue;
            this.olm.getJList().setSelectedIndex(i);
            return iNetLinkSpan;
        }
        return null;
    }

    public void nodeSelected(MapNode mapNode, boolean bl) {
        this.topPanel.requestFocus();
        if (this.modifiers == 2) {
            return;
        }
        if (bl) {
            if (mapNode.isDomain()) {
                this.circuitMap.setSelected(mapNode, false);
                return;
            }
            if (this.isNodeSelectable(mapNode)) {
                MapNode mapNode2;
                if (this.currentNode != null && !(mapNode2 = this.getMapNode(this.currentNode)).isSameNodeAs(mapNode)) {
                    this.circuitMap.setSelected(mapNode2, false);
                    this.unSelectVnodes(mapNode2);
                    this.currentNode = null;
                }
                this.setNode(mapNode);
            } else {
                this.circuitMap.setSelected(mapNode, false);
                this.unSetNode();
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NODE_NOT_SELECTABLE);
            }
        }
    }

    public void clicked(MapLink mapLink) {
        boolean bl = mapLink.isSelected();
        if (!bl) {
            this.deselected(mapLink);
        } else {
            MapLink mapLink2 = null;
            if (this.hoLoPane != null) {
                if (this.hoLoPane.getNetLinkSpan() != null) {
                    mapLink2 = this.getMapLink((NetLinkSpan)this.hoLoPane.getNetLinkSpan());
                }
            } else {
                mapLink2 = null;
            }
            if (mapLink != mapLink2) {
                this.hoLoPane.disablePane();
                if (mapLink2 != null) {
                    this.circuitMap.setSelected(mapLink2, false);
                }
                this.setLink(null);
            }
            if (mapLink instanceof NetMapLink) {
                this.setLink((NetMapLink)mapLink);
            } else if (this.db.on()) {
                this.db.finest("clicked(): cannott set a non-NetMapLink:\n" + mapLink);
            }
            this.circuitMap.updateView();
        }
    }

    private void clearSelection() {
        this.olm.getJList().clearSelection();
    }

    void linkSelected(MapLink mapLink, boolean bl) {
        if (!bl) {
            this.deselected(mapLink);
        }
    }

    public void deselected(MapLink mapLink) {
        MapLink mapLink2;
        if (this.db.on()) {
            this.db.println("deselected was called on " + mapLink);
        }
        MapLink mapLink3 = null;
        if (this.hoLoPane != null) {
            if (this.hoLoPane.getNetLinkSpan() != null) {
                mapLink3 = this.getMapLink((NetLinkSpan)this.hoLoPane.getNetLinkSpan());
            }
        } else {
            mapLink3 = null;
        }
        if ((mapLink2 = mapLink3) != null) {
            if (mapLink2 instanceof NetMapLink && mapLink instanceof NetMapLink) {
                if (mapLink2 == mapLink || mapLink2.getUserObject() == mapLink.getUserObject() && ((NetMapLink)mapLink2).getState() == ((NetMapLink)mapLink).getState()) {
                    this.hoLoPane.disablePane();
                    if (mapLink3 instanceof NetMapLink && ((NetMapLink)mapLink3).getState() == 0) {
                        mapLink3.removeArrows();
                        this.circuitMap.setNetMapLinkState("deselected()", mapLink3, 2);
                    }
                }
                this.circuitMap.setSelected(this.getMapNode(this.currentNode), true);
                this.selectVnodes(this.getMapNode(this.currentNode));
            } else if (this.db.on()) {
                this.db.finest("deselected(): could not continue because link and/or templink are not NetMapLinks:\nlink: " + mapLink + "\ntempLink: " + mapLink2);
            }
        }
        this.circuitMap.updateView();
    }

    public void domainDisplayed(MapNode mapNode) {
        MapNode mapNode2 = this.getMapNode(this.currentNode);
        if (this.db.on()) {
            this.db.println("\ndomainDisplayed " + mapNode);
            this.db.println("    selectedNode = " + mapNode2);
        }
        if (mapNode2 != null) {
            this.selectVnodes(mapNode2);
            this.circuitMap.setSelected(mapNode2, true);
        }
        this.circuitMap.updateView();
    }

    protected void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
        this.getAbstractCktDlg().getCircuit().deleteCircuitSpan(iNetLinkSpan);
    }

    protected void addCircuitSpan(INetLinkSpan iNetLinkSpan) {
        block2: {
            try {
                this.getAbstractCktDlg().getCircuit().addCircuitSpan(iNetLinkSpan);
            }
            catch (NoRoute noRoute) {
                if (!this.db.on()) break block2;
                this.db.println("NoRoute Exception");
            }
        }
    }

    protected List getActiveCircuitSpans() {
        return this.getAbstractCktDlg().getCircuit().getActiveCircuitSpans();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.modifiers = keyEvent.getModifiers() & 2;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.modifiers = 0;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdReviewEditPane;
    }

    public void removeListeners() {
        if (this.addBlsrButton != null) {
            this.addBlsrButton.removeActionListener(this);
        }
        if (this.remBlsrButton != null) {
            this.remBlsrButton.removeActionListener(this);
        }
        if (this.blsrDriList != null) {
            this.blsrDriList.removeListSelectionListener(this);
        }
        if (this.addSpanButton != null) {
            this.addSpanButton.removeActionListener(this);
        }
        if (this.removeButton != null) {
            this.removeButton.removeActionListener(this);
        }
        if (this.topPanel != null) {
            this.topPanel.removeKeyListener(this);
        }
        super.removeListeners();
    }

    public void dispose() {
        if (this.activeCktSpans != null) {
            this.activeCktSpans.clear();
            this.activeCktSpans = null;
        }
        this.currentNode = null;
        this.dstNodeModel = null;
        this.srcNodeModel = null;
        this.altSrcNodeModel = null;
        this.altDstNodeModel = null;
        this.spanList = null;
        super.dispose();
    }

    public String getDiagString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("BLSR DRI List: " + this.blsrDriListModel + "\n");
        if (this.blsrDriListModel != null) {
            stringBuffer.append("Size= " + this.blsrDriListModel.size() + "\n");
            for (n = 0; n < this.blsrDriListModel.size(); ++n) {
                stringBuffer.append("\t#" + (n + 1) + ": " + this.blsrDriListModel.get(n) + "\n");
            }
        }
        stringBuffer.append("Active Ckt Spans: " + this.activeCktSpans + "\n");
        if (this.activeCktSpans != null) {
            stringBuffer.append("Size= " + this.activeCktSpans.size() + "\n");
            for (n = 0; n < this.activeCktSpans.size(); ++n) {
                stringBuffer.append("\t#" + (n + 1) + ": " + this.activeCktSpans.get(n) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected MemberPrefs getCurrentMemberPrefs(RoutePrefs routePrefs) {
        LinkedList linkedList = routePrefs.getFwdDropPrefs().getMemberGroupPrefs();
        if (linkedList == null) {
            return null;
        }
        MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)linkedList.get(0);
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        return memberPrefs;
    }

    protected void storeDriNodePrefs() {
        MemberPrefs memberPrefs = this.getCurrentMemberPrefs(this.getAbstractCktDlg().getRoutePrefs());
        if (this.db.on()) {
            CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "Before redoing Dri Prefs in Review Edit");
        }
        memberPrefs.clearDriNodePrefs();
        for (int i = 0; i < this.blsrDriListModel.size(); ++i) {
            RoutingConstraint routingConstraint = (RoutingConstraint)this.blsrDriListModel.get(i);
            DriNodes driNodes = this.driNodesFromRoutingConstraint(routingConstraint);
            if (driNodes == null) continue;
            memberPrefs.addDriNodes(driNodes);
        }
        if (this.db.on()) {
            CcdRouteConstraintPane.dumpDriNodesFromPrefs(memberPrefs, this.db, "After redoing Dri Prefs in Review Edit");
        }
    }

    protected DriNodes driNodesFromRoutingConstraint(RoutingConstraint routingConstraint) {
        return RoutingConstraint.driNodesFromRoutingConstraint(routingConstraint);
    }

    private INetLinkSpan[] getSpansWithLink(MapLink mapLink) {
        ArrayList<INetLinkSpan> arrayList = new ArrayList<INetLinkSpan>();
        INetLinkSpan iNetLinkSpan = null;
        for (int i = 0; i < this.olm.getContent().size(); ++i) {
            iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i);
            if (this.circuitMap.getDirectionalMapLink(iNetLinkSpan.getLink()) != mapLink) continue;
            arrayList.add(iNetLinkSpan);
        }
        return arrayList.toArray(new INetLinkSpan[arrayList.size()]);
    }

    class MultiLineRenderer
    extends DefaultListCellRenderer {
        public MultiLineRenderer() {
            this.setUI((LabelUI)new MultiLineLabelUI());
        }
    }
}

