/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.cms.ui.circuits.ICcdRoutePane;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridPanel;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.OrderedListListener;
import cerent.util.gui.OrderedListModel;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.LabelUI;

public class CcdSvlanRoutePane
extends CcdCircuitDesignPane
implements ICcdRoutePane {
    private static final String TOP_BORDER = "Selected Node: ";
    private static final String CONSTRAINTS_TAB = "Constraints";
    private static final String SPANS_TAB = "Spans";
    private static final String INCLUDE = "Include";
    private static final String EXCLUDE = "Exclude";
    private static final String APPLY = "Apply";
    private static final String RESET = "Reset";
    private static final String INCLUDED_BORDER = "Included Nodes: ";
    private static final String EXCLUDED_BORDER = "Excluded Nodes: ";
    private static final String EXCLUDE_LABEL = "Excluded";
    private static final int MAX_ROUTING_CONSTRAINTS = 5;
    private MapNode selectedMapNode;
    private INetElement srcNE;
    private INetElement dstNE;
    private boolean isRouted;
    protected RoutePrefs routePrefs;
    private String statusText;
    private JLabel descrLB;
    private JTextField dispTF;
    private JSplitPane constraintsSp;
    private JButton includeButton;
    private JButton excludeButton;
    private JButton applyButton;
    private JButton resetButton;
    private OrderedListModelOrganizer nodesModelOrg;
    private OrderedListModel spansModel;
    private JTabbedPane tabbedPane;
    private static int BOTTOM_PANEL_HEIGTH = 250;
    private static final String PREF = "ctc.CcdSvlanRoutePane";
    private static final String DIV_LOC = "dl";

    public CcdSvlanRoutePane(AbstractCircuitDialog abstractCircuitDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(abstractCircuitDialog, wzDiagDebug, string, bl);
    }

    protected String getStatusText() {
        return this.statusText;
    }

    protected void storeStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        INetElement[] iNetElementArray = this.nodesModelOrg.getIncludedNodes();
        stringBuffer.append("\nRequired Nodes:");
        if (iNetElementArray.length == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (int i = 0; i < iNetElementArray.length; ++i) {
                stringBuffer.append("\n" + iNetElementArray[i].getName());
            }
        }
        INetElement[] iNetElementArray2 = this.nodesModelOrg.getExcludedNodes();
        stringBuffer.append("\n \nExcluded Nodes:");
        if (iNetElementArray2.length == 0) {
            stringBuffer.append("\n(None)");
        } else {
            for (int i = 0; i < iNetElementArray2.length; ++i) {
                stringBuffer.append("\n" + iNetElementArray2[i].getName());
            }
        }
        stringBuffer.append("\n");
        this.statusText = stringBuffer.toString();
    }

    protected JComponent getStatusComponent() {
        Object object;
        INetElement[] iNetElementArray;
        WzStatusPanel wzStatusPanel = new WzStatusPanel(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Required Nodes:");
        JLabel jLabel2 = new JLabel("Excluded Nodes:");
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jLabel2.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, "North");
        INetElement[] iNetElementArray2 = this.nodesModelOrg.getIncludedNodes();
        if (iNetElementArray2.length == 0) {
            jPanel.add((Component)new JLabel("(None)"), "Center");
        } else {
            iNetElementArray = new ArrayList();
            for (int i = 0; i < iNetElementArray2.length; ++i) {
                String[] stringArray = new String[]{String.valueOf(i + 1), iNetElementArray2[i].getName()};
                iNetElementArray.add(stringArray);
            }
            object = CcdSvlanRoutePane.getGridPanel(iNetElementArray);
            jPanel.add((Component)object, "Center");
        }
        jPanel2.add((Component)jLabel2, "North");
        iNetElementArray = this.nodesModelOrg.getExcludedNodes();
        if (iNetElementArray.length == 0) {
            jPanel2.add((Component)new JLabel("(None)"), "Center");
        } else {
            object = new ArrayList();
            for (int i = 0; i < iNetElementArray.length; ++i) {
                String[] stringArray = new String[]{String.valueOf(i + 1), iNetElementArray[i].getName()};
                ((ArrayList)object).add(stringArray);
            }
            GridPanel gridPanel = CcdSvlanRoutePane.getGridPanel((List)object);
            jPanel2.add((Component)gridPanel, "Center");
        }
        wzStatusPanel.push(jPanel, null, true);
        wzStatusPanel.push(new JLabel(" "), null, false);
        wzStatusPanel.push(jPanel2, null, true);
        return wzStatusPanel;
    }

    private void initDescrLabel() {
        if (this.isForProtectSvlan()) {
            this.descrLB.setText("SVLAN Protected Circuit Path [Read-Only Mode]");
        } else {
            this.descrLB.setText("SVLAN Circuit Path");
        }
    }

    protected JPanel getTopPanel() {
        JPanel jPanel = CcdSvlanRoutePane.createHorizontalPanel(null);
        this.descrLB = new JLabel();
        jPanel.add(this.descrLB);
        return jPanel;
    }

    protected JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        jPanel.add((Component)this.tabbedPane, "Center");
        JPanel jPanel2 = this.getConstraintsPanel();
        this.tabbedPane.addTab(CONSTRAINTS_TAB, jPanel2);
        this.tabbedPane.addTab(SPANS_TAB, this.getSpansPanel());
        Dimension dimension = this.tabbedPane.getPreferredSize();
        dimension.height = BOTTOM_PANEL_HEIGTH;
        this.tabbedPane.setMinimumSize(dimension);
        JPanel jPanel3 = CcdSvlanRoutePane.createHorizontalPanel(null);
        this.dispTF = new JTextField("");
        this.dispTF.setEditable(false);
        jPanel3.add(this.dispTF);
        jPanel3.setBorder(BorderFactory.createTitledBorder(TOP_BORDER));
        jPanel.add((Component)jPanel3, "North");
        return jPanel;
    }

    private JPanel getConstraintsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getButtonPanel(), "East");
        jPanel.add((Component)this.getNodesPanel(), "Center");
        return jPanel;
    }

    private JPanel getNodesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.constraintsSp = new JSplitPane(1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(INCLUDED_BORDER));
        jPanel2.add((Component)new JScrollPane(this.nodesModelOrg.getIncludedList()), "Center");
        this.constraintsSp.setLeftComponent(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(EXCLUDED_BORDER));
        jPanel3.add((Component)new JScrollPane(this.nodesModelOrg.getExcludedList()), "Center");
        this.constraintsSp.setRightComponent(jPanel3);
        jPanel.add((Component)this.constraintsSp, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 25, 0, 25, 0, 0, 0, 25, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        this.includeButton = new JButton(INCLUDE);
        this.addAndSetButton(jPanel, this.includeButton, null, 0);
        this.excludeButton = new JButton(EXCLUDE);
        this.addAndSetButton(jPanel, this.excludeButton, null, 1);
        this.nodesModelOrg = new OrderedListModelOrganizer(this);
        this.upButton = this.nodesModelOrg.getButton("Up");
        this.addAndSetButton(jPanel, this.upButton, null, 4);
        this.downButton = this.nodesModelOrg.getButton("Down");
        this.addAndSetButton(jPanel, this.downButton, null, 5);
        this.removeButton = this.nodesModelOrg.getButton("Remove");
        this.addAndSetButton(jPanel, this.removeButton, null, 6);
        this.applyButton = new JButton(APPLY);
        this.addAndSetButton(jPanel, this.applyButton, "Starts the route evaluation using the current constraints", 8);
        this.resetButton = new JButton(RESET);
        this.addAndSetButton(jPanel, this.resetButton, "Clears all constraints and evaluates the default route", 9);
        return jPanel;
    }

    private void addAndSetButton(JPanel jPanel, AbstractButton abstractButton, String string, int n) {
        abstractButton.setHorizontalAlignment(0);
        abstractButton.setEnabled(false);
        abstractButton.addActionListener(this);
        if (string != null) {
            abstractButton.setToolTipText(string);
        }
        jPanel.add((Component)abstractButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    private JPanel getSpansPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.spansModel = new OrderedListModel(this, true);
        jPanel.add((Component)new JScrollPane(this.spansModel.getJList()), "Center");
        return jPanel;
    }

    protected void initPane() {
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.getTopPanel(), "North");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setBottomComponent(this.getBottomPanel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.includeButton) {
            this.includeNode();
        } else if (object == this.excludeButton) {
            this.excludeNode();
        } else if (object == this.applyButton) {
            this.doApply();
        } else if (object == this.resetButton) {
            this.doReset();
        }
        this.enableWidgets();
    }

    boolean setLink(NetMapLink netMapLink) {
        return false;
    }

    boolean setNode(MapNode mapNode) {
        return true;
    }

    void unSetLink() {
    }

    void getMoreUIs() {
    }

    void linkSelected(MapLink mapLink, boolean bl) {
        this.setSelectedNode(null);
    }

    void nodeSelected(MapNode mapNode, boolean bl) {
        if (bl) {
            this.setSelectedNode(mapNode);
        } else {
            this.setSelectedNode(null);
        }
    }

    void clicked(MapLink mapLink) {
    }

    void domainDisplayed(MapNode mapNode) {
    }

    protected String getNextPaneName() {
        return null;
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdSvlanRoutePane;
    }

    public void selectionChanged(Object object, Object object2) {
    }

    public void orderSwapped(Object object, Object object2) {
        this.setNodeLabel((INetElement)object);
        this.setNodeLabel((INetElement)object2);
        this.enableWidgets();
    }

    public void entryRemoved(Object object) {
        this.setNodeLabel((INetElement)object);
        this.refreshLabels();
        this.enableWidgets();
    }

    private void refreshLabels() {
        INetElement[] iNetElementArray = this.nodesModelOrg.getIncludedNodes();
        for (int i = 0; i < iNetElementArray.length; ++i) {
            this.setNodeLabel(iNetElementArray[i]);
        }
        INetElement[] iNetElementArray2 = this.nodesModelOrg.getExcludedNodes();
        for (int i = 0; i < iNetElementArray2.length; ++i) {
            this.setNodeLabel(iNetElementArray2[i]);
        }
    }

    private void setNodeLabel(INetElement iNetElement) {
        MapNode mapNode = this.getMapNode(iNetElement);
        mapNode.setDesc(null);
        if (this.nodesModelOrg.contains(iNetElement)) {
            mapNode.addDesc(this.nodesModelOrg.getRankString(iNetElement));
        }
    }

    void setSelectedNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("--> setSelectedNode " + mapNode);
        }
        if (this.selectedMapNode != null) {
            if (!this.selectedMapNode.isSameNodeAs(mapNode)) {
                this.unSetNode(this.selectedMapNode);
            } else {
                return;
            }
        }
        this.selectedMapNode = mapNode;
        if (this.selectedMapNode == null) {
            this.dispTF.setText("");
        } else {
            INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
            this.dispTF.setText(iNodeModel.getName());
        }
        if (this.db.on()) {
            this.db.finer("<-- setSelectedNode " + mapNode);
        }
        this.enableWidgets();
    }

    private void unSetNode(MapNode mapNode) {
        if (this.db.on()) {
            this.db.finer("unSetNode(mapNode) " + mapNode);
        }
        this.unSelectVnodes(mapNode);
        if (mapNode != null && mapNode.isSelected()) {
            this.circuitMap.setSelected(mapNode, false);
        }
        this.circuitMap.updateView();
        this.enableWidgets();
    }

    public RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        if (this.db.on()) {
            this.db.println("set route prefs " + routePrefs);
        }
        this.routePrefs = routePrefs;
    }

    public boolean isPca() {
        return false;
    }

    public void setPca(boolean bl) {
    }

    public boolean isPathProt() {
        return false;
    }

    public void setPathProt(boolean bl) {
    }

    public boolean isRrbc() {
        return false;
    }

    public boolean isUrn() {
        return false;
    }

    public boolean isAutoRoute() {
        return false;
    }

    public void enteringPane() {
        AbstractCircuitDialog abstractCircuitDialog = this.getAbstractCktDlg();
        if (this.routePrefs == null) {
            this.routePrefs = abstractCircuitDialog.getRoutePrefs();
        }
        this.srcNE = this.routePrefs.getSrc();
        this.dstNE = this.routePrefs.getDst();
        super.enteringPane();
        this.constraintsSp.setDividerLocation(0.5);
        this.setSelectedNode(null);
        if (!this.goingForward) {
            this.nodesModelOrg.restoreLists();
        }
        this.initDescrLabel();
        this.updateMap();
        this.resetDividerLocation();
    }

    private void saveDividerLocation() {
        Preferences preferences = Preferences.instance();
        preferences.setInt(PREF, DIV_LOC, this.mainSplitPane.getDividerLocation());
    }

    private void resetDividerLocation() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, DIV_LOC, 150);
        this.mainSplitPane.setDividerLocation(n);
        this.mainSplitPane.setResizeWeight(1.0);
    }

    private void updateMap() {
        this.cleanup();
        List list = new ArrayList();
        if (this.isRouted) {
            list = this.getAbstractCktDlg().getCircuit().getCircuitSpans();
        }
        this.mapExistingSpans(list);
        this.refreshLabels();
    }

    private void mapExistingSpans(List list) {
        int n = list.size();
        if (this.db.isFinestEnabled()) {
            this.db.println("Map " + n + " existing spans.");
        }
        this.spansModel.clearAll();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                INetLink iNetLink = null;
                NetCircuitSpan netCircuitSpan = null;
                NetLinkSpan netLinkSpan = null;
                netCircuitSpan = (NetCircuitSpan)list.get(i);
                netLinkSpan = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
                if (this.db.isFinestEnabled()) {
                    this.db.println("Iteration #" + i);
                    this.db.println("\tgot NetLinkSpan from ckt: " + netLinkSpan);
                }
                iNetLink = this.getNetLink(netLinkSpan);
                MapLink mapLink = this.netToMapLink(iNetLink);
                if (this.db.isFinestEnabled()) {
                    this.db.println("\tnetLink is " + iNetLink);
                    this.db.println("\tassociated mapLink is " + mapLink);
                }
                if (mapLink == null) {
                    if (!this.db.on()) continue;
                    this.db.println("\tNo MapLink found for " + iNetLink);
                    continue;
                }
                mapLink.setBothArrows();
                this.circuitMap.setNetMapLinkState("mapExistingSpans()", mapLink, 3);
                String string = netLinkSpan == null ? this.getSpanDesc(mapLink, iNetLink) : this.getSpanDesc(mapLink, netLinkSpan);
                this.spansModel.add(iNetLink, string);
            }
        } else {
            this.circuitMap.setSelected(this.getMapNode(this.srcNE), true);
        }
    }

    public void validatePage() throws Exception {
        if (this.nodesModelOrg.anyChange() && !CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_BACK_NEXT), (String)this.getName())) {
            this.isOkToPostValidate = false;
            return;
        }
        this.storeStatusText();
    }

    public void revalidateData() {
        this.isRouted = true;
        this.enableWidgets();
    }

    public boolean handleBack() {
        if (this.nodesModelOrg.getSize() > 0 && !CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_BACK_NEXT), (String)this.getName())) {
            return false;
        }
        try {
            this.getAbstractCktDlg().deleteDestination();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("Delete destination failed: " + exception.getMessage());
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
        }
        this.nodesModelOrg.clearAll();
        this.resetConstraints();
        this.saveDividerLocation();
        return super.handleBack();
    }

    public String handleNext() {
        this.saveDividerLocation();
        return super.handleNext();
    }

    private void routeCircuit() throws Exception {
        if (this.db.on()) {
            this.db.println("routeCircuit() called");
        }
        this.addConstraints(this.getRoutePrefs());
        if (this.getAbstractCktDlg() instanceof CircuitDropCreationDialog) {
            this.getAbstractCktDlg().addDestination(true);
        } else {
            CircuitCreationDialog circuitCreationDialog = (CircuitCreationDialog)this.getAbstractCktDlg();
            circuitCreationDialog.deleteDestination();
            circuitCreationDialog.addDestinationToSvlan();
        }
        if (this.db.on()) {
            this.db.println("routeCircuit() worked");
        }
    }

    private boolean isReadOnly() {
        return this.isForProtectSvlan();
    }

    private boolean isForProtectSvlan() {
        return this.getAbstractCktDlg().getCircuitInfo().isProtected();
    }

    private void doRouteCircuit() {
        this.isRouted = false;
        try {
            this.routeCircuit();
            this.nodesModelOrg.saveLists();
            this.isRouted = true;
        }
        catch (ObjDuplicate objDuplicate) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)objDuplicate);
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_CONSTRAINTS_FAILURE);
        }
        catch (Exception exception) {
            Exception exception2;
            Object object;
            if (this.db.on()) {
                this.db.println("Routing failure: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            if (exception instanceof AnnotatedException) {
                object = (AnnotatedException)((Object)exception);
                exception2 = object.getChild();
            }
            if (exception2 instanceof NoRoute) {
                object = (NoRoute)((Object)exception2);
                DetailedLog detailedLog = ((NoRoute)((Object)object)).getDetailedLog();
                if (detailedLog == null) {
                    ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
                } else {
                    this.getAbstractCktDlg().cerentDialogDisplayError(detailedLog);
                }
            }
            ErrorMsg.displayError((Component)this, (EID)this.getNoRouteEmcErrorId());
        }
        this.updateMap();
        if (this.isRouted) {
            CerentDialog.infoDialog((Component)this, (String)"Routing evaluation succeeded.", (String)this.getName());
        }
    }

    private void enableWidgets() {
        boolean bl = this.isReadOnly();
        boolean bl2 = this.selectedMapNode != null;
        this.includeButton.setEnabled(!bl && bl2);
        this.excludeButton.setEnabled(!bl && bl2);
        this.nodesModelOrg.syncButtons();
        boolean bl3 = this.nodesModelOrg.anyChange();
        this.applyButton.setEnabled(!bl && (!this.isRouted || bl3));
        this.resetButton.setEnabled(!bl && this.nodesModelOrg.getSize() > 0);
        this.getAbstractCktDlg().setNextEnabled(false);
        this.getAbstractCktDlg().setFinishEnabled(this.isRouted);
    }

    private boolean commonChecks(INetElement iNetElement) {
        if (iNetElement.getNodeId() == this.srcNE.getNodeId()) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_SOURCE_NODE);
            return false;
        }
        if (iNetElement.getNodeId() == this.dstNE.getNodeId()) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_DROP_NODE);
            return false;
        }
        if (this.nodesModelOrg.contains(iNetElement)) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_OCH_CIRCUITS_ROUTING_ALREADY_IN);
            return false;
        }
        return true;
    }

    private void includeNode() {
        INetElement iNetElement = this.getNetElement(this.selectedMapNode);
        if (this.commonChecks(iNetElement)) {
            this.nodesModelOrg.addIncluded(iNetElement);
            this.setNodeLabel(iNetElement);
        }
    }

    private void excludeNode() {
        INetElement iNetElement = this.getNetElement(this.selectedMapNode);
        if (this.commonChecks(iNetElement)) {
            this.nodesModelOrg.addExcluded(iNetElement);
            this.setNodeLabel(iNetElement);
        }
    }

    private void addConstraints(RoutePrefs routePrefs) throws ObjDuplicate {
        routePrefs.setReqEntityList(new LinkedList());
        routePrefs.setExcEntityList(new LinkedList());
        routePrefs.setExcludeSrgs(new LinkedHashSet());
        INetElement[] iNetElementArray = this.nodesModelOrg.getIncludedNodes();
        INetElement[] iNetElementArray2 = this.nodesModelOrg.getExcludedNodes();
        if (iNetElementArray.length == 0 && iNetElementArray2.length == 0) {
            return;
        }
        List<INetElement> list = Arrays.asList(iNetElementArray);
        routePrefs.setReqEntityList(list);
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>(Arrays.asList(iNetElementArray2));
        routePrefs.setExcEntityList(linkedList);
    }

    private void resetConstraints() {
        block5: {
            RoutePrefs routePrefs;
            block4: {
                routePrefs = this.getRoutePrefs();
                try {
                    routePrefs.setReqEntityList(new LinkedList());
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.db.on()) break block4;
                    this.db.println("Failed call to setReqEntityList: " + objDuplicate.getMessage());
                }
            }
            try {
                routePrefs.setExcEntityList(new LinkedList());
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.db.on()) break block5;
                this.db.println("Failed call to setExcEntityList: " + objDuplicate.getMessage());
            }
        }
    }

    private void doApply() {
        boolean bl = true;
        if (this.nodesModelOrg.getSize() > 5) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_CONSTRAINTS_NUM_PARAM_1, (Object)new Integer(5)), (String)this.getName());
        }
        if (bl) {
            this.doRouteCircuit();
        }
    }

    private void doReset() {
        if (CerentDialog.yesNoDialog((Component)this, (String)ErrorMsg.getString((EID)NEMC.WID_OCH_CIRCUITS_ROUTING_RESET), (String)this.getName())) {
            this.nodesModelOrg.clearAll();
            this.doRouteCircuit();
        }
    }

    private class OrderedListModelOrganizer
    implements OrderedListListener,
    ActionListener {
        private OrderedListModel includedModel;
        private OrderedListModel excludedModel;
        private INetElement[] savedIncludedNes;
        private INetElement[] savedExcludedNes;
        private OrderedListListener listener;

        public OrderedListModelOrganizer(OrderedListListener orderedListListener) {
            this.listener = orderedListListener;
            this.includedModel = new OrderedListModel(this, true);
            this.excludedModel = new OrderedListModel(this, true);
            this.savedIncludedNes = new INetElement[0];
            this.savedExcludedNes = new INetElement[0];
            this.initButton("Up");
            this.initButton("Down");
            this.initButton("Remove");
        }

        void saveLists() {
            this.savedIncludedNes = this.getIncludedNodes();
            this.savedExcludedNes = this.getExcludedNodes();
        }

        void restoreLists() {
            int n;
            this.includedModel.clearAll();
            for (n = 0; n < this.savedIncludedNes.length; ++n) {
                this.addIncluded(this.savedIncludedNes[n]);
            }
            this.excludedModel.clearAll();
            for (n = 0; n < this.savedExcludedNes.length; ++n) {
                this.addExcluded(this.savedExcludedNes[n]);
            }
        }

        boolean anyChange() {
            int n;
            INetElement[] iNetElementArray = this.getIncludedNodes();
            INetElement[] iNetElementArray2 = this.getExcludedNodes();
            if (iNetElementArray.length != this.savedIncludedNes.length) {
                return true;
            }
            if (iNetElementArray2.length != this.savedExcludedNes.length) {
                return true;
            }
            for (n = 0; n < iNetElementArray.length; ++n) {
                if (iNetElementArray[n].getNodeId() == this.savedIncludedNes[n].getNodeId()) continue;
                return true;
            }
            for (n = 0; n < iNetElementArray2.length; ++n) {
                boolean bl = false;
                for (int i = 0; i < this.savedExcludedNes.length; ++i) {
                    if (iNetElementArray2[n].getNodeId() != this.savedExcludedNes[i].getNodeId()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return true;
            }
            return false;
        }

        private void initButton(String string) {
            AbstractButton abstractButton = this.getButton(string);
            if (abstractButton != null) {
                ActionListener[] actionListenerArray = abstractButton.getActionListeners();
                for (int i = 0; i < actionListenerArray.length; ++i) {
                    abstractButton.removeActionListener(actionListenerArray[i]);
                }
                abstractButton.addActionListener(this);
            }
        }

        public int getSelectedIndex() {
            return this.getIncludedList().getSelectedIndex() == -1 ? this.getExcludedList().getSelectedIndex() : this.getIncludedList().getSelectedIndex();
        }

        public void syncButtons() {
            INetElement iNetElement = this.getSelectedIncluded();
            int n = this.getSelectedIndex();
            this.getButton("Remove").setEnabled(n >= 0);
            this.getButton("Up").setEnabled(n > 0);
            this.getButton("Down").setEnabled(n >= 0 && n < this.getSizeOfSelectedList() - 1);
        }

        JList getIncludedList() {
            return this.includedModel.getJList();
        }

        JList getExcludedList() {
            return this.excludedModel.getJList();
        }

        void addIncluded(INetElement iNetElement) {
            this.includedModel.add(iNetElement, iNetElement.getName());
        }

        INetElement getSelectedIncluded() {
            return (INetElement)this.includedModel.getSelectedEntry();
        }

        INetElement[] getIncludedNodes() {
            return this.includedModel.getContent().toArray(new INetElement[0]);
        }

        void addExcluded(INetElement iNetElement) {
            this.excludedModel.add(iNetElement, iNetElement.getName());
        }

        INetElement[] getExcludedNodes() {
            return this.excludedModel.getContent().toArray(new INetElement[0]);
        }

        void clearAll() {
            this.includedModel.clearAll();
            this.excludedModel.clearAll();
            this.saveLists();
        }

        String getRankString(INetElement iNetElement) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.includedModel.contains(iNetElement)) {
                int n = this.includedModel.getContent().indexOf(iNetElement) + 1;
                stringBuilder.append("(").append(n).append(")");
            } else if (this.excludedModel.contains(iNetElement)) {
                stringBuilder.append(CcdSvlanRoutePane.EXCLUDE_LABEL);
            }
            return stringBuilder.toString();
        }

        public boolean contains(Object object) {
            return this.includedModel.contains(object) || this.excludedModel.contains(object);
        }

        public int getSize() {
            return this.includedModel.getSize() + this.excludedModel.getSize();
        }

        private int getSizeOfSelectedList() {
            if (this.includedModel.getSelectedEntry() != null) {
                return this.includedModel.getSize();
            }
            if (this.excludedModel.getSelectedEntry() != null) {
                return this.excludedModel.getSize();
            }
            return 0;
        }

        public AbstractButton getButton(String string) {
            return this.includedModel.getButton(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.applyAction(this.includedModel, actionEvent);
            this.applyAction(this.excludedModel, actionEvent);
        }

        public void applyAction(OrderedListModel orderedListModel, ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = orderedListModel.getJList().getSelectedIndex();
            if (n < 0) {
                return;
            }
            if (string == "Up") {
                orderedListModel.swapEntries(n - 1);
            } else if (string == "Down") {
                orderedListModel.swapEntries(n);
            } else if (string == "Remove") {
                orderedListModel.remove(orderedListModel.getSelectedEntry());
            }
            this.syncButtons();
        }

        public void selectionChanged(Object object, Object object2) {
            if (object2 != null && this.includedModel.getSelectedEntry() != null && this.excludedModel.getSelectedEntry() != null) {
                if (this.includedModel.contains(object2)) {
                    this.excludedModel.getJList().clearSelection();
                } else {
                    this.includedModel.getJList().clearSelection();
                }
            }
            this.syncButtons();
            this.listener.selectionChanged(object, object2);
        }

        public void orderSwapped(Object object, Object object2) {
            this.listener.orderSwapped(object, object2);
        }

        public void entryRemoved(Object object) {
            this.listener.entryRemoved(object);
        }
    }
}

