/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.RevertiveBehaviorCellEditor;
import cerent.cms.ui.RevertiveBehaviorRenderer;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.circuits.CedUpsrTableModel;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitEditTabbedView;
import cerent.cms.ui.circuits.PathDefRenderer;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CedUpsrPane
extends AbstractProvTablePane
implements PropertyChangeListener {
    private static final SDebug db = new SDebug("CedUpsrPane");
    protected static DefaultComboBoxModel[] upsrCombos;
    protected static DefaultComboBoxModel allOpsCombo;
    protected static int CLR_INDEX;
    protected static int LOP_INDEX;
    protected static int FTW_INDEX;
    protected static int FTP_INDEX;
    protected static int MTW_INDEX;
    protected static int MTP_INDEX;
    protected static Attribute[] allUpsrAttributes;
    protected static int UNKNOWN_OPERATION;

    protected static DefaultComboBoxModel getCBModel(int n) {
        int[] nArray = CedUpsrPane.getAllowedUpsrOps(n);
        Attribute[] attributeArray = new Attribute[nArray.length];
        block8: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 0: {
                    attributeArray[i] = allUpsrAttributes[CLR_INDEX];
                    continue block8;
                }
                case 1: {
                    attributeArray[i] = allUpsrAttributes[LOP_INDEX];
                    continue block8;
                }
                case 3: {
                    attributeArray[i] = allUpsrAttributes[FTW_INDEX];
                    continue block8;
                }
                case 4: {
                    attributeArray[i] = allUpsrAttributes[FTP_INDEX];
                    continue block8;
                }
                case 5: {
                    attributeArray[i] = allUpsrAttributes[MTW_INDEX];
                    continue block8;
                }
                case 6: {
                    attributeArray[i] = allUpsrAttributes[MTP_INDEX];
                    continue block8;
                }
            }
        }
        return new DefaultComboBoxModel<Attribute>(attributeArray);
    }

    public static int[] getAllowedUpsrOps(int n) {
        int[] nArray = null;
        switch (n) {
            case 8: {
                nArray = new int[]{0, 1, 3, 4, 5, 6};
                break;
            }
            case 0: {
                nArray = new int[]{1, 3, 4, 5, 6};
                break;
            }
            case 1: {
                nArray = new int[]{0};
                break;
            }
            case 3: {
                nArray = new int[]{0, 1};
                break;
            }
            case 4: {
                nArray = new int[]{0, 1};
                break;
            }
            case 5: {
                nArray = new int[]{0, 1, 3, 4};
                break;
            }
            case 6: {
                nArray = new int[]{0, 1, 3, 4};
                break;
            }
            default: {
                if (db.on()) {
                    db.println("getAllowedUpsrOps() with invalid op " + n);
                }
                nArray = new int[]{0, 1, 3, 4, 5, 6};
            }
        }
        return nArray;
    }

    public CedUpsrPane(String string, CircuitEditTabbedView circuitEditTabbedView) {
        super(string, circuitEditTabbedView, new CedUpsrTableModel((NetCircuitModel)circuitEditTabbedView.getUiModel(), (Component)((Object)circuitEditTabbedView)), true);
        TableColumn tableColumn;
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        CircuitColumnRenderer.loadColors();
        boolean bl = this.isUserAuthorized(SecurityLevel.MAINTENANCE);
        this.dataModel.setEnabled(bl);
        if (bl) {
            this.addButtonPanel();
        }
        CedUpsrTableModel cedUpsrTableModel = (CedUpsrTableModel)this.dataModel;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.setColumnCellEditor(3, new RevertiveBehaviorCellEditor());
        this.setColumnCellEditor(7, new UpsrOpEditor());
        this.setColumnAttributes(0, 60, true, null);
        this.setColumnAttributes(1, 90, true, new PathDefRenderer());
        this.setColumnAttributes(2, 90, true, new PathDefRenderer());
        this.setColumnAttributes(3, 60, true, new RevertiveBehaviorRenderer());
        this.setColumnAttributes(7, 150, true, null);
        INetCircuit iNetCircuit = ((NetCircuitModel)circuitEditTabbedView.getUiModel()).getNetCircuit();
        if (iNetCircuit.getCircuitTypeObj().isLoCircuitType() || this.getUiModel().getNodeModel().getTdmProtocolTypeObj().isSdh()) {
            tableColumn = tableColumnModel.getColumn(6);
            tableColumnModel.removeColumn(tableColumn);
        } else {
            this.setColumnAttributes(6, 50, true, null);
        }
        if (iNetCircuit.upsrBerThresholdsSettable()) {
            this.setColumnCellEditor(4, "declareSfBerLevel");
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType()) {
                this.setColumnCellEditor(5, "declareVTSdBerLevel");
            } else {
                this.setColumnCellEditor(5, "declareSdBerLevel");
            }
            this.setColumnAttributes(4, 50, true, null);
            this.setColumnAttributes(5, 50, true, null);
        } else {
            tableColumn = tableColumnModel.getColumn(4);
            TableColumn tableColumn2 = tableColumnModel.getColumn(5);
            tableColumnModel.removeColumn(tableColumn);
            tableColumnModel.removeColumn(tableColumn2);
        }
        this.table.sizeColumnsToFit(-1);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected Attribute[] getAttributes(String string) {
        return NetworkDefaults.getAttributeMap().getAttributeArray(string);
    }

    public void destroy() {
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CircuitColumnRenderer.loadColors();
        this.table.repaint();
    }

    static /* synthetic */ AbstractProvTableModel access$000(CedUpsrPane cedUpsrPane) {
        return cedUpsrPane.dataModel;
    }

    static /* synthetic */ SDebug access$100() {
        return db;
    }

    static {
        allUpsrAttributes = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOpApsClear");
        UNKNOWN_OPERATION = -1;
        upsrCombos = new DefaultComboBoxModel[allUpsrAttributes.length];
        try {
            int n;
            MTP_INDEX = -1;
            MTW_INDEX = -1;
            FTP_INDEX = -1;
            FTW_INDEX = -1;
            LOP_INDEX = -1;
            CLR_INDEX = -1;
            block10: for (int i = 0; i < allUpsrAttributes.length; ++i) {
                Attribute attribute = allUpsrAttributes[i];
                n = attribute.getIntValue();
                switch (n) {
                    case 0: {
                        CLR_INDEX = i;
                        continue block10;
                    }
                    case 1: {
                        LOP_INDEX = i;
                        continue block10;
                    }
                    case 3: {
                        FTW_INDEX = i;
                        continue block10;
                    }
                    case 4: {
                        FTP_INDEX = i;
                        continue block10;
                    }
                    case 5: {
                        MTW_INDEX = i;
                        continue block10;
                    }
                    case 6: {
                        MTP_INDEX = i;
                        continue block10;
                    }
                }
            }
            if (db.on()) {
                db.println("Index Vals:" + CLR_INDEX + "\t" + LOP_INDEX + "\t" + FTW_INDEX + "\t" + FTP_INDEX + "\t" + MTW_INDEX + "\t" + MTP_INDEX);
            }
            if (CLR_INDEX == -1 || LOP_INDEX == -1 || FTW_INDEX == -1 || FTP_INDEX == -1 || MTW_INDEX == -1 || MTP_INDEX == -1) {
                throw new Exception("1+ protection ops are not mapped in Attributes");
            }
            Object var0_1 = null;
            for (int i = 0; i < allUpsrAttributes.length; ++i) {
                n = allUpsrAttributes[i].getIntValue();
                CedUpsrPane.upsrCombos[i] = CedUpsrPane.getCBModel(n);
            }
            allOpsCombo = CedUpsrPane.getCBModel(UNKNOWN_OPERATION);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            for (int i = 0; i < upsrCombos.length; ++i) {
                CedUpsrPane.upsrCombos[i] = new DefaultComboBoxModel<Attribute>(allUpsrAttributes);
            }
        }
    }

    protected class UpsrOpEditor
    extends DefaultCellEditor {
        Attribute[] allUpsrAttributes;

        public UpsrOpEditor() {
            super(new JComboBox());
            this.allUpsrAttributes = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOpApsClear");
        }

        /*
         * Unable to fully structure code
         */
        public Component getTableCellEditorComponent(JTable var1_1, Object var2_2, boolean var3_3, int var4_4, int var5_5) {
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = (CedUpsrTableModel)CedUpsrPane.access$000(CedUpsrPane.this);
            if (var8_8 != null) {
                try {
                    var7_7 = var8_8.getLastReadSwitchState(var4_4);
                    for (var9_9 = 0; var9_9 < this.allUpsrAttributes.length; ++var9_9) {
                        var10_12 = this.allUpsrAttributes[var9_9].getIntValue();
                        if (var7_7 != var10_12) continue;
                        var6_6 = var9_9;
                    }
                }
                catch (Exception var9_10) {
                    if (!CedUpsrPane.access$100().on()) ** GOTO lbl22
                    CedUpsrPane.access$100().warning("Following exception occurred trying to refresh Protection Op.  Will use default option instead (all ops allowed)");
                    CedUpsrPane.access$100();
                    SDebug.printStackTrace((Throwable)var9_10);
                }
            } else if (CedUpsrPane.access$100().on()) {
                CedUpsrPane.access$100().println("The CedUpsrTableModel was null");
            }
lbl22:
            // 7 sources

            if (var6_6 > -1) {
                var9_11 = CedUpsrPane.upsrCombos[var6_6];
                ((JComboBox)this.getComponent()).setModel(var9_11);
            } else {
                if (CedUpsrPane.access$100().on()) {
                    CedUpsrPane.access$100().println("attribute index= -1, op=" + var7_7);
                }
                ((JComboBox)this.getComponent()).setModel(CedUpsrPane.allOpsCombo);
            }
            return super.getTableCellEditorComponent(var1_1, var2_2, var3_3, var4_4, var5_5);
        }
    }
}

