/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.util.Preferences;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;

public class CircuitsTableModel
extends SortableRowTableModel
implements ItemListener {
    private static final String SPAN_DET = "Span Details";
    private static final String SPAN_TITLE = "# of Spans";
    private static final String DET_SPAN_TITLE = "Spans";
    private static final int SPAN_WIDTH = 80;
    private static final int DET_SPAN_WIDTH = 400;
    static final String PREF_PATH = "ctc.circuits";
    static final String PREF_SPAN_DET = "span_det";
    private Preferences prefs = Preferences.instance();
    private boolean spanDetailsSelected = false;
    private JCheckBoxMenuItem spanDetailsCB = new JCheckBoxMenuItem("Span Details");
    private JPanel spanDetPanel = new JPanel();

    public CircuitsTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
        super(rowDataSource, columnRendererArray, clazz);
        this.setSpanDetails();
    }

    public CircuitsTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz, int[] nArray, boolean[] blArray) {
        super(rowDataSource, columnRendererArray, clazz, nArray, blArray);
        this.setSpanDetails();
    }

    private void setSpanDetails() {
        this.spanDetailsSelected = this.prefs.getBoolean(PREF_PATH, PREF_SPAN_DET, false);
        this.minColumsWidthsMap.put(DET_SPAN_TITLE, new Integer(400));
        if (this.spanDetailsSelected) {
            this.setSpanDetails(this.spanDetailsSelected);
            this.fireTableDataChanged();
        }
    }

    protected void showPopup(MouseEvent mouseEvent) {
        int n = this.colModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.popup.getComponentIndex(this.spanDetailsCB);
        if (n2 != -1) {
            if (this.table.getColumnName(n) != SPAN_TITLE && this.table.getColumnName(n) != DET_SPAN_TITLE) {
                this.popup.remove(n2);
            }
        } else if (this.table.getColumnName(n) == SPAN_TITLE || this.table.getColumnName(n) == DET_SPAN_TITLE) {
            this.popup.insert(this.spanDetailsCB, 0);
            boolean bl = this.prefs.getBoolean(PREF_PATH, PREF_SPAN_DET, true);
            if (this.table.getColumnName(n) == DET_SPAN_TITLE) {
                this.spanDetailsCB.setSelected(true);
            } else {
                this.spanDetailsCB.setSelected(false);
            }
            this.spanDetailsCB.addItemListener(this);
        }
        super.showPopup(mouseEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.spanDetailsCB) {
            if (itemEvent.getStateChange() == 2) {
                this.setNewSpanColumn(DET_SPAN_TITLE, SPAN_TITLE, 80);
                this.setSpanDetails(false);
                this.prefs.setBoolean(PREF_PATH, PREF_SPAN_DET, false);
                this.spanDetailsSelected = false;
            } else {
                this.setNewSpanColumn(SPAN_TITLE, DET_SPAN_TITLE, 400);
                this.setSpanDetails(true);
                this.prefs.setBoolean(PREF_PATH, PREF_SPAN_DET, true);
                this.spanDetailsSelected = true;
            }
            this.fireTableDataChanged();
        }
    }

    private void setNewSpanColumn(String string, String string2, int n) {
        int n2 = this.colModel.getColumnIndex(string);
        TableColumn tableColumn = this.colModel.getColumn(n2);
        TableColumn tableColumn2 = new TableColumn(tableColumn.getModelIndex(), n, tableColumn.getCellRenderer(), tableColumn.getCellEditor());
        tableColumn2.setHeaderValue(string2);
        SortableRowTableModel.TableHdrRenderer tableHdrRenderer = new SortableRowTableModel.TableHdrRenderer(this);
        tableHdrRenderer.setHorizontalTextPosition(2);
        tableHdrRenderer.setBorder((Border)UIManager.get("TableHeader.cellBorder"));
        tableHdrRenderer.setHorizontalAlignment(0);
        tableHdrRenderer.setOpaque(true);
        tableHdrRenderer.setBackground((Color)UIManager.get("TableHeader.background"));
        tableColumn2.setHeaderRenderer(tableHdrRenderer);
        tableColumn2.setMinWidth((Integer)this.minColumsWidthsMap.get(string2));
        this.colModel.removeColumn(tableColumn);
        this.colModel.addColumn(tableColumn2);
        int n3 = this.colModel.getColumnIndex(string2);
        this.colModel.moveColumn(n3, n2);
    }

    public boolean spanDetailsOn() {
        return this.spanDetailsSelected;
    }

    public void setSpanDetails(boolean bl) {
        for (int i = 0; i < this.colRenderers.length; ++i) {
            ((CircuitColumnRenderer)this.colRenderers[i]).setSpanDetailsOn(bl);
        }
    }
}

