/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdReviewEditPane;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

public class DropReviewEditPane
extends CcdReviewEditPane {
    public DropReviewEditPane(CircuitDropCreationDialog circuitDropCreationDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(circuitDropCreationDialog, wzDiagDebug, string, bl);
    }

    protected boolean isPossibleBlsrDri() {
        return false;
    }

    public void localCleanup() {
        if (this.db.on()) {
            this.db.println("localCleanup");
        }
        for (INetCircuitSpan iNetCircuitSpan : this.getAbstractCktDlg().getCircuit().getRoutedCircuitSpans()) {
            this.getAbstractCktDlg().getCircuit().deleteCircuitSpan(iNetCircuitSpan.getNetLinkSpan());
        }
        if (this.olm != null) {
            this.olm.clearAll();
            this.olm.syncButtons();
        }
        if (this.hoLoPane != null) {
            this.hoLoPane.disablePane();
        }
        if (this.activeCktSpans != null) {
            this.activeCktSpans.clear();
        }
        this.unSetNode();
        this.unSetLink();
    }

    protected void mapExistingSpans(List list) {
        super.mapExistingSpans(list);
        INetCircuit iNetCircuit = this.getAbstractCktDlg().getCircuit().useLAP();
        if (iNetCircuit != null) {
            INetCircuitSpan iNetCircuitSpan = NetCircuitManager.instance().getLAPSpan(this.getAbstractCktDlg().getCircuit());
            NetLinkSpan netLinkSpan = (NetLinkSpan)iNetCircuitSpan.getNetLinkSpan();
            boolean bl = netLinkSpan.isSecondaryCircuit();
            INetLink iNetLink = iNetCircuitSpan.getLink();
            MapLink mapLink = this.netToMapLink(netLinkSpan);
            if (this.db.on()) {
                this.db.println("\tnetLink is " + iNetLink);
                this.db.println("\tassociated mapLink is " + mapLink);
            }
            if (mapLink != null) {
                return;
            }
            this.circuitMap.addLink(iNetLink, null);
            mapLink = this.netToMapLink(netLinkSpan);
            mapLink.setTargetArrow();
            AbstractNetLink abstractNetLink = (AbstractNetLink)mapLink.getUserObject();
            if (abstractNetLink != iNetLink) {
                mapLink.reverseArrow();
            }
            this.circuitMap.setNetMapLinkState("mapExistingSpans()", mapLink, 3);
            if (!this.olm.getContent().contains(netLinkSpan)) {
                String string = bl ? " (Part of secondary path)" : "";
                this.olm.add(netLinkSpan, this.circuitMap.getLinkDesc(mapLink) + string);
            }
            this.addCircuitSpan(netLinkSpan);
            this.removeButton.setEnabled(false);
        }
    }

    protected boolean isNodeSelectable(MapNode mapNode) {
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        if (iNodeModel == this.srcNodeModel) {
            return true;
        }
        if (this.olm.getContent() != null) {
            INetLinkSpan iNetLinkSpan = null;
            for (int i = 0; i < this.olm.getContent().size(); ++i) {
                ILinkModel iLinkModel;
                if (!(this.olm.getContent().get(i) instanceof INetLinkSpan) || (iLinkModel = (iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i)).getLink().getLinkModel()).src() != iNodeModel && iLinkModel.dst() != iNodeModel) continue;
                return true;
            }
        }
        return false;
    }

    public void validatePage() throws Exception {
        if (this.olm != null && this.olm.getContent() != null && this.getAbstractCktDlg().getCircuit() != null) {
            for (int i = 0; i < this.olm.getContent().size(); ++i) {
                if (!(this.olm.getContent().get(i) instanceof INetLinkSpan)) continue;
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)this.olm.getContent().get(i);
                LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
                Object object = this.getAbstractCktDlg().getCircuit().getCircuitSpans().iterator();
                while (object.hasNext()) {
                    linkedList.add(((INetCircuitSpan)object.next()).getNetLinkSpan());
                }
                if (linkedList.contains(iNetLinkSpan) || (object = this.getAbstractCktDlg().getCircuit().useLAP()) != null && object.getCircuitSpanFromNetLink(iNetLinkSpan.getLink()) != null) continue;
                this.addCircuitSpan(iNetLinkSpan);
                if (!this.db.on()) continue;
                this.db.info("\nvalidatePage:  added span from olm " + iNetLinkSpan);
            }
        }
        this.performSanityChecks();
    }

    public boolean handleBack() {
        boolean bl = true;
        if (this.olm.getSize() > 0 || this.blsrDriListModel.size() > 0) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)"Route data will be lost.  Are you sure you want to go BACK?", (String)this.getName());
        }
        if (bl) {
            block9: {
                this.recycle();
                try {
                    if (this.db.on) {
                        this.db.println("revEditPane handleBack: calling deleteDestination() ->");
                    }
                    if (!this.getAbstractCktDlg().isUrn()) {
                        ((CircuitDropCreationDialog)this.parent).deleteDestination();
                    }
                    if (this.db.on) {
                        this.db.println("revEditPane handleBack: deleteDestination() successful\n");
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (this.db.on) {
                        this.db.println("revEditPane handleBack: no such drop to delete");
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block9;
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
            return super.handleBack();
        }
        this.getAbstractCktDlg().setFinishEnabled(true);
        return false;
    }
}

