/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.circuits.AbstractFVCircuitSelectBehavior;
import cerent.cms.ui.circuits.CircuitsPane;
import cerent.cms.ui.circuits.FVCircuitSelectBehavior;
import cerent.cms.ui.circuits.FVNetCircuitSelectBehavior;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.IFunctionalView;
import com.cisco.fv.circuit.FVNetworkCircuitPanel;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public class FVCircuitsPane
extends CircuitsPane
implements IObserver {
    private AbstractFVCircuitSelectBehavior selected;
    private CircuitSelectionListener csl = new CircuitSelectionListener();
    private boolean addListener = false;
    private INetCircuit selectedCircuit;
    private static final SDebug db = new SDebug("FunctionalViewCircuitsPane");

    public FVCircuitsPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.selected = tabbedView instanceof FVNetworkCircuitPanel ? new FVNetCircuitSelectBehavior(this, db) : new FVCircuitSelectBehavior(this, db);
    }

    public void enteringPage() {
        if (!this.isInited()) {
            super.enteringPage();
            this.getEditPB().setVisible(false);
            this.getDeletePB().setVisible(false);
            this.getCreatePB().setVisible(false);
            this.getScopeLabel().setVisible(false);
            this.getScopeCB().setVisible(false);
            if (!this.addListener) {
                this.table.getSelectionModel().addListSelectionListener(this.csl);
                this.addListener = true;
            }
        }
        if (this.selected != null && !this.selected.hasSelectedCircuits()) {
            super.enteringPage();
        }
    }

    public void update(IObservable iObservable, Object object) {
        if (object == ModelUpdateType.DELETED && iObservable instanceof INetCircuit) {
            ((IFunctionalView)this.parentTV).deleteDwdmPath(((INetCircuit)iObservable).getCircuitId().getUniquePart().getUniqueId());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.csl.isSelect()) {
            int n = this.csl.getIdx();
            this.table.setRowSelectionInterval(n, n);
        } else {
            FvNetworkCircuitPath.circuitDbgtime = System.currentTimeMillis();
            ((IFunctionalView)this.parentTV).deleteAllDwdmPath();
            if (this.selected != null) {
                this.selected.clearAllSelectedCircuit();
                this.setSourceEnable(true);
            }
        }
    }

    private void showSelectedCircuit(int n) {
        this.selectedCircuit = this.selected.showSelectedCircuit(n);
        if (this.selectedCircuit == null) {
            return;
        }
        this.setSourceEnable(false);
        if (!this.selectedCircuit.isObserver(this)) {
            this.selectedCircuit.addObserver(this);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    public void dispose() {
        if (this.selectedCircuit == null) {
            return;
        }
        if (this.selectedCircuit.isObserver(this)) {
            this.selectedCircuit.deleteObserver(this);
        }
    }

    public void setEnabled(boolean bl) {
        JButton jButton = this.getFilterPB();
        JButton jButton2 = this.getSearchPB();
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
        if (jButton2 != null) {
            jButton2.setEnabled(bl);
        }
        if (this.table != null) {
            this.table.setEnabled(bl);
        }
    }

    private class CircuitSelectionListener
    implements ListSelectionListener {
        private int idx = -1;
        private boolean isSelect = false;

        private CircuitSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                this.idx = defaultListSelectionModel.getMinSelectionIndex();
                this.isSelect = defaultListSelectionModel.isSelectedIndex(this.idx);
            } else if (listSelectionEvent.getFirstIndex() != listSelectionEvent.getLastIndex()) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                this.idx = defaultListSelectionModel.getMinSelectionIndex();
                this.isSelect = defaultListSelectionModel.isSelectedIndex(this.idx);
                if (this.idx > -1) {
                    FVCircuitsPane.this.showSelectedCircuit(this.idx);
                }
            } else if (FVCircuitsPane.this.table.getSelectedRowCount() > 0) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                this.idx = FVCircuitsPane.this.table.getSelectedRow();
                defaultListSelectionModel.setSelectionInterval(this.idx, this.idx);
                this.isSelect = defaultListSelectionModel.isSelectedIndex(this.idx);
                FVCircuitsPane.this.showSelectedCircuit(this.idx);
            }
        }

        public int getIdx() {
            return this.idx;
        }

        public boolean isSelect() {
            return this.isSelect;
        }
    }
}

