/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.PathStateInfo;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.HoLoSlice;
import cerent.cms.ui.circuits.HoSlicePane;
import cerent.cms.ui.circuits.LoSlicePane;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu4HoNum;
import cerent.util.SonetHoNum;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class HoLoSliceDialog
extends UDialog
implements ActionListener {
    public static final int MODE_STS_12 = 12;
    public static final int MODE_STS_48 = 48;
    public static final int MODE_STS_192 = 192;
    public static final int MODE_STM_4 = 4;
    public static final int MODE_STM_16 = 16;
    public static final int MODE_STM_64 = 64;
    private static final String STATUS_REQ = "Members required: ";
    private static final String STATUS_SEL = "    Members selected: ";
    private static final String IMG_PATH_CHECK = "/images/check_blue.gif";
    private ImageIcon IMG_CHECK = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"), "true");
    private LinkedHashMap sliceMap = new LinkedHashMap();
    private TreeMap holoMap = new TreeMap();
    private HoSlicePane hoPane = null;
    private LoSlicePane loPane = null;
    private JLabel statusMsg = null;
    private JButton okBtn = null;
    private JButton cancelBtn = null;
    private HoLoSlice selectedHoSlice = null;
    private int memberReq = 0;
    private int memberSel = 0;
    private int mode = -1;
    private CircuitCreatInfo cktInfo = null;
    private IHoLoNum[] holoNums = null;
    private boolean isSonet = true;
    private static final SDebug db = new SDebug("HoLoSliceDialog");

    public HoLoSliceDialog(AbstractCircuitDialog abstractCircuitDialog, IModuleModel iModuleModel, CircuitCreatInfo circuitCreatInfo, IPathStateInfo[] iPathStateInfoArray) {
        super((Frame)abstractCircuitDialog, "Member Selection", true);
        this.cktInfo = circuitCreatInfo;
        this.memberReq = circuitCreatInfo.forwardMembers();
        this.isSonet = iModuleModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
        this.setMode(iModuleModel);
        this.init(iPathStateInfoArray);
        this.initContentPane();
    }

    protected void initContentPane(JPanel jPanel, Object object) {
    }

    protected void initContentPane() {
        this.setLayout(new BorderLayout(10, 10));
        this.add(this.createMemberPane(), "North");
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.createCommandPane(), "Center");
        jPanel.add((Component)this.createStatusPane(), "South");
        this.add(jPanel, "South");
        this.setSize(this.getDialogDimension());
        this.updateStatus(STATUS_REQ + this.memberReq + STATUS_SEL + this.memberSel);
    }

    private JPanel createMemberPane() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.hoPane = new HoSlicePane(this, this.holoMap);
        jPanel.add((Component)this.hoPane, "West");
        if (this.hasLo()) {
            this.loPane = new LoSlicePane(this, this.getLoMap(null));
            jPanel.add((Component)this.loPane, "Center");
        }
        return jPanel;
    }

    private JPanel createCommandPane() {
        JPanel jPanel = new JPanel(new BorderLayout(1, 5));
        jPanel.setPreferredSize(new Dimension(this.getPreferredSize().width, 55));
        jPanel.add((Component)new JSeparator(), "North");
        jPanel.add((Component)this.createLegendPane(), "West");
        jPanel.add((Component)this.createButtonPane(), "East");
        return jPanel;
    }

    private JPanel createLegendPane() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2, 0, 0));
        jPanel.add(this.createLegend("Available", null, 1));
        jPanel.add(this.createLegend("Used", null, 2));
        jPanel.add(this.createLegend("Selected", this.IMG_CHECK, 4));
        jPanel.add(this.createLegend("Unavailable", null, 0));
        return jPanel;
    }

    private JPanel createLegend(String string, Icon icon, int n) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        Color color = jButton.getBackground();
        jButton.setPreferredSize(new Dimension(17, 17));
        if (n == 4) {
            jButton.setIcon(icon);
        } else if (n == 2) {
            jButton.setContentAreaFilled(false);
            jButton.setOpaque(true);
            jButton.setBackground(Color.blue);
            jButton.setPreferredSize(new Dimension(15, 15));
        } else if (n == 0) {
            jButton.setContentAreaFilled(false);
            jButton.setOpaque(true);
            jButton.setBackground(color.darker().darker());
            jButton.setPreferredSize(new Dimension(15, 15));
        }
        jPanel.add(jButton);
        jPanel.add(new JLabel(string, 11));
        return jPanel;
    }

    private JPanel createButtonPane() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        this.okBtn = new JButton("OK");
        this.okBtn.setEnabled(false);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        jPanel.add(this.okBtn);
        jPanel.add(this.cancelBtn);
        return jPanel;
    }

    private JPanel createStatusPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.statusMsg = new JLabel();
        jPanel.add(this.statusMsg);
        return jPanel;
    }

    private void init(IPathStateInfo[] iPathStateInfoArray) {
        if (iPathStateInfoArray == null) {
            if (db.on()) {
                db.println("No slice available");
            }
            return;
        }
        short s = -1;
        LinkedList<IPathStateInfo> linkedList = null;
        for (IPathStateInfo iPathStateInfo : iPathStateInfoArray) {
            short s2 = iPathStateInfo.getHoNum().getHoNum();
            if (s != s2) {
                linkedList = new LinkedList<IPathStateInfo>();
                linkedList.add(iPathStateInfo);
                IPathStateInfo iPathStateInfo2 = iPathStateInfo;
                if (this.isLoCircuit(this.cktInfo.type())) {
                    iPathStateInfo2 = this.createDummyPathStateInfo(iPathStateInfo.getHoNum().getHoNum(), 1);
                }
                this.holoMap.put(iPathStateInfo2, linkedList);
                s = s2;
                continue;
            }
            linkedList.add(iPathStateInfo);
        }
        if (this.isLoCircuit(this.cktInfo.type())) {
            this.holoMap.putAll(this.populateHoSlices());
        }
        if (db.on()) {
            db.println("Total number of holoMap is " + this.holoMap.size());
        }
    }

    private Map populateHoSlices() {
        TreeMap treeMap = new TreeMap();
        for (IPathStateInfo iPathStateInfo : this.holoMap.keySet()) {
            treeMap.put(new Integer(iPathStateInfo.getHoNum().getHoNum()), this.holoMap.get(iPathStateInfo));
        }
        TreeMap treeMap2 = new TreeMap();
        int n = this.mode + 1;
        for (int i = 1; i < n; ++i) {
            Integer n2 = new Integer(i);
            if (!treeMap.containsKey(n2)) {
                LinkedList<IPathStateInfo> linkedList = new LinkedList<IPathStateInfo>();
                IPathStateInfo iPathStateInfo = this.createDummyPathStateInfo(i, 3);
                linkedList.add(iPathStateInfo);
                treeMap2.put(iPathStateInfo, linkedList);
                if (!db.on()) continue;
                db.println("No IHoLoNum for " + i + ". Creating dummy");
                continue;
            }
            if (!db.on()) continue;
            db.println("IHoLoNum for " + i + " is available");
        }
        return treeMap2;
    }

    public void setSelectedSlice(HoLoSlice hoLoSlice, boolean bl) {
        if (hoLoSlice.getType() == 1) {
            this.selectedHoSlice = hoLoSlice;
        }
        if (hoLoSlice.getType() == 1) {
            if (hoLoSlice.isFormOfSelected(hoLoSlice)) {
                if (!this.sliceMap.containsKey(hoLoSlice)) {
                    LinkedList<HoLoSlice> linkedList = new LinkedList<HoLoSlice>();
                    this.sliceMap.put(hoLoSlice, linkedList);
                    if (!this.hasLo()) {
                        linkedList.add(hoLoSlice);
                        ++this.memberSel;
                        if (db.on()) {
                            db.println("Adding HO " + hoLoSlice.getNumber() + " to map: " + this.sliceMap);
                        }
                    }
                }
            } else {
                LinkedList linkedList = this.getSelectedSliceList(hoLoSlice);
                this.memberSel -= linkedList.size();
                this.sliceMap.remove(hoLoSlice);
                if (db.on()) {
                    db.println("Removing HO " + hoLoSlice.getNumber() + " from map: " + this.sliceMap);
                }
                HoLoSlice hoLoSlice2 = null;
                Iterator iterator = this.sliceMap.keySet().iterator();
                while (iterator.hasNext() && (hoLoSlice2 = (HoLoSlice)iterator.next()) == null) {
                }
                if (hoLoSlice2 != null) {
                    this.getHoPane().setSelectedSlice(hoLoSlice2, false);
                }
            }
            if (this.hasLo() && bl) {
                this.getLoPane().refreshPane(hoLoSlice, this.getLoMap(null));
            }
        } else {
            if (this.sliceMap.isEmpty()) {
                return;
            }
            HoLoSlice hoLoSlice3 = this.hoPane.getSelectedSlice();
            LinkedList linkedList = this.getSelectedSliceList(hoLoSlice3);
            if (hoLoSlice.isFormOfSelected(hoLoSlice)) {
                linkedList.add(hoLoSlice);
                ++this.memberSel;
                if (db.on()) {
                    db.println("Adding LO " + hoLoSlice.getNumber() + " to loList: " + linkedList);
                }
            } else if (hoLoSlice.getState() == 1) {
                linkedList.remove(hoLoSlice);
                --this.memberSel;
                if (db.on()) {
                    db.println("Removing LO " + hoLoSlice.getNumber() + " from loList: " + linkedList);
                }
            }
        }
        this.memberSel = this.memberSel > 0 ? this.memberSel : 0;
        this.okBtn.setEnabled(this.memberSel == this.memberReq);
        this.updateStatus(STATUS_REQ + this.memberReq + STATUS_SEL + this.memberSel);
    }

    public HoLoSlice getSelectedHoSlice() {
        return this.selectedHoSlice;
    }

    public boolean isSonet() {
        return this.isSonet;
    }

    private void processOK() {
        ArrayList<IHoLoNum> arrayList = new ArrayList<IHoLoNum>();
        for (LinkedList linkedList : this.sliceMap.values()) {
            if (linkedList.isEmpty()) continue;
            for (HoLoSlice hoLoSlice : linkedList) {
                arrayList.add(hoLoSlice.getHoLoNum());
            }
        }
        this.holoNums = arrayList.toArray(new IHoLoNum[0]);
        if (db.on() && this.holoNums != null) {
            for (int i = 0; i < this.holoNums.length; ++i) {
                db.println("Selected IHoLoNum: " + this.holoNums[i].prettyString());
            }
        }
    }

    private Map getLoMap(HoLoSlice hoLoSlice) {
        SortedMap sortedMap = new TreeMap();
        if (hoLoSlice == null) {
            hoLoSlice = this.getHoPane().getSelectedHoSlice();
        }
        if (hoLoSlice != null) {
            short s = hoLoSlice.getHoLoNum().getHoNum().getHoNum();
            Iterator iterator = this.holoMap.keySet().iterator();
            while (iterator.hasNext()) {
                IPathStateInfo iPathStateInfo = (IPathStateInfo)iterator.next();
                if (iPathStateInfo.getHoNum().getHoNum() != s) continue;
                if (iterator.hasNext()) {
                    IPathStateInfo iPathStateInfo2 = (IPathStateInfo)iterator.next();
                    sortedMap = this.holoMap.subMap(iPathStateInfo, iPathStateInfo2);
                    break;
                }
                sortedMap = this.holoMap.tailMap(iPathStateInfo);
                break;
            }
        }
        return sortedMap;
    }

    private boolean isLoCircuit(int n) {
        boolean bl = false;
        if (n == 11 || n == 13) {
            bl = true;
        }
        return bl;
    }

    public IPathStateInfo createDummyPathStateInfo(int n, int n2) {
        Object object = null;
        object = this.isSonet() ? new SonetHoNum(n) : new SdhAu4HoNum(n);
        return new PathStateInfo((IHoNum)object, null, n2);
    }

    public IHoLoNum[] getHoLoNum() {
        return this.holoNums;
    }

    public LinkedList getSelectedSliceList(HoLoSlice hoLoSlice) {
        return (LinkedList)this.sliceMap.get(hoLoSlice);
    }

    public void updateStatus(String string) {
        if (this.memberReq == this.memberSel) {
            this.statusMsg.setForeground(Color.black);
        } else {
            this.statusMsg.setForeground(Color.red);
        }
        this.statusMsg.setText(string);
    }

    public void localDispose() {
        super.dispose();
    }

    public HoSlicePane getHoPane() {
        return this.hoPane;
    }

    public LoSlicePane getLoPane() {
        return this.loPane;
    }

    public LinkedHashMap getSelectedSliceMap() {
        return this.sliceMap;
    }

    public int getCircuitSize() {
        return this.cktInfo.size();
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.cktInfo;
    }

    public boolean hasLo() {
        boolean bl = false;
        switch (this.getCircuitSize()) {
            case 0: 
            case 10: 
            case 11: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Dimension getDialogDimension() {
        Dimension dimension = null;
        switch (this.mode) {
            case 12: {
                if (this.getCircuitSize() == 1) {
                    dimension = new Dimension(390, 315);
                    break;
                }
                dimension = new Dimension(390, 470);
                break;
            }
            case 48: {
                if (this.getCircuitSize() == 1) {
                    dimension = new Dimension(390, 465);
                    break;
                }
                dimension = new Dimension(430, 466);
                break;
            }
            case 192: {
                if (this.getCircuitSize() == 1) {
                    dimension = new Dimension(500, 480);
                    break;
                }
                dimension = new Dimension(670, 480);
                break;
            }
            case 4: {
                if (this.getCircuitSize() == 12) {
                    dimension = new Dimension(390, 315);
                    break;
                }
                if (this.getCircuitSize() == 11) {
                    dimension = new Dimension(390, 460);
                    break;
                }
                if (this.getCircuitSize() != 10) break;
                dimension = new Dimension(390, 610);
                break;
            }
            case 16: {
                if (this.getCircuitSize() == 12) {
                    dimension = new Dimension(390, 465);
                    break;
                }
                if (this.getCircuitSize() == 11) {
                    dimension = new Dimension(400, 465);
                    break;
                }
                if (this.getCircuitSize() != 10) break;
                dimension = new Dimension(400, 465);
                break;
            }
            case 64: {
                if (this.getCircuitSize() == 12) {
                    dimension = new Dimension(400, 465);
                    break;
                }
                if (this.getCircuitSize() == 11) {
                    dimension = new Dimension(525, 465);
                    break;
                }
                if (this.getCircuitSize() != 10) break;
                dimension = new Dimension(535, 465);
                break;
            }
            default: {
                dimension = new Dimension(380, 465);
            }
        }
        return dimension;
    }

    public int getMode() {
        return this.mode;
    }

    private void setMode(IModuleModel iModuleModel) {
        if (iModuleModel.getEqType() == 284) {
            this.mode = 48;
        } else if (iModuleModel.getEqType() == 283 || iModuleModel.getEqType() == 285) {
            this.mode = this.isHighSpeedXc(iModuleModel) && this.isHighSpeedSlot(iModuleModel) ? (this.isSonet() ? 192 : 64) : (this.isHighSpeedXc(iModuleModel) && !this.isHighSpeedSlot(iModuleModel) || !this.isHighSpeedXc(iModuleModel) && this.isHighSpeedSlot(iModuleModel) ? (this.isSonet() ? 48 : 16) : (this.isSonet() ? 12 : 4));
        } else if (db.on()) {
            db.println("Invalid module: " + iModuleModel.getEqLabel());
        }
        if (db.on()) {
            db.println("Mode: " + this.mode);
        }
    }

    private boolean isHighSpeedXc(IModuleModel iModuleModel) {
        boolean bl;
        block2: {
            bl = false;
            try {
                int n = iModuleModel.getShelfId();
                IEntityModel iEntityModel = iModuleModel.getNodeModel().getEntityTable().getEntityModelBySlot(n, 8);
                List list = iEntityModel.getDescendantsOfEqType(3);
                list.addAll(iEntityModel.getDescendantsOfEqType(43));
                list.addAll(iEntityModel.getDescendantsOfEqType(107));
                IEntityModel iEntityModel2 = iModuleModel.getNodeModel().getEntityTable().getEntityModelBySlot(n, 10);
                list.addAll(iEntityModel2.getDescendantsOfEqType(3));
                list.addAll(iEntityModel2.getDescendantsOfEqType(43));
                list.addAll(iEntityModel2.getDescendantsOfEqType(107));
                bl = list.isEmpty();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block2;
                db.println("ACNSEE while retrieving XC card");
            }
        }
        return bl;
    }

    private boolean isHighSpeedSlot(IModuleModel iModuleModel) {
        int n = iModuleModel.getSlot();
        return n == 5 || n == 6 || n == 12 || n == 13;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.okBtn) {
            this.processOK();
            this.localDispose();
        } else if (jButton == this.cancelBtn) {
            this.localDispose();
        }
    }
}

