/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IPathStateInfo;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ui.circuits.HoLoSlice;
import cerent.cms.ui.circuits.HoLoSliceDialog;
import cerent.util.SDebug;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HoSlicePane
extends JPanel {
    protected HoLoSliceDialog parent = null;
    protected IPathStateInfo[] pathStateInfos = null;
    protected Map holoMap = null;
    protected int stsStart = 1;
    protected static final SDebug db = new SDebug("HoSlicePane");

    public HoSlicePane(HoLoSliceDialog hoLoSliceDialog, Map map) {
        this.parent = hoLoSliceDialog;
        this.holoMap = map;
        this.init();
        this.initContentPane();
    }

    protected void initContentPane() {
        this.setLayout(new FlowLayout(0, 5, 5));
        this.setBorder(BorderFactory.createTitledBorder(this.getTitleForBorder()));
        this.add(this.createSlicePane());
    }

    private void init() {
        if (this.holoMap == null) {
            if (db.on()) {
                db.println("No HoLo available");
            }
            return;
        }
        int n = 0;
        this.pathStateInfos = new IPathStateInfo[this.holoMap.size()];
        for (IPathStateInfo iPathStateInfo : this.holoMap.keySet()) {
            if (iPathStateInfo == null) continue;
            this.pathStateInfos[n] = iPathStateInfo;
            if (db.on()) {
                db.println("IHoLoNum: " + n + ":::" + this.pathStateInfos[n].getHoNum());
            }
            ++n;
        }
    }

    protected JComponent createSlicePane() {
        JPanel jPanel = null;
        boolean bl = false;
        switch (this.parent.getMode()) {
            case 12: {
                jPanel = new JPanel(new GridLayout(4, 3, 3, 3));
                break;
            }
            case 48: {
                jPanel = new JPanel(new GridLayout(8, 6, 3, 3));
                break;
            }
            case 192: {
                jPanel = new JPanel(new GridLayout(16, 12, 3, 3));
                bl = true;
                break;
            }
            case 4: {
                jPanel = new JPanel(new GridLayout(4, 3, 3, 3));
                break;
            }
            case 16: {
                jPanel = new JPanel(new GridLayout(8, 2, 3, 3));
                break;
            }
            case 64: {
                jPanel = new JPanel(new GridLayout(8, 8, 3, 3));
            }
        }
        if (jPanel == null) {
            if (db.on()) {
                db.println("Invalid mode: " + this.parent.getMode());
            }
            return jPanel;
        }
        for (int i = 0; i < this.pathStateInfos.length; ++i) {
            jPanel.add(this.createSlice(this.pathStateInfos[i], 1, true));
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setBorder(null);
        if (bl) {
            jScrollPane.setPreferredSize(new Dimension(460, 320));
        }
        return jScrollPane;
    }

    protected HoLoSlice createSlice(IPathStateInfo iPathStateInfo, int n, boolean bl) {
        return new HoLoSlice(this, iPathStateInfo, n, bl);
    }

    public void setSelectedSlice(HoLoSlice hoLoSlice, boolean bl) {
        this.parent.setSelectedSlice(hoLoSlice, bl);
    }

    public HoLoSlice getSelectedSlice() {
        return this.parent.getSelectedHoSlice();
    }

    public HoLoSlice getSelectedHoSlice() {
        return this.getSelectedSlice();
    }

    public LinkedList getSelectedSliceList(HoLoSlice hoLoSlice) {
        return this.parent.getSelectedSliceList(hoLoSlice);
    }

    public CircuitCreatInfo getCircuitInfo() {
        return this.parent.getCircuitInfo();
    }

    public boolean hasLo() {
        return this.parent.hasLo();
    }

    protected String getTitleForBorder() {
        return this.parent.isSonet() ? "STS" : "VC4";
    }
}

