/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IPathStateInfo;
import cerent.cms.ui.circuits.HoLoSlice;
import cerent.cms.ui.circuits.HoLoSliceDialog;
import cerent.cms.ui.circuits.HoSlicePane;
import cerent.util.ComparisonUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoSlicePane
extends HoSlicePane {
    private JPanel mainPane = null;

    public LoSlicePane(HoLoSliceDialog hoLoSliceDialog, Map map) {
        super(hoLoSliceDialog, map);
    }

    private void init(Map map) {
        if (map == null) {
            if (db.on()) {
                db.println("No HoLo available");
            }
            return;
        }
        this.holoMap = map;
        for (IPathStateInfo iPathStateInfo : this.holoMap.keySet()) {
            LinkedList linkedList = (LinkedList)this.holoMap.get(iPathStateInfo);
            Collections.sort(linkedList, new VTGroupComparator());
            this.pathStateInfos = new IPathStateInfo[linkedList.size()];
            for (int i = 0; i < linkedList.size(); ++i) {
                IPathStateInfo iPathStateInfo2;
                this.pathStateInfos[i] = iPathStateInfo2 = (IPathStateInfo)linkedList.get(i);
            }
        }
    }

    @Override
    protected void initContentPane() {
        super.initContentPane();
        this.setBorder(null);
    }

    @Override
    protected JComponent createSlicePane() {
        this.mainPane = new JPanel(new FlowLayout(0, 3, 3));
        return this.mainPane;
    }

    @Override
    public void setSelectedSlice(HoLoSlice hoLoSlice, boolean bl) {
        this.parent.setSelectedSlice(hoLoSlice, bl);
    }

    public void refreshPane(HoLoSlice hoLoSlice, Map map) {
        int n;
        if (db.on()) {
            db.println("LO.refreshPane...: " + map.size());
        }
        this.removeAll();
        if (hoLoSlice.getState() == 1) {
            if (db.on()) {
                db.println("HO is NOT in selected state. No LO created");
            }
            this.setBorder(null);
            return;
        }
        if (hoLoSlice == null || map == null) {
            if (db.on()) {
                db.println("HO is null and loMap has no LO");
            }
            return;
        }
        this.setBorder(BorderFactory.createTitledBorder(this.getTitleForBorder(hoLoSlice.getNumber(), 1)));
        this.init(map);
        LinkedList linkedList = this.parent.getSelectedSliceList(hoLoSlice);
        if (db.on()) {
            db.println("HO " + hoLoSlice + " has LO " + linkedList);
        }
        if ((n = this.parent.getCircuitSize()) == 0) {
            this.mainPane = new JPanel(new GridLayout(7, 1, 2, 10));
            this.add(this.mainPane);
            int n2 = 0;
            int n3 = 0;
            for (int i = 1; i < 8; ++i) {
                n3 = n2 + 4;
                if (n3 > this.pathStateInfos.length) {
                    n3 = this.pathStateInfos.length;
                }
                this.mainPane.add(this.createGroup(linkedList, 1, 4, n2, n3));
                n2 = n3;
            }
        } else if (n == 11) {
            this.mainPane = new JPanel(new GridLayout(1, 0, 2, 10));
            this.add(this.mainPane);
            int n4 = 0;
            int n5 = n4 + 3;
            if (n5 > this.pathStateInfos.length) {
                n5 = this.pathStateInfos.length;
            }
            this.mainPane.add(this.createGroup(linkedList, 1, 3, n4, n5));
        } else if (n == 10) {
            this.mainPane = new JPanel(new GridLayout(1, 1, 10, 10));
            this.add(this.mainPane);
            this.mainPane.add(this.createTug3Group(linkedList));
        }
        this.validate();
    }

    protected JPanel createTug3Group(List<HoLoSlice> list) {
        JPanel jPanel = new JPanel(new GridLayout(7, 1, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getTitleForBorder(1, 2)));
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < 8; ++i) {
            n2 = n + 3;
            if (n2 > this.pathStateInfos.length) {
                n2 = this.pathStateInfos.length;
            }
            jPanel.add(this.createTug2Group(list, n, n2));
            n = n2;
        }
        return jPanel;
    }

    protected JPanel createTug2Group(List<HoLoSlice> list, int n, int n2) {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 22, 22));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)jPanel, "Center");
        short s = this.pathStateInfos[n].getLoNum().getTug2OrVtGroupNum();
        jPanel2.add((Component)new JLabel(this.getTitleForBorder(s, 3)), "West");
        jPanel.add(this.createGroup(list, 1, 3, n, n2));
        return jPanel2;
    }

    protected JPanel createGroup(List<HoLoSlice> list, int n, int n2, int n3, int n4) {
        JPanel jPanel = new JPanel(new GridLayout(n, n2, 2, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "Center");
        for (int i = n3; i < n4; ++i) {
            HoLoSlice hoLoSlice = this.createSlice(this.pathStateInfos[i], 2, true);
            for (HoLoSlice hoLoSlice2 : list) {
                if (!hoLoSlice2.isSameAs(hoLoSlice)) continue;
                hoLoSlice = hoLoSlice2;
                break;
            }
            jPanel.add(hoLoSlice);
        }
        return jPanel2;
    }

    protected String getTitleForBorder(int n, int n2) {
        String string = null;
        switch (this.parent.getCircuitSize()) {
            case 0: {
                if (n2 == 1) {
                    string = "STS-" + n + " :: VT";
                    break;
                }
                if (n2 != 2) break;
                string = "VTG-" + n;
                break;
            }
            case 11: {
                if (n2 != 1) break;
                string = "VC4-" + n + " :: VC3";
                break;
            }
            case 10: {
                if (n2 == 1) {
                    string = "VC4-" + n + " :: VC12";
                    break;
                }
                if (n2 == 2) {
                    string = "TUG3-" + n;
                    break;
                }
                if (n2 != 3) break;
                string = "TUG2-" + n;
                break;
            }
        }
        return string;
    }

    private class VTGroupComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IPathStateInfo iPathStateInfo = (IPathStateInfo)object;
            IPathStateInfo iPathStateInfo2 = (IPathStateInfo)object2;
            short s = iPathStateInfo.getLoNum().getTug2OrVtGroupNum();
            short s2 = iPathStateInfo2.getLoNum().getTug2OrVtGroupNum();
            return ComparisonUtil.compare((int)s, (int)s2);
        }
    }
}

