/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapLinkConnector;

public class OchccProtectedCircuitMapPort
extends AbstractProtectedCircuitMapPort {
    private SDebug db = new SDebug("OchccProtectedCircuitMapPort");
    private int trunkIndex;
    private IEntityModel trunkPort;

    public OchccProtectedCircuitMapPort(DetailedMapNode detailedMapNode, MapLinkConnector mapLinkConnector, int n) {
        super(detailedMapNode, mapLinkConnector);
        this.trunkIndex = n;
    }

    int getTrunkIndex() {
        return this.trunkIndex;
    }

    public IEntityModel getPort() {
        if (this.trunkPort == null) {
            Object object = this.parentNode.getUserObject();
            if (object != null && object instanceof INodeModel) {
                INodeModel iNodeModel = (INodeModel)object;
                CircuitMapNode circuitMapNode = (CircuitMapNode)this.parentNode;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                int n = circuitMapNode.getEntityIndex(this);
                try {
                    this.trunkPort = iEntityTableModel.getEntityModelByIndex(n);
                }
                catch (Exception exception) {
                    this.db.severe("Cannot find trunk EM for " + Integer.toHexString(n) + ": " + exception.getMessage());
                }
            } else {
                this.db.severe("parentKey is not a valid INodeModel instance: " + object);
            }
        }
        return this.trunkPort;
    }

    public IPortModel getInternalPort() {
        return (IPortModel)this.getPort();
    }

    public boolean isActivePort() {
        return OchTrailHelper.isActivePort(this.getPort());
    }

    public boolean isWorkingPort() {
        return OchTrailHelper.isWorkingPort(this.getPort());
    }

    public IYCableModel getYCableOrSplitterModel() throws AbstractCmsNoSuchElementException {
        return OchTrailAttrsHelper.getYCableModel(this.getPort());
    }

    public int getProtectionOp() throws AbstractCmsNoSuchElementException {
        return OchTrailAttrsHelper.getProtectionOp(this.getPort());
    }

    public void setProtectionOp(int n) throws AbstractCmsNoSuchElementException, InvalidProtectionOp, InternalCommError {
        OchTrailAttrsHelper.setProtectionOp(this.getPort(), n);
    }

    public static class InternalCircuitMapPort
    extends OchccProtectedCircuitMapPort {
        private static final double PORTWIDTH = 8.0;
        private static final double PORTHEIGHT = 8.0;

        public InternalCircuitMapPort(AbstractInternalPG abstractInternalPG, DetailedMapNode detailedMapNode, int n) {
            super(detailedMapNode, null, n);
            this.setInternalPG(abstractInternalPG);
        }

        public void graphicallyInitPort() {
            super.graphicallyInitPort();
            this.setSize(8.0, 8.0);
        }
    }
}

