/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.NetProtectionType;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdRoutePane;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

public class RollRoutePane
extends CcdRoutePane {
    public void setRoutePrefs(RoutePrefs routePrefs) {
        if (routePrefs != null) {
            this.routePrefs = routePrefs;
        }
    }

    public RollRoutePane(RollCreationDialog rollCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(rollCreationDialog, wzDiagDebug, string);
    }

    protected void addOrRouteNewCircuit() throws Exception {
        this.routePrefs.setSrc(Network.instance().getNetElem(((RollCreationDialog)this.parent).getSourceNode().getNodeId()));
        this.routePrefs.setDst(Network.instance().getNetElem(((RollCreationDialog)this.parent).getDestNode().getNodeId()));
        if (this.autoRoute && !this.urn && !this.getAbstractCktDlg().isLoCkt() && !this.tscc) {
            ((RollCreationDialog)this.parent).setExcludeEntities(this.routePrefs);
            ((RollCreationDialog)this.parent).routeNewCircuit();
            if (!this.rrbc) {
                try {
                    if (((RollCreationDialog)this.parent).checkNewRouteForUPSR()) {
                        throw new Exception("A(n) " + CircuitMapUtil.UPSR_TERM + " ring was detected between pivot/fixed point 1 and pivot/fixed point 2.");
                    }
                    NetCcatCircuit netCcatCircuit = (NetCcatCircuit)((RollCreationDialog)this.parent).ckt;
                    LinkedList linkedList = new LinkedList();
                    LinkedList linkedList2 = new LinkedList();
                    netCcatCircuit.getNewSpanAndNodeList(((RollCreationDialog)this.parent).newRoute, ((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2);
                    netCcatCircuit.sanityCheckBridgeRollRouting(((RollCreationDialog)this.parent).oldRoute, linkedList, linkedList2, this.getAbstractCktDlg().getRoutePrefs());
                    if (this.db.on()) {
                        this.db.println("validatePage: sanityCheckManualRouting succeeded");
                    }
                    ((RollCreationDialog)this.parent).savePostRollCktSpansAndNodes(linkedList, linkedList2);
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    throw new SanityCheckException("", "spans are", sanityCheckFailed);
                }
                ((RollCreationDialog)this.parent).getNewCircuitInfo();
            }
        }
    }

    public void validatePage() throws Exception {
        this.autoRoute = this.autoRouteCB.isSelected();
        this.rrbc = this.rrbcCB.isSelected();
        this.urn = this.urnCB.isSelected();
        if (NetProtectionType.isProtectedType(((RollCreationDialog)this.parent).oldRouteProtType)) {
            if (!this.pathProtCB.isSelected()) {
                this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)"Are you sure you want to downgrade the fully protected path?", (String)"Downgrade protection");
                if (!this.isOkToPostValidate()) {
                    return;
                }
            } else if (((RollCreationDialog)this.parent).oldRouteProtType == 18 && !this.driCB.isSelected()) {
                this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)"Are you sure you want to downgrade the fully protected DRI path?", (String)"Downgrade protection");
                if (!this.isOkToPostValidate()) {
                    return;
                }
            }
        } else if (((RollCreationDialog)this.parent).oldRouteProtType == 3 && this.pcaCB.isSelected()) {
            this.isOkToPostValidate = CerentDialog.yesNoDialog((Component)this, (String)"Are you sure you want to downgrade the unprotected path?", (String)"Downgrade protection");
            if (!this.isOkToPostValidate()) {
                return;
            }
        }
        super.validatePage();
    }

    public void revalidateData() {
        super.revalidateData();
        if (!this.getAbstractCktDlg().ckt.isBidirectional() && this.getAbstractCktDlg().ckt.getDrops().size() > 1) {
            this.pathProtCB.setEnabled(false);
            this.driCB.setEnabled(false);
            this.pcaCB.setEnabled(false);
            this.ndRequired.setEnabled(false);
            this.ndDesired.setEnabled(false);
            this.ldOnly.setEnabled(false);
        }
        if (NetProtectionType.isProtectedType(((RollCreationDialog)this.parent).oldRouteProtType)) {
            this.pathProtCB.setSelected(true);
            if (((RollCreationDialog)this.parent).oldRouteProtType == 13) {
                this.pathProtCB.setEnabled(false);
                this.driCB.setEnabled(false);
                this.ndRequired.setEnabled(false);
                this.ndDesired.setEnabled(false);
                this.ldOnly.setEnabled(false);
            } else if (((RollCreationDialog)this.parent).oldRouteProtType == 18) {
                this.pathProtCB.setEnabled(false);
                this.driCB.setSelected(true);
                if (((RollCreationDialog)this.parent).getSourceNode() == ((RollCreationDialog)this.parent).rollFromCkt.getPrimarySource().getNodeModel() && ((RollCreationDialog)this.parent).getDestNode() == ((NetCcatCircuit)((RollCreationDialog)this.parent).rollFromCkt).getPrimaryDrop().getNodeModel()) {
                    this.driCB.setEnabled(true);
                } else {
                    this.driCB.setEnabled(false);
                }
                this.urnCB.setSelected(true);
                this.urnCB.setEnabled(false);
                this.ndRequired.setEnabled(false);
                this.ndDesired.setEnabled(false);
                this.ldOnly.setEnabled(false);
            }
        } else if (NetProtectionType.isUnprotectedType(((RollCreationDialog)this.parent).oldRouteProtType)) {
            this.pathProtCB.setSelected(false);
            if (NetProtectionType.isPcaType(((RollCreationDialog)this.parent).oldRouteProtType)) {
                this.pcaCB.setSelected(true);
            }
        }
        if (this.getAbstractCktDlg().getPortGrouping()) {
            this.autoRouteCB.setSelected(true);
            this.autoRouteCB.setEnabled(false);
            this.urnCB.setSelected(false);
            this.urnCB.setEnabled(false);
            this.rrbcCB.setSelected(false);
            this.rrbcCB.setEnabled(false);
            this.driCB.setEnabled(false);
        }
    }

    protected boolean allowTscc() {
        return false;
    }

    protected boolean forceTscc() {
        INetElement iNetElement = ((RollCreationDialog)this.parent).rollFrom1.getNetElement();
        INetElement iNetElement2 = ((RollCreationDialog)this.parent).rollFrom2.getNetElement();
        List list = ((RollCreationDialog)this.parent).changedNodeList;
        List list2 = ((RollCreationDialog)this.parent).rollFromCkt.getXmCircuitEnds();
        if (!list2.isEmpty() && !list.isEmpty()) {
            for (INetCircuitNode iNetCircuitNode : list) {
                if (((INetCircuitEnd)list2.get(0)).getNetElement() != iNetCircuitNode.getNetElement() || iNetCircuitNode.getNetElement() == iNetElement || iNetCircuitNode.getNetElement() == iNetElement2) continue;
                return true;
            }
        }
        return false;
    }

    protected void syncButtons() {
        super.syncButtons();
        if (this.getAbstractCktDlg().getPortGrouping()) {
            this.getAbstractCktDlg().setNextEnabled(false);
            this.getAbstractCktDlg().setFinishEnabled(true);
            this.driCB.setEnabled(false);
        }
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollRoutePane;
    }
}

