/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.ui.circuits.HoLoPane;
import cerent.util.HoLoFactory;
import cerent.util.HoLoRange;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.LoListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SonetHoLoPane
extends HoLoPane {
    private SDebug dbg;
    private JLabel stsLB;
    private JLabel vtLB;
    private JComboBox stsCB;
    private JComboBox vtCB;
    private INetLinkSpan alreadyAddedSpan = null;

    public SonetHoLoPane(SDebug sDebug) {
        super(sDebug);
        this.dbg = sDebug;
    }

    protected void addMoreRows() {
        this.stsCB = new JComboBox();
        this.stsCB.addActionListener(this);
        this.gridPanel.addRow("Source STS", this.stsCB);
        this.vtCB = new JComboBox();
        this.vtCB.setRenderer(new LoListCellRenderer());
        this.gridPanel.addRow("VT", this.vtCB);
    }

    protected void initCB() {
        this.vtCB.removeAllItems();
        this.vtCB.setEnabled(false);
        if (this.circuitType.isLoCircuitType() || this.circuitType.isLoVcatCircuitType()) {
            IHoNum iHoNum = this.stsCB.isEnabled() && this.stsCB.getSelectedIndex() >= 0 ? (IHoNum)this.stsCB.getSelectedItem() : null;
            List list = this.getNetLink().getAvailableLoNumbers(iHoNum, this.circuitSize.getEnum());
            if (this.circuitType.isLoVcatCircuitType()) {
                this.filterLoNumbersForVcat(list, iHoNum);
            }
            if (this.dbg.on()) {
                this.dbg.println("SonetHoLoPane: got VT list size=" + list.size() + " for sts#" + iHoNum.prettyString());
            }
            if (!list.isEmpty()) {
                this.vtCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                this.vtCB.setEnabled(true);
                this.vtCB.setSelectedIndex(0);
            }
            this.addButton.setEnabled(this.vtCB.isEnabled() && this.vtCB.getSelectedIndex() >= 0);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    protected JComboBox getHoCB() {
        return this.stsCB;
    }

    protected void selectHoCB(IHoNum iHoNum) {
        this.stsCB.setSelectedItem(iHoNum);
    }

    protected IHoNum getSelectedHoCB() {
        return (IHoNum)this.stsCB.getSelectedItem();
    }

    private void removeHoCB(IHoNum iHoNum) {
        IHoNum iHoNum2;
        if (this.dbg.on()) {
            this.dbg.println("Removing HOs, centered on " + iHoNum.prettyString());
        }
        HoLoRange hoLoRange = new HoLoRange(HoLoFactory.subtractOffset(iHoNum, this.circuitSize), HoLoFactory.addOffset(iHoNum, this.circuitSize));
        if (this.dbg.on()) {
            this.dbg.println("\tRange: " + hoLoRange.prettyString());
        }
        if ((iHoNum2 = HoLoFactory.createFirstHoNum(0)).isSameTimeslot(iHoNum)) {
            if (this.dbg.on()) {
                this.dbg.println("Manually removing the given HO num: it's the first possible one.");
            }
            this.stsCB.removeItem(iHoNum2);
        }
        IHoNum iHoNum3 = HoLoFactory.addOffset(hoLoRange.getFirst().getHoNum(), 1);
        while (hoLoRange.doesContain(iHoNum3)) {
            this.stsCB.removeItem(iHoNum3);
            iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
        }
    }

    private boolean isHoCBEmpty() {
        return this.stsCB.getItemCount() <= 0;
    }

    protected void selectLoCB(ILoNum iLoNum) {
        this.vtCB.setSelectedItem(iLoNum);
    }

    private void removeLoCB(ILoNum iLoNum) {
        this.vtCB.removeItem(iLoNum);
    }

    private boolean isLoCBEmpty() {
        return this.vtCB.getItemCount() <= 0;
    }

    protected void setEnabledControls(boolean bl) {
        this.stsCB.setEnabled(bl);
        this.vtCB.setEnabled(bl);
    }

    protected void clearControls() {
        this.stsCB.removeAllItems();
        this.vtCB.removeAllItems();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getHoCB() && this.circuitType != null && (this.circuitType.isLoCircuitType() || this.circuitType.isLoVcatCircuitType())) {
            this.initCB();
            if (!this.removeHoLoValuesOfAlreadyAddedSpan()) {
                this.addButton.setEnabled(false);
            }
        }
    }

    public void enable(INetLink iNetLink, int n, int n2) {
        this.enable(iNetLink, n, n2, null);
    }

    public void enable(INetLink iNetLink, int n, int n2, INetLinkSpan iNetLinkSpan) {
        this.alreadyAddedSpan = iNetLinkSpan;
        if (this.dbg.on()) {
            this.dbg.println("sonetPane:enable netLink size=" + n + " type =" + n2);
        }
        super.setNetLink(iNetLink);
        this.circuitSize = CircuitSize.getCircuitSize((int)n);
        this.circuitType = CircuitType.getCircuitType((int)n2);
        this.clearControls();
        if (this.getNetLink().isLOTunnel() || this.getNetLink().isLAP()) {
            if (((NetLink)iNetLink).inBLSR()) {
                this.getHoCB().addItem(iNetLink.getSrcHo());
            }
            this.stsCB.setEnabled(false);
        } else {
            ArrayList arrayList = (ArrayList)this.getNetLink().getAvailableHoNumbers(n, n2);
            if (this.circuitType.isHoVcatCircuitType()) {
                this.filterHoNumbersForVcat(arrayList);
            }
            if (this.dbg.on()) {
                this.dbg.println("SonetPane: got HO list size=" + arrayList.size());
            }
            this.stsCB.setEnabled(true);
            this.stsCB.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
            if (this.getHoCB().getItemCount() > 0) {
                this.getHoCB().setSelectedIndex(0);
            }
        }
        this.initCB();
        if (iNetLinkSpan != null && !this.removeHoLoValuesOfAlreadyAddedSpan()) {
            this.addButton.setEnabled(false);
        }
    }

    public void enable(INetLinkSpan iNetLinkSpan) {
        this.setEnabledControls(false);
        this.from.setEnabled(false);
        this.addButton.setEnabled(false);
        this.setNetLink(iNetLinkSpan.getLink());
        this.setUniqueItem(this.getHoCB(), iNetLinkSpan.getSrcHoNum(), true);
        if (iNetLinkSpan.getLoNum() != null) {
            this.setUniqueItem(this.vtCB, iNetLinkSpan.getLoNum(), false);
        }
    }

    public INetLinkSpan getNetLinkSpan() {
        NetLinkSpan netLinkSpan = null;
        if (this.getNetLink() != null) {
            IHoNum iHoNum = null;
            IHoNum iHoNum2 = null;
            ILoNum iLoNum = null;
            if (this.circuitSize != null && this.circuitSize.isSonetTerminationSize() && this.circuitSize.isLo(0)) {
                if (this.vtCB.getSelectedIndex() == -1) {
                    INetLinkSpan[] iNetLinkSpanArray = this.getNetLink().getAllAvailSpans(this.circuitSize.getEnum(), this.circuitType.getEnum());
                    if (iNetLinkSpanArray != null && iNetLinkSpanArray.length > 0) {
                        return iNetLinkSpanArray[0];
                    }
                    return null;
                }
                iLoNum = (ILoNum)this.vtCB.getSelectedItem();
            }
            if (this.getNetLink().isLOTunnel() || this.getNetLink().isLAP()) {
                iHoNum = this.getNetLink().getSrcHo();
                iHoNum2 = this.getNetLink().getDstHo();
            } else if (this.getNetLink().isServerTrail()) {
                ServerTrailLink serverTrailLink = (ServerTrailLink)this.getNetLink();
                iHoNum = (IHoNum)this.stsCB.getSelectedItem();
                if (serverTrailLink.getPrefs().isLoTrail()) {
                    IHoLoNum iHoLoNum = serverTrailLink.getDstHoLo(iHoNum, iLoNum);
                    iHoNum2 = iHoLoNum.getHoNum();
                } else {
                    iHoNum2 = serverTrailLink.getDstHo(iHoNum);
                }
            } else if (this.getHoCB().getSelectedIndex() >= 0) {
                iHoNum2 = iHoNum = (IHoNum)this.stsCB.getSelectedItem();
            }
            netLinkSpan = new NetLinkSpan(this.getNetLink(), this.cktMap.findReverseLink(this.getNetLink()), iHoNum, iHoNum2, iLoNum);
        }
        return netLinkSpan;
    }

    public void reset() {
        super.reset();
        this.alreadyAddedSpan = null;
    }

    public void disablePane() {
        super.disablePane();
        this.alreadyAddedSpan = null;
    }

    private boolean removeHoLoValuesOfAlreadyAddedSpan() {
        if (this.alreadyAddedSpan == null) {
            return true;
        }
        IHoNum iHoNum = this.alreadyAddedSpan.getSrcHoNum();
        IHoNum iHoNum2 = this.alreadyAddedSpan.getDstHoNum();
        ILoNum iLoNum = this.alreadyAddedSpan.getLoNum();
        if (this.circuitType.isLoCircuitType() && !this.isLoCBEmpty() && iLoNum != null && (this.getSelectedHoCB() == iHoNum2 || this.getSelectedHoCB() == iHoNum)) {
            this.removeLoCB(iLoNum);
            if (this.isLoCBEmpty()) {
                if (iHoNum == this.getSelectedHoCB()) {
                    this.removeHoCB(iHoNum);
                } else {
                    this.removeHoCB(iHoNum2);
                }
                if (this.isHoCBEmpty()) {
                    CerentDialog.errorDialog((Component)this, (String)"Sorry, no VTs are available on this link, for UPSR Over One Plus One Circuit\nPlease make another selection.");
                    return false;
                }
                this.initCB();
            }
        } else if (!(this.isHoCBEmpty() || this.circuitType.isLoCircuitType() || iHoNum == null && iHoNum2 == null)) {
            if (iHoNum != null) {
                this.removeHoCB(iHoNum);
            }
            if (iHoNum2 != null && iHoNum != iHoNum2) {
                this.removeHoCB(iHoNum2);
            }
            if (this.isHoCBEmpty()) {
                CerentDialog.errorDialog((Component)this, (String)"Sorry, no STSes are available on this link, for UPSR Over One Plus One Circuit\nPlease make another selection.");
                return false;
            }
        }
        return true;
    }
}

