/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ipodwdm.ConsolidatedSRLGDataSource;
import cerent.cms.ui.ipodwdm.SRLGRowObject;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ConsolidatedSRLGReportDialog
extends UDialog
implements ActionListener,
MouseListener {
    private static final String TITLE_PREFIX = "Consolidated SRLG Report";
    public static final String NODE_TYPE_STRING = "Node";
    public static final String LINK_TYPE_STRING = "Link";
    private UTable table;
    private JButton reportOkButton;
    private boolean requireClose;
    private ConsolidatedSRLGDataSource cds;
    private MyDataModel srtm;
    private IPoDWDMUtility dwdmUtil;
    public static final String[] columnNames = new String[]{"Resource Name", "Resource Type", "Unique SRLG", "Additional SRLG"};
    public static final int RESOURCE_NAME = 0;
    public static final int RESOURCE_TYPE = 1;
    public static final int UNIQUE_SRLG = 2;
    public static final int ADDITIONAL_SRLG = 3;
    protected static final SDebug db = new SDebug("ConsolidatedSRLGReportDialog");

    public ConsolidatedSRLGReportDialog(Frame frame) {
        super(frame, TITLE_PREFIX, true);
        super.setSize(new Dimension(510, 400));
        if (this.requireClose) {
            super.dispose();
            return;
        }
        this.setVisible(true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
            ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
            this.cds = new ConsolidatedSRLGDataSource(this);
            this.srtm = new MyDataModel(this.cds, columnRendererArray, SRLGRowObject.class);
            this.table = new UTable((TableModel)((Object)this.srtm));
            this.srtm.initTable((JTable)this.table);
            this.table.addMouseListener((MouseListener)this);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(0);
            UScrollPane uScrollPane = new UScrollPane((Component)this.table);
            uScrollPane.setPreferredSize(new Dimension(510, 400));
            this.reportOkButton = new JButton("OK");
            this.reportOkButton.setPreferredSize(new Dimension(80, 30));
            this.reportOkButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add((Component)this.reportOkButton, "Center");
            jPanel.add((Component)jPanel2, "South");
            jPanel.add((Component)uScrollPane, "Center");
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while initializing the Table.");
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_GENERATE_SRLG_REPORT);
            this.requireClose = true;
        }
    }

    private ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columnNames.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = this.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private ColumnRenderer createColumnRenderer(int n) {
        SideColumnRenderer sideColumnRenderer = null;
        switch (n) {
            case 0: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 1: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 2: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 3: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
        }
        return sideColumnRenderer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.reportOkButton)) {
            super.dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n;
            JTable jTable = (JTable)mouseEvent.getSource();
            String string = ((SRLGRowObject)jTable.getValueAt(n = jTable.getSelectedRow(), 0)).getEntityName();
            if (string.equals(SRLGRowObject.UNKNOWN_STRING)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_LAUNCH_VIEW, (Object)string);
                return;
            }
            this.setVisible(false);
            new EditSRLG(UiToolkit.instance().getApplicationFrame(), jTable, this);
            this.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class EditSRLG
    extends UDialog
    implements ActionListener,
    IObserver {
        private static final String TITLE_PREFIX = "Update SRLG";
        private String resourceName;
        private String additionalSRLG;
        private String type;
        private ISideModel smod;
        private long uniqueSRLG;
        private int selectedRow;
        private boolean uniqueSRLGDirty;
        private boolean additionalSRLGDirty;
        private ArrayList<SRLGRowObject> rows;
        private JTextField uniqueSRLGBox;
        private JTextField additionalSRLGBox;
        private JTextField resourceBox;
        private JTextField typeBox;
        private JList srlgList;
        private UScrollPane usp;
        private JButton resetUniqueButton;
        private JButton addButton;
        private JButton deleteButton;
        private JButton resetAdditionalButton;
        private DefaultListModel dlm;
        private JLabel uLabel;
        private JLabel aLabel;
        private JLabel nameLabel;
        private JLabel typeLabel;
        private JButton okButton;
        private JButton cancelButton;
        private JTable target;
        private ConsolidatedSRLGReportDialog csrlg;

        public EditSRLG(Frame frame, JTable jTable, ConsolidatedSRLGReportDialog consolidatedSRLGReportDialog2) {
            super(frame, TITLE_PREFIX, true);
            this.target = jTable;
            this.csrlg = consolidatedSRLGReportDialog2;
            this.assignData();
            super.setSize(new Dimension(450, 400));
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            this.setLayout(null);
            this.nameLabel = new JLabel("Name");
            this.typeLabel = new JLabel("Type");
            this.uLabel = new JLabel("Unique SRLG");
            this.aLabel = new JLabel("Additional SRLG");
            this.resourceBox = new JTextField();
            this.resourceBox.setEnabled(false);
            this.typeBox = new JTextField();
            this.typeBox.setEnabled(false);
            this.uniqueSRLGBox = new JTextField();
            this.additionalSRLGBox = new JTextField();
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.resetUniqueButton = new JButton("Set Default");
            this.resetUniqueButton.addActionListener(this);
            this.resetAdditionalButton = new JButton("Set Default");
            this.resetAdditionalButton.addActionListener(this);
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(this);
            this.deleteButton = new JButton("Delete");
            this.deleteButton.addActionListener(this);
            this.deleteButton.setEnabled(false);
            this.srlgList = new JList();
            this.dlm = new DefaultListModel();
            this.srlgList.setModel(this.dlm);
            this.srlgList.setSelectionMode(0);
            this.srlgList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (EditSRLG.this.dlm.size() != 0) {
                        EditSRLG.this.deleteButton.setEnabled(true);
                    } else {
                        EditSRLG.this.deleteButton.setEnabled(false);
                    }
                }
            });
            this.usp = new UScrollPane((Component)this.srlgList);
            this.addComponent((Container)((Object)this), this.nameLabel, 10, 10, 100, 30);
            this.addComponent((Container)((Object)this), this.typeLabel, 10, 60, 100, 30);
            this.addComponent((Container)((Object)this), this.uLabel, 10, 110, 100, 30);
            this.addComponent((Container)((Object)this), this.aLabel, 10, 160, 100, 30);
            this.addComponent((Container)((Object)this), this.resourceBox, 140, 12, 200, 25);
            this.addComponent((Container)((Object)this), this.typeBox, 140, 62, 200, 25);
            this.addComponent((Container)((Object)this), this.uniqueSRLGBox, 140, 112, 130, 25);
            this.addComponent((Container)((Object)this), this.additionalSRLGBox, 140, 162, 130, 25);
            this.addComponent((Container)((Object)this), (Component)this.usp, 140, 200, 130, 100);
            this.addComponent((Container)((Object)this), this.resetUniqueButton, 280, 112, 110, 25);
            this.addComponent((Container)((Object)this), this.addButton, 280, 162, 80, 25);
            this.addComponent((Container)((Object)this), this.deleteButton, 280, 210, 80, 25);
            this.addComponent((Container)((Object)this), this.resetAdditionalButton, 280, 250, 110, 25);
            this.addComponent((Container)((Object)this), this.okButton, 100, 330, 80, 25);
            this.addComponent((Container)((Object)this), this.cancelButton, 200, 330, 80, 25);
        }

        private void addComponent(Container container, Component component, int n, int n2, int n3, int n4) {
            component.setBounds(n, n2, n3, n4);
            container.add(component);
        }

        private void assignData() {
            this.selectedRow = this.target.getSelectedRow();
            this.rows = this.csrlg.srtm.getSortedList();
            this.resourceName = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 0)).getEntityName();
            this.type = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 1)).getType();
            this.uniqueSRLG = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 2)).getUniqueSRLG();
            this.additionalSRLG = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 3)).getAdditionalSRLG();
            this.resourceBox.setText(this.resourceName);
            this.resourceBox.setToolTipText(this.resourceName);
            this.typeBox.setText(this.type);
            this.uniqueSRLGBox.setText(Long.toString(this.uniqueSRLG));
            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateAdditionalSRLGList(this.dlm, this.additionalSRLG);
        }

        public void update(IObservable iObservable, Object object) {
            block5: {
                try {
                    if (iObservable instanceof ISideModel) {
                        SRLGRowObject sRLGRowObject = this.rows.get(this.selectedRow);
                        INetLink iNetLink = sRLGRowObject.getDwdmLink();
                        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                        int n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getSrcSideId(iNetLink);
                        if (this.uniqueSRLGDirty) {
                            this.uniqueSRLGBox.setText(Long.toString(iNodeModel.getSideModels().getUniqueLinkSRLG(n)));
                        }
                        if (this.additionalSRLGDirty) {
                            String string = iNodeModel.getSideModels().getAdditionalLinkSRLG(n);
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateAdditionalSRLGList(this.dlm, string);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("update(): exception" + exception);
                }
            }
        }

        private void addSideObserver(ISideModel iSideModel) {
            this.smod = iSideModel;
            if (!iSideModel.isObserver((IObserver)this)) {
                this.smod.addObserver((IObserver)this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.resourceName = this.resourceBox.getText().trim();
            String string = this.uniqueSRLGBox.getText().trim();
            this.type = this.typeBox.getText().trim();
            if (this.rows.size() == 0) {
                this.rows = (ArrayList)ConsolidatedSRLGReportDialog.this.cds.getAllObjects();
            }
            SRLGRowObject sRLGRowObject = this.rows.get(this.selectedRow);
            if (actionEvent.getSource().equals(this.okButton)) {
                if (!ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGValid(string)) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                    return;
                }
                if (!ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(string)) {
                    ConsolidatedSRLGReportDialog.this.dwdmUtil;
                    Long l = 0L;
                    ConsolidatedSRLGReportDialog.this.dwdmUtil;
                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l, Long.toString(0xFFFFFFFEL));
                    return;
                }
                if (!ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(new String[]{string}, this.dlm)) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                    return;
                }
                boolean bl = false;
                if (this.type.equals(ConsolidatedSRLGReportDialog.NODE_TYPE_STRING)) {
                    try {
                        INodeModel iNodeModel = sRLGRowObject.getNodeModel();
                        this.additionalSRLG = ConsolidatedSRLGReportDialog.this.dwdmUtil.getAdditionalSRLGString(this.dlm);
                        long l = Long.parseLong(string);
                        iNodeModel.setUniqueNodeSRLG(l);
                        iNodeModel.setAdditionalNodeSRLG(this.additionalSRLG);
                        CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the MSTP node\n" + iNodeModel.getName()), (String)"SRLG Update");
                        bl = true;
                        this.csrlg.cds.refresh();
                        this.csrlg.srtm.fireTableDataChanged();
                        if (db.on()) {
                            db.println("SRLG successfully updated on " + iNodeModel.getName());
                        }
                        ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNodeModel);
                        super.dispose();
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println(exception.getMessage());
                            KDebug.printStackTrace((Throwable)exception);
                        }
                        if (!bl) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                        } else {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                        }
                        super.dispose();
                    }
                } else if (this.type.equals(ConsolidatedSRLGReportDialog.LINK_TYPE_STRING)) {
                    INetLink iNetLink = sRLGRowObject.getDwdmLink();
                    try {
                        this.additionalSRLG = ConsolidatedSRLGReportDialog.this.dwdmUtil.getAdditionalSRLGString(this.dlm);
                        long l = Long.parseLong(string);
                        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                        int n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getSrcSideId(iNetLink);
                        iNodeModel.getSideModels().setUniqueLinkSRLG(n, l);
                        iNodeModel.getSideModels().setAdditionalLinkSRLG(n, this.additionalSRLG);
                        iNodeModel = iNetLink.getDst().getNodeModel();
                        n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getDstSideId(iNetLink);
                        iNodeModel.getSideModels().setUniqueLinkSRLG(n, l);
                        iNodeModel.getSideModels().setAdditionalLinkSRLG(n, this.additionalSRLG);
                        CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the Link\n" + this.resourceName), (String)"SRLG Update");
                        bl = true;
                        this.csrlg.cds.refresh();
                        this.csrlg.srtm.fireTableDataChanged();
                        if (db.on()) {
                            db.println("SRLG successfully updated on " + this.resourceName);
                        }
                        ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNetLink);
                        super.dispose();
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println(exception.getMessage());
                            KDebug.printStackTrace((Throwable)exception);
                        }
                        if (!bl) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                        } else {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                        }
                        super.dispose();
                    }
                }
            } else if (actionEvent.getSource().equals(this.resetUniqueButton)) {
                if (this.type.equals(ConsolidatedSRLGReportDialog.NODE_TYPE_STRING)) {
                    INodeModel iNodeModel = sRLGRowObject.getNodeModel();
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_UNIQUE_SRLG, "Reset SRLG", iNodeModel.getName() + "?")) {
                        try {
                            iNodeModel.setDefaultUniqueNodeSRLG();
                            this.uniqueSRLGBox.setText(Long.toString(iNodeModel.getUniqueNodeSRLG()));
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the MSTP node " + iNodeModel.getName()), (String)"SRLG Update");
                            this.csrlg.cds.refresh();
                            this.csrlg.srtm.fireTableDataChanged();
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNodeModel);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)iNodeModel.getName());
                        }
                    }
                } else {
                    INetLink iNetLink = sRLGRowObject.getDwdmLink();
                    String string2 = ConsolidatedSRLGReportDialog.this.dwdmUtil.constructLinkFormat(iNetLink);
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_UNIQUE_SRLG, "Reset SRLG", string2)) {
                        try {
                            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                            int n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getSrcSideId(iNetLink);
                            ISideModels iSideModels = iNodeModel.getSideModels();
                            this.addSideObserver(iSideModels.getSideById(n));
                            iSideModels.setDefaultUniqueLinkSRLG(n);
                            iNodeModel = iNetLink.getDst().getNodeModel();
                            n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getDstSideId(iNetLink);
                            iSideModels = iNodeModel.getSideModels();
                            this.addSideObserver(iSideModels.getSideById(n));
                            iSideModels.setDefaultUniqueLinkSRLG(n);
                            iNodeModel.getSideModels().setDefaultUniqueLinkSRLG(n);
                            this.uniqueSRLGDirty = true;
                            this.uniqueSRLGBox.setText(Long.toString(iNodeModel.getSideModels().getUniqueLinkSRLG(n)));
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the Link\n" + string2), (String)"SRLG Update");
                            this.csrlg.cds.refresh();
                            this.csrlg.srtm.fireTableDataChanged();
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNetLink);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)string2);
                        }
                    }
                }
            } else if (actionEvent.getSource().equals(this.addButton)) {
                this.additionalSRLG = this.additionalSRLGBox.getText().trim();
                if (ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGValid(this.additionalSRLG)) {
                    if (ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(this.additionalSRLG)) {
                        if (ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(new String[]{string, this.additionalSRLG}, this.dlm)) {
                            if (ConsolidatedSRLGReportDialog.this.dwdmUtil.isSRLGCountOk(this.dlm)) {
                                ConsolidatedSRLGReportDialog.this.dwdmUtil.addElement(this.dlm, this.additionalSRLG);
                                this.additionalSRLGBox.setText("");
                            } else {
                                ConsolidatedSRLGReportDialog.this.dwdmUtil;
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_MAX_ADDITIONAL_SRLG_LIMIT_REACHED, (Object)20);
                            }
                        } else {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                        }
                    } else {
                        ConsolidatedSRLGReportDialog.this.dwdmUtil;
                        Long l = 0L;
                        ConsolidatedSRLGReportDialog.this.dwdmUtil;
                        ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l, Long.toString(0xFFFFFFFEL));
                    }
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                }
            } else if (actionEvent.getSource().equals(this.deleteButton)) {
                if (this.srlgList.getSelectedIndex() != -1) {
                    this.dlm.remove(this.srlgList.getSelectedIndex());
                }
                if (this.dlm.size() == 0) {
                    this.deleteButton.setEnabled(false);
                }
            } else if (actionEvent.getSource().equals(this.resetAdditionalButton)) {
                if (this.type.equals(ConsolidatedSRLGReportDialog.NODE_TYPE_STRING)) {
                    INodeModel iNodeModel = sRLGRowObject.getNodeModel();
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_ADDITIONAL_SRLG, "Reset SRLG", iNodeModel.getName() + "?")) {
                        try {
                            iNodeModel.setDefaultAdditionalNodeSRLG();
                            String string3 = iNodeModel.getAdditionalNodeSRLG();
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateAdditionalSRLGList(this.dlm, string3);
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the MSTP node " + iNodeModel.getName()), (String)"SRLG Update");
                            this.csrlg.cds.refresh();
                            this.csrlg.srtm.fireTableDataChanged();
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNodeModel);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)iNodeModel.getName());
                        }
                    }
                } else {
                    INetLink iNetLink = sRLGRowObject.getDwdmLink();
                    String string4 = ConsolidatedSRLGReportDialog.this.dwdmUtil.constructLinkFormat(iNetLink);
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_ADDITIONAL_SRLG, "Reset SRLG", string4)) {
                        try {
                            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                            int n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getSrcSideId(iNetLink);
                            ISideModels iSideModels = iNodeModel.getSideModels();
                            this.addSideObserver(iSideModels.getSideById(n));
                            iSideModels.setDefaultAdditionalLinkSRLG(n);
                            iNodeModel = iNetLink.getDst().getNodeModel();
                            n = ConsolidatedSRLGReportDialog.this.dwdmUtil.getDstSideId(iNetLink);
                            iSideModels = iNodeModel.getSideModels();
                            this.addSideObserver(iSideModels.getSideById(n));
                            iSideModels.setDefaultAdditionalLinkSRLG(n);
                            this.additionalSRLGDirty = true;
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateAdditionalSRLGList(this.dlm, iNodeModel.getSideModels().getAdditionalLinkSRLG(n));
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the Link \n" + string4), (String)"SRLG Update");
                            this.csrlg.cds.refresh();
                            this.csrlg.srtm.fireTableDataChanged();
                            ConsolidatedSRLGReportDialog.this.dwdmUtil.updateCRS(iNetLink);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)string4);
                        }
                    }
                }
            } else if (actionEvent.getSource().equals(this.cancelButton)) {
                super.dispose();
            }
        }
    }

    protected class SideColumnRenderer
    extends AbstractColumnRenderer {
        public SideColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SRLGRowObject sRLGRowObject = (SRLGRowObject)object;
            object = this.getColumnContents(sRLGRowObject, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(SRLGRowObject sRLGRowObject, int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = sRLGRowObject.getEntityName();
                    break;
                }
                case 1: {
                    string = sRLGRowObject.getType();
                    break;
                }
                case 2: {
                    string = Long.toString(sRLGRowObject.getUniqueSRLG());
                    break;
                }
                case 3: {
                    string = sRLGRowObject.getAdditionalSRLG();
                    break;
                }
            }
            return string;
        }

        public int compareColumn(Object object, Object object2, int n) {
            SRLGRowObject sRLGRowObject = (SRLGRowObject)object;
            SRLGRowObject sRLGRowObject2 = (SRLGRowObject)object2;
            String string = this.getColumnContents(sRLGRowObject, n);
            String string2 = this.getColumnContents(sRLGRowObject2, n);
            if (n == 2) {
                Long l = new Long(string);
                Long l2 = new Long(string2);
                return l.compareTo(l2);
            }
            return string.compareTo(string2);
        }
    }

    private class MyDataModel
    extends SortableRowTableModel {
        MyDataModel(ConsolidatedSRLGDataSource consolidatedSRLGDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
            super((RowDataSource)consolidatedSRLGDataSource, columnRendererArray, clazz);
        }

        private ArrayList getSortedList() {
            return this.sortedObjects;
        }
    }
}

