/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ipodwdm.DetailedSRLGDataSource;
import cerent.cms.ui.ipodwdm.SRLGRowObject;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class DetailedSRLGReportDialog
extends UDialog
implements ActionListener,
MouseListener {
    private JButton reportOkButton;
    private UTable table;
    private static final String TITLE_PREFIX = "Detailed SRLG Report";
    public static final String NODE_TYPE_STRING = "Node";
    public static final String LINK_TYPE_STRING = "Link";
    private DetailedSRLGDataSource cds;
    private MyDataModel srtm;
    private IPoDWDMUtility dwdmUtil;
    private boolean requireClose;
    public static final String[] columnNames = new String[]{"Resource Name", "Resource Type", "SRLG ID", "SRLG Type"};
    public static final int RESOURCE_NAME = 0;
    public static final int RESOURCE_TYPE = 1;
    public static final int GENERIC_SRLG = 2;
    public static final int SRLG_TYPE = 3;
    protected static final SDebug db = new SDebug("DetailedSRLGReportDialog");

    public DetailedSRLGReportDialog(Frame frame) {
        super(frame, TITLE_PREFIX, true);
        super.setSize(new Dimension(510, 400));
        if (this.requireClose) {
            super.dispose();
            return;
        }
        this.setVisible(true);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
            ColumnRenderer[] columnRendererArray = this.createColumnRenderers();
            this.cds = new DetailedSRLGDataSource(this);
            this.srtm = new MyDataModel(this.cds, columnRendererArray, SRLGRowObject.class);
            this.table = new UTable((TableModel)((Object)this.srtm));
            this.srtm.initTable((JTable)this.table);
            this.table.addMouseListener((MouseListener)this);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(0);
            UScrollPane uScrollPane = new UScrollPane((Component)this.table);
            uScrollPane.setPreferredSize(new Dimension(510, 400));
            this.reportOkButton = new JButton("OK");
            this.reportOkButton.setPreferredSize(new Dimension(80, 30));
            this.reportOkButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add((Component)this.reportOkButton, "Center");
            jPanel.add((Component)jPanel2, "South");
            jPanel.add((Component)uScrollPane, "Center");
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while initializing the Table.");
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_GENERATE_SRLG_REPORT);
            this.requireClose = true;
        }
    }

    private ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[columnNames.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = this.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    private ColumnRenderer createColumnRenderer(int n) {
        SideColumnRenderer sideColumnRenderer = null;
        switch (n) {
            case 0: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 1: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 2: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
            case 3: {
                sideColumnRenderer = new SideColumnRenderer(n, 120, true, 2);
                break;
            }
        }
        return sideColumnRenderer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.reportOkButton)) {
            super.dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n;
            JTable jTable = (JTable)mouseEvent.getSource();
            String string = ((SRLGRowObject)jTable.getValueAt(n = jTable.getSelectedRow(), 0)).getEntityName();
            if (string.equals(SRLGRowObject.UNKNOWN_STRING)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_LAUNCH_VIEW, (Object)string);
                return;
            }
            this.setVisible(false);
            new EditSRLG(UiToolkit.instance().getApplicationFrame(), jTable, this);
            this.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class EditSRLG
    extends UDialog
    implements ActionListener {
        private static final String TITLE_PREFIX = "Update SRLG";
        private String resourceName;
        private String resourceType;
        private String srlgType;
        private long genericSRLG;
        private int selectedRow;
        private JTextField resourceField;
        private JTextField typeField;
        private JTextField genericSRLGField;
        private JTextField srlgTypeField;
        private JButton okButton;
        private JButton cancelButton;
        private JTable target;
        private DetailedSRLGReportDialog dsrlg;

        public EditSRLG(Frame frame, JTable jTable, DetailedSRLGReportDialog detailedSRLGReportDialog2) {
            super(frame, TITLE_PREFIX, true);
            this.target = jTable;
            this.dsrlg = detailedSRLGReportDialog2;
            this.assignData();
            super.setSize(new Dimension(350, 300));
            this.setVisible(true);
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.resourceField = new JTextField();
            this.resourceField.setPreferredSize(new Dimension(200, 25));
            this.resourceField.setEnabled(false);
            this.typeField = new JTextField();
            this.typeField.setPreferredSize(new Dimension(200, 25));
            this.typeField.setEnabled(false);
            this.genericSRLGField = new JTextField();
            this.genericSRLGField.setPreferredSize(new Dimension(200, 25));
            this.srlgTypeField = new JTextField();
            this.srlgTypeField.setPreferredSize(new Dimension(200, 25));
            this.srlgTypeField.setEnabled(false);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            this.okButton.setPreferredSize(new Dimension(80, 25));
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.cancelButton.setPreferredSize(new Dimension(80, 25));
            jPanel4.add(new JPanel());
            jPanel3.add(new JPanel());
            jPanel3.add(new JLabel("Name"));
            jPanel4.add(this.resourceField);
            jPanel4.add(new JPanel());
            jPanel3.add(new JPanel());
            jPanel3.add(new JLabel("Type"));
            jPanel4.add(this.typeField);
            jPanel4.add(new JPanel());
            jPanel3.add(new JPanel());
            jPanel3.add(new JLabel("SRLG"));
            jPanel4.add(this.genericSRLGField);
            jPanel4.add(new JPanel());
            jPanel3.add(new JPanel());
            jPanel3.add(new JLabel("SRLG Type"));
            jPanel4.add(this.srlgTypeField);
            jPanel4.add(new JPanel());
            jPanel3.add(new JPanel());
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            jPanel.add((Component)jPanel3, "Center");
            jPanel.add((Component)jPanel4, "East");
            jPanel.add((Component)jPanel2, "South");
        }

        private void assignData() {
            this.selectedRow = this.target.getSelectedRow();
            this.resourceName = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 0)).getEntityName();
            this.resourceType = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 1)).getType();
            this.genericSRLG = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 2)).getUniqueSRLG();
            this.srlgType = ((SRLGRowObject)this.target.getValueAt(this.selectedRow, 3)).getAdditionalSRLG();
            this.resourceField.setText(this.resourceName);
            this.resourceField.setToolTipText(this.resourceName);
            this.typeField.setText(this.resourceType);
            this.genericSRLGField.setText(Long.toString(this.genericSRLG));
            this.srlgTypeField.setText(this.srlgType);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block49: {
                this.resourceName = this.resourceField.getText().trim();
                this.resourceType = this.typeField.getText().trim();
                String string = this.genericSRLGField.getText().trim();
                this.srlgType = this.srlgTypeField.getText().trim();
                ArrayList arrayList = this.dsrlg.srtm.getSortedList();
                if (arrayList.size() == 0) {
                    arrayList = (ArrayList)DetailedSRLGReportDialog.this.cds.getAllObjects();
                }
                SRLGRowObject sRLGRowObject = (SRLGRowObject)arrayList.get(this.selectedRow);
                if (actionEvent.getSource().equals(this.okButton)) {
                    try {
                        boolean bl = false;
                        if (this.resourceType.equals(DetailedSRLGReportDialog.NODE_TYPE_STRING)) {
                            INodeModel iNodeModel = sRLGRowObject.getNodeModel();
                            String string2 = iNodeModel.getAdditionalNodeSRLG();
                            long l = iNodeModel.getUniqueNodeSRLG();
                            StringBuilder stringBuilder = new StringBuilder().append(l);
                            DetailedSRLGReportDialog.this.dwdmUtil;
                            String string3 = stringBuilder.append(",").append(string2).toString();
                            if (this.srlgType.equals(SRLGRowObject.UNIQUE_STRING)) {
                                try {
                                    if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGValid(string)) {
                                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                                        break block49;
                                    }
                                    if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(string)) {
                                        DetailedSRLGReportDialog.this.dwdmUtil;
                                        Long l2 = 0L;
                                        DetailedSRLGReportDialog.this.dwdmUtil;
                                        ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l2, Long.toString(0xFFFFFFFEL));
                                        break block49;
                                    }
                                    if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(string, string3)) {
                                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                                        break block49;
                                    }
                                    iNodeModel.setUniqueNodeSRLG(Long.parseLong(string));
                                    CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully updated on Node " + iNodeModel.getName()), (String)"SRLG Updation");
                                    bl = true;
                                    this.dsrlg.cds.refresh();
                                    this.dsrlg.srtm.fireTableDataChanged();
                                    if (db.on()) {
                                        db.println("SRLG successfully updated.");
                                    }
                                    DetailedSRLGReportDialog.this.dwdmUtil.updateCRS(iNodeModel);
                                    super.dispose();
                                }
                                catch (Exception exception) {
                                    if (db.on()) {
                                        db.println("Error while updating the SRLG.");
                                        KDebug.printStackTrace((Throwable)exception);
                                    }
                                    if (!bl) {
                                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                                    } else {
                                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                                    }
                                    super.dispose();
                                }
                                break block49;
                            }
                            if (!this.srlgType.equals(SRLGRowObject.ADDITIONAL_SRLG)) break block49;
                            try {
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGValid(string)) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                                    break block49;
                                }
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(string)) {
                                    DetailedSRLGReportDialog.this.dwdmUtil;
                                    Long l3 = 0L;
                                    DetailedSRLGReportDialog.this.dwdmUtil;
                                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l3, Long.toString(0xFFFFFFFEL));
                                    break block49;
                                }
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(string, string3)) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                                    break block49;
                                }
                                iNodeModel.setAdditionalNodeSRLG(DetailedSRLGReportDialog.this.dwdmUtil.getUpdatedSRLG(this.genericSRLG, string, string2));
                                CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully updated on Node " + iNodeModel.getName()), (String)"SRLG Updation");
                                bl = true;
                                this.dsrlg.cds.refresh();
                                this.dsrlg.srtm.fireTableDataChanged();
                                if (db.on()) {
                                    db.println("SRLG successfully updated.");
                                }
                                DetailedSRLGReportDialog.this.dwdmUtil.updateCRS(iNodeModel);
                                super.dispose();
                            }
                            catch (Exception exception) {
                                if (db.on()) {
                                    db.println("Error while updating the SRLG.");
                                    KDebug.printStackTrace((Throwable)exception);
                                }
                                if (!bl) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                                } else {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                                }
                                super.dispose();
                            }
                            break block49;
                        }
                        if (!this.resourceType.equals(DetailedSRLGReportDialog.LINK_TYPE_STRING)) break block49;
                        INetLink iNetLink = sRLGRowObject.getDwdmLink();
                        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                        int n = DetailedSRLGReportDialog.this.dwdmUtil.getSrcSideId(iNetLink);
                        if (this.srlgType.equals(SRLGRowObject.UNIQUE_STRING)) {
                            try {
                                String string4 = iNodeModel.getSideModels().getAdditionalLinkSRLG(n);
                                long l = iNodeModel.getSideModels().getUniqueLinkSRLG(n);
                                StringBuilder stringBuilder = new StringBuilder().append(l);
                                DetailedSRLGReportDialog.this.dwdmUtil;
                                String string5 = stringBuilder.append(",").append(string4).toString();
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGValid(string)) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                                    break block49;
                                }
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(string)) {
                                    DetailedSRLGReportDialog.this.dwdmUtil;
                                    Long l4 = 0L;
                                    DetailedSRLGReportDialog.this.dwdmUtil;
                                    ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l4, Long.toString(0xFFFFFFFEL));
                                    break block49;
                                }
                                if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(string, string5)) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                                    break block49;
                                }
                                iNodeModel.getSideModels().setUniqueLinkSRLG(n, Long.parseLong(string));
                                iNodeModel = iNetLink.getDst().getNodeModel();
                                n = DetailedSRLGReportDialog.this.dwdmUtil.getDstSideId(iNetLink);
                                iNodeModel.getSideModels().setUniqueLinkSRLG(n, Long.parseLong(string));
                                CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully updated on Link\n" + DetailedSRLGReportDialog.this.dwdmUtil.constructLinkFormat(iNetLink)), (String)"SRLG Updation");
                                bl = true;
                                this.dsrlg.cds.refresh();
                                this.dsrlg.srtm.fireTableDataChanged();
                                if (db.on()) {
                                    db.println("SRLG successfully updated.");
                                }
                                DetailedSRLGReportDialog.this.dwdmUtil.updateCRS(iNetLink);
                                super.dispose();
                            }
                            catch (Exception exception) {
                                if (db.on()) {
                                    db.println("Error while updating the SRLG.");
                                    KDebug.printStackTrace((Throwable)exception);
                                }
                                if (!bl) {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                                } else {
                                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                                }
                                super.dispose();
                            }
                            break block49;
                        }
                        if (!this.srlgType.equals(SRLGRowObject.ADDITIONAL_SRLG)) break block49;
                        try {
                            String string6 = iNodeModel.getSideModels().getAdditionalLinkSRLG(n);
                            long l = iNodeModel.getSideModels().getUniqueLinkSRLG(n);
                            StringBuilder stringBuilder = new StringBuilder().append(l);
                            DetailedSRLGReportDialog.this.dwdmUtil;
                            String string7 = stringBuilder.append(",").append(string6).toString();
                            if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGValid(string)) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                            } else if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGInRange(string)) {
                                DetailedSRLGReportDialog.this.dwdmUtil;
                                Long l5 = 0L;
                                DetailedSRLGReportDialog.this.dwdmUtil;
                                ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l5, Long.toString(0xFFFFFFFEL));
                            } else if (!DetailedSRLGReportDialog.this.dwdmUtil.isSRLGUnique(string, string7)) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                            } else {
                                iNodeModel.getSideModels().setAdditionalLinkSRLG(n, DetailedSRLGReportDialog.this.dwdmUtil.getUpdatedSRLG(this.genericSRLG, string, string6));
                                iNodeModel = iNetLink.getDst().getNodeModel();
                                n = DetailedSRLGReportDialog.this.dwdmUtil.getDstSideId(iNetLink);
                                iNodeModel.getSideModels().setAdditionalLinkSRLG(n, DetailedSRLGReportDialog.this.dwdmUtil.getUpdatedSRLG(this.genericSRLG, string, string6));
                                CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully updated on Link\n" + DetailedSRLGReportDialog.this.dwdmUtil.constructLinkFormat(iNetLink)), (String)"SRLG Updation");
                                bl = true;
                                this.dsrlg.cds.refresh();
                                this.dsrlg.srtm.fireTableDataChanged();
                                if (db.on()) {
                                    db.println("SRLG successfully updated.");
                                }
                                DetailedSRLGReportDialog.this.dwdmUtil.updateCRS(iNetLink);
                                super.dispose();
                            }
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("Error while updating the SRLG.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            if (!bl) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                            } else {
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_CRS_SRLG, (Object)exception.getMessage());
                            }
                            super.dispose();
                        }
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("Error while updating the SRLG.");
                            KDebug.printStackTrace((Throwable)exception);
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG, (Object)exception.getMessage());
                    }
                } else if (actionEvent.getSource().equals(this.cancelButton)) {
                    super.dispose();
                }
            }
        }
    }

    protected class SideColumnRenderer
    extends AbstractColumnRenderer {
        public SideColumnRenderer(int n, int n2, boolean bl, int n3) {
            super(columnNames[n], n2, bl, n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SRLGRowObject sRLGRowObject = (SRLGRowObject)object;
            object = this.getColumnContents(sRLGRowObject, n2);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            return defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getColumnContents(SRLGRowObject sRLGRowObject, int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = sRLGRowObject.getEntityName();
                    break;
                }
                case 1: {
                    string = sRLGRowObject.getType();
                    break;
                }
                case 2: {
                    string = Long.toString(sRLGRowObject.getUniqueSRLG());
                    break;
                }
                case 3: {
                    string = sRLGRowObject.getAdditionalSRLG();
                    break;
                }
            }
            return string;
        }

        public int compareColumn(Object object, Object object2, int n) {
            SRLGRowObject sRLGRowObject = (SRLGRowObject)object;
            SRLGRowObject sRLGRowObject2 = (SRLGRowObject)object2;
            String string = this.getColumnContents(sRLGRowObject, n);
            String string2 = this.getColumnContents(sRLGRowObject2, n);
            if (n == 2) {
                Long l = new Long(string);
                Long l2 = new Long(string2);
                return l.compareTo(l2);
            }
            return string.compareTo(string2);
        }
    }

    private class MyDataModel
    extends SortableRowTableModel {
        MyDataModel(DetailedSRLGDataSource detailedSRLGDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
            super((RowDataSource)detailedSRLGDataSource, columnRendererArray, clazz);
        }

        private ArrayList getSortedList() {
            return this.sortedObjects;
        }
    }
}

