/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModels;
import cerent.cms.topo.INetLink;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SRLGRowObject {
    private String entityName;
    private long uniqueSRLG;
    private String additionalSRLG;
    private INodeModel nodeModel;
    private ISideModels sideModels;
    private INetLink netLink;
    public static String UNKNOWN_STRING = "Unknown";
    public static String UNIQUE_STRING = "Unique";
    public static String ADDITIONAL_SRLG = "Additional";
    public static int UNKNOWN_SRLG = -1;
    private static String NODE_STRING = "Node";
    private static String LINK_STRING = "Link";
    protected static final SDebug db = new SDebug("SRLGRowObject");

    SRLGRowObject(INodeModel iNodeModel, String string) throws Exception {
        this.nodeModel = iNodeModel;
        this.entityName = string;
        this.uniqueSRLG = iNodeModel.getUniqueNodeSRLG();
        this.additionalSRLG = this.getSortedAdditionalSRLGList(iNodeModel.getAdditionalNodeSRLG().trim());
    }

    SRLGRowObject(INetLink iNetLink, ISideModels iSideModels, int n, String string) throws Exception {
        this.netLink = iNetLink;
        this.sideModels = iSideModels;
        this.entityName = string;
        this.uniqueSRLG = iSideModels.getUniqueLinkSRLG(n);
        this.additionalSRLG = this.getSortedAdditionalSRLGList(iSideModels.getAdditionalLinkSRLG(n).trim());
    }

    SRLGRowObject(INodeModel iNodeModel, String string, long l, String string2) {
        this.nodeModel = iNodeModel;
        this.entityName = string;
        this.uniqueSRLG = l;
        this.additionalSRLG = string2;
    }

    SRLGRowObject(INetLink iNetLink, ISideModels iSideModels, String string, long l, String string2) {
        this.netLink = iNetLink;
        this.sideModels = iSideModels;
        this.entityName = string;
        this.uniqueSRLG = l;
        this.additionalSRLG = string2;
    }

    public String getType() {
        try {
            if (this.entityName.equals(UNKNOWN_STRING)) {
                return UNKNOWN_STRING;
            }
            if (this.entityName.indexOf("/") == -1 && this.entityName.indexOf(" - ") == -1) {
                return NODE_STRING;
            }
            return LINK_STRING;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_STRING;
        }
    }

    public String getEntityName() {
        try {
            return this.entityName;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_STRING;
        }
    }

    public long getUniqueSRLG() {
        try {
            return this.uniqueSRLG;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_SRLG;
        }
    }

    public String getAdditionalSRLG() {
        try {
            return this.additionalSRLG;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return UNKNOWN_STRING;
        }
    }

    public INodeModel getNodeModel() {
        try {
            return this.nodeModel;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public ISideModels getSidesModel() {
        try {
            return this.sideModels;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public INetLink getDwdmLink() {
        try {
            return this.netLink;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error Occurred.");
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    private String getSortedAdditionalSRLGList(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<Long> treeSet = new TreeSet<Long>();
        IPoDWDMUtility iPoDWDMUtility = IPoDWDMUtility.instance();
        if (string.equals("")) {
            return string;
        }
        if (string.indexOf(",") == -1) {
            treeSet.add(new Long(string));
        } else {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                treeSet.add(new Long(((StringTokenizer)object).nextToken().trim()));
            }
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            stringBuffer.append(object.next().toString());
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

